<?php
defined('WikyBlog') or die("Not an entry point...");

global $pageOwner,$dbObject,$langA,$page;
$page->displayTitle = $langA['watchlist'];
$page->regLink('?',$langA['watchlist'].'?en=Watchlist');

//	isOwner(warn,strct)
if(!isOwner(true,true)) return false;

includeFile('search/all.php');

class watchlist extends query{
	var $classes;
	var $day,$month,$year = false;
	function watchlist(){
		global $page,$dbInfo,$pageOwner,$langA,$wbTables,$wbNow;
		$page->css2 =true;
		$page->session = true; //resend the usermenu to get rid of the warning
		
		$this->rowLimit = 25;
		$this->classes[] = ' class="tableRowOdd" ';
		$this->classes[] = ' class="tableRowEven" ';
		$_SESSION['checked'] = $wbNow;
		
		switch($page->userCmd){
			case 'unwatch':
			case wbStrtolower($langA['unwatch']):
				$this->unwatch();
			break;
		}
		
		$this->selectFrom = $wbTables['all_watch'].' INNER JOIN '.$wbTables['all_files'].' USING(`file_id`) ';
		$this->joinAllTo = $wbTables['all_watch'];
		$this->allSelect = array(
							' IF( '.$wbTables['all_files'].'.`owner_id` = "'.wbDB::escape($pageOwner['user_id']).'", 1, 0) '=>'is_owner',
							$wbTables['all_files'].'.`modified` '=>'modified',
							$wbTables['all_files'].'.`file_id` '=>'file_id',
							$wbTables['all_files'].'.`ip` '=>'ip',
							$wbTables['all_files'].'.`username` '=>'username');
		$this->infoSelect[] = 'summary';
					
		
		$this->queryAllFiles();
		$this->query .= ' AND '.$wbTables['all_watch'].'.`user_id` = "'.wbDB::escape($_SESSION['user_id']).'" ';
		$this->query .= ' ORDER BY '.$wbTables['all_files'].'.`modified` DESC ';

		
		$this->searchUrl = $page->formAction = '/Special/'.$_SESSION['username'].'/WatchList';
		$this->browse($langA['watchlist']);
	}
	function displayPre(){
		global $langA;
		echo '<table cellpadding="2" cellspacing="0" border="0">';
		echo '<tr class="tableRows"><th>'.$langA['modified'].'</th>';
		echo '<th>'.$langA['file'].'</th>';
		echo '<th>'.$langA['user'].'</th>';
		echo '<th>'.$langA['edit_summary'].'</th>';
		echo '<th>'.$langA['options'].'</th>';
		echo '</tr>';
	}
	function displayPost(&$prev,&$pages,&$next){
		global $langA;
		echo '<tr><td colspan="4"></td>';
		echo '<td>';
		echo '<input type="submit" name="cmd" value="'.$langA['unwatch'].'" />';
		echo '</td>';
		echo '</table>';
		parent::displayPost($prev,$pages,$next);
	}
	function abbrevOutput(&$row,$i){
		global $langA;
		
		$this->queryAllResult($row);

		////////	2)	For Odd rows
			$class3 = $this->classes[($i%2)];

		////////	3)	Echo a row
			echo '<tr>';
			$this->timelineTD($row['modified']);
			
			//echo '<td '.$class3.' style="white-space:nowrap">';
			echo '<td '.$class3;
				echo ' onmouseover="if(!WB)return;WB.SIO(this)"';
				echo ' onmouseout="if(!WB)return;WB.HI(this)"';
				echo '>';
			
			echo wbLinks::local($row['uniqLink'],toDisplay($row['dTitle'],30),' title="'.toDisplay($row['dTitle']).'"');
			if( $row['is_owner'] == '0'){
				echo ' &nbsp; <span class="sm"> (';
				echo wbLinks::user($row['owner']);
				echo ') </span>';
			}
			
			echo '<span class="sm" style="display:none">';
				$editLink = '/Edit'.$row['uniqLink'];
				$editLink = str_replace('?','',$editLink);
				echo wbLinks::local($editLink.'?cmd=edit','edit');
				echo ' &nbsp; ';
				echo wbLinks::local($editLink.'?cmd=history','history');
				
				if( $row['is_owner'] == '1'){
					echo ' &nbsp; ';
					echo wbLinks::local($editLink.'?cmd=options','options');
					echo ' &nbsp; ';
					
					//this will work for any type of file..
					$linkPrefix = '/Edit/'.$row['space'].'/'.$row['owner'].'/'.$row['file_id'];
					echo wbLinks::local($linkPrefix.'?cmd=delete','delete');
				}
				echo '</span>';
							
			echo '</td><td '.$class3.'>';
			
			if( !empty($row['username']) ){
				echo wbLinks::user($row['username']);
			}else{
				echo $row['ip'];
			}
			
			
			if( isset($_SESSION['username']) ){
				if($_SESSION['username'] != $row['username']){
					$guest = $row['username'];
					if( empty($row['username']) ){
						$guest = $row['ip'];
					}
					
					if( !empty($row['username']) ){
						echo ' <span class="sm">';
						echo wbLinks::special('Permissions?guest='.$guest,'+/-','title="'.$langA['SET_USER_PERMISSIONS'].$guest.'"',$_SESSION['username']);
						echo '</span>';
					}
				}
			}			
			
			echo '</td><td '.$class3.'><span class="sm">';
			
			echo $row['summary'];
			echo '&nbsp;</span>';
			echo '</td><td '.$class3.'>';
			
			echo '<input type="checkbox" name="ids[]" value="'.$row['file_id'].'"/>';
			echo '</td>';
			echo '</tr>';
	}
	
	function unwatch(){
		global $wbTables,$dbObject,$langA;
		if( empty($_POST['ids']) ){
			return;
		}
		
		$queryA = array();
		foreach( $_POST['ids'] as $id){
			$queryA[] = ' `file_id` = "'.wbDB::escape($id).'" ';
		}
		
		$query = 'DELETE FROM '.$wbTables['all_watch'];
		$query .= ' WHERE `user_id` = "'.wbDB::escape($_SESSION['user_id']).'" ';
		$query .= ' AND (';
		$query .= implode(' OR ',$queryA);
		$query .= ' ) ';
		if( wbDB::runQuery($query) ){
			$link = wbLinks::special('WatchList',false);
			message('WATCH_UPDATED',$link);
		}
	}
}
new watchlist();
	