<?php
//$langA checked

defined('WikyBlog') or die("Not an entry point...");

includeFile('search/all_space.php');


class searchTalk extends query_space{
	var $root;
	var $prefix;
	var $links; //for $dbObject
	var $fileLinks; //for each row found
	
	function searchTalk(){
		//Space Info
		$this->SetSpaceInfo('comment');
	}
	
	function getOwner(&$pathArray){
		if( empty($pathArray['owner']) ){
			$this->owner = $GLOBALS['wbConfig']['pUser'];
		}else{
			$this->owner = $pathArray['owner'];
		}
		return $this->owner;
	}
	
	// Talk Page
	// $langA not available to this function
	function getStep1($pathArray){
		global $page;
		$this->prefix = '';
		if( !empty($pathArray['type2']) ){
			//if an admin wanted to restrict from the talk space -> we wouldn't do it
			//talk and comment from another datatype will be unreachable if the type is restricted
			//$page->effectiveSpace = $pathArray['type2'];
			
			$this->titlePrefix = $pathArray['type2'];
			$this->prefix = $this->titlePrefix.'/'; //prefixes have the slash included
		}
		
		$this->title = implode('/',$pathArray['path']);
		if( empty($this->title) ){
			$this->title = $GLOBALS['wbDefaultTitle'];
		}
	}
	
	function setLinks2(){
		global $langA,$page;
		
		$this->root = '/Comment/'.$this->prefix.$this->owner.'/'.$this->title.'/';
		

		$userPage = '/'.$this->prefix.$this->owner.'/'.$this->title;
		$label = toDisplay($this->title);
		if( wbStrlen($label) > 18){
			$label = wbSubstr($label,0,15).'...';
		}
		
		
		$page->regLink($label,$userPage);
		$this->searchUrl = '/Talk'.$userPage;
		
		$page->regLink('?',$langA['talk'].'?en=Talk');
		
		
		//
		// Display Title
		//
		
		if( is_numeric($this->title) ){
			if( empty($this->titlePrefix) ){
				$type = 'page';
			}else{
				$type = $this->titlePrefix;
			}
			
			
			$dTitle = wbData::dbInfo($type,'dTitle');
			$dbTable = wbData::dbInfo($type,'dbTable');
			
			$query = 'SELECT ';
			$query .= wbData::getDTitle($type);
			$query .= ' FROM '.$dbTable;
			$query .= ' WHERE `file_id` ="'.$this->title.'" ';
			$query .= ' LIMIT 1 ';
			$result = wbDB::runQuery($query);
			if($row  = mysql_fetch_assoc($result) ){
				$page->displayTitle = $row['dTitle'].' > '.$langA['talk'];
				return;
			}
		}
		
		
		
		$page->displayTitle = '';
		if( !empty($this->titlePrefix) ){
			if( isset($langA[$this->titlePrefix]) ){
				$page->displayTitle = $langA[$this->titlePrefix].' > ';
			}else{
				$page->displayTitle = $this->titlePrefix.' > ';
			}
		}
		
		$page->displayTitle .= toDisplay($this->title).' > '.$langA['talk'];
	}
	
	function getStep2(){
		global $dbInfo,$langA,$pageOwner,$wbTables;
		$this->setLinks2();

	
		//$this->fields[--shown to user--] = --database column--
		$this->fields[$langA['posted']] = 'posted';
		$this->fields[$langA['modified']] = 'modified';
		//$this->fields[$langA['created']] = 'created';
		$this->fields[$langA['created']] = $dbInfo['comment']['dbTable'].'.`file_id`';
		
		
		$this->rowLimit = 10;
		$this->query = 'SELECT SQL_CALC_FOUND_ROWS '.wbData::dbInfo('comment','querySelect');
		$this->query .= ', '.wbData::dbInfo('comment','uniqLink').' as uniqLink ';
		$this->query .= ', `modified`, `created`, `flags` ';
		$this->query .= ' FROM ';
		$this->query .= wbData::dbInfo('comment','queryFrom');
		$this->query .= ' INNER JOIN ';
		$this->query .= $wbTables['all_files']; //join to all_files needs to be last in case 'queryFrom' has more than one table
		$this->query .= ' ON '.$wbTables['all_files'].'.`file_id` = '.$dbInfo['comment']['dbTable'].'.`file_id` ';
		$this->query .= ' WHERE ';
		//$this->query .= ' `owner_id` = "'.$pageOwner['user_id'].'" ';
		$this->query .= ' `owner` = "'. wbDB::escape($this->owner) .'" ';
		$this->query .= ' AND `title` = "'. wbDB::escape($this->title) .'" ';
		$this->query .= ' AND `prefix` = "'. wbDB::escape($this->prefix) .'" ';
		$this->query .= ' AND '.$wbTables['all_files'].'.`visible` = 1 ';
		$this->query .= ' AND !FIND_IN_SET("redirect", '.$wbTables['all_files'].'.`flags`) ';
		
		
		$this->orderBy();
		$this->browse($langA['talk']);
	}

	
	function displayEmpty(){
		parent::displayEmpty();
		return true;
	}
	
	function displayNumbers(&$from,&$to,&$rowsFound,&$prev,&$next){
		global $langA,$page,$pageOwner;
		
		if( empty($_GET['offset']) && !$page->interRequest){
			if( !array_key_exists('quickComment', $pageOwner ) || ($pageOwner['quickComment'] == 'On')){
	
				$page->formAction = $this->root;
				echo '<input type="hidden" name="summary" value="" />';
				echo ' <input type="hidden" name="quicksave" value="true" />';
				echo '<table style="margin-right:auto;margin-left:auto;" class="wbTalkForm">';
				
					echo '<tr><td colspan="2">';
					echo '<h4 class="heading underline">'.$langA['add_comment'].'</h4>';
					echo '</td></tr>';
				
					echo '<tr><td>'.$langA['title'].'</td>';
					echo '<td><input type="text" name="new_title" size="40" />';
					echo '</td></tr>';
					
					echo '<tr><td>'.$langA['comment'].'</td>';
					echo '<td><textarea cols="40" name="content" rows="4"></textarea>';
					echo '</td></tr>';
					
					echo '<tr><td></td>';
					echo '<td>';
					echo '<input type="submit" name="cmd" value="'.$langA['continue'].'" /> ';
					echo '<input type="submit" name="cmd" value="'.$langA['preview'].'" /> ';
					echo '<input type="submit" name="cmd" value="'.$langA['save'].'" />';
					echo '</td></tr>';
				echo '</table>';
			}
		}
		
		parent::displayNumbers($from,$to,$rowsFound,$prev,$next);
	}
}

