<?php
defined('WikyBlog') or die("Not an entry point...");


class exportWB{
	var $flush = false;
	
	function exportWB(){
		global $page,$pageOwner,$serverName4,$wbTables,$wbCompress;
		
		if( $page->interRequest ){
			message('This cannot be made with an external request');
			return;
		}
		
		if( function_exists('ob_flush') ){
			$this->flush = true;
		}
		
		
		//	if gz buffering was enabled, then the deflate header will be set
		//	so we have to use the gz output buffer
		// 
		// while( @ob_end_clean() ){ 
		// 	//nothing
		// }
		// if( $wbCompress && function_exists('ob_gzhandler') ){
		// 	@ob_start( 'ob_gzhandler' );
		// }
		
		
		header('Content-Type: text/xml; charset=UTF-8');
		header('Content-Description: File Transfer');
		$filename = 'WikyBlog-'.date('Y-m-d') . '.xml';
		header('Content-Disposition: attachment; filename='.$filename);
		echo '<'.'?xml version="1.0" encoding="utf-8" ?'.'>';
		?>
		
<!-- This XML file was created by WikyBlog -->
<!-- Exported XML can help you save/transfer much of your bliki's contents to alternate locations but are in no way comprehensive backups. -->
<!-- The Export does not include, among other data, the following: Uploaded Files, Revision History  -->

<!-- The Export feature for WikyBlog is under development -->
<rss version="2.0" xmlns:wb="http://www.wikyblog.com/Main/Export">
		
		<?php
		echo '<channel>';
			$this->xml_PCDATA('title',$pageOwner['username']);
			$this->xml_PCDATA('link',$serverName4.'/'.$pageOwner['username']);
			$this->xml_PCDATA('description','Wiki/Blog by '.$pageOwner['username']);
			$this->xml_PCDATA('pubDate',dbFromDate(date('Y-m-d 0:0:0'),5));
			$this->xml_PCDATA('generator','http://www.wikyblog.com');
			$this->xml_PCDATA('language',$pageOwner['lang']);
			
			$this->items_by_space();

		echo "\n</channel>";
		echo "\n</rss>";
		exit();
	}
	
	function items_by_space(){
		global $dbInfo,$pageOwner,$wbTables;
	
		$startTime = microtime();
		
		foreach($dbInfo as $space => $info){
			if( !isset($info['dbTable']) ){
				continue;
			}
			
			//If it's taking a long time, try to allow for more.. won't work in save_mode
			if( microtime_diff($startTime, microtime()) > 15 ){
				@set_time_limit(60);
			}
			
			$class = wbData::getClass($space,true);
			$vars = get_class_vars($class);
			//$keys = $var
			//echo $vars['dbValues'];
			$keys = wbData::dbInfo($space,'keys');
			//$valueKeys = $vars['dbValues']+$vars['userValues']+$keys; //userValues don't always correspond to columns in a database
			$valueKeys = $vars['dbValues']+$keys;
			$valueKeys = array_keys($valueKeys);
			
			//Get all info for space
			$query = 'SELECT '.$wbTables['all_files'].'.* ';
			foreach($valueKeys as $valueKey){
				if( $valueKey == 'keywords' ){
					continue;
				}
				$query .= ', '.$info['dbTable'].'.`'.$valueKey.'` ';
			}
			$query .= ', '.wbData::dbInfo($space,'uniqLink').' as `uniqLink` ';
			$query .= ', '.$info['dbTable'].'.`hitcounter` ';
			$query .= ' FROM '.$wbTables['all_files'];
			$query .= ' JOIN '.$info['dbTable'].' USING (`file_id` ) ';
			$query .= ' WHERE `owner_id` = "'.$pageOwner['user_id'].'" ';
			// Debuggin
			//echo '<query>'.$query.'</query>';
			$result = wbDB::runQuery($query);
			while($row = mysql_fetch_assoc($result) ){
				$this->xml_item($row,$space,$class,$valueKeys);
			}
		}
	}
		
	
	function xml_item(&$row,&$space,&$class,&$valueKeys){
		echo "\n";
		echo '<item>';
		$this->xml_PCDATA('wb:space',$space);
		$this->xml_PCDATA('wb:class',$class);
		$this->xml_PCDATA('wb:file_id',$row['file_id']);
		$this->xml_PCDATA('link',$row['uniqLink']);
		$this->xml_PCDATA('created',$row['created']);
		$this->xml_PCDATA('modified',$row['modified']);
		$this->xml_PCDATA('posted',$row['posted']);
		$this->xml_PCDATA('hits',$row['hitcounter']);
		$this->xml_PCDATA('flags',$row['flags']);
		foreach($valueKeys as $valueKey){
			$this->xml_CDATA('wb:content',$row[$valueKey],'name="'.$valueKey.'"');
		}
		echo '</item>';
		
		if( $this->flush ){
			ob_flush();
			flush();
		}
	}
	
	/*
	&#0; is a NULL
	character which, if used in C/C++ strings for example, will represent the
	end of a string.  All the control characters which are used for data transmission
	and control purposes (e.g. ^S, ^Q, ^Z, ^C) are inappropriate for the obvious reasons.	
	*/
	function xml_PCDATA($tag,$text,$attr=''){
		echo "\n";
		echo '<'.$tag.' '.$attr.'>';
		echo $this->xmlchars($text);
		echo '</'.$tag.'>';
	}
	function xmlchars(&$text) {
		return str_replace('&#039;', '&apos;', htmlspecialchars($text, ENT_QUOTES));
	}
	function xml_CDATA($tag,$text,$attr=''){
		echo "\n";
		echo '<'.$tag.' '.$attr.'><![CDATA[';
		echo str_replace(']]>',']]&gt;',$text); //just in case
		echo ( substr($text, -1) == ']' ) ? ' ' : '';
		echo ']]></'.$tag.'>';
	}
	
}
new exportWB();
