<?php
defined('WikyBlog') or die("Not an entry point...");

includeFile('search/all.php');


class fileManager extends query{
	var $path;
	var $imgs=array();
	var $checked = false;
	var $totals = array();
	var $type;
	var $managerLink;
	
	
	function fileManager(){
		global $page,$pageOwner,$dbObject,$langA,$wbTablePrefix, $wbTables;
		
		$page->regLink($langA['image_manager'],'/Special/'.$pageOwner['username'].'/ImageManager');
		$page->regLink($langA['file_manager'],'/Special/'.$pageOwner['username'].'/FileManager');
		$page->regLink($langA['file_upload'],'/Attach/'.$pageOwner['username'].'?cmd=uploadform');
		$page->regLink('?',$langA['image_manager'].'?en=Image_Manager');
		$page->autoForm = true;
		$page->formMethod = 'get';
		$page->css2 = true;
		
		$this->isOwner = isOwner(false,false);
		
		switch($dbObject->title){
			case 'imagemanager':
				$title = $langA['image_manager'];
				$this->type = 'imgs';
				$this->searchUrl = '/Special/'.$pageOwner['username'].'/ImageManager';
			break;
			default:
				$title = $langA['file_manager'];
				$this->type = 'files';
				$this->searchUrl = '/Special/'.$pageOwner['username'].'/FileManager';
			break;
		}
		
		
		$this->classes[] = ' class="tableRowEven" ';
		$this->classes[] = ' class="tableRowOdd" ';
		$this->rowLimit = 25;
		$this->overWrite['s'] = false;
		$this->overWrite['cmd'] = false;
		
		$this->query = 'SELECT SQL_CALC_FOUND_ROWS * FROM ';
		$this->query .= ' `'.$wbTablePrefix.'attachments` ';
		$this->query .= ' JOIN '.$wbTables['all_files'].' USING(`file_id`) ';
		$this->query .= ' WHERE ';
		$this->query .= ' `owner` = "'.wbDB::escape($pageOwner['username']).'" ';
		if( $this->type == 'imgs' ){
			$this->query .= ' AND `is_image` = 1 ';
		}else{
			$this->query .= ' AND `is_image` = 0 ';
		}
		
		if( !empty($_GET['s']) ){
			$this->query .= ' AND `title` LIKE "%'.wbDB::escape($_GET['s']).'%" ';
		}
		$this->query .= ' ORDER BY `title` ';
		
		$this->browse($title);
	}
	
	function mysqlFetch(&$result){
		return mysql_fetch_assoc($result);
	}
	function displayNumbers(&$from,&$to,&$rowsFound,&$prev,&$next){
		global $langA, $pageOwner;
		
		if( $this->type == 'imgs' ){
			echo $langA['IMAGE_MANAGER_INTRO'];
			echo '<ul><li>[[image:<i>example.jpg</i>]]</li>';
			echo '<li>&lt;img src="'.wbLinks::getDir('/userfiles/'.wbStrtolower($pageOwner['username'])).'/uploaded/<i>example.jpg</i>" height="21" width="20" /></li>';
			echo '</ul>';
			
		}else{
		
			echo $langA['FILE_MANAGER_INTRO'];
			echo '<ul>';
			echo '<li>[[attach:<i>example.doc.gz</i>]]</li>';
			$link = '/include/tool/Files.php?o='.toStorage($pageOwner['username'],true).'&f=<i>example.doc.gz</i>';
			$link = wbLinks::getDir($link);
			echo '<li>&lt;a href="'.$link.'"&gt;example.doc.gz&lt;/a&gt;</li>';
			echo '</ul>';
		}
		
		parent::displayNumbers($from,$to,$rowsFound,$previousLink,$nextLink);
	}
	
	
	
	function displayPre(){
		global $langA;
		
		
		echo '<table class="tableRows" style="width:100%">';
		echo '<tr>';
		echo '<th>'.$langA['file_name'].'</th>';
		echo '<th>'.$langA['size'].'</th>';
		echo '<th>'.$langA['modified'].'</th>';
		echo '<th class="unsortable">'.$langA['options'].'</th>';
		echo '</tr>';
		
	}
	function abbrevOutput(&$row,$i){
		global $pageOwner;
		
		echo '<tr '.$this->classes[($i%2)].'>';
		echo '<td>';
		echo $row['title'];
		echo '</td>';
		echo '<td>';
		echo $this->convert( $row['filesize'] );
		//echo 
		echo '</td>';
		echo '<td>';
		echo dbFromDate($row['modified'],3);
		echo '</td>';
		echo '<td>';
		
		echo wbLinks::local('/Attach/'.$pageOwner['username'].'/'.$row['title'],'more');
		echo ' &nbsp; ';
		if( $this->isOwner ){
			echo wbLinks::local('/Attach/'.$pageOwner['username'].'/'.$row['title'].'?cmd=delete','delete');
		}
		
		echo '</td>';
		echo '</tr>';
	}
	function displayPost(&$prev,&$pages,&$next){
		global $langA;
		echo '</table>';
		
		
		$_GET += array('s'=>'');
		echo '<table class="WBeditArea1" style="margin: 1em auto 0 auto"><tr><td>';
		echo '<b>';
		echo $langA['file'];
		echo '</b>';
		echo ' &nbsp; ';
		echo '<input type="text" name="s" value="'.$_GET['s'].'" />';
		echo ' &nbsp; ';
		echo '<input type="submit" name="cmd" value="'.$langA['search'].'" />';
		echo '</td></tr></table>';
		
		parent::displayPost($prev,$pages,$next);
		
	}
	
	function convert( $bytes ){
		global $langA;
		$bytes = floatval($bytes);
		$types = array();
		
		$types[1] = $langA['kb'];
		$types[2] = $langA['mb'];
		$types[3] = $langA['gb'];
		
		
		$i = 0;
		while( ($bytes > 1500) && ($i < 3) ){
			$bytes /= 1024;
			$i++;
		}
		if( $i == 0 ){
			return number_format($bytes).' '.$langA['bytes'];
		}
		
		return number_format($bytes,2).' '.$types[$i];
	}
	
}

new fileManager();

	


