<?php
defined('WikyBlog') or die("Not an entry point...");

if( !isOwner(true,false) ) return false;

class ownerLinkGroups{
	var $groupOrder;
	var $groups;
	
	
	function ownerLinkGroups(){
		global $page,$pageOwner,$dbObject,$langA;
		
		$page->regLink($langA['links'],'/Special/'.$pageOwner['username'].'/Links');
		$link = $page->regLink($langA['link_groups'],'/Special/'.$pageOwner['username'].'/LinkGroups');
		$page->regLink('?',$langA['link_groups'].'?en=Link Groups');
		$page->displayTitle = $langA['link_groups'];		
		$page->autoForm = true;
		$page->css2 = true;
		
		$this->groupOrder = array('descending'=>'descending','random'=>'random');
		
		//
		//	act
		//
		ob_start();
		
			$show = true;
			switch($page->userCmd){
				case wbStrtolower($langA['add_group']):
					$this->addGroup();
				break;
				
				case wbStrtolower($langA['delete']):
					$this->deleteGroup();
				break;
				
				case wbStrtolower($langA['edit']):
					$this->edit();
					$show = false;
				break;
				
				case wbStrtolower($langA['save']):
					$this->save();
				break;
				case 'addform':
					$this->addForm();
					$show = false;
				break; 
			}
			if( $show){
				$this->showAllGroups();
			}
			
		$page->contentB[$link] = wb::get_clean();
	}
	
	//
	//	Group Management
	//
		function save(){
			global $langA,$page,$pageOwner;
			
			$ownerGroups =& $pageOwner['data2']['groups'];
			$_POST['name'] = trim($_POST['name']);
			if( empty($_POST['name']) ){
				message('INVALID_REQUEST');
				return;
			}
			$_POST['name'] = wbHtmlspecialchars($_POST['name']);
			
			if( !isset($ownerGroups[$_POST['currName']])){
				message('INVALID_REQUEST');
				return;
			}
			
			
			if( !empty($_POST['order']) && isset($this->groupOrder[$_POST['order']]) ){
				$list['order'] = wbHtmlspecialchars($_POST['order']);
			}else{
				$list['order'] = key($this->groupOrder);
			}
			
			if( !empty($_POST['limit']) && is_numeric($_POST['limit']) ){
				$list['limit'] = $_POST['limit'];
			}
			$pageOwner['data2']['groups'][$_POST['currName']] = $list;
			
			
			if( $_POST['name'] != $_POST['currName']){
				if( isset($pageOwner['data2']['groups'][$_POST['name']]) ){
					message('INVALID_REQUEST');
					return;
				}
				$this->renameGroup($_POST['currName'],$_POST['name']);
				return;
			}
		}
		
		function renameGroup($oldName,$newName){
			global $pageOwner;
			if( isset($pageOwner['data2']['links'][$oldName]) ){
				$new = array();
				foreach($pageOwner['data2']['links'] as $groupName => $linkData){
					if( $groupName == $oldName ){
						$groupName = $newName;
					}
					$new[$groupName] = $linkData;
				}
				$pageOwner['data2']['links'] = $new;
			}
			
			$new = array();
			foreach($pageOwner['data2']['groups'] as $groupName => $groupData){
				if( $groupName == $oldName ){
					$groupName = $newName;
				}
				$new[$groupName] = $groupData;
			}
			$pageOwner['data2']['groups'] = $new;
		}
		
		function edit(){
			global $langA,$page,$pageOwner;
			$page->displayTitle .= ' > '.$langA['edit'];
			if( !isset($pageOwner['data2']['groups'][$page->cmdArg[0]])){
				message('INVALID_REQUEST');
				return;
			}
			$args = $pageOwner['data2']['groups'][$page->cmdArg[0]];
			
			echo '<input type="hidden" name="currName" value="'.$page->cmdArg[0].'" />';
			echo '<table style="margin-right:auto;margin-left:auto;margin-top:3em;">';
			echo '<tr><td style="text-align:center;">';
			$this->groupForm($args,'save',$page->cmdArg[0]);
			echo '</td>';
			echo '</td></tr></table>';
			
		}
		
		function addGroup(){
			global $page,$pageOwner;
			$_POST['name'] = trim($_POST['name']);
			if( empty($_POST['name']) ){
				message('INVALID_REQUEST');
				return;
			}
			$name = wbHtmlspecialchars($_POST['name']);
			$list = array();
			
			if( !empty($_POST['order']) && isset($this->groupOrder[$_POST['order']]) ){
				$list['order'] = wbHtmlspecialchars($_POST['order']);
			}else{
				$list['order'] = key($this->groupOrder);
			}
			
			if( !empty($_POST['limit']) && is_numeric($_POST['limit']) ){
				$list['limit'] = $_POST['limit'];
			}
			$pageOwner['data2']['groups'][$name] = $list;
		}
		
		function deleteGroup(){
			global $page,$pageOwner;
			if( empty($page->cmdArg[0]) ){
				$page->cmdArg[0] = '';
			}
			
			if( !isset($pageOwner['data2']['groups'][$page->cmdArg[0]])){
				message('INVALID_REQUEST');
				return;
			}

			$new = array();
			foreach($pageOwner['data2']['groups'] as $i => $groupData){
				if( $i === $page->cmdArg[0]){
					continue;
				}
				$new[$i] = $groupData;
			}
			$pageOwner['data2']['groups'] = $new;
		}
		
	//
	// Show
	//
		function showAllGroups(){
			global $page,$pageOwner,$dbObject,$langA;
			
			if( empty($pageOwner['data2']['groups']) ){
				$this->showAllGroupsForm();
				return;
			}
			echo '<table class="tableRows sortable" style="width:100%">';
			echo '<tr>';
			echo '<th>'.$langA['name'].'</th>';
			echo '<th>'.$langA['links'].'</th>';
			echo '<th>'.$langA['order'].'</th>';
			echo '<th>'.$langA['limit'].'</th>';
			echo '<th class="unsortable">'.$langA['options'].'</th>';
			echo '</tr>';
			
			$classes[] = 'class="tableRowOdd" ';
			$classes[] = 'class="tableRowEven" ';
			$i = 0;
			$count= count($pageOwner['data2']['groups']);
			foreach($pageOwner['data2']['groups'] as $groupName => $groupData){
				echo '<tr '.$classes[($i%2)].'>';
				echo '<td>';
				echo $groupName;
				echo '</td>';
				echo '<td>';
				if( isset($pageOwner['data2']['links'][$groupName]) ){
					echo count($pageOwner['data2']['links'][$groupName]);
				}else{
					echo '0';
				}
				echo ' &nbsp; ';
				echo wbLinks::special('Links?cmd=addform&name='.$groupName,'add_link');
				
				echo '</td>';
				echo '<td>';
				if( isset($groupData['order']) ){
					
					if( isset($langA[$groupData['order']]) ){
						echo $langA[$groupData['order']];
					}else{
						echo $groupData['order'];
					}
						
				}else{
					echo $langA['descending'];
				}
				echo '</td>';
				echo '<td>';
				if( isset($groupData['limit']) ){
					echo $groupData['limit'];
				}else{
					echo $langA['unlimited'];
				}
				echo '</td>';
				echo '<td style="white-space:nowrap">';
				
				echo ' <input type="submit" name="cmd['.$groupName.']" value="'.$langA['edit'].'" />';
				echo ' <input type="submit" name="cmd['.$groupName.']" value="'.$langA['delete'].'" />';
				echo '</td>';
				echo '</tr>';
				$i++;
			}
			echo '</table>';
			$this->showAllGroupsForm();
			
		}
		function showAllGroupsForm(){
			global $langA;
			$_POST += array('name'=>'');

			echo '<table style="margin-right:auto;margin-left:auto;">';
			echo '<tr>';
			echo '<td style="text-align:center;">';
			echo '<h3>'.$langA['add_group'].'</h3>';
			$this->groupForm($_POST,'add_group',$_POST['name']);
			echo '</td>';
			echo '</td></tr></table>';
		}
		
		function addForm(){
			global $langA;
			echo '<table style="margin-right:auto;margin-left:auto;">';
			echo '<tr>';
			echo '<td style="text-align:center;">';
			echo '<h3>'.$langA['add_group'].'</h3>';
			$this->groupForm($_GET,'add_group',$_GET['name']);
			echo '</td>';
			echo '</td></tr></table>';
		}
		
		function groupForm($args,$how='add_group',$groupName=''){
			global $langA;
			$args += array('order'=>'','limit'=>'');
			
			
			echo '<table cellspacing="7" class="WBeditArea1">';
			echo '<tr>';
				echo '<td style="text-align:right"><b>* '.$langA['name'].': </b></td>';
				echo '<td><input type="text" name="name" size="50" value="'.wbHtmlspecialchars($groupName).'" />';
				echo '</tr>';
			echo '<tr>';
				echo '<td style="text-align:right"><b> '.$langA['order'].': </b></td>';
				echo '<td>';
				echo $this->formSelect('order',$this->groupOrder,$args['order']);
				echo '</tr>';
			echo '<tr>';
				echo '<td style="text-align:right"><b>'.$langA['limit'].': </b></td>';
				echo '<td><input type="text" name="limit" size="10" value="'.wbHtmlspecialchars($args['limit']).'" />';
				echo '&nbsp; <span class="sm">('.$langA['LEAVE_EMPTY'].')</span>';
				echo '</tr>';
			echo '<tr>';
				echo '<td></td>';
				echo '<td>';
				echo '<input type="submit" name="cmd" value="'.$langA[$how].'" />';
				echo ' <input type="submit" name="cmd" value="'.$langA['cancel'].'" />';
				echo '</tr>';
				
			echo '</table>';			
		}
		function formSelect($name,$values,$selected=null,$useLang=true){
			global $langA;
			$select = '<select name="'.$name.'">';
			foreach($values as $key => $value){
				if($key == $selected){
					$focus = ' selected ';
				}else{
					$focus = '';
				}
				if( $useLang && isset($langA[$value]) ){
					$value = $langA[$value];
				}
				$select .= '<option value="'.wbHtmlspecialchars($key).'" '.$focus.'>'.$value.'</option>';
			}
			$select .= '</select>';
			return $select;
		}		
		
}
new ownerLinkGroups();
