<?php
defined('WikyBlog') or die("Not an entry point...");

if( !isOwner(true,false) ) return false;

class ownerLinks{
	var $templateFile;
	
	function ownerLinks(){
		global $page,$pageOwner,$dbObject,$langA,$serverName1,$serverName4;
		
		$link = $page->regLink($langA['links'],'/Special/'.$pageOwner['username'].'/Links');
		$page->regLink($langA['link_groups'],'/Special/'.$pageOwner['username'].'/LinkGroups');
		$page->regLink('?','Owner Links?en=Owner_Links');
		$page->displayTitle = $langA['links'];
		$page->autoForm = true;
		$page->css2 = true;
		
		$this->groups = array();

		
		if( !isset($pageOwner['data2']['links']) ){
			$pageOwner['data2']['links'] = array();
			$pageOwner['data2']['groups'] = array();
			
			$list = array();
			if( !empty($serverName1) ){
				$list[]= array('uri'=>'/','label'=>toDisplay($GLOBALS['wbDefaultTitle']),'desc'=>'','intern'=>true);
				$pageOwner['data2']['links'][$serverName1] = $list;
				$pageOwner['data2']['groups'][$serverName1] = array();
			}
		}
		
		
		// $pageOwner['data2']['links'] = array();
		// $pageOwner['data2']['groups'] = array();
		
		// $list = array();
		// if( !empty($serverName1) ){
		// 	$serverName1 = '';
		// 	$list[]= array('uri'=>'/','label'=>'Home','desc'=>$serverName1.' home','intern'=>true);
		// 	$pageOwner['data2']['links'][$serverName1] = $list;
		// 	$pageOwner['data2']['groups'][$serverName1] = array();
		// }
		
		//
		//	Template has links area?
		//
			$this->whichTemplate();
			$this->hasLinks();
			
		//
		//	act
		//
			$this->setGroups();
			ob_start();
			
			
			echo '<div style="text-align:right">';
			$bookmarklet = 'javascript:void(';
			$bookmarklet .= 'linkpopup=window.open(\''.$serverName4.'/Special/'.$pageOwner['username'].'/Links?cmd=addform';
			$bookmarklet .= '&amp;uri=\'+escape(location.href)+\'&amp;label=\'+escape(document.title)';
			$bookmarklet .= ' ,\'LinkManger\',\'scrollbars=yes,width=750,height=550,left=15,top=15,status=yes,resizable=yes\')';
			$bookmarklet .= ');';
			$bookmarklet .= 'window.focus();linkpopup.focus();';
			
			echo $langA['bookmarklet'].': <a href="'.$bookmarklet.'">'.$langA['add_link'].'</a>';
			echo '</div>';
			
			
		
			$show = true;
			$changed = false;
			switch($page->userCmd){
				case wbStrtolower($langA['add_link']):
					$this->addLink();
					$changed = true;
				break;
				
				case wbStrtolower($langA['delete']):
					$this->deleteLink();
					$changed = true;
				break;
				
				case wbStrtolower($langA['edit']):
					$this->editLink();
					$show = false;
				break;
				
				case wbStrtolower($langA['save']):
					$this->saveLink();
					$changed = true;
				break;
				
				case 'addform':
					$this->addForm();
					$show = false;
				break;
				
				case 'optadd':
					$this->addFromOptions();
					$show = false;
				break;
				
				case 'up';
					$this->moveUp();
					$changed = true;
				break;
				
				case 'down';
					$this->moveDown();
					$changed = true;
				break;
				
				case 'groupup':
					$this->moveGroupUp();
					$changed = true;
				break;
				case 'groupdown':
					$this->moveGroupDown();
					$changed = true;
				break;
				
			}
			if( $show){
				$this->showAll();
			}
			
			if( $changed ){
				$this->sendUpdated();
			}
			
		$page->contentB[$link] = wb::get_clean();
	}
	
	
	
	//dynamically update links
	function sendUpdated(){
		global $page, $pageOwner;
		
		if( !$page->ajaxRequest ){
			return;
		}
		if( $page->interRequest ){
			return;
		}
		
		if( isset($_GET['wb']['o']) && ($_GET['wb']['o'] != $pageOwner['user_id'])){
			return;
		}

		includeFile('wikiResponseNormal.php');
		$addContent = new content();
		$addContent->aa = 'replace';
		$addContent->bb = 'WB.Links';
		
		ob_start();
		wbPageNormal::getLinks();
		$addContent->cc = wb::get_clean();
		
		$page->contentClasses[] = $addContent;
	}
	
	
	//
	// Group Movement
	//
		function moveGroupDown(){
			global $page,$pageOwner;
			
			if( !isset($pageOwner['data2']['links'][$page->cmdArg[0]])){
				message('INVALID_REQUEST');
				return false;
			}
			$entry = false;
			$new = array();
			
			foreach($pageOwner['data2']['links'] as $groupName => $groupData){
				if($groupName === $page->cmdArg[0]){
					$entry = $pageOwner['data2']['links'][$page->cmdArg[0]];
					continue;
				}
				$new[$groupName] = $groupData;
				if( $entry ){
					$new[$page->cmdArg[0]] = $entry;
					$entry = false;
				}
			}
			$pageOwner['data2']['links'] = $new;
			return true;
		}
		
		function moveGroupUp(){
			global $page,$pageOwner;
			
			if( !isset($pageOwner['data2']['links'][$page->cmdArg[0]])){
				message('INVALID_REQUEST');
				return;
			}
			$old = $pageOwner['data2']['links'];
			$pageOwner['data2']['links'] = array_reverse($pageOwner['data2']['links'],true);
			if( !$this->moveGroupDown() ){
				$pageOwner['data2']['links'] = $old;
				return;
			}
			$pageOwner['data2']['links'] = array_reverse($pageOwner['data2']['links'],true);
		}
		
	//
	// Link Management
	//
		function addFromOptions(){
			global $langA;
			
			$_GET += array('desc'=>'','type'=>'internal');
			$pos = strrpos($_GET['uri'],'/');
			if( ($pos > 0) && ($pos != strlen($_GET['uri'])) ){
				$_GET['label'] = substr($_GET['uri'],$pos+1);
			}else{
				$_GET['label'] = $_GET['uri'];
			}
			
			$_GET += array();
			echo '<table style="margin-right:auto;margin-left:auto;">';
			echo '<tr>';
			echo '<td style="text-align:center;">';
			echo '<h3>'.$langA['add_link'].'</h3>';
			$this->linkForm($_GET,'add_link');
			echo '</td>';
			echo '</tr></table>';		
		}
	
	
		function addForm(){
			global $langA;
			
			$_GET += array('name'=>'');
			if( isset($_GET['uri']) ){
				$_GET['uri'] = urldecode($_GET['uri']);
			}
			if( isset($_GET['label']) ){
				$_GET['label'] = urldecode($_GET['label']);
			}
				
			echo '<table style="margin-right:auto;margin-left:auto;">';
			echo '<tr>';
			echo '<td style="text-align:center;">';
			echo '<h3>'.$langA['add_link'].'</h3>';
			$this->linkForm($_GET,'add_link',$_GET['name']);
			echo '</td>';
			echo '</tr></table>';
		}
		
		function editLink(){
			
			global $page,$pageOwner,$langA;
			$page->displayTitle .= ' > '.$langA['edit'];
			
			if( !is_numeric($page->cmdArg[1]) || !isset($pageOwner['data2']['links'][$page->cmdArg[0]])){
				message('INVALID_REQUEST');
				return;
			}
			if( !isset($pageOwner['data2']['links'][$page->cmdArg[0]][$page->cmdArg[1]])){
				message('INVALID_REQUEST');
				return;
			}
			echo '<input type="hidden" name="index" value="'.$page->cmdArg[1].'" />';
			echo '<input type="hidden" name="currGroup" value="'.$page->cmdArg[0].'" />';
			
			$args = $pageOwner['data2']['links'][$page->cmdArg[0]][$page->cmdArg[1]];
			
			if( isset($args['intern'])){
				$args['type'] = 'internal';
				
			}elseif( isset($args['attach']) ){
				$args['type'] = 'attach';
				
			}else{
				$args['type'] = 'external';
				
			}
			
			echo '<table style="margin-right:auto;margin-left:auto;margin-top:3em;">';
			echo '<tr><td style="text-align:center;">';
			$this->linkForm($args,'save',$page->cmdArg[0]);
			echo '</td></tr></table>';
		}
		
		function saveLink(){
			global $page,$pageOwner;
			
			if( !is_numeric($_POST['index']) || !isset($this->groups[$_POST['currGroup']])){
				message('INVALID_REQUEST');
				return;
			}
			if( !isset($this->groups[$_POST['group']]) ){
				message('INVALID_REQUEST');
				return;
			}

			if( $_POST['currGroup'] != $_POST['group']){
				unset($pageOwner['data2']['links'][$_POST['currGroup']][$_POST['index']]);
				$pageOwner['data2']['links'][$_POST['currGroup']] = array_values($pageOwner['data2']['links'][$_POST['currGroup']]);
				$this->addLink();
				return;
			}

			$pageOwner['data2']['links'][$_POST['group']][$_POST['index']] = $this->getLinkInfo($_POST);
		}
		
		function addLink(){
			global $page,$pageOwner;
			if( empty($_POST['uri']) || empty($_POST['label']) || empty($_POST['group']) ){
				message('INVALID_REQUEST');
				return;
			}
			if( !isset($this->groups[$_POST['group']]) ){
				message('INVALID_REQUEST');
				return;
			}
			$temp = $this->getLinkInfo($_POST);
			$pageOwner['data2']['links'][$_POST['group']][] = $this->getLinkInfo($_POST);
		}
		
		
		
		function getLinkInfo($args){
			global $pageOwner;
			$list = array();
			
			//should not change & to &amp; or else it will be done twice
			//$list['uri'] = str_replace(array('<','&lt;'),array('%3C'),$args['uri']);
			//$list['uri'] = str_replace(array('>','&gt;'),array('%3E'),$args['uri']);
			$list['uri'] = str_replace(array('>','<'), array('%3E','%3C'), $args['uri']);
			$test = wbStrtolower($list['uri']);	
			
			if( $args['type']=='internal'){
			//Internal
			
				if($test{0} !== '/'){
					$list['uri'] = '/'.$pageOwner['username'].'/'.$list['uri'];
					$list['intern'] = true;
					
				}elseif( !$this->isOwnerLink($test) ){
					$list['otheruser'] = true;
					
				}else{
					$list['intern'] = true;
				}
				
				
			}elseif( $args['type'] == 'external'){
			//External
				
				if( strpos($list['uri'],'://')){
					//nothing
				}elseif( strpos($list['uri'],'mailto:') === 0){
					//nothing
				}else{
					$list['uri'] = 'http://'.$list['uri'];
				}
				
			}elseif( $args['type'] == 'attach' ){
			//Attachment
			
				$list['attach'] = true;
				
			}else{
			//AutoDetect
			
				$dotPos = strpos($test,'.');
				$slashPos = strpos($test,'/');
			
				if( strpos($test,'://') !== false ){
					//external
					
				}elseif( strpos($test,'mailto:') === 0){
					//external
					
				}elseif( $slashPos === 0 ){
					
					if( strpos($test,'/include') === 0){ //for /include/tools/Files.php
						$list['attach'] = true;
					
					}elseif( strpos($test,'/userfiles') === 0){
						$list['attach'] = true;
						
					}elseif( !$this->isOwnerLink($test) ){
						$list['otheruser'] = true;
						
					}else{
						
						$list['intern'] = true;
					}
					
				}elseif( $dotPos === false ){
					$list['intern'] = true;
					
				}elseif( $slashPos !== false ){
					
					if( $dotPos < $slashPos ){
						$list['uri'] = 'http://'.$list['uri']; //external
						
					}else{
						$list['intern'] = true;
					}
				
				//	
				//no slash, there is a dot
				//	could be example.com or filename.ext
				//
				
				}elseif( (strpos($test,'.com') !== false) || (strpos($test,'.net') !== false)  || (strpos($test,'.org') !== false) ){
					 $list['uri'] = 'http://'.$list['uri']; //external
					 
				}else{
					
					$list['intern'] = true;
					
				}
			}
			
			$list['label'] = wbHtmlspecialchars($args['label']);
			if( !empty($args['desc']) ){
				$list['desc'] = wbHtmlspecialchars($args['desc']);
			}
			return $list;		
		}
		
		function isOwnerLink($link){
			global $dbInfo, $pageOwner;
			
			$link = toStorage($link,true);
			//$link = wbStrtolower($link);
			
			//using explode
			$link = trim($link,'/\\');
			$pathArray = explode('/',$link);
			$piece = array_shift($pathArray);
			
			if( $piece === 'edit' ){
				//begins with /edit
				$piece = array_shift($pathArray);
			}
			
			if( isset($dbInfo[$piece]) ){
				//begins with space: $piece
				$piece = array_shift($pathArray);
				if( isset($dbInfo[$piece]) ){
					//begins with second space: $piece
					$piece = array_shift($pathArray);
				}
			}
			if( wbStrcasecmp($pageOwner['username'],$piece) ){
				return true;
			}
			return false;
		}
		
		function deleteLink(){
			global $page,$pageOwner;
			
			
			if( !is_numeric($page->cmdArg[1]) ){
				message('INVALID_REQUEST');
				return;
			}
			if( empty($page->cmdArg[0]) ){
				$page->cmdArg[0] = '';
			}
			if( !isset($this->groups[$page->cmdArg[0]]) ){
				message('INVALID_REQUEST');
				return;
			}
			// if( (count($pageOwner['data2']['links']) < 2) && (count($pageOwner['data2']['links'][$page->cmdArg[0]]) < 2) ){
			// 	return;
			// }

			unset($pageOwner['data2']['links'][$page->cmdArg[0]][$page->cmdArg[1]]);
			if( count($pageOwner['data2']['links'][$page->cmdArg[0]]) < 1){
				unset($pageOwner['data2']['links'][$page->cmdArg[0]]);
				return;
			}
			$pageOwner['data2']['links'][$page->cmdArg[0]] = array_values($pageOwner['data2']['links'][$page->cmdArg[0]]);
		}
		
		function moveUp(){
			global $page,$pageOwner;
			if( !is_numeric($page->cmdArg[1]) || !isset($pageOwner['data2']['links'][$page->cmdArg[0]])){
				message('INVALID_REQUEST');
				return;
			}
			if( !isset($pageOwner['data2']['links'][$page->cmdArg[0]][$page->cmdArg[1]])){
				message('INVALID_REQUEST');
				return;
			}
			$new = array();
			$entry = $pageOwner['data2']['links'][$page->cmdArg[0]][$page->cmdArg[1]];
			foreach($pageOwner['data2']['links'][$page->cmdArg[0]] as $i => $linkArray){
				if( $i === ($page->cmdArg[1]-1)){
					$new[] = $entry;
				}elseif( $i === $page->cmdArg[1]){
					continue;
				}
				$new[] = $linkArray;
			}
			$pageOwner['data2']['links'][$page->cmdArg[0]] = $new;
		}
		
		function moveDown(){
			global $page,$pageOwner;
			if( !isset($page->cmdArg[1]) || !is_numeric($page->cmdArg[1]) ){
				message('INVALID_REQUEST');
				return;
			}
			$page->cmdArg[1]++;
			$this->moveUp();
		}

	
			
	//
	// Show
	//
		function showAll(){
			global $page,$pageOwner,$dbObject,$langA;
			
			$i = 0;
			$groupTotal = count($pageOwner['data2']['links']);
			foreach($pageOwner['data2']['links'] as $groupName => $linkData){
				
				$this->showGroupLinks($i,$groupTotal,$groupName,$linkData);
				$i++;
			}
			
			//
			// forms
			//
				
				echo '<table style="margin-right:auto;margin-left:auto;">';
				echo '<tr>';
				echo '<td style="text-align:center;" >';
				echo '<h3 >'.$langA['add_link'].'</h3>';
				$this->linkForm($_POST);
				echo '</td>';
				echo '</tr></table>';
		}
		
		function showGroupLinks(&$n,&$groupTotal,&$groupName,$linkData=false){
			global $page,$pageOwner,$dbObject,$langA;
				
			//
			//	Show
			//
				$groupData = false;
				$random = false;
				if( isset($pageOwner['data2']['groups'][$groupName]) ){
					$groupData =& $pageOwner['data2']['groups'][$groupName];
					
					if( isset($groupData['order']) && ($groupData['order'] == 'random') ){
						$random = true;
					}
				}
				
				
				$classes[] = 'class="tableRowOdd" ';
				$classes[] = 'class="tableRowEven" ';
				
				echo '<fieldset style="padding-top:0;">';
				echo '<legend align="center">';
				if( $groupData !== false ){
					echo wbLinks::special('LinkGroups?cmd['.$groupName.']=edit',' '.$groupName);
				}elseif( !$groupData ){
					echo wbLinks::special('LinkGroups?cmd=addform&name='.$groupName,' '.$groupName);
					echo ' ('.$langA['deleted'].') ';
				}
				
				echo '</legend>';
				
				echo '<div style="text-align:right">';
				if( $n != 0){
					$label = '<img src="'.wbLinks::getDir('/imgs/icons/arrow_up.gif').'" height="16" width="16" alt="'.$langA['move_up'].'" title="'.$langA['move_up'].'" />';
					echo wbLinks::special('Links?cmd['.urlencode($groupName).']=groupup"',$label);
				}
				if( ($n+1) != $groupTotal ){
					$label = '<img src="'.wbLinks::getDir('/imgs/icons/arrow_down.gif').'" height="16" width="16" alt="'.$langA['move_down'].'" title="'.$langA['move_down'].'" />';
					echo wbLinks::special('Links?cmd['.urlencode($groupName).']=groupdown"',$label);
				}
				echo '</div>';
					
				if( $linkData ){
					echo '<table class="tableRows" style="width:100%;margin:0 1em 1em 1em;">';
					echo '<tr>';
					echo '<th style="width:15%">'.$langA['label'].'</th>';
					echo '<th style="width:15%">'.$langA['type'].'</th>';
					echo '<th style="width:15%">'.$langA['uri'].'</th>';
					echo '<th style="width:40%">'.$langA['description'].'</th>';
					echo '<th style="width:15%">'.$langA['options'].'</th>';
					echo '</tr>';
				
					$count = count($linkData);
					foreach($linkData as $i => $linkArray){
					echo '<tr '.$classes[($i)%2].'>';
						
						echo '<td style="white-space:nowrap">';
						echo $linkArray['label'];
						echo '</td>';
						echo '<td style="white-space:nowrap">';
						if( isset($linkArray['intern']) ){
							echo $langA['internal_link'];
							
						}elseif( isset($linkArray['attach']) ){
							echo $langA['attach'];
							
						}else{
							echo $langA['external_link'];
						}
						echo '</td>';
						echo '<td style="white-space:nowrap">';
						
						$attr = '';
						if( !empty($linkArray['desc']) ){
							$attr = ' title="'.$linkArray['desc'].'"';
						}
						
						$showUri = $linkArray['uri'];
						$pos = strpos($showUri,'://');
						if( $pos !== false){
							$showUri = substr($showUri,$pos+3);
						}
						if( strlen($showUri) > 20 ){
							$showUri = substr($showUri,0,20).'...';
						}
						
						if( isset($linkArray['intern']) ){
							echo wbLinks::local($linkArray['uri'],$showUri,$attr);
							
						}elseif( isset($linkArray['attach']) ){
							
							echo '<a href="'.wbLinks::getDir($linkArray['uri']).'"';
							echo ' rev="'.$page->revType.'" ';
							echo $attr;
							echo '>';
							echo $showUri;
							echo '</a>';
							
						}elseif( isset($linkArray['otheruser']) ){
							
							echo '<a href="'.wbLinks::getUrl($linkArray['uri']).'"';
							echo ' class="otheruser" ';
							echo $attr;
							echo '>';
							echo $showUri;
							echo '</a>';
							
						}else{
							
							echo '<a href="'.str_replace('&','&amp;',$linkArray['uri']).'" class="external"';
							echo $attr;
							echo '>';
							echo $showUri;
							echo '</a>';
							
						}
						
						
						echo '</td>';
						
						echo '<td class="sm">';
						if( !empty($linkArray['desc']) ){
							echo $linkArray['desc'];
						}else{
							echo ' ';
						}
						echo '</td>';
						
						echo '<td style="white-space:nowrap">';
						if( !$random ){
							if( $i != 0){
								$label = '<img src="'.wbLinks::getDir('/imgs/icons/arrow_up.gif').'" height="16" width="16" alt="'.$langA['move_up'].'" title="'.$langA['move_up'].'" />';
								echo wbLinks::special('Links?cmd['.urlencode($groupName).']['.$i.']=up"',$label);
							}else{
								echo '<img src="'.wbLinks::getDir('/imgs/blank.gif').'" height="16" width="16" alt="" title="" />';
							}
							echo ' &nbsp; ';
							if( ($i+1) != $count ){
								$label = '<img src="'.wbLinks::getDir('/imgs/icons/arrow_down.gif').'" height="16" width="16" alt="'.$langA['move_down'].'" title="'.$langA['move_down'].'" />';
								echo wbLinks::special('Links?cmd['.urlencode($groupName).']['.$i.']=down"',$label);
							}else{
								echo '<img src="'.wbLinks::getDir('/imgs/blank.gif').'" height="16" width="16" alt="" title="" />';
							}
						}else{
							echo ' <img src="'.wbLinks::getDir('/imgs/blank.gif').'" height="16" width="16" alt="" />';
							echo ' &nbsp; ';
							echo ' <img src="'.wbLinks::getDir('/imgs/blank.gif').'" height="16" width="16" alt="" />';
						}
						
						if( empty($groupName)){
							$groupName = '0';
						}
						
						echo ' <input type="submit" name="cmd['.$groupName.']['.$i.']" value="'.$langA['edit'].'" />';
						echo ' <input type="submit" name="cmd['.$groupName.']['.$i.']" value="'.$langA['delete'].'" />';
						
						echo '</td>';
						
						echo '</tr>';
					}
					echo '</table>';
				}
				echo '</fieldset>';
		}
	//
	// forms
	//
		function setGroups(){
			global $pageOwner;
			if( isset($pageOwner['data2']['groups']) && is_array($pageOwner['data2']['groups']) ){
				foreach($pageOwner['data2']['groups'] as $group => $groupData){
					$this->groups[$group] = $group;
				}
			}
			foreach($pageOwner['data2']['links'] as $group => $linkData){
				$this->groups[$group] = $group;
			}
		}

		function linkForm($args,$how='add_link',$group=''){
			global $langA,$serverName4,$pageOwner;
			
			
			$args += array('label'=>'','uri'=>'','desc'=>'','type'=>'');
			if( empty($group) && isset($args['group']) ){
				$group =& $args['group'];
			}
			
			$types = array(''=>'auto_detect',' '=>'','internal'=>'internal_link','attach'=>'attach','external'=>'external_link');
			
			echo '<table cellspacing="7" class="WBeditArea1">';
			echo '<tr>';
				echo '<td style="text-align:right;"><b>* '.$langA['label'].': </b></td>';
				echo '<td><input type="text" name="label" size="50" value="'.wbHtmlspecialchars($args['label']).'" />';
				echo '</td>';
				echo '</tr>';
			echo '<tr>';
				echo '<td style="text-align:right"><b>* '.$langA['uri'].': </b></td>';
				echo '<td><input type="text" name="uri" size="50" value="'.wbHtmlspecialchars($args['uri']).'" />';
				echo '</td>';
				echo '</tr>';
				
			echo '<tr>';
				echo '<td style="text-align:right"><b>'.$langA['description'].': </b></td>';
				echo '<td><input type="text" name="desc" size="50" value="'.wbHtmlspecialchars($args['desc']).'" />';
				echo '</td>';
				echo '</tr>';
				
			echo '<tr>';
				echo '<td style="text-align:right">';
				if( count($this->groups) < 1){
					echo ' <span style="color:red;font-weight:bold">!</a> ';
				}
				echo '<b>'.$langA['group'].': </b>';
				echo '</td>';
				echo '<td>';
				echo $this->formSelect('group',$this->groups,$group,false);
				echo ' ';
				echo wbLinks::special('LinkGroups','link_groups');
				echo '</td>';
				echo '</tr>';
				
			echo '<tr>';
				echo '<td style="text-align:right"><b> '.$langA['type'].': </b></td>';
				echo '<td>';
				echo $this->formSelect('type',$types,$args['type']);
				echo '</td>';
				echo '</tr>';
				
			echo '<tr>';
				echo '<td></td>';
				echo '<td>';
				echo '<input type="submit" name="cmd" value="'.$langA[$how].'" />';
				echo ' <input type="submit" name="cmd" value="'.$langA['cancel'].'" />';
				echo '</td>';
				echo '</tr>';
				
			echo '</table>';
			
		}
		
		function formSelect($name,$values,$selected=null,$useLang=true){
			global $langA;
			$select = '<select name="'.$name.'">';
			if( count($values) < 1 ){
				$select .= '<option></option>';
			}
			foreach($values as $key => $value){
				if($key == $selected){
					$focus = ' selected="selected" ';
				}else{
					$focus = '';
				}
				if( $useLang && isset($langA[$value]) ){
					$value = $langA[$value];
				}
				$select .= '<option value="'.wbHtmlspecialchars($key).'" '.$focus.'>'.$value.'</option>';
			}
			$select .= '</select>';
			return $select;
		}		
		
		
	//
	// Template detection
	//
	
		function hasLinks(){
			if( is_readable($this->templateFile) ){
				$contents = file_get_contents($this->templateFile);
				if( strpos($contents,'$page->getLinks();') === false){
					message('Your theme does not have links enabled.');
				}
			}
		}
		
		function whichTemplate(){
			global $pageOwner,$includeDir,$rootDir;
			
			if( isset($pageOwner['template']) && !empty($pageOwner['template']) ){
				$template = whichTemplate($pageOwner);
				if( is_array($template)){
					$this->templateFile = $rootDir.'/templates/'.$template['templateNameLow'].'/template.php';
					if( file_exists($this->templateFile)){
						return;
					}
				}
			}
			if( isset($pageOwner['pTemplate']) && $pageOwner['pTemplate'] != ''){
				$this->templateFile = $includeDir.'/themes/'.dirname($pageOwner['pTemplate']).'/template.php';
				if( file_exists($this->templateFile) ){
					return;
				}
			}
			$this->templateFile = $includeDir.'/themes/default/template.php';
			return;
		}

}
new ownerLinks();
