<?php
defined('WikyBlog') or die("Not an entry point...");

wbLang::getFile('specPreferences');

						
//New						
class specPreferences{
	
	var $defaultPrefs = array(	/*user*/
								'email'=>null,
								'timezone'=>null,
								'lang'=>null,
								'sig'=>null,
								/*javascript*/
								'ajax'=>null,
								'nTabs'=>null,
								'nWin'=>'Off',				//version 1.3.5	Open external links in new window
								'scrl'=>null,
								'shortK'=>null,
								/*template*/
								'template'=>null,
								'pTemplate'=>null,
								/*account display*/
								'homeTitle'=>null,
								'ihelp'=>'Off',				//version 1.6	show help links
								'quickComment'=>null,
								'share'=>null,
								/*blog*/
								'isBlog'=>null,
								'blogT'=>null,
								'sBlog'=>'Off',				//version 1.3.1	selective blogging
								'uServices'=>null,
								'nBlog'=>null,
								'blen'=>400,
								/*editing*/
								'textareaY'=>null,'maxHistory'=>null,'fEdits'=>null,
								'saveAll'=>'Off'				//version 1.5.7	Save All Edits
								);
								
	var $prefTypes = array(		/*user*/
								'email'=>'string','timezone'=>'string', 'lang'=>'string',
								'sig'=>'string',
								/*javascript*/
								'ajax'=>'bool2','nTabs'=>'int','nWin'=>'bool','scrl'=>'bool',
								'shortK'=>'shortcut',
								/*template*/
								'template'=>'string','pTemplate'=>'string',
								/*account display*/
								'homeTitle'=>'string', 'ihelp'=>'bool',
								'quickComment'=>'bool', 'share'=>'bool',
								/*Blog*/
								'isBlog'=>'bool','blogT'=>'blogT',
								'sBlog'=>'bool','uServices'=>'string',
								'nBlog'=>'nBlog','blen'=>'int',
								/*editing*/
								'textareaY'=>'int','maxHistory'=>'int','fEdits'=>'fEdits','saveAll'=>'bool'
								);
								
	var $javascriptEval = array('ajax'=>'WB.ajax','nTabs'=>'WB.tabs','nWin'=>'WB.win','scrl'=>'WB.sc');
								
	var $values = array();
	
	function setValues(){
		global $langA;
		
		$this->values['bool']['On'] = $langA['on'];
		$this->values['bool']['Off'] = $langA['off'];
		
		$this->values['bool2']['On'] = $langA['on'];
		/* $this->values['bool2']['Partial'] = $langA['partial']; */
		$this->values['bool2']['Off'] = $langA['off'];

		$this->values['fEdits']['2'] = $langA['workgroup'];
		$this->values['fEdits']['1'] = $langA['registered'];
		$this->values['fEdits']['0'] = $langA['anonymous'];
		
		$this->values['shortcut']['alt'] = 'alt';
		$this->values['shortcut']['alt-shift'] = 'alt-shift';
		$this->values['shortcut']['alt-ctrl'] = 'alt-ctrl';
		
		$this->values['nBlog']['5'] = '5';
		$this->values['nBlog']['10'] = '10';
		$this->values['nBlog']['15'] = '15';
		$this->values['nBlog']['20'] = '20';
		$this->values['nBlog']['25'] = '25';
	}		
											
	function specPreferences(){
		global $langA,$dbInfo,$dbObject, $page,$pageOwner;
		
		if( !isOwner(true,true) ) return false; //	personal preferences, no need to let others change them

		$contentUri = $page->regLink($langA['user_preferences'],'/Special/'.$pageOwner['username'].'/Preferences');
		$page->regLink('?',$langA['user_preferences'].'?en=User_Preferences');

		$this->setValues();
		
		// blog types
		$tempObject=null;
		$this->values['blogT'] = array();
		foreach($dbInfo as $space => $info){
			if( !isset($info['dbTable']) ){
				continue;
			}
			$class = wbData::getClass($space,true);
			if( !$class ){
				continue;
			}
			
			if( is_callable(array($class,'abbrevOutputContent')) ){
				
				
				if( isset($langA[$space]) ){
					$this->values['blogT'][$space] = $langA[$space];
				}else{
					$this->values['blogT'][$space] = $space;
				}
			}
		}
		
		ob_start();
		
		switch( $page->userCmd ){
			case 'js':
				$this->setJs();
			break;
			case 'set':
				$this->setPref($_GET);
			break;
			case 'save preferences':
				$this->save($_POST);
			break;
			default:
				$this->displayForm();
			break;
		}
		
		$page->contentB[$contentUri] = wb::get_clean();
	}

	function setJs(){
		global $page;
		$keys = array('scrl'=>true,'nWin'=>true);
		$_GET += array('k'=>'','v'=>'');
		if( !isset($keys[$_GET['k']]) ){
			return;
		}
		
		$page->session = true; //update the user session menu
		$setValue[$_GET['k']] = $_GET['v'];
		$this->save($setValue,false);
	}

	function save($newValues,$show=true){
		global $pageOwner,$page,$langA,$dbObject,$maxHistory;
		$invalid = array();
			
			
		////	check timezone
			if( !empty($newValues['timezone']) ){
				$num = sscanf($newValues['timezone'], "%d:%d", $hr,$mim);
				if($num !== 2){
					$invalid['timezone'] = true;
				}
			}
		
		/////	check template
			if( isset($newValues['pTemplate']) && ($newValues['pTemplate'] != '')){
				$newValues['template'] = '';
				
			}elseif( isset($newValues['template']) ){
				$newValues['template'] = toStorage($newValues['template']);
				$temp = whichTemplate($newValues,false);//will be warned with the form display
				if( !is_array($temp) ){
					$invalid['template'] = false; //idea is that false will prevent another message
				}
			}
			
		/////	Update Services
			if( !isset($newValues['sBlog']) || ($newValues['sBlog'] == 'Off') ){
				unset($newValues['uServices']);
			}
			
		/////	Update Blog Type
			if( isset($newValues['sBlog']) && ($newValues['sBlog'] == 'On') ){
				unset($newValues['blogT']);
			}
			
			if( isset($newValues['uServices']) ){
				$goodUrls = true;
				$urls = stringToArray($newValues['uServices']);
				foreach($urls as $url){
					$url = trim($url);
					if( empty($url) ){
						continue;
					}
					$temp = parse_url($url);
					if( empty($temp['host']) || empty($temp['scheme']) ){
						$goodUrls = false;
					}
				}
				if( !$goodUrls ){
					message('BAD_UPDATE_SERVICES');
				}
			}
			
			
		////	Max History
			if( !empty($newValues['maxHistory']) ){
				$newValues['maxHistory'] = (int)$newValues['maxHistory'];
				$maxHistory = (int)$maxHistory;
				if( ($maxHistory > 0) && ($newValues['maxHistory'] > $maxHistory) ){
					$newValues['maxHistory'] = $maxHistory;
				}
			}
			
		////	lang
			global $userLanguage;
			if( isset($newValues['lang'] )){
				$possLangs = $this->getPossible('lang');
				if( !isset($possLangs[$newValues['lang']]) ){
					$newValues['lang'] = $userLanguage;
				}
			}
			
		//// check against types
			foreach($newValues as $key => $value){
				if( !array_key_exists($key,$this->prefTypes) ){
					unset($newValues[$key]);
					continue;
				}
				$type = $this->prefTypes[$key];
				
				//this takes care of bool, bool2
				if( isset($this->values[$type]) ){
					if( !isset($this->values[$type][$value]) ){
						unset($newValues[$key]);
					}
					continue;
				}
				
				switch($type){
					case 'int':
						$newValues[$key] = (int)$newValues[$key];
					break;
					case 'string':
						$newValues[$key] = wbHtmlspecialchars($newValues[$key]);
					break;
				}
			}
			

		////	Valid?
			if( count($invalid) > 0){
				message('INVALID_PREFS');
				//message(showArray($invalid)); //after this..
				$this->displayForm();
				return false;
			}
			
			
		//
		//	Which Have Changed?
		//
			$evalSet = array();
			foreach($newValues as $prefKey => $value){
				
				//invalid $prefKey
				if( !array_key_exists($prefKey,$this->defaultPrefs) ){
					continue;
				}
					
				//both empty, no change
				if( empty($pageOwner[$prefKey]) && empty($newValues[$prefKey]) ){
					continue;
				}
				//unchanged
				if( isset($pageOwner[$prefKey]) && ($pageOwner[$prefKey] === $newValues[$prefKey]) ){
					continue;
				}
				
				if( !isset($pageOwner[$prefKey]) ){
					$old[$prefKey] = '';
				}elseif( $pageOwner[$prefKey] !== $newValues[$prefKey] ){
					$old[$prefKey] = $pageOwner[$prefKey];
				}
				
				if( empty($newValues[$prefKey]) && ($value !== '0') ){
					unset($pageOwner[$prefKey]);
				}else{
					$pageOwner[$prefKey] = $newValues[$prefKey];
				}
				
				//javascript changes?
				if( isset($this->javascriptEval[$prefKey]) ){
					$evalSet[$prefKey] = $newValues[$prefKey];
				}
			}
			if( isset($pageOwner['template']) ){
				unset($pageOwner['pTemplate']);
			}
			
			
		// Javascript Eval Values
			$this->sendJavascript($evalSet);

			
		//
		//	Unchanged Message
		//						
			if( !$show ){
				return;
			}
			if( empty($old) ){
				message('PREFERENCES_UNCHANGED');
				return;
			}
			$newValues = $newValues + $this->defaultPrefs;	//defaultPrefs won't overwrite values, but will set keys
			
		//
		//	Preferences Were Changed
		//
		//		some values need to be changed in the user's browser..
		
			echo $langA['PREFS_CHANGED'];
			
			echo '<table class="tableRows" cellspacing="0">';
			echo '<tr><th>'.$langA['preference'].'</th><th>'.$langA['old_value'].'</th><th>'.$langA['new_value'].'</th>';
			$i = 0;
			$classes[] = ' class="tableRowEven" ';
			$classes[] = ' class="tableRowOdd" ';
			foreach($old as $prefKey => $oldValue){
				$class = $classes[($i%2)];
				echo '<tr'.$class.'><td>';
				
				if( isset($langA[$prefKey]) && is_string($langA[$prefKey]) ){
					echo $langA[$prefKey];
				}else{
					echo toDisplay($prefKey);
				}
				
				echo '</td><td>';
				
				if( isset($langA[$oldValue]) ){
					echo $langA[$oldValue];
				}else{
					echo $oldValue;
				}
				
				echo '</td><td>';
				
				if(isset($langA[$newValues[$prefKey]]) && is_string($langA[$newValues[$prefKey]]) ){
					echo $langA[$newValues[$prefKey]];
				}else{
					echo $newValues[$prefKey];
				}
				
				echo '</td></tr>';
				$i++;
			}
			
			echo '<tr><td>';
			echo wbLinks::local('/Special/'.$pageOwner['username'].'/Preferences?again=true',$langA['user_preferences']);
			echo '</td></tr>';
			echo '</table>';
			
			

	}
	
	//send JSON objects to update the user's javascript prefs
	function sendJavascript($evalSet){
		global $page;
		
		if( $page->ajaxRequest && count($evalSet) > 0){
			$addContent = new content();
			$addContent->aa = 'eval';
			$addContent->bb = '';
			foreach($evalSet as $prefKey=>$value){
				if( $prefKey == 'scrl' ){
					if( $value == 'Off'){
						$addContent->bb .= 'WBx.uDS();';
					}else{
						$addContent->bb .= 'WBx.iDS();';
					}
				}
				
				$addContent->bb .= $this->javascriptEval[$prefKey].'="'.$value.'";';
			}
			$page->contentClasses[] = $addContent;
		}
	}
	

	///	Do not use checkboxes!
	function displayForm(){
		global $page,$thisServer,$dbObject,$pageOwner,$langA,$jsNum,$wbWritable,$wbNow,$maxHistory;
	
		$page->scripts[] = '/include/js/preferences.js?'.$jsNum;
		$page->autoForm = true;
		$pageOwner = $pageOwner + $this->defaultPrefs;	//defaultPrefs won't overwrite values, but will set keys
		
		if( isset($pageOwner['pTemplate']) && ($pageOwner['pTemplate'] != '')){
			$template = '';
		}else{
			$template = whichTemplate($pageOwner,true);
		}
		
		if( empty($pageOwner['sig']) ){
			$pageOwner['sig'] = '--[[/'.$pageOwner['username'].'/'.$GLOBALS['wbDefaultTitle'].'|'.$pageOwner['username'].']]';
		}
		
		

		
		//Go through dbFromDate function to get times
		//yyyy/mm/dd hh:mm:ss
		$adjusted = dbFromDate($wbNow,'unix');
	 	$serverTime = date("H:i");
	 	$adjustedTime = date("H:i",$adjusted);
	 	
	 	
		//Max History Rows
			$max = (int)$maxHistory;
			$pageOwner['maxHistory'] = (int)$pageOwner['maxHistory'];
			$personalMax = $pageOwner['maxHistory'];
			
			if( ($max > 0) && ($max < $personalMax) ){
				$personalMax = $max;
			}
			if( $max === 0 ){
				$max = $langA['unlimited'];
			}
			
		?>
		<br/>
		
		<table class="tableRows" width="100%" border="0">
		
		<tr><th colspan="3"><?php echo $langA['user'] ?></th></tr>
		
		<tr><td><?php echo $langA['email'] ?>:</td><td>
			<input size="30" name="email" value="<?php echo $pageOwner['email'] ?>" type="text" />
			</td><td class="row2"><?php echo $langA['EMAIL_PREFS'] ?></td></tr>
		
		<tr><td><?php echo $langA['language'] ?>:</td><td>
			<?php
				echo formSelect('lang',$this->getPossible('lang'),$pageOwner['lang']);
			?>
			</td><td class="row2"><?php echo $langA['LANG_PREFS'] ?></td></tr>
			
			
		<tr><td><?php echo $langA['time_zone'] ?>:</td><td>
			<input size="6" name="timezone" value="<?php echo $pageOwner['timezone'] ?>" type="text" />
			</td><td class="row2"><?php echo $langA['TIME_ZONE_PREFS'] ?>
			<div style="width:18em;margin-left:auto;margin-right:auto;white-space:nowrap">
				<?php echo wbLang::text('TIME_ZONE_PREFS2', $serverTime,$adjustedTime) ?>
			</div>
			</td></tr>
			
		<tr><td><?php echo $langA['sig'] ?>:</td><td>
			<textarea rows="3" cols="6" style="width:98%" name="sig"><?php
				echo $pageOwner['sig'];
				?></textarea>
		
			</td><td class="row2"><?php echo $langA['SIGNATURE'] ?>
			</td></tr>
			
		<tr><th colspan="3"><?php echo $langA['javascript'] ?></th></tr>	
			
		<tr><td><?php echo $langA['enhanced_tabs'] ?>:</td><td>
			<?php
				echo formSelect('ajax',$this->values['bool2'],$pageOwner['ajax'])
			?>
			</td><td class="row2">
			<?php echo $langA['ENHANCED_TABS'] ?>
			</td></tr>
			
		<tr><td><?php echo $langA['tab_limit'] ?>:</td><td>
			<input size="6" name="nTabs" value="<?php echo $pageOwner['nTabs'] ?>" type="text" />
			</td><td class="row2">
			<?php echo $langA['TAB_LIMIT'] ?>
			</td></tr>		
			
		
		<tr><td><?php echo $langA['nWin'] ?>:</td><td>
			<?php
				echo formSelect('nWin',$this->values['bool'],$pageOwner['nWin']);
			?>
			</td><td class="row2">
			<?php echo $langA['EXTERNAL_LINKS']; ?>
			</td></tr>
			
		<tr><td><?php echo $langA['scrl'] ?>:</td><td>
			<?php
				echo formSelect('scrl',$this->values['bool'],$pageOwner['scrl']);
			?>
			</td><td class="row2">
			<?php echo $langA['SCROLL_CONTENT']; ?>
			</td></tr>
			
		<tr><td><?php echo $langA['shortK'] ?>:</td><td>
			<?php
				echo formSelect('shortK',$this->values['shortcut'],$pageOwner['shortK']);

			?>
			</td><td class="row2">
			<?php echo $langA['SHORTK_CONTENT']; ?>
			</td></tr>
			
		<tr><th colspan="3"><?php echo $langA['theme'] ?></th></tr>	
			
		<tr><td><?php echo $langA['pTemplate'] ?>:</td><td>
			<?php
				$this->pTemplates();
			?>
			</td><td class="row2"><?php  /*echo $langA['LANG_PREFS']*/ ?></td></tr>
			
			
			<?php
				if( !isset($wbWritable) || $wbWritable === true){
					echo '<tr><td>'. $langA['custom_theme'] .':</td><td>';
					$script = ' onchange="this.form.pTemplate.value=\'\'" ';
					if( is_array($template) ){
						echo '<input '.$script.' size="30" name="template" value="'. $template['templateName'].'" type="text" /><br/>';
						echo '</td><td class="row2">';
				
						$link1 = wbLinks::local('/Theme/'.$template['templateName'],false);
						echo wbLang::text('VIEW_THEME',$link1);
					}else{
						echo '<input '.$script.' size="30" name="template" value="" type="text" /><br/>';
						echo '</td><td class="row2">';
					}
					echo '</td></tr>';
				}
			?>
			
		<tr><th colspan="3"><?php echo $langA['account_display'] ?></th></tr>	
	
		<tr><td><?php echo $langA['home_title'] ?>:</td><td>
			<input size="30" name="homeTitle" value="<?php echo $pageOwner['homeTitle'] ?>" type="text" />
			</td><td class="row2"><?php echo $langA['HOME_TITLE_PREFS'] ?></td></tr>
			
		<tr><td style="white-space:nowrap"><?php echo $langA['quick_comment']; ?>:</td><td>
			<?php
			echo formSelect('quickComment',$this->values['bool'],$pageOwner['quickComment'])
			?>
			</td><td class="row2"><?php echo $langA['QUICK_COMMENT']; ?></td></tr>
			
		<tr><td style="white-space:nowrap"><?php echo $langA['share'] ?>:</td><td>
			<?php
			//	sharing
			echo formSelect('share',$this->values['bool'],$pageOwner['share']);
			?>
	
			</td><td class="row2"><?php echo $langA['SHARE'] ?></td></tr>
		
		<?php
		
			//help Links
			echo '<tr><td style="white-space:nowrap">';
			echo $langA['ihelp']; 
			echo ':</td><td>';
			echo formSelect('ihelp',$this->values['bool'],$pageOwner['ihelp']);
			echo '</td><td class="row2">';
			echo $langA['IHELP'];
			echo '</td></tr>';
			
		?>
		
		<tr><th colspan="3"><?php echo $langA['blog'] ?></th></tr>	
		
		<tr><td style="white-space:nowrap"><?php echo $langA['blog_styled_frontpage'] ?>:</td><td>
			<?php
			//	isBlog
			echo formSelect('isBlog',$this->values['bool'],$pageOwner['isBlog'])
			?>
			</td><td class="row2"><?php echo $langA['BLOG_PREFS'] ?></td></tr>
		
		<tr><td style="white-space:nowrap"><?php echo $langA['blog_count'] ?>:</td><td>
			<?php
			//	nBlog
			echo formSelect('nBlog',$this->values['nBlog'],$pageOwner['nBlog']);
			?>
	
			</td><td class="row2"><?php echo $langA['BLOG_COUNT'] ?></td></tr>
			
		<tr><td style="white-space:nowrap"><?php echo $langA['blen']; ?>:</td><td>
			<input size="6" name="blen" value="<?php echo $pageOwner['blen']; ?>" type="text" />
			</td><td class="row2"><?php echo $langA['BLEN']  ?></td></tr>

					<tr><td style="white-space:nowrap"><?php echo $langA['selective_blogging'] ?>:</td><td>
			<?php
			//	sBlog
			echo formSelect('sBlog',$this->values['bool'],$pageOwner['sBlog'],'showSBOptions');
			?>
	
			</td><td class="row2"><?php echo $langA['SELECTIVE_BLOGGING'] ?></td></tr>
		
			
		<?php
		
			if( isset($pageOwner['sBlog']) && ($pageOwner['sBlog'] == 'On') ){
				echo '<tr id="WBPrefUpdateServices">';
			}else{
				echo '<tr id="WBPrefUpdateServices" style="display:none">';
			}
			echo '<td>';
			echo $langA['uServices'];
			?>
			:</td>
			<td colspan="2">
			<?php echo $langA['UPDATE_SERVICES']; ?>
			<p>
			<textarea rows="5" style="width:98%" cols="6" name="uServices"><?php
			echo $pageOwner['uServices'];
			?></textarea>
			</p>
			</td></tr>
			
		<?php
			//Blog Type
			//	Only makes sense to limit the blogType when selective blogging is off
			if( isset($pageOwner['sBlog']) && ($pageOwner['sBlog'] == 'On') ){
				echo '<tr id="WBPrefBlogType" style="display:none">';
			}else{
				echo '<tr id="WBPrefBlogType">';
			}
			echo '<td style="white-space:nowrap">'. $langA['blogT'].':</td><td>';
			
			echo formSelect('blogT',$this->values['blogT'],$pageOwner['blogT']);
			echo '</td><td class="row2">'. $langA['BLOG_TYPE'] .'</td></tr>';
			?>

		
		<tr><th colspan="3"><?php echo $langA['editing'] ?></th></tr>
		
		<tr><td><?php echo $langA['textarea rows'] ?>:</td><td>
			<input size="4" name="textareaY" value="<?php echo $pageOwner['textareaY'] ?>" type="text" />
			</td><td class="row2"><?php echo $langA['TEXTAREA_ROWS_PREFS'] ?></td></tr>
			
		
		<tr><td style="white-space:nowrap"><?php echo $langA['history_rows'] ?>:</td><td>
		
			<input size="4" name="maxHistory" value="<?php echo $personalMax; ?>" type="text" />
			</td><td class="row2">
			<?php echo $langA['HISTORY_ROWS_PREFS'] ?>
			<div style="width:18em;margin-left:auto;margin-right:auto;white-space:nowrap">
				<?php echo wbLang::text('HISTORY_ROWS_PREFS2',$max) ?>
			</div>
			</td></tr>
			
		<tr><td style="white-space:nowrap"><?php echo $langA['fEdits'] ?>:</td><td>
			<?php
			echo formSelect('fEdits',$this->values['fEdits'],$pageOwner['fEdits']);
			?>
			</td><td class="row2"><?php echo $langA['FLAG_EDITS'] ?></td></tr>
			
		<tr><td style="white-space:nowrap"><?php echo $langA['saveAll'] ?>:</td><td>
			<?php
			echo formSelect('saveAll',$this->values['bool'],$pageOwner['saveAll']);
			?>
			</td><td class="row2"><?php echo $langA['SAVEALL'] ?></td></tr>
			
		<tr><td></td><td>
			<input type="hidden" name="cmd" value="Save Preferences" />
			<input type="submit" value="<?php echo $langA['save_preferences'] ?>" accesskey="s" />
			<input type="reset" value="<?php echo $langA['reset'] ?>" />
			</td></tr>
			
		</table>
		<?php
		
		
	}	
				
	///////////////////////////////////
	//		
	//		Select for pTemplates
	//
	
	function pTemplates(){
		global $langA,$pageOwner;
		
		includeFile('themes/data.php');
		$this->themes = returnThemeData();
		
		echo '<select name="pTemplate">';
		
		foreach($this->themes as $theme => $colors){
			echo '<option value="" ></option>';
			
			if( isset($langA['themes'][$theme]) ){
				echo '<optgroup label="'.$langA['themes'][$theme].'" title="'.$langA['themes'][$theme].'">';
			}else{
				echo '<optgroup label="'.$theme.'" title="'.$theme.'">';
			}
			
			foreach($colors as $color => $array){
				if( $color == 'html'){
					continue;
				}
				$full = $theme.'/'.$color;
				if( $full == $pageOwner['pTemplate'] ){
					echo '<option value="'.$full.'" selected="selected" >'.$langA['colors'][$color].'</option>';
				}else{
					echo '<option value="'.$full.'" >'.$langA['colors'][$color].'</option>';
				}
			}
			echo '</optgroup>';
		}
		echo '</select>';

	}
	
	
	function setPref($array){
		global $page,$pageOwner,$langA,$dbObject;
		
		$page->autoForm = true;
		
		echo $langA['CONFIRM_CHANGE'];
		
		echo '<table class="tableRows" cellspacing="0">';
		echo '<tr><th>'.$langA['preference'].'</th><th>'.$langA['old_value'].'</th><th>'.$langA['new_value'].'</th></tr>';
		$i = 0;
		$classes[] = ' class="tableRowOdd" ';
		$classes[] = ' class="tableRowEven" ';
		foreach($array as $prefKey => $value){
			if( !array_key_exists($prefKey,$this->defaultPrefs) ){
				continue;
			}
			$i++;
			echo '<tr'.$classes[($i%2)].'><td>';
			if( isset($langA[$prefKey]) ){
				echo $langA[$prefKey];
			}else{
				echo toDisplay($prefKey);
			}
			echo '</td><td>';
			if( isset($pageOwner[$prefKey]) ){
				echo $pageOwner[$prefKey];
			}else{
				echo '&nbsp;';
			}
			echo '</td><td>'.$value;
			echo '<input type="hidden" name="'.$prefKey.'" value="'.$value.'" />';
			echo '</td></tr>';
		}
		echo '</table>';
		echo '<input type="hidden" name="cmd" value="Save Preferences" />';
		echo '<input type="submit" value="'. $langA['save_preferences'] .'" accessKey="s" />';
		echo '<input type="submit" name="cmd" value="'.$langA['cancel'].'" />';
	}
	
	
	///////////////////////////////////
	//		
	//		get possible value
	//
	

	//Get an array of available languages
	function getPossible($dir){
		global $includeDir,$langA;
		
		$array = array();
		$langDir = $includeDir.'/'.$dir;
		if($dh = @opendir($langDir)){
			while (($file = readdir($dh)) !== false){
				if( strpos($file,'.') === 0){
					continue;
				}
				if( strpos($file,'x_') === 0){
					continue;
				}
	
				$fullPath = $langDir.'/'.$file;
				if( !is_dir($fullPath) ){
					continue;
				}
				
				$array[$file] = $langA[$dir][$file];
			}
		}
		asort($array);
		return $array;
	}

	
}

global $initiateFileClass;
if( $initiateFileClass ){
	new specPreferences();
}




// similar to functions in searchSearch.php, specPreferences.php
function formSelect($name,$values,$selected=null,$onchange=false){
	if( !$onchange ){
		$select = '<select name="'.$name.'">';
	}else{
		$select = '<select name="'.$name.'" onchange="'.$onchange.'(this)">';
	}
	foreach($values as $key => $value){
		if($key == $selected){
			$focus = ' selected="selected" ';
		}else{
			$focus = '';
		}
		// if( is_numeric($key) ){
		// 	$key = '';
		// }
		$select .= '<option value="'.$key.'" '.$focus.'>'.$value.'</option>';
	}
	$select .= '</select>';
	return $select;
}
