<?php

defined('WikyBlog') or die("Not an entry point...");
wbLang::getFile('register');
wbLang::getFile('SPEC');


class registerForm{
	
	var $requireEmail = false;
	var $requireCaptcha = false;
	var $config;
	
	function registerForm(){
		global $pageOwner,$dbObject,$langA,$page, $registered;
		
		//config
		includeFile('tool/Variables.php');
		$this->config = wbVariables::getArray('register:');
		if( isset($this->config['register:reqemail']) && ($this->config['register:reqemail'] === 'On') ){
			$this->requireEmail = true;
		}
		if( isset($this->config['register:captcha']) && ($this->config['register:captcha'] === 'On') ){
			$this->requireCaptcha = true;
		}
		

		$page->regLink($langA['log_in'],'/Special/'.$GLOBALS['wbConfig']['pUser'].'/LogIn');
		$contentUri = $page->regLink($langA['register'],'/Special/'.$GLOBALS['wbConfig']['pUser'].'/Register');
		$page->regLink($langA['lost_password'],'/Special/'.$GLOBALS['wbConfig']['pUser'].'/LostPassword');
		
		

		
		
		
		ob_start();
		
			if( empty($_POST['username']) && !empty($_GET['username']) ){
				$_POST['username'] = $_GET['username'];
			}
			
			
			if( isset($_SESSION['username']) ){
				$registered = true;
			}
			
			if( !isset($registered) || !$registered ){
				$this->showForm();
			}
			
				
			$this->regText();
		
		$page->contentB[$contentUri] = wb::get_clean();
	}

	function showForm(){
		global $page,$pageOwner,$dbObject,$langA;
		
		$page->autoForm = true;
		$_POST += array('username'=>'', 'email'=>'');
		
		//maybe
		//$colors['#883333'] = '#ffffdd';
		//$colors['#333388'] = '#eeeeff';
		//$colors['#338833'] = '#eeffdd';
		
		//maybe
		$colors['#cccccc'] = '#f1f1f1';
		
		//no
		//$colors['blue'] = 'red';
		
		$border = array_rand($colors);
		$color = $colors[$border];
		
		?>
		
		
		<style>
		.registerWrapper{
			letter-spacing:normal;
			font-color:black;
			font-size:normal;line-height:normal;}
			
		.registerBox{
			letter-spacing:.07em;
			border: 1px <?php echo $border ?> solid;font-size:normal;line-height:150%;
			background-color:<?php echo $color ?>;width:90%;
			margin: 3em auto 3em auto;padding:1em;}
		
			
		.registerTable td{vertical-align:top;}
		.registerHead{font-size:200%;line-height:normal;text-align:left;border-color:#cccccc;border-style:solid;border-width: 0 0 1px 0;}
	
		
		.registerLabel{white-space:nowrap;text-align:right;font-weight:bold}
		.registerDetail{font-size:95%;}
		.registerSubmit{border:1px <?php echo $border ?> solid;padding:.4em .8em .4em .8em;background-color:<?php echo $color ?>;font-weight:bold;}
		.registerTable .input{width:10em;}
		
		</style>
		<p>
		
		
		<div class="registerWrapper">
		<div class="registerBox">
		<div class="registerHead"><?php echo $langA['register'] ?></div>
		<table width="100%" cellpadding="9" cellspacing="0" border="0" class="registerTable">
	
		<tr>
			<td class="registerLabel">
				*<?php echo $langA['username'] ?>:
			</td><td class="registerInput">
				<input size="20" name="username" value="<?php echo wbHtmlspecialchars($_POST['username']) ?>" maxlength="20" type="text" class="input" />
			</td><td class="registerDetail">
				<?php echo $langA['REG_USERNAME'] ?> 
			</td>
		
		</tr><tr>
		
			<td class="registerLabel">
				*<?php echo $langA['password'] ?>:
			</td><td>
				<input type="password" size="20" name="password" value="" class="input" />
			</td><td class="registerDetail">
				<?php echo $langA['REG_PASSWORD'] ?>
			</td>
		
		</tr><tr>
			
			<td class="registerLabel">
				*<?php echo $langA['confirm_password'] ?>:
			</td><td>
				<input type="password" size="20" name="password2" value="" class="input" />
			</td><td class="registerDetail">
				<?php echo $langA['REG_CONFIRM_PASS'] ?>
			</td>
		</tr>	
			

		<tr>
			<td class="registerLabel">
				<?php
				if( $this->requireEmail ){
					echo '*';
				}
				echo $langA['email'] 
				?>:
			</td><td>
				<input type="text" size="20" name="email" value="<?php echo wbHtmlspecialchars($_POST['email']) ?>" class="input" />
			</td><td class="registerDetail">
				<?php 
				if( !$this->requireEmail ){
					echo $langA['REG_EMAIL'];
				}
				?>
			</td>
		</tr>
			
			
		<?php
		if( $this->requireCaptcha ){
			includeFile('tool/EditPage.php');
			
			$dbObject->uniqStorage = '/Special/Main/Register';
			$r = fileEdit::captcha();
			echo '<tr>';
			echo '<td class="registerLabel">';
			$path = wbLinks::getDir('/include/tool/captcha.php?r='.$r);
			echo '<img src="'.$path.'" alt="captcha" />';
			echo '</td><td>';
			echo '<input type="text" size="20" name="captcha" value="'.wbHtmlspecialchars($_POST['email']).'" class="input" />';
			echo '</td><td class="registerDetail">';
			echo '</td>';
			echo '</tr>';
		}
		?>				
					
		<tr>	
			<td class="registerLabel">
			</td><td>
				<input type="submit" name="none" class="registerSubmit" value="<?php echo $langA['register'] ?>" />
				
			</td><td class="registerDetail">
				<b>*</b> <?php echo $langA['REQUIRED_FIELD'] ?>
			</td>
			
		</tr></table>
		
		<input type="hidden" name="session" value="Register" />
		
		
		</div>
		</div>
		
		<?php 
		
		
	}//end register form	
	
	
	//
	//	New User Form
	//
	function regText(){
		global $page,$serverName1,$langA,$wbConfig,$serverName4, $registered,$dbInfo;
		$variables = array();
		includeFile('tool/SpecialContent.php');
		
		
		if( isset($_SESSION['username']) ){
			
			$variables['controlpanel'] = '[[/Special/'.$_SESSION['username'].'/ControlPanel|'.$langA['control_panel'].']]';
			$variables['newpage'] = '[[/'.$_SESSION['username'].'/'.$GLOBALS['wbDefaultTitle'].'|'.$_SESSION['username'].']]';
			
		}else{
				
			$variables['controlpanel'] = $langA['control_panel'];
			$variables['newpage'] = $langA['REG_A_USER_PAGE'];
			
		}
		
		
		if( $registered ){
			
			if( !empty($this->config['register:registered']) ){
				$page->displayTitle = $this->config['register:registered'];
			}else{
				$page->displayTitle = $langA['welcome_to'].$serverName1;
			}
			$content = specialContent::get('Registered',$variables);
			
		}else{
			
			if( !empty($this->config['register:register']) ){
				$page->displayTitle = $this->config['register:register'];
			}else{
				$page->displayTitle = $langA['register'];
			}
			$content = specialContent::get('Register',$variables);
			
		}
		
		
		if( $content !== false){
			echo $content;
			return;
		}
		
		echo $langA['REGISTRATION_TEXT'];
	
	}

	
	
}

new registerForm();
