<?php

defined('WikyBlog') or die("Not an entry point...");
wbLang::getFile('toolRename');


//
//				PAGE ACTION FUNCTIONS
//



//	must be the owner to get this far..
//	just check to make sure there's not an admin lock
global $dbObject;
if( !$dbObject->editable ){
	message('Site administrators have locked on this file.'); //!!lang
	return;
}

class deletePage{

	function deletePage(){
		global $page,$dbObject,$langA;
		
		if( !$dbObject->editable ){
			message('Site administrators have locked on this file.'); //!!lang
			return;
		}		
		
		
		if( !isOwner(true,false) ){
			return;
		}
			
		if( !$dbObject->exists ){
			message('FILE_MUST_EXIST');
			return;
		}
		
		switch( $page->userCmd ){
			
			case 'confirm delete':
			//case wbStrtolower($langA['confirm_delete']):
				//new deletePage(true);
				$this->deleteThisFile(true);
			break;
			case 'delete':
				//new deletePage();
				$this->deleteThisFile();
			break;
			
			case 'restore':
				$this->restorePage();
			break;
		
		}
	}
	
	function isHomePage(){
		global $dbObject, $wbDefaultTitle;
		
		if( $dbObject->objectType !== 'page' ){
			return false;
		}
		if( wbStrtolower($dbObject->title) !== wbStrtolower($wbDefaultTitle) ){
			return false;
		}
		return true;
	}
	
	function deleteThisFile($perm=false){
		global $page,$dbObject,$langA;
		
		
		if( $this->isHomePage() ){
			message('Cannot delete this file.');
			return false;
		}
		
		if( $perm ){
			$this->permDelete();
			return;
		}
		
		if( method_exists($dbObject,'setFileLocations')){
			$this->deleteForm();
			return;
		}
		
		$previouslyDone = false;
		if( strpos($dbObject->flags,'deleted') !== false ){
			$previouslyDone = true;
			message('DELETED_FILE');
		}
		$this->sendToTrash($previouslyDone);
	}
	
	function deleteForm(){
		global $page,$dbObject,$langA;
		$page->css2 = true;
		$mess = '';
		
		//use $_SESSION['editPage'] to secure deletion
		includeFile('tool/EditPage.php');
		fileEdit::init();
		
		$mess = '';
		$mess .= '<b>Notice:</b> This file cannot be stored in the trash and will be permanently removed if you continue. &nbsp; ';
		$mess .= wbLinks::local($dbObject->uniqLink.'?cmd=confirm_delete"',$langA['confirm_delete']);
		if( $page->ajaxRequest ){
			$mess .= ' &nbsp; <a href="javascript:void(0)" onclick="WB.DS(WB.C(this,\'DIV\'),\'none\');return false;">'.$langA['cancel'].'</a>';
		}
		message($mess);
		
	}
	
	
	function permDelete(){
		global $page,$dbObject;
		wbData::loadFileFunctions();
		includeFile('tool/emptyTrash.php');

		//make sure file is in editPage array
		if( !isset($_SESSION['editPage'][$dbObject->uniqStorage]) ){
			message('INVALID_REQUEST');
			return false;
		}
		
		$list = array();
		$list[] = $dbObject->file_id;
		$num = emptyTrash($list, $dbObject->dbInfo['dbTable'], false);
		if( $num === 0 ){
			message('ERROR_DELETING',$dbObject->uniqLink);
			return;
		}
		
		
		if( isset($dbObject->files) && is_array($dbObject->files) ){
			foreach($dbObject->files as $file => $null){
				wbUnlink($dbObject->$file);
			}
		}
		message('FILE_DELETED',$dbObject->uniqLink);

		$this->afterDelete();
		
	}
	
	
	function sendToTrash($previouslyDone){
		global $page,$dbObject,$pageOwner,$wbTables;
		
		$query = 'UPDATE '.$wbTables['all_files'];
		$query .= ' SET ';
		$query .= ' `visible` = 0 ';
		if( !$previouslyDone ){
			$query .= ', `flags` = '. wbDB::add_to_set('deleted','`flags`');
		}
		$query .= ' WHERE ';
		$query .= $wbTables['all_files'].'.`file_id` = "'.$dbObject->file_id.'" ';
		$num = wbDB::runQuery($query,true);
		
		if( ($num == 0) && !$previouslyDone ){
			message('ERROR_DELETING',$dbObject->uniqLink);
			return;
		}
		
		if( $previouslyDone ){
			return;
		}
		
		$this->afterDelete();
		
		message('WAS_DELETED',$dbObject->uniqLink,wbLinks::special('Trash','trash'));
	}
	
	function afterDelete(){
		global $dbObject,$pageOwner;
		
		////	all_search
		allSearch::remove($dbObject);
		
		////	$pageOwner['keywords']
		if( (strpos($dbObject->flags,'hidden') === false)
			&& (strpos($dbObject->flags,'relvisible') === false)
			){
			includeFile('tool/Tags.php');
			updateTags($dbObject->keywords,'');
			
			//comment count
			if( $dbObject->objectType == 'comment' ){
				includeFile('tool/FileComments.php');
				fileComments::updateByFileId($dbObject->parent_id);
			}
		}
		
		
		
		////	File Usage
		$pageOwner += array('totalUsage' => 0);
		$pageOwner['totalUsage'] = ($pageOwner['totalUsage'] - $dbObject->size);
		if( $pageOwner['totalUsage'] < 0 ){
			$pageOwner['totalUsage'] = 0;
		}
	}
	
	//
	//		restorePage()
	//	
	

	function restorePage(){
		global $dbObject,$wbTables,$pageOwner;
		
		if( strpos($dbObject->flags,'deleted') === false ){
			message('ALREADY_RESTORED');
			return;
		}
		
		$query = 'UPDATE '.$wbTables['all_files'];
		$query .= ' SET `modified` = `modified` ';
		$query .= ' , `flags` = '. wbDB::remove_from_set('deleted','`flags`');
		
		if( (strpos($dbObject->flags,'hidden') !== false)
			|| (strpos($dbObject->flags,'relvisible') !== false)
			){
				$query .= ', `visible` = 0 ';
			}else{
				$query .= ', `visible` = 1 ';
		}
		$query .= ' WHERE ';
		$query .= $wbTables['all_files'].'.`file_id` = "'.$dbObject->file_id.'" ';
	
		$num = wbDB::runQuery($query,true);
		if($num == 0){
			message('ERROR_RESTORING',$dbObject->uniqLink);
			return;
		}
		
		////	$pageOwner['keywords']
		if( (strpos($dbObject->flags,'hidden') === false)
			&& (strpos($dbObject->flags,'relvisible') === false)
			){
			includeFile('tool/Tags.php');
			updateTags('',$dbObject->keywords);
			allSearch::update($dbObject);
			
			//comment count
			if( $dbObject->objectType == 'comment' ){
				includeFile('tool/FileComments.php');
				fileComments::updateByFileId($dbObject->parent_id);
			}			
			
		}
		
		////	File Usage
		//!!	Might need to check against the maximum size before restoring if this ever gets abused
			$pageOwner += array('totalUsage' => 0);
			$pageOwner['totalUsage'] = ($pageOwner['totalUsage'] + $dbObject->size);
		
		message('FILE_RESTORED',$dbObject->uniqLink);
	}
}

new deletePage();
