<?php
defined('WikyBlog') or die("Not an entry point...");
/* Notes on safe_mode
is_dir() is apparently not affected

*/

//////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////
//
//		functions that are not the same between FileSystemFTP.php and FileSystem.php
//	


	//Attemps to save a file..
	//	if the file does not exist it attempts to create it
	//	
	function saveFile(&$fileLocation,&$contents){
		if( !file_exists($fileLocation) ){
			if( !(makeFile($fileLocation)) ){
				return false;
			}
		}
		
		if( !is_writable($fileLocation) ){
			if( !chmod($fileLocation,0666) ){
				trigger_error('Could not change mode:'.$fileLocation);
				return false;
			}
		}
		
		if ( !($handle = fopen($fileLocation, 'w')) ) {
			trigger_error('Could not open file:'.$fileLocation);
			return false;
		}
		
		
		if( fwrite($handle, $contents) === FALSE ) {
			trigger_error('Could not save file:'.$fileLocation);
			return false;
		}
		
		fclose($handle);
		return true;
	}

	//Attempts to create a file for writing
	//	- calls makeDir to create directory
	//	- new directories must be within subdirectories of $rootDir.. ie $rootDir/userfiles/<new dir>
	function makeFile($fileLocation,$how='w'){
		$dir = dirname($fileLocation);
		
		if( !makeDir($dir) ){
			return false;
		}
		
		if ( !($handle = fopen($fileLocation, $how)) ) {
			trigger_error('Could not open file:'.$fileLocation);
			return false;
		}
		
		return true;
	}


	//Attempts to create a directory
	//accepts paths that include filenames, it will just remove the filename
	function makeDir($relPath){
		global $rootDir;
		
		if( is_dir($relPath)){
			//message('already exists');
			
			if( !is_writable($relPath)){
				if( !chmod($relPath,0777) ){
					trigger_error('Could not change mode:'.$relPath);
					return false;
				}
			}
			return true;
		}
		
		//Must be a subdir of $rootDir
		if( wbStrpos($relPath,$rootDir) === false){
			trigger_error('Tried to create an illegal directory for: '.$relPath);
			return false;
		}
		
		$relPath = wbStr_replace($rootDir.'/','',$relPath);
		$newParts = explode('/',$relPath);
		$newDir = $rootDir.'/'.array_shift($newParts);
		
		//The immediate subdir of $rootDir must already exist
		if( !is_dir($newDir) ){
			trigger_error('The subdirectory to the rootdir must already exist: '.$relPath);
			return false;
		}
		
		//maybe not?
		if( !is_writable($newDir) ){
			trigger_error('The subdirectory to the rootdir must be writable: '.$relPath);
			return false;
		}
		
		foreach($newParts as $piece){
			$newDir .= '/'.$piece;
			
			if( is_dir($newDir) ){
				if( !is_writable($newDir) ){
					chmod($newDir,0777);
				}
				continue;
			}
			
			if( mkdir($newDir,0777) ){
				continue;
			}
			trigger_error('Could not create directory: '.$newDir);
			return false;
		}
		return true;
	}
	
	function renameFile($from,$to){
		$toDir = dirname($to);
		if( !makeDir($toDir) ){
			return false;
		}
		
		if( !rename($from,$to) ){
			trigger_error('Couldn\'t rename '.$from. ' to '. $to);
			return false;
		}
		return true;
	}

	function wbMove_uploaded_file($from,$to){
		return move_uploaded_file($from,$to);
	}
	
	function wbUnlink($path){
		if( !file_exists($path) ){
			return true;
		}
		return unlink($path);
	}
	
	function wbRmdir($path){
		if( !file_exists($path) ){
			return true;
		}
		return rmdir($path);
	}
	function wbChmod($file,$mode){
		return chmod($file,$mode); //true on success, false on failure
	}
	
	
	function wbSaveCompressed($destination,&$contents,$compressType){
		
		//save with gz
		if( $compressType == '.gz'){
			$handle = gzopen($destination,'w5');
			if( !$handle ){
			    return false;
		    }
			if( !gzwrite($handle, $contents) ){
			    return false;
		    }
			gzclose($handle);
			
		//save with bz
		}elseif( $compressType == '.bz' ){
			$handle = bzopen($destination, 'w');
			if( !$handle ){
			    return false;
		    }
			if( !bzwrite($handle, $contents) ){
			    return false;
		    }
			bzclose($handle);
		}else{
			return false;
		}
		
		return true;		
	}
	
	
//
//		functions that are not the same between FileSystemFTP.php and FileSystem.php
//	
//////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////
//
//		These funcitons are the same for FileSystemFTP.php and FileSystem.php
//


	
	// check to make sure a supplied path is a subdirectory of $rootdir
	function checkPath($dir,$subDir='',$trigger=true){
		global $rootDir;
		$check = $rootDir.'/'.$subDir;
		
		//try to get rid of ../
		$dir = wbStr_replace('\\','/',$dir);
		$dir = wbStr_replace('../','/',$dir);
		$dir = wbStr_replace('./','/',$dir);
		
		
		//check for more ./
		if( wbStrpos($dir,'./') !== false ){
			if($trigger){
				trigger_error('Illegal path supplied to checkPath() (1): '.$dir);
			}
			return false;
		}
		
		//should be in $check
		if( wbStrpos($dir,$check) === false){
			if($trigger){
				trigger_error('Illegal path supplied to checkPath() (2): '.$dir);
			}
			return false;
		}
		
		return true;
	}


	//
	//		saveAsPHP
	//	
	function saveAsPHP(&$location,$varName,&$mixed,$global=false){
		
		$text = '<'.'?'."php\n";
		$text .= "//\n";
		$text .= "//\t\tWikyBlog Generated File\n";
		$text .= "//\t\t*****************************************************\n";
		$text .= "//\t\tThis file contains data used by the wikyblog software\n";
		$text .= "//\n\n";
		$text .= 'defined(\'WikyBlog\') or die(\'Not an entry point...\');';
		$text .= "\n\n";
		
		if( $global ){
			$text .= 'global $'.$varName.";\n";
		}
		$text .= '$'.$varName." = \n";
		$text .= var_export($mixed,true);
		$text .= ';';
	
		return saveFile($location,$text);
	}
	
