<?php
defined('WikyBlog') or die("Not an entry point...");
//
//				PAGE ACTION FUNCTIONS
//
wbLang::getFile('toolOptions');


class options{

	// Advanced File Options
	function getOptions(){
		global $page,$dbObject,$pageOwner,$langA;
		
		//
		//this could happen if a user accesses the ?cmd=options page when they aren't authorised..
		//	this could happen to someone with Owner privileges on a Admin_only page
		//	they still won't be able to do anything to the options but this way the links will be correct
		//
		$link = $page->regLink($langA['options'], '/Edit'.$dbObject->uniqLink. '?cmd=options');
		$page->regLink('?',$langA['options'].'?en=Options');
		$page->autoForm = true;
		
		
		if( !isOwner(true,false) ){
			return;
		}
		
		
		switch( $page->userCmd ){
			
			case 'save options':
			case wbStrtolower($langA['save_options']):
				$do = options::setNewFlags();
				options::saveFlags($do);
			break;
			
			case 'repost':
				options::repost();
			break;
			case 'blogthis':
				options::blogThis();
			break;
			
			case 'unblog':
				options::unBlog();
			break;
			
			case 'options':
			case 'get options':
			break;
			
			case 'defaultoptions':
				options::setDefault();
			break;
		
		}		
		
		$page->contentB[$link] = options::form();
	}
	
	
	//returns true if visibility was changed, false otherwise
	function setNewFlags(){
		// not much checking going on here
		//	there's not really anything anyone could do by adding undefined flags
		global $dbObject;
		$empty = array('');
		$hiddenAfter = $hiddenBefore = false;
		$_POST += array('permission'=>'','visibility'=>'','commenting'=>'','captcha'=>'','nofollow'=>'');
		
		
		
		
		//		We only want it to affect these values
		$changeThese = options::whichFlags();
		
		//must be the owner to get this far..
		// just check to make sure there's not an admin lock
		if( !$dbObject->editable ){
			message('You must be the administrator.');
			return false;
		}
		
		//	0)	Before
		$arrayBefore = explode(',',$dbObject->flags);
		$arrayBefore = array_diff($arrayBefore,$empty);
		sort($arrayBefore);
		if( (strpos($dbObject->flags,'hidden') !== false)
			|| (strpos($dbObject->flags,'relvisible') !== false)
			){
			$hiddenBefore = true;
		}
		
		//	1)	After
		$arrayAfter = array_diff($arrayBefore,$changeThese);
		if( $dbObject->commands['lock'] ){
			$arrayAfter['permission'] =& $_POST['permission'];
		}
		if( !options::canHide() ){
			$arrayAfter['visibility'] =& $_POST['visibility'];
		}
		if( $dbObject->commands['comments'] ){
			$arrayAfter['commenting'] =& $_POST['commenting'];
		}
		$arrayAfter['captcha'] =& $_POST['captcha'];
		$arrayAfter['nofollow'] =& $_POST['nofollow'];
		$arrayAfter['recentcomments'] =& $_POST['recentcomments'];
		$arrayAfter = array_diff($arrayAfter,$empty);
		sort($arrayAfter);
		
		//	2)	Update??
		if( $arrayAfter === $arrayBefore){
			message('OPTIONS_NOT_CHANGED');
			return false;
		}
		
		$arrayAfter = array_diff($arrayAfter,array('default'));
		$dbObject->flags = implode(',',$arrayAfter);
		
		
		//	5)	Was "hidden" changed?
		if( (strpos($dbObject->flags,'hidden') !== false)
			|| (strpos($dbObject->flags,'relvisible') !== false)
			){
			$hiddenAfter = true;
		}
		if( $hiddenAfter === $hiddenBefore){
			return array(true,false);
		}else{
			return array(true,true);
		}
	}


	function saveFlags($do){
		global $dbObject,$wbTables;
		
		if( !$do ){
			return;
		}
		
		if( !$dbObject->exists ){
			message('FILE_MUST_EXIST');
			return;	
		}
		options::cleanFlags($dbObject->flags);
		
		
		if( (strpos($dbObject->flags,'hidden') !== false)
			|| (strpos($dbObject->flags,'relvisible') !== false)
			){
				$hidden = true;
			}else{
				$hidden = false;
		}
		
		$query = 'UPDATE '.$wbTables['all_files'];
		$query .= ' SET `flags` = "'. $dbObject->flags.'" ';
		$query .= ', `modified` = `modified` ';
		if( $hidden ){
			$query .= ', `visible` = 0 ';
		}else{
			$query .= ', `visible` = 1 ';
		}
		$query .= ' WHERE `file_id` = "'.$dbObject->file_id.'"';
		$num = wbDB::runQuery($query,true);
		if($num == 0){
			message('OPTIONS_NOT_UPDATED');
			return;
		}
		
		//Success, doKeys?
		message('OPTIONS_UPDATED');
		
		if( !$do[1] ){
			return;
		}
		
		includeFile('tool/Tags.php');
		if( $hidden ){
			//Now Hidden
			updateTags($dbObject->keywords,'');
			allSearch::remove($dbObject);
		}else{
			//Now Visible
			updateTags('',$dbObject->keywords);
			allSearch::update($dbObject);
		}
		
		//	show/hide are not currently options for comment
		// if( $dbObject->objectType == 'comment' ){
		// 	includeFile('tool/FileComments.php');
		// 	fileComments::updateByFileId($dbObject->parent_id);
		// }
		
	}
	
	//the names of the flags that are used for options
	// flag4 is used for recentcomments
	function whichFlags(){
		return array('locked','hidden','restricted','nocomments','registered','admin','relvisible','captcha','nofollow','flag4');
	}
	
	function form(){
		global $pageOwner, $dbObject, $langA, $page;
	
		$flags =& $dbObject->flags;
		
		$outArray = array();
		
		$checked = array_flip(options::whichFlags());
		foreach($checked as $key => $num){
			$checked[$key] = false;
		}
		$checked['global'] = false;
		$checked['visible'] = false;
		$checked['comments'] = false;
		$checked['hidecomments'] = false;

		
		$flagsArray = explode(',',$flags);
		foreach($flagsArray as $value){
			$checked[$value] = ' checked="checked" ';
		}
		
		$outArray[$langA['properties']] = '';
		$outArray[$langA['redirect']] = '';
		$outArray[$langA['editing']] = '';
		$outArray[$langA['visibility']] = '';
		$outArray[$langA['comments']] = '';
		$outArray[$langA['anti_spam']] = '';
		$outArray[$langA['save']] = '';
		$outArray[$langA['other']] = '';
		

		////////	0)	Properties
			if( $dbObject->exists ){
				
				if( empty($dbObject->size) ){
					$size = 0;
					foreach($dbObject->dbValues as $key =>$value){
						$size += strlen($dbObject->$key);
					}
				}else{
					$size = $dbObject->size;
				}
				
				
				$outArray[$langA['properties']] .= '<table width="100%">';
				$outArray[$langA['properties']] .= '<tr><td>'.$langA['file_id'].': </td><td> '.number_format($dbObject->file_id);
				$outArray[$langA['properties']] .= '</td></tr>';
				//$outArray[$langA['properties']] .= '<tr><td>'.$langA['file_name'].': </td><td> '.$dbObject->uniqLink;
				//$outArray[$langA['properties']] .= '</td></tr>';
				$outArray[$langA['properties']] .= '<tr><td style="white-space:nowrap">'.$langA['last_modified'].': </td><td> '.dbFromDate($dbObject->modified,7); //nowrap because the uniqLink could potentially be long!
				$outArray[$langA['properties']] .= '</td></tr><tr><td>'.$langA['posted'].':</td><td> '.dbFromDate($dbObject->posted,7);
				$outArray[$langA['properties']] .= '</td></tr><tr><td>'.$langA['created'].':</td><td> '.dbFromDate($dbObject->created,7);
				$outArray[$langA['properties']] .= '</td></tr><tr><td>'.$langA['size'].':</td><td> '.options::convert($size);
				$outArray[$langA['properties']] .= '</td></tr></table>';
			}
			
		////////	0)	Update Software pages
			//	this was used by CLASShelp.php
			//
			// if( method_exists($dbObject,'options')){
			// 	$temp = $dbObject->options();
			// 	if( is_array($temp) ){
			// 		$outArray += $temp;
			// 	}
			// }
			
		////////	Redirect
			if( (strpos($flags,'redirect') !== false) ){
				$outArray[$langA['redirect']] = '<ul>';
				$outArray[$langA['redirect']] .= '<li>'.$langA['REMOVE_REDIRECT'].'</li>';
				$outArray[$langA['redirect']] .= '</ul>';
			}
			
		
		////////	1)	Locking
			$disabled = '';
			if( !$dbObject->commands['lock'] ){
				$disabled = ' disabled="disabled" ';
			}
				
			if( !$checked['restricted'] && !$checked['locked'] && !$checked ['registered'] && !$checked['admin']){
				$checked['global'] = ' checked="checked" ';
			}
			$outArray[$langA['editing']] .= '<span class="sm">'.$langA['EDITING_OPTIONS'].'</span> <p></p>';
			$outArray[$langA['editing']] .= ' <label><input '.$disabled.' type="radio" name="permission" value="" '.$checked['global'].'/> '.$langA['all_users'].'</label>';
			$outArray[$langA['editing']] .= '<br /> <label><input '.$disabled.' type="radio" name="permission" value="registered" '.$checked['registered'].'/> '.$langA['registered_users'].'</label>';
			$outArray[$langA['editing']] .= '<br /> <label><input '.$disabled.' type="radio" name="permission" value="restricted" '.$checked['restricted'].'/> '.$langA['restricted_to'].'</label>';
			$outArray[$langA['editing']] .= wbLinks::special('Permissions','workgroup');
			$outArray[$langA['editing']] .= '<br /> <label><input '.$disabled.' type="radio" name="permission" value="locked" '.$checked['locked'].'/> '.$langA['owner_only'].'</label>';
			if( isAdmin(false) || $checked['admin'] ){
				$outArray[$langA['editing']] .= '<br /> <label><input '.$disabled.' type="radio" name="permission" value="admin" '.$checked['admin'].'/> '.$langA['admin_only'].'</label>';
			}
			
			
		////////	(new) Anti Spam
				if( function_exists('imagecreate') ){
					$outArray[$langA['anti_spam']] .= '<label><input type="checkbox" name="captcha" value="captcha" '.$checked['captcha'].'/> '.$langA['use_captcha'].'</label>';
				}
				$outArray[$langA['anti_spam']] .= '<br/><label><input type="checkbox" name="nofollow" value="nofollow" '.$checked['nofollow'].'/> '.$langA['nofollow'].'</label>';
				
			
		////////	2)	Hiding
			$disabled = '';
			if( !options::canHide() ){
				$disabled = ' disabled="disabled" ';
			}
				
			if( !$checked['hidden'] && !$checked['relvisible']){
				$checked['visible']= ' checked="checked" ';
			}
			$outArray[$langA['visibility']] .= '<span class="sm">'.$langA['VISIBILITY_OPTIONS'];
			$outArray[$langA['visibility']] .= '</span>';
			
			$outArray[$langA['visibility']] .= '<p></p> <label><input '.$disabled.' type="radio" name="visibility" value="" '.$checked['visible'].'/> '.$langA['visible'].'</label>';
			$outArray[$langA['visibility']] .='<br /> <label><input '.$disabled.' type="radio" name="visibility" value="relvisible" '.$checked['relvisible'].'/> '.$langA['editor_visible'].'</label>';
			$outArray[$langA['visibility']] .='<br /> <label><input '.$disabled.' type="radio" name="visibility" value="hidden" '.$checked['hidden'].'/> '.$langA['hidden'].'</label>';
			
			
			
		////////	3)	Comments
			$disabled = '';
			if( !$dbObject->commands['comments'] ){
				$disabled = ' disabled="disabled" ';
			}

			if( !$checked['nocomments']){
				$checked['comments'] = ' checked="checked" ';
			}
	
			$outArray[$langA['comments']] .= '<p>';
			$outArray[$langA['comments']] .= '<span class="sm">'.$langA['COMMENT_OPTIONS'] .'</span>';
			$outArray[$langA['comments']] .= '<p></p> <label><input '.$disabled.' type="radio" name="commenting" value="" '.$checked['comments'].'/> '.$langA['enabled'].'</label>';
			$outArray[$langA['comments']] .= '<br /> <label><input '.$disabled.' type="radio" name="commenting" value="nocomments" '.$checked['nocomments'].'/> '.$langA['disabled'].'</label>';
			$outArray[$langA['comments']] .= '</p>';
			
			
			if( !$checked['flag4'] ){
				$checked['hidecomments'] = ' checked="checked" ';
			}
			//recentcomments
			
			if( options::isBlog() ){
				$disabled = ' disabled="disabled" '; //may already be disable because comments are disabled
			}

			$outArray[$langA['comments']] .= '<p><span class="sm">'.$langA['RECENT_COMMENTS'] .'</span>';
			$outArray[$langA['comments']] .= '<br /> <label><input '.$disabled.' type="radio" name="recentcomments" value="" '.$checked['hidecomments'].'/> '.$langA['hidden'].'</label>';
			$outArray[$langA['comments']] .= '<br /> <label><input '.$disabled.' type="radio" name="recentcomments" value="flag4" '.$checked['flag4'].'/> '.$langA['visible'].'</label>';
			$outArray[$langA['comments']] .= '</p>';
			
			
			
			$outArray[$langA['save']] = '';
			
		////////	4)	Other
			if( $dbObject->exists ){
				$outArray[$langA['other']] = '<ul>';
	
				
				//Blog (new)
				$blogMessage = false;
				
				if( method_exists($dbObject,'abbrevOutputContent')
					&& (strpos($flags,'hidden') === false)
					&& (strpos($flags,'relvisible') === false)
					&& (strpos($flags,'template') === false)
					){
						if( ($dbObject->objectType == 'page') && wbStrcasecmp($dbObject->title,$GLOBALS['wbDefaultTitle']) ){
							$blogMessage = false;
							
						}elseif( isset($pageOwner['sBlog']) && ($pageOwner['sBlog'] == 'On') ){
							$blogMessage = true;
							
						}elseif( $dbObject->objectType == $pageOwner['blogT'] ){
							$blogMessage = true;
						}
				}
				if( $blogMessage ){
					if( strpos($flags,'blogged') === false){
						$outArray[$langA['other']] .= '<li>'.wbLinks::local($dbObject->uniqLink.'?cmd=blogthis',$langA['blog_this']).'</li>';
					}else{
						$outArray[$langA['other']] .= '<li>'.wbLinks::local($dbObject->uniqLink.'?cmd=unblog',$langA['unblog']).'</li>';
					}
				}
					
				//Repost
				$outArray[$langA['other']] .= '<li>'.wbLinks::local($dbObject->uniqLink.'?cmd=repost',$langA['repost']).'</li>';
				
				
				//Add to Tabs
				if( isset($_SESSION['username']) ){
					$outArray[$langA['other']] .= '<li>'.wbLinks::special('Tabs?cmd=optadd&uri='.$dbObject->uniqLink,'add_to_tabs','',$_SESSION['username']).'</li>';
					$outArray[$langA['other']] .= '<li>'.wbLinks::special('Links?cmd=optadd&uri='.$dbObject->uniqLink,'add_to_links','',$_SESSION['username']).'</li>';
				}
								
				//Delete
				if( $dbObject->commands['delete'] ){
					$outArray[$langA['other']] .= '<li>';
					if( !options::isHomePage() ){
						$outArray[$langA['other']] .= wbLinks::local($dbObject->uniqLink.'?cmd=delete',$langA['delete'],' title="'.$langA['send_to_trash'].'"').'</li>';
					}else{
						$outArray[$langA['other']] .= $langA['delete'];
					}
					$outArray[$langA['other']] .= '</li>';
						
						
				}
					

				
				
				//New Copy/Rename
				//	do it with a form
				
				//this check doesn't work for comments
				//if( isset($dbObject->dbInfo['dbTable']) && (!isset($dbObject->dbInfo['dTitle']) || ($dbObject->objectType == 'page')) ){
				
					end($dbObject->dbInfo['keys']);
					$key = key($dbObject->dbInfo['keys']);
					$title = $dbObject->$key;
					
					$temp = '';
					$temp .= '<input type="text" name="to" size="20" value="'.wbHtmlspecialchars(wbStr_replace('_',' ',$title)).'" /> ';
					$temp .= '<br/>';
					$temp .= '<input type="submit" name="cmd" value="'.$langA['copy'].'" /> ';
					$temp .= '<input type="submit" name="cmd" value="'.$langA['rename'].'" /> ';
					$outArray[$langA['other']] .= '<li>'.$temp.'</li>';
				//}
				
				
				
			}
			
		
		
		////////	5)	Saving
			if(count($outArray)%2 == 0){
				$outArray['&nbsp;'] = '';
			}
			
			$outArray[$langA['save']] = '<br /><input type="submit" name="cmd" value="'.$langA['save_options'].'" />';
			if( $dbObject->exists ){
				$outArray[$langA['save']] .= ' <p> ';
				if( strpos($flags,'default') === false ){
					$outArray[$langA['save']] .= wbLinks::local($dbObject->uniqLink.'?cmd=defaultoptions',$langA['restore_defaults']);
				}else{
					$outArray[$langA['save']] .= ' <img alt="" height="16" width="16" src="'.wbLinks::getDir('/imgs/icons/tick.gif').'" style="vertical-align:middle" /> ';
					$outArray[$langA['save']] .= $langA['default_options'];
				}
				$outArray[$langA['save']] .= ' </p> ';
			}
			
			
		////////	6)	Show Options
			ob_start();
			if(	$dbObject->exists ){
				echo '<h2 style="text-align:center;">';
				//echo $langA['file_name'].': ';
				echo $dbObject->uniqLink;
				echo '</h2>';
			}
			
			echo '<table cellpadding="20" border="0" width="100%"><tr>';
			$i=0;
			$amount = intval(count($outArray)/2);
			$amount = count($outArray) - $amount;
			foreach( $outArray as $key => $value){
				if( empty($value)){
					continue;
				}
		
				if($i==2){
					echo '</tr><tr>';
					$i=0;
				}
				$i++;
				echo '<td width="50%">';
				echo '<h3 class="heading underline">'.$key.'</h3>';
				echo $value;
				echo '</td>';
			}
			echo '</tr></table>';
			
			
			if( $dbObject->exists ){
				
				echo '<div class="WBsearchFooter">';
				echo '<b>'.$langA['related_links'].'</b>';
				
				echo '<ul>';
				
				//user permissions
				echo '<li>'.wbLinks::special('Permissions','user_permissions').'</li>';

				
				//default options
				$link = 'DefaultOptions?type='.$dbObject->objectType;
				echo '<li>'.wbLang::text('SET_DEFAULT_OPTIONS',wbLinks::special($link,'default_options')).'</li>';
				
				
				//browse hidden
				echo '<li>'.wbLinks::special('Flagged?flag=hidden','BROWSE_HIDDEN').'</li>';
				
				
				//trash
				if( $dbObject->commands['delete'] ){
					echo '<li>'.wbLinks::special('Trash','trash').'</li>';
				}
				echo '</ul>';
			
				echo '</div>';				
			}
			
		
			return wb::get_clean();
	}
	
	function canHide(){
		global $dbObject;
		
		if( !$dbObject->commands['hide'] ){
			return false;
			$disabled = ' disabled="disabled" ';
		}
		if( options::isHomePage() ){
			return false;
		}
		return true;
	}
	
	
	//similar to $page->isBlog();
	function isBlog(){
		global $dbObject, $pageOwner;
		
		//must be the home page .. therefore using 'page' object
		if( !isset($dbObject->objectType) || ($dbObject->objectType != 'page') ){ 
			return false;
		}
		
		if( !isset($dbObject->title) ){
			return false;
		}
		
		if( !wbStrcasecmp($dbObject->title,$GLOBALS['wbDefaultTitle']) ){
			return false;
		}
		
		if( isset($pageOwner['isBlog']) && ($pageOwner['isBlog'] =='On') ){
			return true;
		}
		return false;
	}
	
	
	function convert( $bytes ){
		global $langA;
		$bytes = floatval($bytes);
		$types = array();
		
		$types[1] = $langA['kb'];
		$types[2] = $langA['mb'];
		$types[3] = $langA['gb'];
		
		
		$i = 0;
		while( ($bytes > 1500) && ($i < 3) ){
			$bytes /= 1024;
			$i++;
		}
		if( $i == 0 ){
			return number_format($bytes).' '.$langA['bytes'];
		}
		
		return number_format($bytes,2).' '.$types[$i];
	}	
	
	
	function repost(){
		global $dbObject,$wbTables,$wbNow;
		
		$query = 'UPDATE '.$wbTables['all_files'];
		$query .= ' SET `modified` = `modified` ';
		$query .= ', `posted` = "'.$wbNow.'" ';
		$query .= ' WHERE ';
		$query .= $wbTables['all_files'].'.`file_id` = "'.$dbObject->file_id.'" ';
		
		$num = wbDB::runQuery($query,true);
		if($num != 1){
			message('NOT_REPOSTED');
			if($num == -1){
				trigger_error('File not reposted');
			}
			return;
		}
			
		$dbObject->posted = $wbNow;
		message('REPOSTED');
		
		//
		//	Ping
		//
			options::ping();
	}
	
	function blogThis(){
		global $dbObject, $wbNow;
		
		if( isset($dbObject->userValues['keywords']) && empty($dbObject->keywords) && !isset($_GET['confirm']) ){
			$link1 = wbLinks::local('/edit'.$dbObject->uniqLink.'?cmd=edit',false);
			$link2 = wbLinks::local($dbObject->uniqLink.'?cmd=blogthis&confirm=true',false);
			message('NO_KEYWORDS',$link1,$link2);
			return;
		}
		
		if( !empty($dbObject->flags) ){
			$dbObject->flags .= ',blogged';
		}else{
			$dbObject->flags = 'blogged';
		}
		$dbObject->posted = $wbNow; //Update posted value so the blogged file is the newest blog posting

		options::update();
		
		//
		//	PING
		//
			options::ping();
	}
	
	function unBlog(){
		global $dbObject;
		
		$flagsArray = explode(',',$dbObject->flags);
		$remove = array('','blogged');
		$flagsArray = array_diff($flagsArray,$remove);
		$dbObject->flags = implode(',',$flagsArray);
		options::update();
	}

	
	function update(){
		global $wbTables, $dbObject;
		
		$query = 'UPDATE '.$wbTables['all_files'];
		$query .= ' SET `modified` = `modified` ';
		$query .= ' ,`flags` = "'.wbDB::escape($dbObject->flags).'" ';
		$query .= ' , `posted` = "'.$dbObject->posted.'" ';
		$query .= ' WHERE ';
		$query .= $wbTables['all_files'].'.`file_id` = "'.$dbObject->file_id.'" ';
		
		$num = wbDB::runQuery($query,true);
		if($num != 1){
			message('OPTIONS_NOT_UPDATED');
			if($num == -1){
				trigger_error('File not reposted');
			}
			return;
		}
		message('OPTIONS_UPDATED');	
	}
	
	//
	//	PING
	//		how does this work for files that are old.. and have an old posted value.. where are they shown?
	function ping(){
		global $dbObject,$pageOwner;
		
		if( empty($pageOwner['uServices']) ){
			return;
		}
		
		//is this page in the blog?
		if( strpos($dbObject->flags,'blogged') === false){
			return;
		}
		
		//is this page visible
		if( strpos($dbObject->flags,'hidden') !== false){
			return;
		}
		
		//is this page visible
		if( strpos($dbObject->flags,'relvisible') !== false){
			return;
		}
		
		includeFile('/tool/Ping.php');
		RPC::pingAllUrls($pageOwner['uServices']);
	}
	
	function setDefault(){
		global $pageOwner,$dbObject;
		$hiddenBefore = $hiddenAfter = false;
		
		if( (strpos($dbObject->flags,'hidden') !== false) 
			|| (strpos($dbObject->flags,'relvisible') !== false)
			){
			$hiddenBefore = true;
		}
		
		$defaultFlags =& $pageOwner['flags'][$dbObject->dbInfo['class']];
		if( (strpos($defaultFlags,'hidden') !== false)
			|| (strpos($defaultFlags,'relvisible') !== false)
			){
			$hiddenAfter = true;
		}
		if( $hiddenAfter === $hiddenBefore){
			$do = array(true,false);
		}else{
			$do = array(true,true);
		}
		
		$removeFlags = options::whichFlags();
		$dbObject->flags = str_replace($removeFlags,array(''),$dbObject->flags);		//remove any option flags
		$dbObject->flags .= ',default';
		if( !empty($pageOwner['flags'][$dbObject->dbInfo['class']]) ){
			$dbObject->flags .= ','.$pageOwner['flags'][$dbObject->dbInfo['class']];		//add the defaults
		}

		options::cleanFlags($dbObject->flags);
		options::saveFlags($do);
	}
	
	//remove duplicates and empty flags
	function cleanFlags(&$flags){
		$temp = explode(',',$flags);
		$temp = array_unique($temp);
		$temp = array_diff($temp,array(''));
		$flags = implode(',',$temp);
	}
	
	function isHomePage(){
		global $dbObject, $wbDefaultTitle;
		
		if( $dbObject->objectType !== 'page' ){
			return false;
		}
		if( wbStrcasecmp($dbObject->title,$wbDefaultTitle) ){
			return true;
		}
		return false;
	}	
		
}


global $initiateFileClass;
if( $initiateFileClass ){
	options::getOptions();
}
