<?php
/*
	Remote Procedure Call

	.. we don't want to ping technorati if a file is created by an untrusted user .. 
		--> only available with "Selective Blogging"

	For More Information
		http://www.xmlrpc.com/weblogsCom
	
		
	Example Response
	
		HTTP/1.0 200 OK 
		X-Powered-By: PHP/4.4.2 
		Content-Type: text/xml 
		Content-Length: 354 
		Server: LiteSpeed 
		Date: Thu, 09 Nov 2006 07:30:17 GMT 
		Connection: close 
		
		<?xml version="1.0"?> 
			<methodResponse> 
				<params> 
					<param> 
						<value> 
							<struct> 
								<member>
									<name>flerror</name>
										<value>
											<boolean>0</boolean>
										</value>
								</member> 
								<member>
									<name>message</name>
										<value>
											<string>Pings being forwarded to 16 services!</string>
										</value>
								</member> 
							</struct> 
						</value> 
					</param> 
				</params> 
			</methodResponse>	
			
*/

class RPC{
	
	function pingAllUrls($urls){
		
		$urlList = stringToArray($urls);
		foreach($urlList as $url){
			$url = trim($url);
			if( empty($url) ){
				continue;
			}
			$temp = parse_url($url);
			if( empty($temp['host']) ){
				continue;
			}
			RPC::pingUrl($url);
		}
	}

	function pingUrl($url){
		global $serverName4,$pageOwner,$serverName2;
		$newLine = "\r\n";
	
		//
		//	Create XML Request
		//
		
			//both of these parameters should be safe with character escaping
			$blogName = $pageOwner .' - '.$serverName2;
			$blogUrl = $serverName4.'/'.$pageOwner['username'];
			
			//xml
			$xml = '<?xml version="1.0"?><methodCall><methodName>weblogUpdates.ping</methodName>';
			$xml .= '<params><param><value>';
			$xml .= $blogName;
			$xml .= '</value></param><param><value>';
			$xml .= $blogUrl;
			$xml .= '</value></param>';
			$xml .= '</params></methodCall>';
			
			//header
			if( strpos($url,'://') === false){
				$url = 'http://'.$url;
			}
			$pathArray = parse_url($url);
			
			$request = 'POST '.$pathArray['path'].' HTTP/1.0'.$newLine;
			$request .= 'User-Agent: WikyBlog'.$newLine;
			$request .= 'Host: '.$pathArray['host'].$newLine;
			$request .= 'Content-Type: text/xml'.$newLine;
			$request .= 'Content-length: '.strlen($xml);
			$request .= $newLine.$newLine;
			$request .= $xml;
		//
		//	Send XML
		//
		
			$port = 80;
			$errNum=null;
			$errString=null;
			if( isset($pathArray['port']) && !empty($pathArray['port'])){
				$port = $pathArray['port'];
			}
			$handle = @fsockopen( $pathArray['host'], $port ,$errNum, $errString,3 );
			if(!$handle){
				message('Could not connect to '.$pathArray['host']);
				//dies quietly.. should there be a user message?
				return false;
			}
			
	        fputs($handle, $request);
			
		//
		//	Check Response ??
		//		do we need to do this for pings?.. only if we're going to warn users about pings that don't work
		//
		
// 		    $gotFirstLine = false;
// 		    $gettingHeaders = true;
// 		    $all = '';
// 		    while (!feof($handle)) {
// 		        $line = fgets($handle, 4096);
// 		        $all .= $line;
// 		        if (!$gotFirstLine) {
// 		            // Check line for '200'
// 		            if (strstr($line, '200') === false) {
// 		                $this->error = new IXR_Error(-32300, 'transport error - HTTP status code was not 200');
// 		                return false;
// 		            }
// 		            $gotFirstLine = true;
// 		        }
// 		        if (trim($line) == '') {
// 		            $gettingHeaders = false;
// 		        }
// 		        if (!$gettingHeaders) {
// 		            $contents .= trim($line)."\n";
// 		        }
// 		    }
//		    message(wbHtmlspecialchars($all));
		    
	}
}

