<?php
//$langA checked

defined('WikyBlog') or die("Not an entry point...");

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//		xmlError
//

wbLang::getFile('myParserErrors');

function getXmlError(&$caller, &$text){
	global $langA;
	
	$array = wbExplode("\n",$text);
	if( !$caller->htmlDoc ){
		array_pop($array);		//</DocumentContainer>
		array_shift($array);	//<DocumentContainter>
	}
	
	//	Produced 
	$errorLineNum = xml_get_current_line_number( $caller->xmlParser )-1; // accounts for array_shift
	$errorColNum = xml_get_current_column_number( $caller->xmlParser );
	$errorCode = xml_get_error_code( $caller->xmlParser );
	
	//Text
	$textLength = count($array); 
	$arrayLine = $errorLineNum-1;
	if( isset($array[$arrayLine]) ){
		$arrayLineText = $array[$arrayLine];
	}else{
		$arrayLineText = '';
	}
	
	
	//messages
	$message = '';
	$errorContext = '';
	
	//	Tags
	$lastOpenTag = '';
	if( isset($caller->openTags[0]) ){
		$lastOpenTag = $caller->openTags[0];
	}
	$closeTags = $caller->closeTags;
	
	// check array index
	if($arrayLine > $textLength){
		$arrayLine = $textLength;
	}

	
	//	Error Content
	$line = $errorLineNum+1;
	$amountShown = 0;

	while( ($amountShown < 5) && ($line >= 0) ){
		
		if( $line === $arrayLine ){
			$style = ' style="color:red" ';
		}else{
			$style = '';
		}

		if( $line === $textLength+1 ){
			$errorContext = '<tr><td>'.$line.'</td><td'.$style.'>'.$langA['end_of_document'].'</td></tr>'.$errorContext;
			$amountShown++;
			$line--;
			continue;
		}elseif( $line > $textLength){
			$line--;
			continue;
		}
		if( isset($array[$line]) ){
			$errorContext = '<tr><td>'.$line.'</td><td'.$style.'>'.wbHtmlspecialchars( $array[$line] ).'</td></tr>'.$errorContext;
		}
		$line--;
		$amountShown++;
	}
	$errorContextPrepend = '<table style="background-color:#dddddd;padding:5px;border: 1px solid #999999;">';
	$errorContextPrepend .= '<tr><th style="white-space:nowrap">'.$langA['line_num'].'</th><th>'.$langA['text'].'</th></tr>';
	$errorContext = $errorContextPrepend.$errorContext;
	$errorContext .= '</table>';
	//
	
	if( $errorCode == XML_ERROR_INVALID_TOKEN ){ // "Invalid Token" or "not well-formed"
		//	CASES:
		//		- "<"
		//		- poorly formatted attribute: attr="something'
		//
		
		
		$message .= '<strong>'.$langA['syntax_warning'].'</strong>';
		$message .= wbLang::text('XML_ERROR_INVALID_TOKEN',$arrayLine,$errorColNum);
		$message .= '<br />';
		$message .= $errorContext;
		$message .= $langA['XML_ERROR_INVALID_TOKEN2'];
		$message .= '(1)';
		
	
	}elseif( ($errorCode == XML_ERROR_TAG_MISMATCH) ){
		//	CASES:
		//		-Open tag not closed before closing another
		//			-many different ways!
		//		
		//			- Closing tag might be </tag> or <tag />
		
		
		// these are not the same as below: <input>, <base> are not accepted!
		$singleTags = array('BR'=>1, 'HR'=>1,'META'=>1,'IMG'=>1
							,'BASEFONT'=>1,'AREA'=>1
							,'INPUT'=>1,'BASE'=>1
							);
				
		$nextClosingTag = substr($arrayLineText,$errorColNum);
		$position = wbStrpos($nextClosingTag,'>');// this works because if there are unecessary spaces, the error will be somewhere else
		$nextClosingTag = wbStrtoupper( wbSubstr($nextClosingTag,0, ($position) ) );
		
		
		
		if( ($textLength == $arrayLine) && (strlen($arrayLineText) === $errorColNum) ){
			//if( ($textLength == $arrayLine) && ($errorCode == XML_ERROR_TAG_MISMATCH) ){
			//	CASES:	-open tags at the very end of the file
			//	
			//
			// Parser reached the end (</DOCUMENTCONTAINER>) and there are still open tags
			// could try to fix this one by just closing all open tags?
			
			
			//this doesn't ever seem to show!
			$message .= '<strong>'.$langA['syntax_warning'].'</strong>';
			$message .= wbLang::text('XML_ERROR_TAG_MISMATCH1',wbHtmlspecialchars( implode(' ',$closeTags) ));
			$message .= '(2)';

		}elseif( isset($singleTags[$nextClosingTag]) ){
			
			$message .= '<strong>'.$langA['syntax_warning'].'</strong>';
			$message .= $langA['unnecessary_closing_tag'];
			$message .= ' <br /><tt>&lt;'.$nextClosingTag.'&gt;...text...&lt;/'.$nextClosingTag.'&gt;</tt>'.$langA['should_be'];
			$message .= ' <tt>&lt;'.$nextClosingTag.' /&gt;...text...</tt>';
			$message .= $errorContext;
			$message .= '(3)';
			
		}elseif( !empty($nextClosingTag) && (empty($caller->openTags)||(array_search($nextClosingTag,$caller->openTags)===false))){
			//no opener
			$message .= '<strong>'.$langA['syntax_warning'].'</strong>';
			$message .= wbLang::text('CLOSING_AN_UNOPENED_TAG',wbHtmlspecialchars($nextClosingTag));
			$message .= $errorContext;
			$message .= $langA['CLOSING_AN_UNOPENED_TAG2'];
			$message .= '(4)';
			
		}elseif( !empty($caller->openTags) ){
			
			$message .= '<strong>'.$langA['syntax_warning'].'</strong>';
			$message .= wbLang::text('MISSING_CLOSING_TAG',array_shift($caller->openTags),wbHtmlspecialchars( array_shift($closeTags) ));
			if( !empty($nextClosingTag) ){
				$message .= wbLang::text('MISSING_CLOSING_TAG2',wbHtmlspecialchars($nextClosingTag));
			}
			$message .= $errorContext;
			$message .= '(5)';
			
		}else{
			
			$message .= ' <strong>'.$langA['AUTOMATED_SYNTAX_ERROR'] .'</strong> '.xml_error_string( $errorCode);
			$message .= wbLang::text('AUTOMATED_SYNTAX_ERROR2',$errorCode,$arrayLine,$textLength,$errorColNum);
			$temp = substr($arrayLineText,0,$errorColNum).'{'.$nextClosingTag.'}'.substr($arrayLineText,($errorColNum+$position));
			$message .= wbHtmlspecialchars($temp).'<br />';
			$message .= '(6)';
		}
		
	}elseif(false){
		//unecessary closing tags
		
	}else{
		//	CASES: ALL OTHERS
		
		//message
		$message .= ' <strong>'.$langA['AUTOMATED_SYNTAX_ERROR'] .'</strong> '.xml_error_string( $errorCode);
		$message .= wbLang::text('AUTOMATED_SYNTAX_ERROR2',$errorCode,$arrayLine,$textLength,$errorColNum);
		
		$message .= $langA['last_open_tag']. array_shift( $caller->openTags);
		$message .= $errorContext;
		$message .= '(7)';
		
	}
	$caller->errors[] = $message;
	
}


//
//		xmlError
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
