<?php


defined('WikyBlog') or die("Not an entry point...");


class pluginCheck{
	////////////////////////////////////////////////////////////////////////
	//
	//	Date And Time
	//
	
	//'1000-01-01' to '9999-12-31'
	function date($name){
		global $dbObject;
		$lower = wbStrtolower($name);
		$value =& $dbObject->$lower;
		$regExp = '#^[0-9]{4}-[01]?[0-9]-[0-3]?[0-9]$#';
		$matched = preg_match($regExp,$value);
		if( !preg_match($regExp,$value) ){
			message($name.' was not a valid date.');
		}
	}
	
	function time($name){
		global $dbObject;
		$lower = wbStrtolower($name);
		$value =& $dbObject->$lower;
		$regExp = '#^[012]?[0-9]:[0-6]?[0-9](:[0-6]?[0-9])?$#';
		$matched = preg_match($regExp,$value);
		if( !preg_match($regExp,$value) ){
			message($name.' was not a valid time.');
		}
	}
	
	////////////////////////////////////////////////////////////////////////
	//
	//	Numeric
	//
	function integer($name,$which){
		global $dbObject;
		$lower = wbStrtolower($name);
		$value =& $dbObject->$lower;
		if( !ctype_digit ($value) ){
			message($name.' was not an integer');
			$dbObject->validData = false;
		}
		switch($which){
			case 'TINYINT':
				$limit = 127;
			break;
			case 'SMALLINT':
				$limit = 32767;
			break;
			case 'MEDIUMINT':
				$limit = 8388607;
			break;
			case 'INT':
				$limit = 2147483647;
			break;
			case 'BIGINT':
				$limit = 9223372036854775807;
			break;
		}
		if( $value > $limit ){
			$dbObject->validData = false;
			message($name.' was too big.');
		}elseif( $value < (-1)*$limit ){
			$dbObject->validData = false;
			message($name.' was too small.');
		}
	}
	
	function wiki($name,$warn=true){
		global $wbParser,$langA,$dbObject;
		initiateParser();
		$text =& $dbObject->$name;
		
		if( '' == trim($text) ){
			message('EMPTY_CONTENT');
			$dbObject->validData = false;
			return;
		}
		
		$wbParser->parse($this->content,true,$this);
		$dbObject->getParserInfo();
		$dbObject->isUnSafe($wbParser->foundUnsafe);
		if( $wbParser && $wbParser->errors && $warn ){
			$link = wbLinks::local($dbObject->uniqLink.'?cmd=viewErrors',$langA['syntax_error']);
			message('SYNTAX_WARNING',$link);
		}
	}
	
	function url($key,$warn=true){
		global $dbObject;
		$url =& $dbObject->$key;
		if( !empty($url) && strpos($url,'://') === false){
			$url = 'http://'.$url;
		}
		
	}
}
	
