<?php
/* 
DATE:
	YYYY-MM-DD	
	
DATETIME:
	YYYY-MM-DD HH:MM:SS
	
TIMESTAMP:
	YYYYMMDDHHMMSS (pre)4.1
	YYYY-MM-DD HH:MM:SS
	
TIME:
	HH:MM:SS
	
YEAR:
	YYYY

	
*/

defined('WikyBlog') or die("Not an entry point...");



class pluginFromPost{
	function setTime($name){
		// global $dbObject;
		// if( isset($_POST[$name]) ){
		// 	$result = sscanf($_POST[$name],"%d:%d:%d");
		// 	if( empty($result[2]) ){
		// 		$result[2] = '00';
		// 	}
		// 	$_POST[$name] = implode(':',$result);
		// }
	}
	
	function setSet($name){
		global $dbObject;
		if( isset($_POST[$name]) && is_array($_POST[$name]) ){
			$_POST[$name] = implode(',',$_POST[$name]);
		}
	}
	
}

class pluginEdit{
	
	////////////////////////////////////////////////////////////////////////
	//
	//	Editing Date & Time types
	//
	function editYear($name){
		pluginEdit::editVarchar($name,4,'Example: 1997');
	}
	function editTime($name){
		pluginEdit::editVarchar($name,8,'HH:MM or HH:MM:SS Example: 12:24 or 12:24:37');
	}
	function editDate($name){
		pluginEdit::editVarchar($name,10,'YYYY-MM-DD Example: 2006-12-31');
	}
		
	////////////////////////////////////////////////////////////////////////
	//
	//	Numeric
	//
	function editInteger($name,$len){
		pluginEdit::editVarchar($name,$len,'Integer. Example: 10, 438..');
	}
	function editDecimal($name,$len){
		pluginEdit::editVarchar($name,$len,'Integer. Example: 10, 438..');
	}
	////////////////////////////////////////////////////////////////////////
	//
	//
	function editVarchar($name,$len,$example=false){
		global $dbObject;
		echo '<tr><td>';
		echo '<b>'.$name.'</b>';
		$name = wbStrtolower($name);
		echo '</td><td>';
		echo '<input type="text" name="'.$name.'" value="'.wbHtmlspecialchars($dbObject->$name).'" size="40" maxlength="'.$len.'" onchange="WBe.set(true)" />';
		
		if( $example ){
			echo '</td><td class="sm">';
			echo $example;
		}
		
		echo '</td></tr>';
	}
	
	function editUrl($name,$len){
		global $dbObject;
		echo '<tr><td>';
		echo '<b>'.$name.'</b>';
		$name = wbStrtolower($name);
		echo '</td><td>';
		echo '<input type="text" name="'.$name.'" value="'.wbHtmlspecialchars($dbObject->$name).'" size="40" maxlength="'.$len.'" onchange="WBe.set(true)" />';
		echo '</td><td class="sm">';
		echo 'Example: http://www.wikyblog.com';
		echo '</td></tr>';
	}
	function editWiki($name){
		global $dbObject;
		$name = wbStrtolower($name);
		echo '<tr><td colspan="3">';
		echo toEditArea($this->$name,1,$name);
		echo '</td></tr>';
	}

	function editList($name,$list,$multiple=true){
		global $dbObject;
		
		echo '<tr><td>';
		echo '<b>'.$name.'</b>';
		echo '</td><td>';
		
		$name = wbStrtolower($name);
		
		$setKeywords = array();
		if( is_string($dbObject->keywords) ){
			$setKeywords = mysqlSetToArray($dbObject->keywords); // here's where the problem is!
		}elseif( is_array($dbObject->keywords) ){
			$setKeywords = $dbObject->keywords;
		}
		
		$selected = '';
		
		//echo '<select name="keywords[]" multiple size="5">';
		if( $multiple ){
			$size = min(count($list),5);
			$values = explode(',',$dbObject->$name);
			echo '<select name="'.$name.'[]" multiple="multiple" size="'.$size.'" onchange="WBe.set(true)">';
			foreach($list as $keyword){
				if( in_array($keyword,$values) ){
					echo '<option value="'.wbHtmlspecialchars($keyword).'" selected="selected">'.$keyword.'</option>';
				}else{
					echo '<option value="'.wbHtmlspecialchars($keyword).'" >'.$keyword.'</option>';
				}
			}
			echo '</select>';
		}else{
			//this actually isn't possible yet.. need to do something in PluginCreate.php
			echo '<select name="'.$name.'" onchange="WBe.set(true)">';
			$value =& $dbObject->$name;
			foreach($list as $keyword){
				if( $keyword === $value ){
					echo '<option value="'.wbHtmlspecialchars($keyword).'" selected="selected">'.$keyword.'</option>';
				}else{
					echo '<option value="'.wbHtmlspecialchars($keyword).'" >'.$keyword.'</option>';
				}
			}
			echo '</select>';
		}
		echo '</td></tr>';
	}
}