<?php
defined('WikyBlog') or die("Not an entry point...");

class skeleton extends dbPage{

	var $dbValues = array('owner'=>1,'title'=>1,'content'=>1);
	var $userValues = array('content'=>1,'keywords'=>1);

	function skeleton($type){
		$this->objectType = $type;	//this is used to select the correct array from $dbInfo
		$this->setDbInfo();
	}
	
	function newPage(){
		global $includeDir,$page;
		global $userLanguage,$langA;
		parent::newPage();

		//	STANDARD EDIT MESSAGE
		if( $this->editable ){
			$this->content = wbLang::text('DEFAULT_CONTENT',$this->uniqLink);
			if( empty($page->userCmd) && cookies() ){
				$page->userCmd = 'edit';
			}
		}else{
			$this->content = $langA['DEFAULT_CONTENT_PROTECTED'];
		}
	}

	function setLinks(){
		global $page,$pageOwner,$langA;

		parent::setLinks();
		
		$page->displayTitle = $langA[$this->objectType].' > '.toDisplay($this->title);
		$this->links['?'] = 'Skeleton';
	}
	
	//same as for CLASSpage
	function abbrevOutput(&$row){
		global $langA,$page;
		
		$links = array();
		$links[$langA['file']] = '/'.$row->owner.'/'.$row->title;
		if( strpos($row->flags,'nocomments') === false ){
			$links[$langA['talk']] = '/Talk'.$links[$langA['file']];
		}
		
		echo '<h2 class="heading">'.toDisplay($row->title).'</h2>';
		echo '<div class="underline"></div>';

		echo ' <div class="fileInfo">';
			echo '<span>';
			$temp = Array();
			foreach( $links as $key => $value){
				if( is_string($value) ){
					$temp[] = wbLinks::local($value,$key);
				}
			}
			echo implode(' :: ',$temp);
			echo '</span>';		
			echo '<span>'.$langA['modified'].': '.dbFromDate($row->modified,3).'</span>';
			echo '<span>'.$langA['created'].': '. dbFromDate($row->created,3).'</span>';
		echo ' </div>';

		echo '<div class="desc">';
			$bool = outputWiki($row->content,400);
			if($bool == true){
				echo '... '.wbLinks::local($row->uniqLink,$langA['read_more']).' <span class="sm">('.$bool.$langA['words'].')</span>';
			}
		echo '</div>';
		echo '<br />';
	}	

}