function saveCookie(name, value, expires, path, domain, secure){
  var strCookie = name + "=" + value;
  if (expires){
     var curTime = new Date();
     curTime.setTime(curTime.getTime() + expires*24*60*60*1000);
     strCookie += "; expires=" + curTime.toGMTString();
  }
  strCookie +=  (path) ? "; path=" + path : ""; 
  strCookie +=  (domain) ? "; domain=" + domain : "";
  strCookie +=  (secure) ? "; secure" : "";
  document.cookie = strCookie;
}

function getCookie(name){
  var strCookies = document.cookie;
  var cookieName = name + "=";  
  var valueBegin, valueEnd, value;
 
  valueBegin = strCookies.indexOf(cookieName);
  if (valueBegin == -1) return null;  

  valueEnd = strCookies.indexOf(";", valueBegin);
  if (valueEnd == -1)
      valueEnd = strCookies.length; 

  value = strCookies.substring(valueBegin+cookieName.length,valueEnd);
  return value;
}

function checkCookieExist(name){
  if (getCookie(name))
      return true;
  else
      return false;
}

function deleteCookie(name, path, domain){
  var strCookie;
 
  if (checkCookieExist(name)){
   
    strCookie = name + "="; 
    strCookie += (path) ? "; path=" + path : "";
    strCookie += (domain) ? "; domain=" + domain : "";
    strCookie += "; expires=Thu, 01-Jan-70 00:00:01 GMT";
    document.cookie = strCookie;
  }
}
