/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.modes.MindMapCloud;
import freemind.view.mindmapview.ConvexHull;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.QuadCurve2D;
import java.util.LinkedList;
import java.util.Vector;

public class CloudView {
    protected MindMapCloud cloudModel;
    protected NodeView source;
    protected int iterativeLevel;
    static final Stroke DEF_STROKE = new BasicStroke(3.0f);

    protected CloudView(MindMapCloud cloudModel, NodeView source, int iterativeLevel) {
        this.cloudModel = cloudModel;
        this.source = source;
        this.iterativeLevel = iterativeLevel;
    }

    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics.create();
        this.setRendering(g);
        Graphics2D gstroke = (Graphics2D)g.create();
        g.setColor(this.getColor());
        g.setStroke(this.getStroke());
        gstroke.setColor(this.getExteriorColor());
        gstroke.setStroke(this.getStroke());
        double distanceBetweenPoints = (double)(50 / (this.iterativeLevel + 1)) * this.getZoom();
        if (distanceBetweenPoints < 15.0 * this.getZoom()) {
            distanceBetweenPoints = 100.0 * this.getZoom();
        }
        double distanceToConvexHull = (double)(25 / (this.iterativeLevel + 1)) * this.getZoom();
        LinkedList coordinates = new LinkedList();
        ConvexHull hull = new ConvexHull();
        this.source.getCoordinates(coordinates, this.iterativeLevel == 0 ? (int)(5.0 * this.getZoom()) : 0);
        Vector res = hull.calculateHull(coordinates);
        Polygon p = new Polygon();
        for (int i = 0; i < res.size(); ++i) {
            Point pt = (Point)res.get(i);
            p.addPoint(pt.x, pt.y);
        }
        g.fillPolygon(p);
        g.drawPolygon(p);
        Point lastPoint = new Point((Point)res.get(0));
        double x0 = lastPoint.x;
        double y0 = lastPoint.y;
        res.add(res.get(0));
        double x2 = x0;
        double y2 = y0;
        for (int i = res.size() - 1; i >= 0; --i) {
            Point nextPoint = new Point((Point)res.get(i));
            double x1 = nextPoint.x;
            double y1 = nextPoint.y;
            double dx = x1 - x0;
            double dy = y1 - y0;
            double length = Math.sqrt(dx * dx + dy * dy);
            double dxn = dx / length;
            double dyn = dy / length;
            if (length > distanceBetweenPoints) {
                int j = 0;
                while ((double)j < length / distanceBetweenPoints - 1.0) {
                    double y3;
                    double x3;
                    if ((double)(j + 2) * distanceBetweenPoints < length) {
                        x3 = x0 + (double)(j + 1) * distanceBetweenPoints * dxn;
                        y3 = y0 + (double)(j + 1) * distanceBetweenPoints * dyn;
                    } else {
                        x3 = x1;
                        y3 = y1;
                    }
                    this.paintClouds(g, gstroke, x2, y2, x3, y3, distanceToConvexHull);
                    x2 = x3;
                    y2 = y3;
                    ++j;
                }
            } else {
                this.paintClouds(g, gstroke, x2, y2, x1, y1, distanceToConvexHull);
                x2 = x1;
                y2 = y1;
            }
            x0 = x1;
            y0 = y1;
        }
    }

    private void paintClouds(Graphics2D g, Graphics2D gstroke, double x0, double y0, double x1, double y1, double distanceToConvexHull) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        double length = Math.sqrt(dx * dx + dy * dy);
        if (length == 0.0) {
            return;
        }
        double dxn = dx / length;
        double dyn = dy / length;
        double x2 = x0 + 0.5 * dx - distanceToConvexHull * dyn;
        double y2 = y0 + 0.5 * dy + distanceToConvexHull * dxn;
        QuadCurve2D.Double shape = new QuadCurve2D.Double(x0, y0, x2, y2, x1, y1);
        g.fill(shape);
        gstroke.draw(shape);
    }

    public Color getColor() {
        return this.getModel().getColor();
    }

    public Color getExteriorColor() {
        return this.getModel().getExteriorColor();
    }

    public Stroke getStroke() {
        Stroke result = this.getModel().getStroke();
        if (result == null) {
            return DEF_STROKE;
        }
        return result;
    }

    public int getWidth() {
        return this.getModel().getWidth();
    }

    public int getRealWidth() {
        int width = this.getWidth();
        return width < 1 ? 1 : width;
    }

    protected MapView getMap() {
        return this.source.getMap();
    }

    protected MindMapCloud getModel() {
        return this.cloudModel;
    }

    protected double getZoom() {
        return this.getMap().getZoom();
    }

    protected void setRendering(Graphics2D g) {
        if (this.getMap().getController().getAntialiasEdges() || this.getMap().getController().getAntialiasAll()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }
}

