<?php
include('header.php');

?>

<!-- Page Content-->
<div class="page-content">

    <div class="container-fluid">
        <!-- Page-Title -->
        <div class="row">
            <div class="col-sm-12">
                <div class="page-title-box">
                    <div class="float-right">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">充值中心</a></li>
                            <li class="breadcrumb-item active">在线支付</li>
                        </ol>
                    </div>
                    <h4 class="page-title">在线支付</h4>
                </div><!--end page-title-box-->
            </div><!--end col-->
        </div><!--end-row-->
        <!-- end page title end breadcrumb -->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title mt-0 mb-3">onlinePay</h4>
                        <?php if ($conf['alipay_api'] == 0 && $conf['wxpay_api'] == 0 && $conf['qqpay_api'] == 0) {
                        ?> <p class="text-muted mb-3"><span style="color:red">当前网站已关闭在线支付.</span>
                            <?php }else{ ?>
                        <p class="text-muted mb-3">请选择支付方式.
                            <?php }?>

                        <div class="billing-nav">
                            <ul class="nav nav-pills justify-content-center text-center mb-3" id="pills-tab"
                                role="tablist">
                                <?php if($conf['alipay_api'] != 0) {?>
                                    <li class="nav-item">
                                        <a class="nav-link active" data-toggle="pill" id="buy_alipay" href="javascript:void(0);">
                                            <i class="mdi mdi-credit-card d-block mx-auto text-danger font-18"></i>支付宝</a>
                                    </li>
                                <?php }?>

                                <?php if($conf['wxpay_api'] != 0) {?>
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="pill" id="buy_wxpay" href="#">
                                            <i class="mdi mdi-paypal d-block mx-auto text-secondary font-18"></i>微信支付</a>
                                    </li>
                                <?php }?>

                                <?php if($conf['qqpay_api'] != 0) {?>
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="pill" id="buy_qqpay" href="#">
                                            <i class="mdi mdi-bitcoin d-block mx-auto text-warning font-18"></i>QQ支付</a>
                                    </li>
                                <?php }?>

                            </ul>
                            <div class="tab-content" id="pills-tabContent">
                                <div class="tab-pane fade show active" id="pills-credit-card">
                                    <div class="demo-container">
                                        <div class="card-wrapper mb-4"></div>
                                        <div class="form-container">
                                            <form class="bill-form">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label>充值金额</label>
                                                            <input placeholder="请输入要充值的金额" class="form-control" type="tel" name="account">
                                                        </div>
                                                    </div><!--end col-->
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label>用户编号</label>
                                                            <input placeholder="未设置" class="form-control"
                                                                   type="tel" value="<?php echo $userrow['uid'] ?>"
                                                                   disabled>
                                                        </div>
                                                    </div><!--end col-->
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label>充值账号</label>
                                                            <input placeholder="未设置" class="form-control"
                                                                   type="tel" value="<?php echo $userrow['username'] ?>"
                                                                   disabled>
                                                        </div>
                                                    </div><!--end col-->
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label>通知邮箱</label>
                                                            <input placeholder="未设置" class="form-control"
                                                                   type="text"
                                                                   value="<?php echo $userrow['email'] ?>" disabled>
                                                        </div>
                                                    </div><!--end col-->
                                                </div><!--end row-->

                                            </form><!--end form-->
                                        </div><!--end form-container-->
                                    </div><!--end demo-->
                                </div><!--end tab-pane-->

                            </div><!--end tab-content-->
                        </div> <!--end billing-nav-->
                    </div><!--end card-body-->
                </div><!--end card-->
            </div><!--end col-->
        </div><!--end row-->

    </div><!-- container -->

    <?php
    include('footer.php');
    ?>
    <script>
        $("#buy_alipay").click(function () {
            dopay('alipay')
        });
        $("#buy_qqpay").click(function () {
            dopay('qqpay')
        });
        $("#buy_wxpay").click(function () {
            dopay('wxpay')
        });
        $("#buy_tenpay").click(function () {
            dopay('tenpay')
        });

        function dopay(type) {
            var account = $("input[name='account']").val();
            if (account == '' || account == 0) {
                layer.alert('充值金额不能为空');
                return false;
            }
            var ii = layer.msg('数据处理中···', {icon: 16, shade: 0.01, time: 15000});
            $.ajax({
                url: './ajax.php?act=pay',
                type: 'POST',
                dataType: 'json',
                data: {account: $("input[name='account']").val(), type: type},
                success: function (data) {
                    layer.close(ii);
                    if (data.code == 1) {
                        window.location.href = data.url;//'../pay/submit.php?type=' + data.type + '&orderid=' + data.order_no;
                    } else {
                        layer.msg(data.msg, {icon: 2, time: 2000, shade: 0.4});
                    }
                },
                error:function () {
                    layer.alert("网络连接错误");
                }
            })
        }
    </script>

