<?php
// +----------------------------------------------------------------------
// | Quotes [未来可期]
// +----------------------------------------------------------------------
// +----------------------------------------------------------------------
// | Author: 自助建站系统 https://www.kancloud.cn/btwcms-com/btwcms/2265967 作者QQ：1617643
// +----------------------------------------------------------------------
// | Date: 2020年2月5日
// +----------------------------------------------------------------------


include("../app/common.php");

$act = isset($_GET['act']) ? daddslashes($_GET['act']) : null;

use app\Site;

@header('Content-Type: application/json; charset=UTF-8');

if ($islogin != 1) {
    exit('{"code":-1,"msg":"登录信息失效"}');
}

switch ($act) {

    case 'teachTip':
        if ($conf['teach_tip'] == 0) { //未关闭指导提示
            $result = array("code" => -1, "msg" => "未关闭指导提示", "data" => "尊敬的系统管理员您好:</br>感谢您使用本系统,</br>为了您操作方便,也为了减轻我们的负担,我们为您制作了指导手册,您可在本页面下方的快捷操作功能中查看手册.");
        } else {
            $result = array("code" => 1, "msg" => "已经关闭指导提示");
        }
        exit(json_encode($result));
        break;

    case 'closeTeachTip':
        $k = 'teach_tip';
        $value = 1;
        $DB->query("insert into `wcms_conf` set `k`='{$k}',`v`='{$value}' on duplicate key update `v`='{$value}'");
        $result = array("code" => 1, "msg" => "指导提示已不再显示");
        exit(json_encode($result));
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 获取短连接地址
     */
    case 'getShortLink':
        $result = \app\Admin::getShortLink();
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 获取网站运营数据
     */
    case 'getData':
        $thtime = date("Y-m-d") . ' 00:00:00';
        $allSite = $DB->query("SELECT * from `wcms_site` WHERE 1")->rowCount(); //所有网站数量
        $todaySite = $DB->query("SELECT * from `wcms_site` WHERE `addtime`>='$thtime' ")->rowCount(); //今日建站数量
        $allUser = $DB->query("SELECT * from `wcms_user` WHERE 1")->rowCount(); //所有用户数量
        $todayUser = $DB->query("SELECT * from `wcms_user` WHERE `regtime`>='$thtime' ")->rowCount(); //今日用户数量
        $q = $DB->query("SELECT sum(money) from `wcms_order` where `status` = 1");//总收入
        $rows = $q->fetch();
        if ($rows[0] == null) {
            $allMoney = '0.00';
        } else {
            $allMoney = round($rows[0], 2);
        }

        $q = $DB->query("SELECT sum(money) from `wcms_order` where `date`>='$thtime' and `status`=1");//今日交易额
        $rows = $q->fetch();
        if ($rows[0] == null) {
            $todayMoney = '0.00';
        } else {
            $todayMoney = round($rows[0], 2);
        }
        exit('{"code":1,"msg":"获取成功","allSite":"' . $allSite . '","todaySite":"' . $todaySite . '","allUser":"' . $allUser . '","todayUser":"' . $todayUser . '","todayMoney":"' . $todayMoney . '","allMoney":"' . $allMoney . '"}');
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 系统设置
     */
    case 'sysSet':
        $_POST['system_key'] = trim(strip_tags(daddslashes($_POST['system_key'])));
        $_POST['api_status'] = trim(strip_tags(daddslashes($_POST['api_status'])));
        $_POST['api_user'] = trim(strip_tags(daddslashes($_POST['api_user'])));
        $_POST['need_email'] = trim(strip_tags(daddslashes($_POST['need_email'])));

        $_POST['api_key'] = trim(strip_tags(daddslashes($_POST['api_key'])));
        if ($api_status == 1 && (!$api_user || !$api_key)) {
            $result = array("code" => -1, "msg" => "API账号及API密钥不能为空");
            exit(json_encode($result));
        }
       
        foreach ($_POST as $k => $value) {
            $value = daddslashes($value);
            $DB->query("insert into wcms_conf set `k`='{$k}',`v`='{$value}' on duplicate key update `v`='{$value}'");
        }
        saveLog($userrow['uid'], "修改系统设置");
        $result = array("code" => 1, "msg" => "修改成功");
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 网站设置
     */
    case 'siteSet':
        $web_name = $_POST['web_name'];
        $web_subtitle = $_POST['web_subtitle'];
        $web_description = $_POST['web_description'];
        $web_icp = $_POST['web_icp'];
        $about_us = $_POST['about_us'];
        $connect_us = $_POST['connect_us'];
        $friend_link = $_POST['friend_link'];
        $template = $_POST['template'];
        $qqjump = $_POST['qqjump'];//QQ跳转
        $quikly_pass = $_POST['quikly_pass'];
        $push_toll = $_POST['push_toll'];
        $push_price = $_POST['push_price'];
        $access_tongji = $_POST['access_tongji'];
        foreach ($_POST as $k => $value) {
            $value = daddslashes($value);
            $DB->query("insert into wcms_conf set `k`='{$k}',`v`='{$value}' on duplicate key update `v`='{$value}'");
        }
        saveLog($userrow['uid'], "修改网站设置");
        $result = array("code" => 1, "msg" => "修改成功");
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO LOGO设置
     */
    case 'logoSet':
        $filesName = $_FILES["file"]["name"];  //文件名数组
        if ($_FILES["file"]["type"] != "image/jpeg" && $_FILES["file"]["type"] != "image/jpg" && $_FILES["file"]["type"] != "image/png") {
            exit('{"code":-1,"msg":"文件格式不对，非png或jpg文件！ ' . $filesName . '"}');
        }
        $filesTmpName = $_FILES['file']['tmp_name'];  //临时文件名数组
        $filePath = "../assets/img/logo/"; //文件路径
        $filename = "logo.png";
        $rs = move_uploaded_file($filesTmpName, $filePath . $filename);  //保存在缓冲区的是临时文件名而不是文件名
        if ($rs) {    //文件路径  '.$filePath.$filename.'
            saveLog($userrow['uid'], "修改网站LOGO");
            $result = array("code" => 1, "msg" => "修改成功");
            exit(json_encode($result));
        } else {
            $result = array("code" => -1, "msg" => "上传失败");
            exit(json_encode($result));
        }
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/03/07 22:22
     * description:TODO ICO设置
     */
    case 'icoSet':
        $filesName = $_FILES["file"]["name"];  //文件名数组
        if ($_FILES["file"]["type"] != "image/x-icon") {
            exit('{"code":-1,"msg":"文件格式不对，非ico文件！ ' . $filesName . '"}');
        }
        $filesTmpName = $_FILES['file']['tmp_name'];  //临时文件名数组
        $filePath = "../assets/img/"; //文件路径
        $filename = "favicon.ico";
        $rs = move_uploaded_file($filesTmpName, $filePath . $filename);  //保存在缓冲区的是临时文件名而不是文件名
        if ($rs) {    //文件路径  '.$filePath.$filename.'
            saveLog($userrow['uid'], "修改网站ICO");
            $result = array("code" => 1, "msg" => "修改成功");
            exit(json_encode($result));
        } else {
            $result = array("code" => -1, "msg" => "上传失败");
            exit(json_encode($result));
        }
        break;


    //邮箱设置
    case 'emailSet':
        $mail_cloud = trim(strip_tags(daddslashes($_POST['mail_cloud'])));
        $mail_smtp = trim(strip_tags(daddslashes($_POST['mail_smtp'])));
        $mail_port = trim(strip_tags(daddslashes($_POST['mail_port'])));
        $mail_name = trim(strip_tags(daddslashes($_POST['mail_name'])));
        $mail_pwde = trim(strip_tags(daddslashes($_POST['mail_pwd'])));
        foreach ($_POST as $k => $value) {
            if ($k == 'pwd') continue;
            $value = daddslashes($value);
            $DB->query("insert into `wcms_conf` set `k`='{$k}',`v`='{$value}' on duplicate key update `v`='{$value}'");
        }
        saveLog($userrow['uid'], "修改邮箱");
        $result = array("code" => 1, "msg" => "修改成功");
        exit(json_encode($result));
        break;


    //发送测试邮件
    case 'emailTest':
        $sub = $conf['web_name'] . ' - 测试邮件';
        $msg = emailWritting($conf['web_name'], "测试邮件", " 如果您接收到此邮件,说明您已经成功配置邮箱");
        $flag = sendEmail($conf['mail_name'], $sub, $msg);
        if ($flag == true) {
            $result = array("code" => 1, "msg" => "发送成功,请查看您的邮箱是否有测试邮件");
        } else {
            $result = array("code" => -1, "msg" => "发送失败,请检查配置");
        }
        exit(json_encode($result));
        break;


    case 'paySet':
        $_POST['alipay_api'] = trim(strip_tags(daddslashes($_POST['alipay_api'])));
        $_POST['alipay_pid'] = trim(strip_tags(daddslashes($_POST['alipay_pid'])));
        $_POST['alipay_key'] = trim(strip_tags(daddslashes($_POST['alipay_key'])));
        $_POST['alipay2_api'] = trim(strip_tags(daddslashes($_POST['alipay2_api'])));
        $_POST['qqpay_api'] = trim(strip_tags(daddslashes($_POST['qqpay_api'])));
        $_POST['wxpay_api'] = trim(strip_tags(daddslashes($_POST['wxpay_api'])));
        $_POST['ma_id'] = trim(strip_tags(daddslashes($_POST['ma_id'])));
        $_POST['ma_key'] = trim(strip_tags(daddslashes($_POST['ma_key'])));
        $_POST['epay_api'] = trim(strip_tags(daddslashes($_POST['epay_api'])));
        $_POST['epay_id'] = trim(strip_tags(daddslashes($_POST['epay_id'])));
        $_POST['epay_key'] = trim(strip_tags(daddslashes($_POST['epay_key'])));
        $_POST['micropay_api'] = trim(strip_tags(daddslashes($_POST['micropay_api'])));
        $_POST['micropay_pid'] = trim(strip_tags(daddslashes($_POST['micropay_pid'])));
        $_POST['epay_key'] = trim(strip_tags(daddslashes($_POST['epay_key'])));
        $_POST['micropay_mchid'] = trim(strip_tags(daddslashes($_POST['micropay_mchid'])));
        foreach ($_POST as $k => $value) {
            $value = daddslashes($value);
            $DB->query("insert into `wcms_conf` set `k`='{$k}',`v`='{$value}' on duplicate key update `v`='{$value}'");
        }
        saveLog($userrow['uid'], "修改支付设置");
        $result = array("code" => 1, "msg" => "修改成功");
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 添加用户
     */
    case 'addUser':
        $username = trim(strip_tags(daddslashes($_POST['user'])));
        $password = trim(strip_tags(daddslashes($_POST['pass'])));
        $email = trim(strip_tags(daddslashes($_POST['email'])));
        $phone = trim(strip_tags(daddslashes($_POST['phone'])));
        $nickname = trim(strip_tags(daddslashes($_POST['nickname'])));
        $money = trim(strip_tags(daddslashes($_POST['money'])));
        $mcode = trim(strip_tags(daddslashes($_POST['mcode'])));
        $status = trim(strip_tags(daddslashes($_POST['status'])));
        if (!$username || !$email || !$nickname || !$money || !$phone) {
            $result = array("code" => -1, "msg" => "所有项不得为空,请补充完整！");
            exit(json_encode($result));
        }

        if (!preg_match('/^[a-zA-Z0-9]+$/', $username)) {
            $result = array("code" => -1, "msg" => "用户名只能为英文或数字！");
            exit(json_encode($result));
        } elseif (strlen($password) < 6) {
            $result = array("code" => -1, "msg" => "密码不能低于6位！");
            exit(json_encode($result));
        }

        if (strlen($phone) != 11 && strpos($phone, '@') == false) {
            $result = array("code" => -1, "msg" => "请填写正确的手机账号！");
            exit(json_encode($result));
        }
        if (!preg_match('/^[A-z0-9._-]+@[A-z0-9._-]+\.[A-z0-9._-]+$/', $email)) {
            $result = array("code" => -1, "msg" => "邮箱格式不正确");
            exit(json_encode($result));
        }

        $exitusername = $DB->query("SELECT * FROM `wcms_user` WHERE `username`='{$username}' limit 1")->fetch();
        $exitphone = $DB->query("SELECT * FROM `wcms_user` WHERE `phone`='{$phone}' limit 1")->fetch();
        $exitemail = $DB->query("SELECT * FROM `wcms_user` WHERE `email`='{$email}' limit 1")->fetch();
        if ($exitusername) {
            exit('{"code":-1,"msg":"用户账号:' . $username . '已存在,请重新设置"}');
        }
        if ($exitphone) {
            exit('{"code":-1,"msg":"手机号:' . $phone . '已存在,请重新设置"}');
        }
        if ($exitemail) {
            exit('{"code":-1,"msg":"邮箱:' . $email . '已存在,请重新设置"}');
        }
        $city = getCityByIp($clientIp);
        $city = $city['city'];
        $password = md5($password);
        $sql = $DB->exec("INSERT INTO `wcms_user` (`username`, `password`, `email`, `sid`,`phone`, `nickname`, `money`, `regtime`, `regip`, `regcity`, `mcode`, `status`)VALUES ('{$username}', '{$password}', '{$email}', '','{$phone}', '{$nickname}', '{$money}', '{$date}', '{$clientIp}','{$city}','{$mcode}', '{$status}')");
        if ($sql) {
            saveLog($userrow['uid'], "添加用户 $username ");
            exit('{"code":1,"msg":"用户:' . $username . '添加成功"}');
        } else {
            exit('{"code":-1,"msg":"用户:' . $username . '添加失败,请稍后再试"}');
        }

        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 修改用户
     */
    case 'editUser':
        $uid = trim(strip_tags(daddslashes($_POST['uid'])));
        $password = trim(strip_tags(daddslashes($_POST['pass'])));
        $email = trim(strip_tags(daddslashes($_POST['email'])));
        $phone = trim(strip_tags(daddslashes($_POST['phone'])));
        $nickname = trim(strip_tags(daddslashes($_POST['nickname'])));
        $money = trim(strip_tags(daddslashes($_POST['money'])));
        $mcode = trim(strip_tags(daddslashes($_POST['mcode'])));
        $status = trim(strip_tags(daddslashes($_POST['status'])));

       
        if (!$email || !$nickname || !$money || !$phone) {
            $result = array("code" => -1, "msg" => "所有项不得为空,请补充完整");
            exit(json_encode($result));
        }
        if (!$uid) {
            $result = array("code" => -1, "msg" => "修改失败,参数不存在");
            exit(json_encode($result));
        }
        $exitphone = $DB->query("SELECT * FROM `wcms_user` WHERE `phone`='{$phone}'  and uid!='{$uid}' limit 1")->fetch();
        $exitemail = $DB->query("SELECT * FROM `wcms_user` WHERE `email`='{$email}'  and uid!='{$uid}' limit 1")->fetch();
        if ($exitphone) {
            exit('{"code":-1,"msg":"手机号:' . $phone . '已存在,请重新设置"}');
        }
        if ($exitemail) {
            exit('{"code":-1,"msg":"邮箱:' . $email . '已存在,请重新设置"}');
        }
        $rows = $DB->query("select * from `wcms_user` where `uid`='$uid' limit 1")->fetch();
        if (!$rows) {
            exit('{"code":-1,"msg":"修改失败,用户不存在"}');
        }
        //无修改内容时执行
        if ($password == null && $email == $rows['email'] && $phone == $rows['phone'] && $nickname == $rows['nickname'] && $money == $rows['money'] &&
            $status == $rows['status'] && $mcode == $rows['mcode']) {
            exit('{"code":1,"msg":"修改成功"}');
        }
        //修改成功的情况
        //不修改密码
        if ($password == null) {

            $sql = $DB->exec("UPDATE `wcms_user` SET `email` ='{$email}',`phone` ='{$phone}',`nickname` ='{$nickname}',`money` ='{$money}',`mcode` ='{$mcode}',`status` ='{$status}' WHERE `uid`='{$uid}'");
            if ($sql) {
                exit('{"code":1,"msg":"修改成功"}');
            } else {
                exit('{"code":-1,"msg":"修改失败,请稍后再试"}');
            }
        } else {//修改密码
            $password = md5($password);
            $sql = $DB->exec("UPDATE `wcms_user` SET  `password` ='{$password}',`email` ='{$email}',`phone` ='{$phone}',`nickname` ='{$nickname}',`money` ='{$money}',`mcode` ='{$mcode}',`status` ='{$status}' WHERE `uid`='{$uid}'");
            if ($sql) {
                exit('{"code":1,"msg":"修改成功"}');
            } else {
                exit('{"code":-1,"msg":"修改失败,请稍后再试"}');
            }
        }
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 删除用户
     */
    case 'delUser':
        $uid = trim(strip_tags(daddslashes($_POST['uid'])));
        if (!$uid) {
            exit('{"code":-1,"msg":"删除失败,参数不存在"}');
        }
        if ($uid == 10000) {
            exit('{"code":0,"msg":"删除失败,管理员账号不可删除"}');
        }
        $rows = $DB->query("select * from `wcms_user` where `uid`='$uid' limit 1")->fetch();
        if (!$rows) {
            exit('{"code":-1,"msg":"删除失败,用户不存在"}');
        }
        $sql = $DB->exec("DELETE FROM `wcms_user` WHERE `uid`='$uid'");
        if ($sql) {
            exit('{"code":1,"msg":"删除 ' . $uid . ' 成功"}');
        } else {
            exit('{"code":-1,"msg":"删除 ' . $uid . ' 失败"}');
        }
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 添加会员分类
     */
    case 'addMember':
        $mcode = trim(strip_tags(daddslashes($_POST['mcode'])));
        $mname = trim(strip_tags(daddslashes($_POST['mname'])));
        $mprice = trim(strip_tags(daddslashes($_POST['mprice'])));
        $mpercent = trim(strip_tags(daddslashes($_POST['mpercent'])));
        $mdecription = $_POST['mdecription'];
        if ($mcode == null || $mname == null || $mprice == null || $mpercent == null) {
            $result = array("code" => -1, "msg" => "数据不得为空,请补充完整");
            exit(json_encode($result));
        }
        $exitMember = $DB->query("SELECT * FROM `wcms_member` WHERE `mcode`='{$mcode}' limit 1")->fetch();
        if ($exitMember) {
            $result = array("code" => -1, "msg" => "该会员分类唯一编码已存在,请重新设置");
            exit(json_encode($result));
        }
        if (!preg_match("/^\d*$/", $mcode)) {
            $result = array("code" => -1, "msg" => "唯一编码只能为数字");
            exit(json_encode($result));
        }
        if ($mpercent > 1) { //折扣不能大于1
            exit('{"code":-1,"msg":"折扣不能大于1"}');
        }
        //  exit('{"code":-1,"msg":"价格'.$mprice.',折扣:'.$mpercent.',描述:'.$mdecription.',表示:'.$mcode.'"}');
        $sql = $DB->exec("INSERT INTO `wcms_member` (`mname`, `mprice`, `mpercent`, `mdecription`, `mcode`) VALUES ('{$mname}', '{$mprice}', '{$mpercent}', '{$mdecription}', '{$mcode}')");
        if ($sql) {
            $result = array("code" => 1, "msg" => "会员分类: $mname 添加成功");
            exit(json_encode($result));
        } else {
            $result = array("code" => -1, "msg" => "会员分类:  $mname  添加失败,请稍后再试");
            exit(json_encode($result));
        }

        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 修改会员分类
     */
    case 'editMember':
        $mcode = trim(strip_tags(daddslashes($_POST['mcode'])));
        $mname = trim(strip_tags(daddslashes($_POST['mname'])));
        $mprice = trim(strip_tags(daddslashes($_POST['mprice'])));
        $mpercent = trim(strip_tags(daddslashes($_POST['mpercent'])));
        $mdecription = $_POST['mdecription'];
        if ($mcode == null || $mname == null || $mprice == null || $mpercent == null || $mdecription == null) {
            $result = array("code" => -1, "msg" => "数据不得为空,请补充完整");
            exit(json_encode($result));
        }
        if ($mcode == 100 || $mcode == 10000) {
            $result = array("code" => -1, "msg" => "普通用户和管理员分类不可修改");
            exit(json_encode($result));
        }
        if ($mpercent > 1) { //折扣不能大于1
            $result = array("code" => -1, "msg" => "折扣不能大于1");
            exit(json_encode($result));
        }

        $rows = $DB->query("select * from `wcms_member` where `mcode`='{$mcode}' limit 1")->fetch();
        if (!$rows) {
            $result = array("code" => -1, "msg" => "修改失败,分类不存在");
            exit(json_encode($result));
        }
        //没有修改的情况
        if ($mname == $rows['mname'] && $mprice == $rows['mprice'] && $mpercent == $rows['mpercent'] && $mdecription == $rows['mdecription']) {
            $result = array("code" => 1, "msg" => "修改成功");
            exit(json_encode($result));
        }
        //修改成功的情况
        $sql = $DB->exec("UPDATE `wcms_member` SET `mname` ='{$mname}',`mprice` ='{$mprice}',`mpercent` ='{$mpercent}',`mdecription` ='{$mdecription}' WHERE `mcode`='{$mcode}'");
        if ($sql) {
            $result = array("code" => 1, "msg" => "修改成功");
            exit(json_encode($result));
        } else {
            $result = array("code" => -1, "msg" => "修改失败,请稍后再试");
            exit(json_encode($result));
        }
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 删除会员分类
     */
    case 'delMember':
        $mcode = trim(strip_tags(daddslashes($_POST['mcode'])));
        if (!$mcode) {
            $result = array("code" => -1, "msg" => "删除失败,参数不存在");
            exit(json_encode($result));
        }
        $rows = $DB->query("select * FROM `wcms_member` WHERE `mcode`='$mcode' limit 1")->fetch();
        if (!$rows) {
            $result = array("code" => -1, "msg" => "删除失败,会员类别不存在");
            exit(json_encode($result));
        }
        if ($mcode == 100 || $mcode == 10000) {
            $result = array("code" => -1, "msg" => "普通用户和管理员分类不可删除");
            exit(json_encode($result));
        }
        $rows = $DB->query("select * from `wcms_user` where `mcode`='{$mcode}' limit 1")->fetch();
        if ($rows) {//当前分类下有用户
            $result = array("code" => -1, "msg" => "当前分类下有用户,不可删除");
            exit(json_encode($result));
        } else {
            $sql = $DB->exec("DELETE FROM `wcms_member` WHERE `mcode`='$mcode'");
            $name = $rows['mname'];
            if ($sql) {
                $result = array("code" => 1, "msg" => "删除 $name 成功");
                exit(json_encode($result));
            } else {
                $result = array("code" => -1, "msg" => "删除 $name 失败");
                exit(json_encode($result));
            }
        }
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 添加服务器
     */
    case 'addServer':
        $sname = trim(strip_tags(daddslashes($_POST['sname'])));
        $api = trim(strip_tags(daddslashes($_POST['api'])));
        $pass = trim(strip_tags(daddslashes($_POST['pass'])));
        $domain = trim(strip_tags(daddslashes($_POST['domain'])));
        $active = trim(strip_tags(daddslashes($_POST['active'])));
        $ok_domain = trim(strip_tags(daddslashes($_POST['ok_domain'])));
        $sitepath = trim(strip_tags(daddslashes($_POST['sitepath'])));//网站存放路径

        if ($sname == null || $api == null || $pass == null || $domain == null || $active == null || $sitepath == null) {
            $result = array("code" => -1, "msg" => "所有项不得为空,请补充完整");
            exit(json_encode($result));
        }
        if (strexists($domain, "*")) {
            $result = array("code" => -1, "msg" => "域名中不需要带*");
            exit(json_encode($result));
        }
        if (strexists($api, "http")) {
            $result = array("code" => -1, "msg" => "宝塔面板管理地址不需要带http://和/");
            exit(json_encode($result));
        }

        $result = \app\Site::checkServer('http://' . $api, $pass);
        if ($result['code'] != 1) {
            exit(json_encode($result));
        }

        $sql = $DB->exec("INSERT INTO `wcms_server` (`sname`, `api`, `pass`, `domain`,`ok_domain`,`sitepath`, `active`)VALUES ('{$sname}', '{$api}', '{$pass}', '{$domain}','{$ok_domain}', '{$sitepath}', '{$active}')");
        if ($sql) {
            //saveLog($this->pdo, $this->userInfo['uid'], "添加服务器- $sname ");
            $result = array("code" => 1, "msg" => "服务器: $sname 添加成功", "url" => "server.php");
            exit(json_encode($result));
        } else {
            $result = array("code" => -1, "msg" => "服务器: $sname 添加失败,请稍后再试");
            exit(json_encode($result));
        }
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 修改服务器
     */
    case 'editServer':
        $sid = trim(strip_tags(daddslashes($_POST['sid'])));
        $sname = trim(strip_tags(daddslashes($_POST['sname'])));
        $api = trim(strip_tags(daddslashes($_POST['api'])));
        $pass = trim(strip_tags(daddslashes($_POST['pass'])));
        $domain = trim(strip_tags(daddslashes($_POST['domain'])));
        $active = trim(strip_tags(daddslashes($_POST['active'])));
        $sitepath = trim(strip_tags(daddslashes($_POST['sitepath'])));//网站存放路径
        $ok_domain = trim(strip_tags(daddslashes($_POST['ok_domain'])));

        if (!$sid || $sname == null || $api == null || $pass == null || $api == null || $domain == null || $active == null || $sitepath == null) {
            $result = array("code" => -1, "msg" => "所有项不得为空,请补充完整");
            exit(json_encode($result));
        }
        $rows = $DB->query("SELECT * FROM `wcms_server` WHERE `sid`='{$sid}' limit 1")->fetch();
        if (!$rows) {
            $result = array("code" => -1, "msg" => "修改失败,该服务器不存在");
            exit(json_encode($result));
        }
        if (strexists($domain, "*")) {
            $result = array("code" => -1, "msg" => "域名中不需要带*");
            exit(json_encode($result));
        }
        if (strexists($api, "http")) {
            $result = array("code" => -1, "msg" => "宝塔面板管理地址不需要带http://和/");
            exit(json_encode($result));
        }
        if ($sid == $rows['sid'] && $sname == $rows['sname'] && $api == $rows['api'] && $pass == $rows['pass'] && $domain == $rows['domain'] && $ok_domain == $rows['ok_domain'] && $active == $rows['active'] && $sitepath == $rows['sitepath']) {
            $result = array("code" => 1, "msg" => "修改成功", "url" => "server.php");
            exit(json_encode($result));
        }
        $result = \app\Site::checkServer('http://' . $api, $pass);
        if ($result['code'] != 1) {
            exit(json_encode($result));
        }
        $sql = $DB->exec("UPDATE `wcms_server` SET `sname` ='{$sname}',`api` ='{$api}',`pass` ='{$pass}',`domain` ='{$domain}',`ok_domain` ='{$ok_domain}',`sitepath` ='{$sitepath}',`active` ='{$active}'  WHERE `sid`='{$sid}'");
        if ($sql) {
            //saveLog($this->pdo, $this->userInfo['uid'], "修改服务器- $sname ");
            $result = array("code" => 1, "msg" => "修改成功", "url" => "server.php");
            exit(json_encode($result));
        } else {
            $result = array("code" => -1, "msg" => "修改失败,请稍后再试");
            exit(json_encode($result));
        }

        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 删除服务器
     */
    case 'delServer':
        $sid = trim(strip_tags(daddslashes($_POST['sid'])));
        if (!$sid) {
            $result = array("code" => -1, "msg" => "删除失败,参数不存在");
            exit(json_encode($result));
        }
        $rowServer = $DB->query("SELECT `sid`,`sname` FROM `wcms_server` WHERE `sid`='{$sid}' limit 1")->fetch();
        if (!$rowServer) {
            $result = array("code" => -1, "msg" => "删除失败,服务器不存在");
            exit(json_encode($result));
        }
        $rowSite = $DB->query("SELECT `serverid` FROM `wcms_site` WHERE `serverid`='{$sid}' limit 1")->fetch();
        if ($rowSite) {//当前服务器有正在使用的网站
            $result = array("code" => -1, "msg" => "服务器下有网站,不可删除");
            exit(json_encode($result));
        } else {
            $sql = $DB->exec("DELETE FROM `wcms_server` WHERE `sid`='{$sid}'");
            if ($sql) {
                $sname = $rowServer['sname'];
                //saveLog($this->pdo, $this->userInfo['uid'], "删除服务器- $sname ");
                $result = array("code" => 1, "msg" => "删除成功");
                exit(json_encode($result));
            } else {
                $result = array("code" => -1, "msg" => "删除失败,请稍后再试");
                exit(json_encode($result));
            }
        }
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 检测服务器运行状态
     */
    case 'checkServer':
        $sid = trim(strip_tags(daddslashes($_POST['sid'])));
        $rowServer = $DB->query("SELECT `api`,`pass` FROM `wcms_server` WHERE `sid`='{$sid}' limit 1")->fetch();
        $api = 'http://' . $rowServer['api'] . '';
        $pass = $rowServer['pass'];
        $site = new Site();
        $result = \app\Site::checkServer($api, $pass);
        exit(json_encode($result));
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 添加项目
     */
    case 'addProgram':
        $tid = trim(strip_tags(daddslashes($_POST['tid'])));
        $name = trim(strip_tags(daddslashes($_POST['name'])));
        $path = trim(strip_tags(daddslashes($_POST['path'])));
        $price = trim(strip_tags(daddslashes($_POST['price'])));
        $reprice = trim(strip_tags(daddslashes($_POST['reprice'])));
        $install = trim(strip_tags(daddslashes($_POST['install'])));
        $site_path = trim(strip_tags(daddslashes($_POST['site_path'])));
        $usetime = trim(strip_tags(daddslashes($_POST['usetime'])));
        $decription = $_POST['decription'];
        $tip = $_POST['tip'];
        $demo = trim(strip_tags(daddslashes($_POST['demo'])));
        $img = trim(strip_tags(daddslashes($_POST['img'])));
        $discount = trim(strip_tags(daddslashes($_POST['discount']))); //是否参与打折
        $phpversion = trim(strip_tags(daddslashes($_POST['phpversion'])));//项目PHP版本
        $isrewrite = trim(strip_tags(daddslashes($_POST['isrewrite'])));//是否开启伪静态
        $rewrite = $_POST['rewrite'];//伪静态规则
        $specifys_server = trim(strip_tags(daddslashes($_POST['specifys_server'])));
        $sid = trim(strip_tags(daddslashes($_POST['sid'])));
        $code = random(16); //唯一标识
        if (strexists($install, ".zip")) {
            $result = array("code" => -1, "msg" => "项目安装标识只需要填写ZIP压缩包的名字");
            exit(json_encode($result));
        }
        if ($name == null || $price == null || $reprice == null || $install == null || $path == null || $usetime == null || $decription == null || $demo == null || $phpversion == null) {
            $result = array("code" => -1, "msg" => "数据不得为空,请补充完整");
            exit(json_encode($result));
        }
        if (!is_numeric($phpversion)) {
            $result = array("code" => -1, "msg" => "PHP版本输入错误");
            exit(json_encode($result));
        }
        if (!strexists($path, "http")) {
            $result = array("code" => -1, "msg" => "项目源地址需要输入http://或https://");
            exit(json_encode($result));
        }
        if (strexists($path, ".zip")) {
            $result = array("code" => -1, "msg" => "项目源地址不需要带压缩包名字");
            exit(json_encode($result));
        }
        if (!$site_path) {
            $site_path = "/";
        }


        $sql = $DB->exec("INSERT INTO `wcms_program` (`name`, `price`, `reprice`, `path`, `img`, `install`,`site_path`, `usetime`,  `decription`, `tip`, `demo`, `phpversion`, `code`,`discount`,`isrewrite`,`rewrite`, `status`, `tid`,`specifys_server`, `sid`) VALUES ('{$name}', '{$price}', '{$reprice}',  '{$path}', '{$img}','{$install}', '{$site_path}', '{$usetime}', '{$decription}','{$tip}','{$demo}', '{$phpversion}', '{$code}','{$discount}','{$isrewrite}','{$rewrite}', '1','{$tid}','{$specifys_server}','{$sid}')");
        if ($sql) {
            $result = array("code" => 1, "msg" => "项目: $name 添加成功");
            exit(json_encode($result));
        } else {
            $result = array("code" => -1, "msg" => "项目: $name 添加失败,请稍后再试");
            exit(json_encode($result));
        }

        break;


    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 修改项目
     */
    case 'editProgram':
        $tid = trim(strip_tags(daddslashes($_POST['tid'])));
        $pid = trim(strip_tags(daddslashes($_POST['pid'])));
        $name = trim(strip_tags(daddslashes($_POST['name'])));
        $path = trim(strip_tags(daddslashes($_POST['path'])));
        $price = trim(strip_tags(daddslashes($_POST['price'])));
        $reprice = trim(strip_tags(daddslashes($_POST['reprice'])));
        $install = trim(strip_tags(daddslashes($_POST['install'])));
        $usetime = trim(strip_tags(daddslashes($_POST['usetime'])));
        $site_path = trim(strip_tags(daddslashes($_POST['site_path']))); //项目运行路径
        $decription = $_POST['decription'];
        $tip = $_POST['tip'];
        $demo = trim(strip_tags(daddslashes($_POST['demo'])));
        $status = trim(strip_tags(daddslashes($_POST['status'])));
        $img = trim(strip_tags(daddslashes($_POST['img'])));
        $discount = trim(strip_tags(daddslashes($_POST['discount'])));//优惠
        $phpversion = trim(strip_tags(daddslashes($_POST['phpversion'])));//项目PHP版本
        $isrewrite = trim(strip_tags(daddslashes($_POST['isrewrite'])));//是否开启伪静态
        $rewrite = trim(strip_tags(daddslashes($_POST['rewrite'])));//伪静态规则
        $specifys_server = trim(strip_tags(daddslashes($_POST['specifys_server'])));
        $sid = trim(strip_tags(daddslashes($_POST['sid'])));

        if (!$pid) {
            $result = array("code" => -1, "msg" => "修改失败,参数不存在");
            exit(json_encode($result));
        }
        if (strexists($install, ".zip")) {
            $result = array("code" => -1, "msg" => "项目安装标识只需要填写ZIP压缩包的名字");
            exit(json_encode($result));
        }

        if ($name == null || $price == null || $reprice == null || $install == null || $path == null || $usetime == null || $decription == null || $demo == null || $phpversion == null) {
            $result = array("code" => -1, "msg" => "所有项不得为空,请补充完整");
            exit(json_encode($result));
        }
        if (!is_numeric($phpversion)) {
            $result = array("code" => -1, "msg" => "PHP版本输入错误");
            exit(json_encode($result));
        }
        if (!strexists($path, "http")) {
            $result = array("code" => -1, "msg" => "项目源地址需要输入http://或https://");
            exit(json_encode($result));
        }
        if (strexists($path, ".zip")) {
            $result = array("code" => -1, "msg" => "项目源地址不需要带压缩包名字");
            exit(json_encode($result));
        }
        if (!$site_path) {
            $site_path = "/";
        }
        $rows = $DB->query("select * from `wcms_program` where `pid`='{$pid}' limit 1")->fetch();
        if (!$rows) {
            $result = array("code" => -1, "msg" => "修改失败,项目不存在");
            exit(json_encode($result));
        }
          //没有修改的情况
        if ($specifys_server == $rows['specifys_server'] && $sid == $rows['sid'] && $tip == $rows['tip'] && $tid == $rows['tid'] && $name == $rows['name'] && $price == $rows['price'] && $img == $rows['img'] && $reprice == $rows['reprice'] && $install == $rows['install'] && $path == $rows['path'] && $usetime == $rows['usetime'] && $decription == $rows['decription'] && $demo == $rows['demo'] && $phpversion == $rows['phpversion'] && $discount == $rows['discount'] && $status == $rows['status'] && $isrewrite == $rows['isrewrite'] && $rewrite == $rows['rewrite'] && $site_path == $rows['site_path']) {
            $result = array("code" => 1, "msg" => "修改成功");
            exit(json_encode($result));
        }
        //修改成功的情况
        $sql = $DB->exec("UPDATE `wcms_program` SET `name` ='{$name}',`price` ='{$price}',`reprice` ='{$reprice}',`img` ='{$img}',`install` ='{$install}',`path` ='{$path}',`site_path` = '{$site_path}',`usetime` ='{$usetime}',`decription` ='{$decription}',`tip` ='{$tip}',`demo` ='{$demo}',`discount` ='{$discount}',`isrewrite` ='{$isrewrite}',`rewrite` ='{$rewrite}',`status` ='{$status}' ,`phpversion` ='{$phpversion}',`tid`='{$tid}',`tid`='{$tid}',`specifys_server`='{$specifys_server}',`sid`='{$sid}',`site_path`='{$site_path}' WHERE `pid`='{$pid}'");
        if ($sql) {
            $result = array("code" => 1, "msg" => "修改成功");
            exit(json_encode($result));
        } else {
            $result = array("code" => -1, "msg" => "修改失败,请稍后再试");
            exit(json_encode($result));
        }
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 删除项目
     */
    case 'delProgram':
        $pid = trim(strip_tags(daddslashes($_POST['pid'])));
        if (!$pid) {
            $result = array("code" => -1, "msg" => "删除失败,参数不存在");
            exit(json_encode($result));
        }
        $rows = $DB->query("select * from `wcms_program` where `pid`='$pid' limit 1")->fetch();
        if (!$rows) {
            $result = array("code" => -1, "msg" => "删除失败,项目不存在");
            exit(json_encode($result));
        }
        $rows = $DB->query("select * from `wcms_site` where `code`='{$rows['code']}' limit 1")->fetch();
        if ($rows) {//当前项目有正在使用的网站
            $result = array("code" => -1, "msg" => "项目下有网站,不可删除,如不售卖,可下架");
            exit(json_encode($result));
        } else {
            $sql = $DB->exec("DELETE FROM `wcms_program` WHERE `pid`='$pid'");
            $name = $rows['name'];
            if ($sql) {
                saveLog($userrow['uid'], "删除项目 $name ");
                $result = array("code" => 1, "msg" => "删除 $name 成功");
                exit(json_encode($result));
            } else {
                $result = array("code" => -1, "msg" => "删除 $name 失败");
                exit(json_encode($result));
            }
        }
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/3/26 22:22
     * description:TODO 一键切换所有项目源地址
     */
    case 'changeProPath':
        $path = trim(strip_tags(daddslashes($_POST['proPath'])));
        $DB->exec("update `wcms_program` set `path`='{$path}' ");
        $result = array("code" => 1, "msg" => "切换成功");
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/4/12 22:22
     * description:TODO 修改所有项目的销售价格
     */
    case 'changeSalePrice':
        $price = trim(strip_tags(daddslashes($_POST['salePrice'])));
        if (!is_numeric($price)) {
            $result = array("code" => -1, "msg" => "请输入整数");
            exit(json_encode($result));
        }
        $DB->exec("update `wcms_program` set `price`='{$price}'");
        $result = array("code" => 1, "msg" => "修改成功");
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/4/12 22:22
     * description:TODO 修改所有项目的续费价格
     */
    case 'changeRePrice':
        $reprice = trim(strip_tags(daddslashes($_POST['rePrice'])));
        if (!is_numeric($reprice)) {
            $result = array("code" => -1, "msg" => "请输入整数");
            exit(json_encode($result));
        }
        $DB->exec("update `wcms_program` set `reprice`='{$reprice}'");
        $result = array("code" => 1, "msg" => "修改成功");
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/4/12 22:22
     * description:TODO 修改所有项目的使用时间
     */
    case 'changeUseTime':
        $usetime = trim(strip_tags(daddslashes($_POST['useTime'])));
        if (!is_numeric($usetime)) {
            $result = array("code" => -1, "msg" => "请输入整数");
            exit(json_encode($result));
        }
        $DB->exec("update `wcms_program` set `usetime`='{$usetime}'");
        $result = array("code" => 1, "msg" => "修改成功");
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/4/12 22:22
     * description:TODO 修改所有项目的演示地址
     */
    case 'changeDemo':
        $demo = trim(strip_tags(daddslashes($_POST['demo'])));
        $DB->exec("update `wcms_program` set `demo`='{$demo}'");
        $result = array("code" => 1, "msg" => "修改成功");
        exit(json_encode($result));
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/4/12 22:22
     * description:TODO 上架所有项目
     */
    case 'onSaleAll':
        $DB->exec("update `wcms_program` set `status`='1'");
        $result = array("code" => 1, "msg" => "上架成功");
        exit(json_encode($result));
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/4/12 22:22
     * description:TODO 下架所有项目
     */
    case 'downSaleAll':
        $DB->exec("update `wcms_program` set `status`='0'");
        $result = array("code" => 1, "msg" => "下架成功");
        exit(json_encode($result));
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/4/12 22:22
     * description:TODO 删除所有项目
     */
    case 'delProAll':

        $rows = $DB->query("select * from `wcms_site` limit 1")->fetch();
        if ($rows) {//当前项目有正在使用的网站
            $result = array("code" => -1, "msg" => "项目下有网站,不可进行批量删除操作");
            exit(json_encode($result));
        }

        $DB->exec("truncate table `wcms_program` ");
        $result = array("code" => 1, "msg" => "删除成功");
        exit(json_encode($result));
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 添加文章
     */
    case 'addArticle':
        $title = trim(strip_tags(daddslashes($_POST['title'])));
        $content = $_POST['content'];
        $type = trim(daddslashes($_POST['type']));
        if ($title == null || $content == null) {
            $result = array("code" => -1, "msg" => "所有项不得为空,请补充完整");
            exit(json_encode($result));
        }
        $sql = $DB->exec("INSERT INTO `wcms_news` (`title`, `content`,`type`,`uid`, `date`) VALUES ('{$title}','{$content}','{$type}','{$userrow['uid']}', '{$date}')");
        if ($sql) {
            saveLog($userrow['uid'], "发布文章- $title");
            $result = array("code" => 1, "msg" => "文章发布成功", "url" => "article.php");
            exit(json_encode($result));
        } else {
            $result = array("code" => -1, "msg" => "文章发布失败,请稍后再试");
            exit(json_encode($result));
        }
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 修改文章
     */
    case 'editArticle':
        $id = trim(strip_tags(daddslashes($_POST['id'])));
        $title = trim(strip_tags(daddslashes($_POST['title'])));
        $content = $_POST['content'];
        $type = trim(daddslashes($_POST['type']));
        if ($title == null || $content == null) {
            $result = array("code" => -1, "msg" => "所有项不得为空,请补充完整");
            exit(json_encode($result));
        }
        $sql = $DB->exec("UPDATE `wcms_news` SET `title` ='{$title}',`content` ='{$content}',`type` ='{$type}' WHERE `id`='{$id}'");
        saveLog($userrow['uid'], "修改文章- $title");
        $result = array("code" => 1, "msg" => "文章修改成功", "url" => "article.php");
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 删除文章
     */
    case 'delArticle':
        $id = trim(strip_tags(daddslashes($_POST['id'])));
        if ($art = $DB->query("select * from `wcms_news` where `id`='$id' limit 1")->fetch()) {
            $flag = $DB->exec("DELETE FROM `wcms_news` WHERE `id`='$id'");
            if ($flag) {
                $title = $art['title'];
                saveLog($userrow['uid'], "删除文章- $title");
                $result = array("code" => 1, "msg" => "删除成功");
            } else {
                $result = array("code" => -1, "msg" => "网络异常");
            }
        } else {
            $result = array("code" => -1, "msg" => "文章不存在");
        }
        exit(json_encode($result));
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 清空日志记录
     */
    case 'delLog':
        $day = trim(strip_tags(daddslashes($_POST['day'])));
        if ($day == "7天前") {
            $date = date('Y-m-d H:i:s', strtotime('-7 days'));//获得七天前日期
            $sql = $DB->exec("DELETE FROM `wcms_log` WHERE `date` < '{$date}'");
            if ($sql) {
                saveLog($userrow['uid'], "清空7天前日志");
                $result = array("code" => 1, "msg" => "清空7天前日志成功");
                exit(json_encode($result));
            } else {
                $result = array("code" => -1, "msg" => "暂无7天前日志");
                exit(json_encode($result));
            }
        } else if ($day == "15天前") {
            $date = date('Y-m-d H:i:s', strtotime('-15 days'));//获得15天前日期
            $sql = $DB->exec("DELETE FROM `wcms_log` WHERE date<'$date'");
            if ($sql) {
                saveLog($userrow['uid'], "清空15天前日志");
                $result = array("code" => -1, "msg" => "清空15天前日志成功");
                exit(json_encode($result));
            } else {
                $result = array("code" => -1, "msg" => "暂无15天前日志");
                exit(json_encode($result));
            }
        } else if ($day == "全部") {
            $sql = $DB->exec("DELETE FROM `wcms_log` WHERE 1");
            if ($sql) {
                saveLog($userrow['uid'], "清空全部日志");
                $result = array("code" => 1, "msg" => "清空全部日志成功");
                exit(json_encode($result));
            } else {
                $result = array("code" => -1, "msg" => "暂无日志");
                exit(json_encode($result));
            }
        }
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 清空消费记录
     */
    case 'delOrder':
        $day = trim(strip_tags(daddslashes($_POST['day'])));
        if ($day == "所有支付失败") {
            $sql = $DB->exec("DELETE FROM `wcms_order` WHERE `status` = 0");
            if ($sql) {
                saveLog($userrow['uid'], "清空所有支付失败消费记录");
                $result = array("code" => 1, "msg" => "清空所有支付失败消费记录成功");
                exit(json_encode($result));
            } else {
                $result = array("code" => -1, "msg" => "暂无支付失败消费记录");
                exit(json_encode($result));
            }
        } else if ($day == "15天前") {
            $date = date('Y-m-d H:i:s', strtotime('-15 days'));//获得15天前日期
            $sql = $DB->exec("DELETE FROM `wcms_order` WHERE `addtime` < '{$date}'");
            if ($sql) {
                saveLog($userrow['uid'], "清空15天前消费记录");
                $result = array("code" => 1, "msg" => "清空15天前消费记录成功");
                exit(json_encode($result));
            } else {
                $result = array("code" => -1, "msg" => "暂无15天前消费记录");
                exit(json_encode($result));
            }
        } else if ($day == "全部") {
            $sql = $DB->exec("DELETE FROM `wcms_order` WHERE 1");
            if ($sql) {
                saveLog($userrow['uid'], "清空全部消费记录");
                $result = array("code" => 1, "msg" => "清空全部消费记录成功");
                exit(json_encode($result));
            } else {
                $result = array("code" => -1, "msg" => "暂无消费记录");
                exit(json_encode($result));
            }
        }
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 续费用户网站
     */
    case 'rePay':
        $sid = trim(strip_tags(daddslashes($_POST['sid'])));
        //根据宝塔ID获得数据库中对应的站点的信息
        $rowSite = $DB->query("select * from `wcms_site` where `sid`='{$sid}' limit 1")->fetch();
        //获得对应的项目信息
        $rowProgram = $DB->query("select * from `wcms_program` where `code`='{$rowSite['code']}' limit 1")->fetch();
        //获得对应的服务器信息
        $rowServer = $DB->query("select * from `wcms_server` where `sid`='{$rowSite['serverid']}' limit 1")->fetch();
        //$rowProgram['usetime']  //续费使用
        // $rowSite['endtime'] 	//剩余时间
        //新到期时间 = 剩余时间 + 续费时间
        $endtime = date('Y-m-d H:i:s', strtotime("{$rowSite['endtime']} + {$rowProgram['usetime']} months"));
        $endtime = date('Y-m-d', strtotime($endtime)); //将年月日时分秒转成年月日
        $api = 'http://' . $rowServer['api'] . '';
        $pass = $rowServer['pass'];

        $timeSet = app\Site::rePay($api, $pass, $rowSite['bid'], $endtime);
        if ($timeSet['code'] == -1) {
            $result = array("code" => -1, "msg" => $timeSet['msg']);
            exit(json_encode($result));
        } else {
            $DB->exec("UPDATE `wcms_site` SET `endtime` ='{$endtime}' WHERE `bid`='{$rowSite['bid']}'");
            $proName = $rowProgram["name"];
            $uid = $rowSite['uid'];
            $sid = $rowSite['sid'];
            saveLog($userrow['uid'], "续费用户 $uid-$proName 网站编号 $sid");
            $result = array("code" => 1, "msg" => "续费成功", "url" => 'site.php');
            exit(json_encode($result));
        }
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 删除用户网站
     */
    case 'delSite':
        $sid = trim(strip_tags(daddslashes($_POST['sid'])));
        //根据宝塔ID获得数据库中对应的站点的信息
        //判断当前站点是否再数据库中
        $rows = $DB->query("select * from `wcms_site` where `sid`='{$sid}' limit 1")->fetch();
        if (!$rows) {
            $result = array("code" => 1, "msg" => "删除成功");
            exit(json_encode($result));
        }
        //获得对应的服务器信息
        $rowServer = $DB->query("SELECT * FROM `wcms_server` WHERE `sid`='{$rows['serverid']}' limit 1")->fetch();
        $result = \app\Site::delSite($rowServer['api'], $rowServer['pass'], $rows['bid'], $rows['domain']);
        if ($result["code"] != 1 && $result["msg"] != '指定站点不存在!') {
            $result = array("code" => -1, "msg" => $result["msg"]);
            exit(json_encode($result));
        } else {
            $sql = $DB->exec("DELETE FROM `wcms_site` WHERE `sid`='{$sid}'");
            if ($sql) {
                $uid = $rows['uid'];
                saveLog($userrow['uid'], "删除 $uid - 网站编号 $sid");
                $result = array("code" => 1, "msg" => "删除成功");
                exit(json_encode($result));
            }
        }
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/4/17 22:22
     * description:TODO 申请宝塔面板SSL证书
     */
    case 'GetDVSSL':
        $bid = trim(strip_tags(daddslashes($_POST['bid'])));
        $rows = $DB->query("select * from `wcms_site` where `bid`='{$bid}' limit 1")->fetch();
        if (!$rows) {
            $result = array("code" => -1, "msg" => "未找到指定网站");
            exit(json_encode($result));
        }

        //获得对应的服务器信息
        $rowServer = $DB->query("SELECT * FROM `wcms_server` WHERE `sid`='{$rows['serverid']}' limit 1")->fetch();
        $getKey = \app\Site::getKey($rowServer['api'], $rowServer['pass'],$rowSite['bid']);
        $result = \app\Site::GetDVSSL($rowServer['api'], $rowServer['pass'],$rows['domain'], $getKey);
        if ($result["code"] == 1) { //开启SSL
            $DB->exec("UPDATE `wcms_site` SET `open_ssl` ='1' WHERE `bid`='{$rowSite['bid']}'");
            $result = array("code" => 1, "msg" => $result["msg"]);
            exit(json_encode($result));
        } else {
            $result = array("code" => -1, "msg" => "宝塔面板提示：".$result["msg"]);
            exit(json_encode($result));
        }
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 获取服务商城信息
     */
    case 'getStore':
        $updateResult = \app\Admin::getUpdateControFile();
        if ($updateResult['ver'] == VER) {
            $ver = VER;
            $result = "<div class='ibox-content'><div class='alert alert-success'>当前已是系统最新版本。 <br><a class='alert-link' href='#'>当前版本： Beta $ver .0.0.0 </a></div></div>";
        } else {
            $ver = $updateResult['ver'];
            $log = $updateResult['log'];
            $result = " <div class='ibox-content'><div class='alert alert-danger'>检测到新版：Beta  $ver </div><div class='alert alert-green'>更新内容:</br>  $log </div> &nbsp;&nbsp;&nbsp;<a onclick='update()' class='btn btn-success'>立即更新</a></div>";
        }
        $result = array("code" => 1, "msg" => "获取成功", "data" => $result);
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 安装插件模板
     */
    case 'installTem':
        $pid = trim(strip_tags(daddslashes($_POST['pid'])));
        if (!$pid) {
            $result = array("code" => -1, "msg" => "安装失败,参数不存在");
            exit(json_encode($result));
        }
        //模板下载密钥
        $system_key = $conf['system_key'];
        $result = \app\Admin::installTem($DB, $system_key, $pid, $mainDomain);
        //删除菜单session
        unset($_SESSION["menuList"]);
        unset($_SESSION["menuListMange"]);
        exit('{"code":"' . $result['code'] . '","msg":"' . $result['msg'] . '"}');
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 判断是否需要更新
     */
    case 'isUpdate':
        $updateResult = \app\Admin::getUpdateControFile();
        if ($updateResult['ver'] == VER) {
            $result = array("code" => 1, "msg" => "当前系统为最新版本");
            exit(json_encode($result));
        } else {
            $result = array("code" => -1, "msg" => "系统需要更新啦", "data" => $updateResult['log']);
            exit(json_encode($result));
        }
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 获取更新信息
     */
    case 'getUpdate':
        $updateResult = \app\Admin::getUpdateControFile();
        if ($updateResult['ver'] == VER) {
            $ver = VER;
            $result = "<div class='ibox-content'><div class='alert alert-success'>当前已是系统最新版本。 <br><a class='alert-link' href='#'>当前版本： Beta $ver .0.0.0 </a></div></div>";
        } else {
            $ver = $updateResult['ver'];
            $log = $updateResult['log'];
            $oldVer = VER;
            $result = " <div class='ibox-content'><div class='alert alert-danger'>当前系统版本：Beta $oldVer .0.0.0  检测到新版：Beta  $ver .0.0.0  </div><div class='alert alert-green'>更新内容:</br>  $log </div> &nbsp;&nbsp;&nbsp;<a onclick='update()' class='btn btn-success'>立即更新</a></div>";
        }
        $oldLog = $updateResult['older'];
        $result = array("code" => -1, "msg" => "获取成功", "data" => $result, "oldLog" => $oldLog);
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/12 22:22
     * description:TODO 更新
     */
    case 'update':
        $result = \app\Admin::updateSystem();
        $result = array("code" => $result['code'], "msg" => $result['msg'], "url" => $result['url']);
        exit(json_encode($result));
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/2/28 22:22
     * description:TODO 删除单个工单
     */
    case 'delOneWorkOrder':
        $id = trim(strip_tags(daddslashes($_POST['id'])));
        $row = $DB->query("SELECT * from `wcms_workorder` WHERE `id`='{$id}' limit 1")->fetch();//f03a84cb7482f59e
        $DB->exec("DELETE FROM `wcms_workorder` WHERE `code` = '{$row['code']}'");
        $result = array("code" => 1, "msg" => "删除成功", "url" => 'workOrder.php');
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/28 22:22
     * description:TODO 删除所有工单
     */
    case 'delAllWorkOrder':
        $sql = $DB->exec("TRUNCATE TABLE `wcms_workorder`");
        $result = array("code" => 1, "msg" => "删除成功", "url" => 'workOrder.php');
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/28 22:22
     * description:TODO 删除已解决工单
     */
    case 'delOkWorkOrder':
        $DB->exec("DELETE FROM `wcms_workorder` WHERE `state` = 1");
        $result = array("code" => 1, "msg" => "删除成功", "url" => 'workOrder.php');
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/28 22:22
     * description:TODO 回复工单
     */
    case 'replyWorkOrder':
        $code = trim(strip_tags(daddslashes($_POST['code'])));
        $content = trim(strip_tags(daddslashes($_POST['content'])));
        $row = $DB->query("SELECT * from `wcms_workorder` WHERE `code`='{$code}' limit 1")->fetch();//f03a84cb7482f59e
        $date = $row['date'];
        $title = $row['title'];
        $adminreply = date("Y-m-d H:i:s");
        $userreply = date("Y-m-d H:i:s");
        $num = time();
        $date = date("Y-m-d H:i:s");
        $userrow['username'] = '系统管理员';
        $state = 0;
        $DB->exec("UPDATE `wcms_workorder` SET `adminreply` ='{$adminreply}' WHERE `code`='{$code}'");
        $sql = $DB->exec("INSERT INTO `wcms_workorder` (`code`,`uid`,`num`, `user`, `title`,`content`,`userreply`, `state`,`date`,`adminreply`) VALUES ('{$code}','{$userrow['uid']}','{$num}','{$userrow['username']}','{$title}','{$content}','{$userreply}','{$state}','{$date}','{$adminreply}')");
        $DB->exec("UPDATE `wcms_workorder` SET  `state`=0  WHERE `code`='{$code}'");
        $DB->exec("UPDATE `wcms_workorder` SET  `userreply`='{$userreply}'  WHERE `code`='{$code}'");
        $email = $DB->query("SELECT * FROM `wcms_user` WHERE `uid`='{$row['uid']}' limit 1")->fetch();
        if ($email['email'] != null && ($conf['mail_pwd'] != null || $conf['sms_appkey'] != null)) {
            $sub = $conf['web_name'] . ' - 新工单提醒';
            $msg = emailWritting($conf['web_name'], "新工单提醒", " 您的网站有新的工单提醒请及时查看<br/>工单提交时间为：$date");
            sendEmail($email['email'], $sub, $msg);
        }
        $result = array("code" => 1, "msg" => "回复成功", "url" => 'workOrder.php');
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/28 22:22
     * description:TODO 改变工单状态
     */
    case 'changeWorkOrder':
        $id = trim(strip_tags(daddslashes($_POST['id'])));
        $row = $DB->query("SELECT * from `wcms_workorder` WHERE `id`='{$id}' limit 1")->fetch();
        $state = 0;
        if ($row['state'] == 0) {
            $state = 1;
        }
        $DB->exec("UPDATE `wcms_workorder` SET  `state`='{$state}'  WHERE `code`='{$row['code']}'");
        $result = array("code" => 1, "msg" => "修改成功", "url" => 'workOrder.php');
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/29 02:39
     * description:TODO 清空菜单缓存
     */
    case 'clearCache':
        unset($_SESSION["menuListManage"]);//后台菜单session
        unset($_SESSION["menuList"]);//用户端菜单session
        $result = array("code" => 1, "msg" => "菜单缓存已清除", "url" => 'index.php');
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/29 02:45
     * description:TODO 管理员开启一键搭建演示站任务
     */
    case 'addDemo':
        /*思路： 1.查询出所有上架程序 2.查询出一个可用的服务器 3.为每个程序分配域名 4.写入数据库 5.执行监控任务 */
        $cron = $DB->query("SELECT * FROM `wcms_demo` where `status` != 3 limit 1")->fetch();
        if ($cron) {
            $result = array("code" => -1, "msg" => "当前任务中有未执行或执行失败的任务,不可添加新任务");
            exit(json_encode($result));
        }
        $programList = $DB->query("SELECT * FROM `wcms_program` where `status`=1 ")->fetchAll();
        $server = $DB->query("SELECT * FROM `wcms_server` where `active`= 1 limit 1")->fetch();
        if (!$server || !$programList) {
            $result = array("code" => -1, "msg" => "没有上架的程序或没有可用的服务器");
            exit(json_encode($result));
        }
        foreach ($programList as $program) {
            $domainRound = getRandStr(); //域名前缀
            $server['domain'];//服务器设置的泛绑定域名
            $domain = $domainRound . '.' . $server['domain'];
            $status = 1;//任务状态
            $DB->exec("INSERT INTO `wcms_demo` (`domain`,`code`,`date`,`status`)VALUES('{$domain}', '{$program['code']}','{$date}','{$status}')");
        }
        $result = array("code" => 1, "msg" => "建站任务添加完成", "url" => 'addDemo.php');
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/29 18:29
     * description:TODO 清空一键建站任务
     */
    case 'clearDemo':
        $DB->exec("TRUNCATE TABLE `wcms_demo` ");
        $result = array("code" => 1, "msg" => "一键建站任务已清空", "url" => 'addDemo.php');
        exit(json_encode($result));
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/2/29 05:30
     * description:TODO 修改后台菜单
     */
    case 'editManageMenu':
        $id = trim(strip_tags(daddslashes($_POST['id'])));
        $menuname = trim(strip_tags(daddslashes($_POST['menuname'])));
        $menupath = trim(strip_tags(daddslashes($_POST['menupath'])));
        $menuicon = $_POST['menuicon'];
        $parentid = trim(strip_tags(daddslashes($_POST['parentid'])));
        $status = trim(strip_tags(daddslashes($_POST['status'])));
        $hava_parent = trim(strip_tags(daddslashes($_POST['hava_parent'])));
        if ($hava_parent == 0) {
            $parentid = 0;
        }

        $DB->exec("UPDATE `wcms_menu2` SET  `menuname` ='{$menuname}',`menupath` ='{$menupath}',`menuicon` ='{$menuicon}',`parentid` ='{$parentid}',`status` ='{$status}' WHERE `id`='{$id}'");
        unset($_SESSION["menuListManage"]);//后台菜单session
        unset($_SESSION["menuList"]);//用户端菜单session
        $result = array("code" => 1, "msg" => "修改成功", "url" => "menu.php");
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/29 05:56
     * description:TODO 修改用户菜单
     */
    case 'editConsumerMenu':
        $id = trim(strip_tags(daddslashes($_POST['id'])));
        $menuname = trim(strip_tags(daddslashes($_POST['menuname'])));
        $menupath = trim(strip_tags(daddslashes($_POST['menupath'])));
        $menuicon = $_POST['menuicon'];
        $parentid = trim(strip_tags(daddslashes($_POST['parentid'])));
        $status = trim(strip_tags(daddslashes($_POST['status'])));
        $hava_parent = trim(strip_tags(daddslashes($_POST['hava_parent'])));
        if ($hava_parent == 0) {
            $parentid = 0;
        }
        $DB->exec("UPDATE `wcms_menu` SET  `menuname` ='{$menuname}',`menupath` ='{$menupath}',`menuicon` ='{$menuicon}',`parentid` ='{$parentid}',`status` ='{$status}' WHERE `id`='{$id}'");
        unset($_SESSION["menuListManage"]);//后台菜单session
        unset($_SESSION["menuList"]);//用户端菜单session
        $result = array("code" => 1, "msg" => "修改成功", "url" => "menu.php");
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/29 05:56
     * description:TODO 添加后台菜单
     */
    case 'addManageMenu':
        $menuname = trim(strip_tags(daddslashes($_POST['menuname'])));
        $menupath = trim(strip_tags(daddslashes($_POST['menupath'])));
        $menuicon = $_POST['menuicon'];
        $parentid = trim(strip_tags(daddslashes($_POST['parentid'])));
        $status = trim(strip_tags(daddslashes($_POST['status'])));
        $hava_parent = trim(strip_tags(daddslashes($_POST['hava_parent'])));
        if ($hava_parent == 0) {
            $parentid = 0;
        }
        $DB->exec("INSERT INTO `wcms_menu2` (`menuname`, `menupath`, `menuicon`, `parentid`,`status`)VALUES ('{$menuname}', '{$menupath}', '{$menuicon}', '{$parentid}', '{$status}')");
        unset($_SESSION["menuListManage"]);//后台菜单session
        unset($_SESSION["menuList"]);//用户端菜单session
        $result = array("code" => 1, "msg" => "添加成功", "url" => "menu.php");
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/29 05:56
     * description:TODO 添加用户菜单
     */
    case 'addConsumerMenu':
        $menuname = trim(strip_tags(daddslashes($_POST['menuname'])));
        $menupath = trim(strip_tags(daddslashes($_POST['menupath'])));
        $menuicon = $_POST['menuicon'];
        $parentid = trim(strip_tags(daddslashes($_POST['parentid'])));
        $status = trim(strip_tags(daddslashes($_POST['status'])));
        $hava_parent = trim(strip_tags(daddslashes($_POST['hava_parent'])));
        if ($hava_parent == 0) {
            $parentid = 0;
        }
        $DB->exec("INSERT INTO `wcms_menu` (`menuname`, `menupath`, `menuicon`, `parentid`,`status`)VALUES ('{$menuname}', '{$menupath}', '{$menuicon}', '{$parentid}', '{$status}')");
        unset($_SESSION["menuListManage"]);//后台菜单session
        unset($_SESSION["menuList"]);//用户端菜单session
        $result = array("code" => 1, "msg" => "添加成功", "url" => "menu.php");
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/29 06:06
     * description:TODO 删除后台菜单
     */
    case 'delManageMenu':
        $id = trim(strip_tags(daddslashes($_POST['id'])));
        $list = $DB->query("SELECT * FROM `wcms_menu2` WHERE `parentid` = '{$id}' ")->fetchAll();
        if ($list) {
            $result = array("code" => -1, "msg" => "当前菜单下有子菜单,无法删除");
            exit(json_encode($result));
        }
        $DB->exec("DELETE FROM `wcms_menu2` WHERE `id` = '{$id}' ");
        unset($_SESSION["menuListManage"]);//后台菜单session
        unset($_SESSION["menuList"]);//用户端菜单session
        $result = array("code" => 1, "msg" => "删除成功", "url" => 'menu.php');
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/29 06:06
     * description:TODO 删除用户菜单
     */
    case 'delConsumerMenu':
        $id = trim(strip_tags(daddslashes($_POST['id'])));
        $list = $DB->query("SELECT * FROM `wcms_menu` WHERE `parentid` = '{$id}' ")->fetchAll();
        if ($list) {
            $result = array("code" => -1, "msg" => "当前菜单下有子菜单,无法删除");
            exit(json_encode($result));
        }
        $DB->exec("DELETE FROM `wcms_menu` WHERE `id` = '{$id}' ");
        unset($_SESSION["menuListManage"]);//后台菜单session
        unset($_SESSION["menuList"]);//用户端菜单session
        $result = array("code" => 1, "msg" => "删除成功", "url" => 'menu.php');
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/29 14:50
     * description:TODO 生成卡密
     */
    case 'addCard':
        $num = trim(strip_tags(daddslashes($_POST['num'])));
        $money = trim(strip_tags(daddslashes($_POST['money'])));
        if (!$num || !$money) {
            $result = array("code" => -1, "msg" => "数据不能为空");
            exit(json_encode($result));
        }
        for ($i = 0; $i < $num; $i++) {
            $card = rand(1, 9999);
            $card = md5($card);
            $card = mb_substr($card, 0, 12, 'utf-8');
            $DB->exec("INSERT INTO `wcms_card` (`card`, `money`, `addtime`, `active`,`type`)VALUES ('{$card}', '{$money}', '{$date}', '0', '0')");
        }
        $result = array("code" => 1, "msg" => "生成成功", "url" => 'cardPay.php');
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/29 14:55
     * description:TODO 删除已使用卡密
     */
    case 'delUseCard':
        $DB->exec("DELETE FROM `wcms_card` WHERE `active` = '1' and type  = '0' ");
        $result = array("code" => 1, "msg" => "删除成功", "url" => 'cardPay.php');
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/29 14:59
     * description:TODO 删除所有卡密
     */
    case 'delAllCard':
        $DB->exec("DELETE FROM `wcms_card` WHERE type = '0' ");
        $result = array("code" => 1, "msg" => "删除成功", "url" => 'cardPay.php');
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/2/29 15:05
     * description:TODO 导出未使用卡密
     */
    case 'exportCard':
        $filename = 'card.txt';
        $list = $DB->query("SELECT * FROM `wcms_card` WHERE `type` = '0' and `active`= '0'  ")->fetchAll();
        $txt = '';
        foreach ($list as $res) {
            $txt .= $res['card'] . '-----' . $res['money'] . "元\r\n";
        }
        $file_size = strlen($txt);
        $result = array("code" => 1, "msg" => '获取成功', "data" => $txt);
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/3/2 15:25
     * description:TODO 获取自带项目存放地址
     */
    case 'getOriginalPro':
        $originalPro = \app\Admin::getOriginalPro();
        $result = array("code" => 1, "msg" => '获取成功', "data" => "<code>系统自带项目存放地址: <a href='$originalPro' target='_blank'>$originalPro</a> </code>");
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/3/2 15:25
     * description:TODO 获取自带项目源地址
     */
    case 'getLastPath':
        $lastPath = \app\Admin::getLastPath();
        if ($lastPath) {
            $result = array("code" => 1, "msg" => '获取成功', "getLastPath" => $lastPath, "getLastPathTip" => "如一键替换完成后无法使用，可切换回系统自带项目源地址");
        } else {
            $result = array("code" => 1, "msg" => '数据未获取到', "getLastPath" => "暂未获取到", "getLastPathTip" => "系统自带项目源地址");
        }
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/3/2 18:57
     * description:TODO 添加项目分类
     */
    case 'addProType':
        $name = trim(strip_tags(daddslashes($_POST['name'])));
        if (!$name) {
            $result = array("code" => -1, "msg" => "分类不得为空,请补充完整");
            exit(json_encode($result));
        }
        $sql = $DB->exec("INSERT INTO `wcms_protype` (`name`) VALUES ('{$name}')");
        if ($sql) {
            saveLog($userrow['uid'], "添加项目分类- $name");
            $result = array("code" => 1, "msg" => "项目分类添加成功", "url" => "programType.php");
        } else {
            $result = array("code" => -1, "msg" => "项目分类添加失败,请稍后再试");
        }
        exit(json_encode($result));
        break;

    /**
     * author: 1617643@qq.com
     * time:2020/3/2 18:57
     * description:TODO 修改项目分类
     */
    case 'editProType':
        $id = trim(strip_tags(daddslashes($_POST['id'])));
        $name = trim(strip_tags(daddslashes($_POST['name'])));
        if ($name == null) {
            $result = array("code" => -1, "msg" => "分类不得为空,请补充完整");
            exit(json_encode($result));
        }
        $sql = $DB->exec("UPDATE `wcms_protype` SET `name` ='{$name}' WHERE `id`='{$id}'");
        saveLog($userrow['uid'], "修改项目分类- $name");
        $result = array("code" => 1, "msg" => "项目分类修改成功", "url" => "programType.php");
        exit(json_encode($result));
        break;


    /**
     * author: 1617643@qq.com
     * time:2020/3/2 18:57
     * description:TODO 删除项目分类
     */
    case 'delProType':
        $id = trim(strip_tags(daddslashes($_POST['id'])));
        if ($id == 10000) {
            $result = array("code" => -1, "msg" => "默认分类不可删除");
            exit(json_encode($result));
        }
        if ($art = $DB->query("select * from `wcms_protype` where `id`='{$id}' limit 1")->fetch()) {
            $flag = $DB->exec("DELETE FROM `wcms_protype` WHERE `id`='{$id}'");
            if ($flag) {
                $name = $type['name'];
                saveLog($userrow['uid'], "删除项目分类- $name");
                $result = array("code" => 1, "msg" => "删除成功");
            }
        } else {
            $result = array("code" => -1, "msg" => "项目分类删除失败,请稍后再试");
        }
        exit(json_encode($result));
        break;


    default:

        $result = array("code" => -1, "msg" => "服务器错误");
        exit(json_encode($result));
        break;


}

?>