<?php
// +----------------------------------------------------------------------
// | Quotes [未来可期]
// +----------------------------------------------------------------------
// +----------------------------------------------------------------------
// | Author: 自助建站系统 https://www.kancloud.cn/btwcms-com/btwcms/2265967 作者QQ：1617643
// +----------------------------------------------------------------------
// | Date: 2020年2月5日
// +----------------------------------------------------------------------
include('header.php');

$numrows=$DB->query("SELECT * from `wcms_server` WHERE 1")->rowCount();
$list=$DB->query("SELECT * FROM `wcms_server` WHERE 1 order by `sid` asc")->fetchAll();

$sid = intval(daddslashes($_GET['sid']));
$type = daddslashes($_GET['type']);

if ($type == 'edit' && $sid) {
    $row = $DB->query("SELECT * from `wcms_server` WHERE `sid`={$sid} limit 1")->fetch();
    $title = '修改服务器';
    $result = 1;
} else if ($type == 'add') {
    $title = '添加服务器';
    $result = 2;
} else if ($type == 'serverAnalytics' && $sid) {
    $row = $DB->query("SELECT * from `wcms_server` WHERE `sid`={$sid} limit 1")->fetch();
    $Bt  = new \app\Bt('http://'.$row['api'],$row['pass']);
    $Logs = $Bt->GetLogs();
    $list = $Logs['data'];
    $system = $Bt->GetSystemTotal();
    $title = '服务器分析报告';
    $result = 5;

} else {
    $result = 3;
}
?>
<?php if($result == 5){?>
<div class="page-content">
    <div class="container-fluid">
        <!-- Page-Title -->
        <div class="row">
            <div class="col-sm-12">
                <div class="page-title-box">
                    <div class="float-right">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">服务器列表</a></li>
                            <li class="breadcrumb-item active"><?php echo $title;?></li>
                        </ol>
                    </div>
                    <h4 class="page-title"><?php echo $title;?></h4>
                </div><!--end page-title-box-->
            </div><!--end col-->
        </div>
        <!-- end page title end breadcrumb -->

        <div class="row justify-content-center">
            <div class="col-md-3">
                <div class="card report-card">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="dripicons-thumbs-up report-main-icon"></i>
                        </div>
                        <span class="badge badge-danger">宝塔面板版本</span>
                        <h3 class="my-3"><?php echo $system['version']?></h3>
                    </div><!--end card-body-->
                </div><!--end card-->
            </div> <!--end col-->
            <div class="col-md-3">
                <div class="card report-card">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="dripicons-clock report-main-icon"></i>
                        </div>
                        <span class="badge badge-secondary">面板运行时间</span>
                        <h4 class="my-3"><?php echo $system['time']?></h4>
                    </div><!--end card-body-->
                </div><!--end card-->
            </div> <!--end col-->
            <div class="col-md-3">
                <div class="card report-card">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="dripicons-meter report-main-icon"></i>
                        </div>
                        <span class="badge badge-warning">CPU使用率</span>
                        <h3 class="my-3"><?php echo $system['cpuRealUsed']?>%</h3>
                    </div><!--end card-body-->
                </div><!--end card-->
            </div> <!--end col-->
            <div class="col-md-3">
                <div class="card report-card">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="dripicons-wallet report-main-icon"></i>
                        </div>
                        <span class="badge badge-success">内存使用率</span>
                        <h3 class="my-3"><?php echo round($system['memRealUsed']/$system['memTotal'],3)*100;?>%</h3>
                    </div><!--end card-body-->
                </div><!--end card-->
            </div> <!--end col-->
        </div><!--end row-->



        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="mt-0 header-title">宝塔面板操作记录</h4>
                        <table id="datatable" class="table table-bordered dt-responsive " style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                            <tr>
                                <th >操作类型</th>
                                <th >操作时间</th>
                                <th >用户</th>
                                <th>详情</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($list as $res) {
                                $res['username'] = substr($res['username'],0,1).'***';
                                echo '
                                    <tr id="' . $res['id'] . '">
                                        <td nowrap>' . $res['type'] . '</td>
                                        <td nowrap>' . $res['addtime'] . '</td>
                                        <td nowrap>' . $res['username'] . '</td>
                                        <td>' . $res['log'] . '</td>
                                        
                                    </tr>   
                                 ';
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div> <!-- end col -->
        </div> <!-- end row -->


    </div><!-- container -->

<?php }else if ($result == 3){ ?>
<!-- Page Content-->
<div class="page-content">
    <div class="container-fluid">
        <!-- Page-Title -->
        <div class="row">
            <div class="col-sm-12">
                <div class="page-title-box">
                    <div class="float-right">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">管理模块</a></li>
                            <li class="breadcrumb-item active">服务器列表</li>
                        </ol>
                    </div>
                    <h4 class="page-title">管理模块</h4>
                </div><!--end page-title-box-->
            </div><!--end col-->
        </div>
        <!-- end page title end breadcrumb -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="mt-0 header-title">服务器列表</h4>

                        <div class="float-right">
                            <a href="?type=add" class="btn m-b-xs btn-sm btn-success btn-addon">
                                <i class="typcn typcn-th-large-outline "></i> 添加服务器
                            </a>
                        </div>
                        <p class="text-muted mb-4 font-13">
                            系统共有 <code><?php echo $numrows?></code> 台服务器
                        </p>
                        
                        <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                            <tr>
                                <th>编号</th>
                                <th>服务器名称</th>
                                <th>宝塔管理地址</th>
                                <th>默认域名</th>
                                <th>是否启用</th>
                                <th>操作</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($list as $res) {
                                if($res['active']==1){
                                    $serveractive="<span style='color:green;'>启用中</span>";
                                }elseif($res['active']==0){
                                    $serveractive="<span style='color:red;'>暂停中</span>";
                                }
                                  echo '
                                    <tr id="' . $res['sid'] . '">
                                        <td>' . $res['sid'] . '</td>
                                        <td>' . $res['sname'] . '</td>
                                        <td>' . $res['api'] . '</td>
                                        <td>' . $res['domain'] . '</td>
                                        <td>' . $serveractive . '</td>
                                        <td>
                                        <a id="checkServerBtn" href="javascript:void(0);" onclick="checkServer(' . $res['sid'] . ')" class="btn m-b-xs btn-sm btn-success btn-addon" >检测状态</a>
                                          <a href="server.php?type=edit&sid=' . $res['sid'] . '" class="btn m-b-xs btn-sm btn-primary btn-addon" >修改</a>
                                          <a href="javascript:void(0);" onclick="delServer(' . $res['sid'] . ')" class="btn m-b-xs btn-sm btn-danger btn-addon" >删除</a>
                                        </td>
                                    </tr>   
                                 ';
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div> <!-- end col -->
        </div> <!-- end row -->

    </div><!-- container -->

    <?php } else if ($result == 2){ ?>
    <!-- Page Content-->
    <div class="page-content">
        <div class="container-fluid">
            <!-- Page-Title -->
            <div class="row">
                <div class="col-sm-12">
                    <div class="page-title-box">
                        <div class="float-right">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">管理模块</a></li>
                                <li class="breadcrumb-item active"><?php echo $title ?></li>
                            </ol>
                        </div>
                        <h4 class="page-title">管理模块</h4>
                    </div><!--end page-title-box-->
                </div><!--end col-->
            </div>
            <!-- end page title end breadcrumb -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="mt-0 header-title"><?php echo $title ?></h4>
                            <p class="text-muted mb-3">userAdd.
                            </p>
                            <form action="#" method="post">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">服务器名称</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="sname">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">宝塔面板管理地址</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="api" placeholder="例如: 192.168.1.1:8888">
                                                <pre ><font color="#006400">不需要带http:// 且端口号后面字符也不需要带</font></pre>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">宝塔API密钥</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="pass" placeholder="宝塔面板->面板设置中查看">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">绑定域名</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="domain" placeholder="泛解析到服务器IP">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-2 col-form-label text-left">是否允许绑定服务器域名</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" id="ok_domain">
                                                    <option value="1">允许</option>
                                                    <option value="0">不允许</option>
                                                </select>
                                                <pre><font color="#006400">用户建站后可自定义绑定域名,请设置是否允许绑定服务器域名</font></pre>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">网站存放路径</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="sitepath">
                                                <pre><font color="#006400">默认请填写/www/wwwroot/</font></pre>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-2 col-form-label text-left">是否启用</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" id="active">
                                                    <option value="1">启用</option>
                                                    <option value="0">禁用</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div><!--end card-body-->
                                <div class="row">
                                    <div class="col-sm-10 ml-auto">
                                        <button type="button" class="btn btn-primary" id="addServer">保存数据</button>
                                    </div>
                                </div>
                            </form>
                        </div><!--end card-->
                    </div><!--end col-->
                </div><!--end row-->
            </div><!--end row-->
        </div><!-- container -->
        <?php } else if ($result == 1){ ?>
        <!-- Page Content-->
        <div class="page-content">
            <div class="container-fluid">
                <!-- Page-Title -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box">
                            <div class="float-right">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="javascript:void(0);">管理模块</a></li>
                                    <li class="breadcrumb-item active"><?php echo $title ?></li>
                                </ol>
                            </div>
                            <h4 class="page-title">管理模块</h4>
                        </div><!--end page-title-box-->
                    </div><!--end col-->
                </div>
                <!-- end page title end breadcrumb -->
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="mt-0 header-title"><?php echo $title ?></h4>
                                <p class="text-muted mb-3">userEdit.
                                </p>
                                <form action="#" method="post">
                                    <input class="form-control" type="hidden" name="sid" value="<?php echo $row['sid']?>">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group row">
                                                <label for="example-text-input"
                                                       class="col-sm-2 col-form-label text-left">服务器名称</label>
                                                <div class="col-sm-10">
                                                    <input class="form-control" type="text" name="sname" value="<?php echo $row['sname']?>">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="example-text-input"
                                                       class="col-sm-2 col-form-label text-left">宝塔面板管理地址</label>
                                                <div class="col-sm-10">
                                                    <input class="form-control" type="text" name="api" value="<?php echo $row['api']?>">
                                                    <pre ><font color="#006400">不需要带http://</font></pre>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="example-text-input"
                                                       class="col-sm-2 col-form-label text-left">宝塔API密钥</label>
                                                <div class="col-sm-10">
                                                    <input class="form-control" type="text" name="pass" value="<?php echo $row['pass']?>">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="example-text-input"
                                                       class="col-sm-2 col-form-label text-left">绑定域名</label>
                                                <div class="col-sm-10">
                                                    <input class="form-control" type="text" name="domain" value="<?php echo $row['domain']?>">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-sm-2 col-form-label text-left">是否允许绑定服务器域名</label>
                                                <div class="col-sm-10">
                                                    <select class="custom-select" id="ok_domain">
                                                        <?php if ($row['ok_domain'] == 0) { ?>
                                                            <option value="0" >不允许</option>
                                                            <option value="1">允许</option>
                                                        <?php } else { ?>
                                                            <option value="1">允许</option>
                                                            <option value="0">不允许</option>
                                                        <?php } ?>
                                                    </select>
                                                    <pre><font color="#006400">用户建站后可自定义绑定域名,请设置是否允许绑定服务器域名</font></pre>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="example-text-input"
                                                       class="col-sm-2 col-form-label text-left">网站存放路径</label>
                                                <div class="col-sm-10">
                                                    <input class="form-control" type="text" name="sitepath" value="<?php echo $row['sitepath']?>">
                                                    <pre><font color="#006400">默认请填写:/www/wwwroot/</font></pre>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-sm-2 col-form-label text-left">是否启用</label>
                                                <div class="col-sm-10">
                                                    <select class="custom-select" id="active">
                                                        <?php if ($row['active'] == 0) { ?>
                                                            <option value="0" >禁用</option>
                                                            <option value="1">启用</option>
                                                        <?php } else { ?>
                                                            <option value="1">启用</option>
                                                            <option value="0">禁用</option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!--end card-body-->
                                    <div class="row">
                                        <div class="col-sm-10 ml-auto">
                                            <button type="button" class="btn btn-primary" id="editServer">保存数据</button>
                                        </div>
                                    </div>
                                </form>
                            </div><!--end card-->
                        </div><!--end col-->
                    </div><!--end row-->
                </div><!--end row-->
            </div><!-- container -->
            <?php } ?>

            <?php
            include('footer.php');
            ?>
            <script>
                function delServer(sid) {
                    layer.confirm('确认删除 ' + sid + ' 吗?', {
                        btn: ['是', '否'], btn1: function () {
                            $.ajax({
                                url: './ajax.php?act=delServer',
                                type: 'POST',
                                dataType: 'json',
                                data: { sid: sid },
                                success: function (data) {
                                    if (data.code == 1) {
                                        layer.msg(data.msg, { icon: 1, time: 2000, shade: 0.4 }, function () {
                                            var del="#"+sid;
                                            $(del).remove();
                                        });
                                    } else {
                                        layer.msg(data.msg, { icon: 2, time: 2000, shade: 0.4 });
                                    }
                                },
                                error:function () {
                                    layer.alert("网络连接错误");
                                }
                            });
                        }
                    });
                }

                $("#editServer").click(function () {
                    var ii = layer.load(0, {shade: false,time: 35000}); //0代表加载的风格，支持0-2
                    $.ajax({
                        url: 'ajax.php?act=editServer',
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            sid: $("input[name='sid']").val(),
                            sname: $("input[name='sname']").val(),
                            api: $("input[name='api']").val(),
                            pass: $("input[name='pass']").val(),
                            domain: $("input[name='domain']").val(),
                            sitepath: $("input[name='sitepath']").val(),
                            ok_domain: $("#ok_domain").val(),
                            active: $("#active").val()
                        },
                        success: function (data) {
                            layer.close(ii);
                            if (data.code == 1) {
                                layer.msg(data.msg, { icon: 1, time: 1000, shade: 0.4 }, function () {
                                    location.href = data.url;
                                });
                            }else {
                                layer.msg(data.msg, {icon: 2, time: 2000, shade: 0.4});
                            }
                        },
                        error:function () {
                            layer.close(ii);
                            layer.alert("网络连接错误");
                        }
                    })
                })


                $("#addServer").click(function () {
                    var oneClick=document.getElementById("addServer");
                    var resultClick = oneClick.getAttribute("disabled");
                    if(null != resultClick && 'false'== resultClick){
                        return false;
                    }
                    oneClick.setAttribute("disabled","false");
                    var ii = layer.load(0, {shade: false,time: 35000}); //0代表加载的风格，支持0-2
                    $.ajax({
                        url: 'ajax.php?act=addServer',
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            sname: $("input[name='sname']").val(),
                            port: $("input[name='port']").val(),
                            api: $("input[name='api']").val(),
                            pass: $("input[name='pass']").val(),
                            domain: $("input[name='domain']").val(),
                            sitepath: $("input[name='sitepath']").val(),
                            ok_domain: $("#ok_domain").val(),
                            active: $("#active").val()
                        },
                        success: function (data) {
                            oneClick.removeAttribute("disabled");
                            layer.close(ii);
                            if(data.code == 1) {
                                layer.msg(data.msg, { icon: 1, time: 1000, shade: 0.4 }, function () {
                                    location.href = data.url;
                                });
                            }else{
                                layer.msg(data.msg, {icon: 2, time: 2000, shade: 0.4});
                            }
                        },
                        error:function () {
                            oneClick.removeAttribute("disabled");
                            layer.close(ii);
                            layer.alert("网络异常");
                        }
                    })
                })

                function checkServer(sid){
                    var ii = layer.load(0, {shade: false,time: 35000}); //0代表加载的风格，支持0-2
                    $.ajax({
                        url: "ajax.php?act=checkServer",
                        type: 'POST',
                        dataType: 'json',
                        data: {sid: sid},
                        success: function (data) {
                            layer.close(ii);
                            if (data.code == 1) {

                                var down = layer.confirm(data.msg + "<br>是否查看服务器报告", {
                                        btn: ['查看','取消'],closeBtn:0,icon:1,
                                        title: '检测服务器状态'
                                    }, function() {
                                    window.location.href = '?type=serverAnalytics&sid='+sid;
                                    layer.close(down);
                                });

                            }else {
                                layer.msg(data.msg, { icon: 2, time: 2000, shade: 0.4 });
                            }
                        },
                        error:function () {
                            layer.close(ii);
                            layer.alert("网络连接错误!");
                        }
                    });
                }
            </script>
