<?php 
use Helper\Common;
define('PATH_SYS', '../System/');
define('QCMS_VERSION', '5.0.2');
require '../Lib/Helper/Common.php';
$CommonObj = Common::get_instance();
?>
<!DOCTYPE html>
<html lang="zh-cn">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1.0, user-scalable=no">
    <title>QCMS <?=QCMS_VERSION?>系统安装</title>
    <!-- Bootstrap -->
    <link href="../Static/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="../Static/bootstrap/css/bootstrap_common.css" rel="stylesheet">
    <script src="../Static/bootstrap/js/jquery-3.3.1.min.js"></script>
    <script src="../Static/bootstrap/js/bootstrap.min.js"></script>
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="http://cdn.bootcss.com/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script src="http://cdn.bootcss.com/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->
	<style>
	.form-check-inline{
    font-size: 1.4rem;
   
  }
  body{
    margin: auto;
  }
	</style>
  </head>
  <body style="margin-top:100px;width:360px;">   
  
  <?php
  if(!empty($_POST)){
    if(empty($_POST['SqlType'])) $CommonObj->Err('缺少参数');
    if($_POST['SqlType'] != 'SQLite'){
      if(empty($_POST['Host']) || empty($_POST['DbName']) || empty($_POST['DbAcount']) || empty($_POST['DbPassword'])){
        $CommonObj->Err('缺少参数');
      }
      try{
      @new PDO('mysql:dbname='.$_POST['DbName'].';host='.$_POST['Host'].'', $_POST['DbAcount'], $_POST['DbPassword'], 
          array(PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION));
      }catch (Exception $e){
          $Msg = $e->getMessage();
          if(strpos($Msg, '2002') !== false) $CommonObj->Err('连接数据库失败');
          if(strpos($Msg, '1049') !== false) $CommonObj->Err('数据库不存在');
          $CommonObj->Err("数据库连接失败，请确认数据库帐号密码正确");
      }
    }
	
	$dataPath = '../Database/qcms5.sql';
	$configPath = '../Lib/Config/Config.php';
  //unlink($configPath);
	$configPathTemp = '../Lib/Config/Config_bak.php';
	
	if(file_exists($configPath)){
    $CommonObj->Err('数据库配置文件存在，请删除Lib/Config/Config.php');
	}
	$dataTemp = file_get_contents($configPathTemp);
  $SearchArr = $ReplaceArr = array();
  if($_POST['SqlType'] == 'SQLite'){
    $DbName = md5(uniqid (rand ( 100, 999 )));
    copy('../Database/qcms5.db','../Lib/Config/'.$DbName.'.db');
    $SearchArr = array('{DbName}', '{SqlType}');
    $ReplaceArr = array($DbName, $_POST['SqlType']);
  } else{
    $SearchArr = array('{Host}', '{DbName}', '{DbAcount}', '{DbPassword}', '{SqlType}');
    $ReplaceArr = array($_POST['Host'], $_POST['DbName'], $_POST['DbAcount'], $_POST['DbPassword'], $_POST['SqlType']);
  } 
	$configFileData = str_replace($SearchArr, $ReplaceArr, $dataTemp);
	$access = @file_put_contents($configPath, $configFileData);
	if(!$access){
    $CommonObj->Err('请确保Lib/Config/目录有可写权限');
	}
  $result = true;
  if($_POST['SqlType'] != 'SQLite'){
    require '../Lib/Config/Config.php';
    $configArr = db_config();
    try{
        $dataObj = new PDO('mysql:dbname='.$configArr['Name'].';host='.$configArr['Host'].'', $configArr['Accounts'], $configArr['Password'], 
            array(PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION));
            $dataObj->exec("SET NAMES ".$configArr['Charset']);
    }catch (PDOException $e){
        echo 'Connection failed: ' . $e->getMessage();exit();
    }
    $result = importData($configArr, $dataObj, $dataPath);
  }	
	if($result){
    ?>
    <div class="container">
      <div class="text-center">
    <img src="/Static/images/Inlogo.svg" class="mb-3" alt="QCMS" width="108px;" >
      <div class="mb-4 font-weight-normal">V<?=QCMS_VERSION?> 安装成功</div>
    </div>
    <ul class="list-group list-group-flush text-center">
      <li class="list-group-item">前台地址：<a href="../" target="_blank">立即访问</a></li>
      <li class="list-group-item">后台地址：<a href="../index/login" target="_blank">立即访问</a></li>
      <li class="list-group-item">管理员账号：18888888888</li>
      <li class="list-group-item">管理员密码：123456</li>
    </ul>
    </div>
    <?
		exit;
	}
}else{
?>
<div class="container">
      <form class="form-signin text-center" method="post" id="InstallForm">
      <img src="/Static/images/Inlogo.svg" class="mb-3" alt="QCMS" width="108px;" >
      <div class="mb-4 font-weight-normal">V<?=QCMS_VERSION?> 系统安装</div>
      <div class="form-check form-check-inline">
        <input class="form-check-input SqlTypeRadio" type="radio" name="SqlType" id="InputSQLite" value="SQLite" checked="checked">
        <label class="form-check-label" for="InputSQLite">SQLite</label>
      </div>
      <div class="form-check form-check-inline mb-3" >
        <input class="form-check-input SqlTypeRadio" type="radio" name="SqlType" id="InputMysql" value="Mysql">
        <label class="form-check-label" for="InputMysql">Mysql</label>
      </div>
      <div id="MysqlView" style="display: none">
      <label for="InputHost" class="sr-only">服务器IP</label>
      <input type="text" name="Host" id="InputHost" class="form-control" placeholder="服务器IP" required autofocus>
      <label for="InputDbName" class="sr-only">数据库名</label>
      <input type="text" name="DbName" id="InputDbName" class="form-control" placeholder="数据库名" required>
      <label for="InputDbAcount" class="sr-only">数据库帐号</label>
      <input type="text" name="DbAcount" id="InputDbAcount" class="form-control" placeholder="数据库帐号" required>
      <label for="InputDbPassword" class="sr-only">数据库密码</label>
      <input type="text" name="DbPassword" id="InputDbPassword" class="form-control" placeholder="数据库密码" required>
      </div>
      <div class="input-group mb-3">
        <button class="btn btn-primary btn-block" type="button" id="SubmitBut">现在就试用！</button>
      </div>
     
      <p class="mt-5 mb-3 text-muted" style="text-align: center;">技术支持 : <a href="http://www.q-cms.cn/" target="_blabk">QCMS</a></p>
    </form>
    </div>
	<?php
}
	?>
<div class="d-none"><script type="text/javascript">document.write(unescape("%3Cspan id='cnzz_stat_icon_1707573'%3E%3C/span%3E%3Cscript src='https://s4.cnzz.com/stat.php%3Fid%3D1707573' type='text/javascript'%3E%3C/script%3E"));</script></div>
  <script type="text/javascript">
  var ScanArr = {
    'Version' : '检测PHP版本',
    'Permission' : '检测配置文件目录可写权限', 
    'UploadPermission' : '检测文件上传目录可写权限', 
    'Config' : '检测配置文件是否存在', 
    'Shortag' : '检测shor_open_tag是否打开',
    'Curl' : '检测是否支持CURl',
    'Mysql' : '检测是否支持PdoMysql',
    'SQLite' : '检测是否支持PdoSQLite',
  };
  $(function(){
  	$('#SubmitBut').click(function(){
      let SqlType = $("input[name='SqlType']:checked").val();
      if(SqlType == 'SQLite') {
        $('#InstallForm').submit();
        return  true;
      }
  		if($('#InputHost').val() == ""){
  			checkAlert('服务器IP不能为空');
  			$('#InputHost').focus();
  			return false;
  		}
  		if($('#InputDbName').val() == ""){
  			checkAlert('数据库不能为空');
  			$('#InputDbName').focus();
  			return false;
  		}
  		if($('#InputDbAcount').val() == ""){
  			checkAlert('帐号不能为空');
  			$('#InputDbAcount').focus();
  			return false;
  		}
  		if($('#InputDbPassword').val() == ""){
  			checkAlert('密码不能为空');
  			$('#InputDbPassword').focus();
  			return false;
  		}
      let ScanRet = true;
      $.each(ScanArr, function(k, v){
        if(checkSys(k) == 0){
          alert(v+':失败 !');
          ScanRet = false;
          return false;
        }
      })
      if(ScanRet) $('#InstallForm').submit();
  		
  		return true;
  	})
    $('.SqlTypeRadio').click(SqlInstallView)
  })

  var checkSys = function(act){
  	return $.ajax({
  	   type: "GET",
  	   url: 'detect.php?act='+act,
  	   data: '',
  	   async: false
  	}).responseText;
  }

  var checkAlert = function(str){
    alert(str);
  	/*$('#alertMsg').css('display', 'block');
  	$('#alertMsg').html(str);*/
  }
  var SqlInstallView = function(){
    let SqlType = $("input[name='SqlType']:checked").val();
    if(SqlType == 'SQLite'){
      $('#MysqlView').hide();
    }else{
      $('#MysqlView').show();
    }
  }
  </script>
  </body></html>

<?php 
	function importData($configArr, $dataObj, $dataPath){
		$result = file($dataPath);
		$query = '';
    try{
		foreach($result as $key => $value){
			$value=trim($value); 
			if(empty($value) || $value[0]=='#' || $value[0]=='-' || $key == 0) continue;
      //var_dump($value);continue;
			if(preg_match("/\;$/i",$value)){
				$query.=$value;
				if(preg_match("/^CREATE/i",$query)){
					$extra = substr(strrchr($query,')'),1);
					$query = str_replace($extra,'',$query);
					$extra = "ENGINE=InnoDB DEFAULT CHARSET=utf8;";
					$query .= $extra;
				}elseif(preg_match("/^INSERT/i",$query)){
					$query='REPLACE '.substr($query,6);
				}
				//$query = str_replace('{qcms}_', $configArr['Prefix'], $query);
				
				$rs = $dataObj->exec($query);
				$query='';
			}else{
				$query.= $value;
			}
		
		}
  }catch (PDOException $e){
      echo 'Connection failed: ' . $e->getMessage();exit();
  }
		return true;
	}
	

