/*
 Highcharts JS v7.1.1 (2019-04-09)

 Highstock as a plugin for Highcharts

 (c) 2010-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(q){"object"===typeof module&&module.exports?(q["default"]=q,module.exports=q):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(B){q(B);q.Highcharts=B;return q}):q("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(q){function B(c,E,r,q){c.hasOwnProperty(E)||(c[E]=q.apply(null,r))}q=q?q._modules:{};B(q,"parts/Scrollbar.js",[q["parts/Globals.js"]],function(c){function E(b,k,v){this.init(b,k,v)}var r=c.addEvent,q=c.Axis,u=c.correctFloat,
z=c.defaultOptions,A=c.defined,x=c.destroyObjectProperties,D=c.fireEvent,C=c.hasTouch,l=c.merge,g=c.pick,t=c.removeEvent,p,d={height:c.isTouchDevice?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:1,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"#333333",trackBackgroundColor:"#f2f2f2",trackBorderColor:"#f2f2f2",
trackBorderWidth:1};z.scrollbar=l(!0,d,z.scrollbar);c.swapXY=p=function(b,k){var v=b.length,a;if(k)for(k=0;k<v;k+=3)a=b[k+1],b[k+1]=b[k+2],b[k+2]=a;return b};E.prototype={init:function(b,k,v){this.scrollbarButtons=[];this.renderer=b;this.userOptions=k;this.options=l(d,k);this.chart=v;this.size=g(this.options.size,this.options.height);k.enabled&&(this.render(),this.initEvents(),this.addEvents())},render:function(){var b=this.renderer,k=this.options,v=this.size,a=this.chart.styledMode,n;this.group=
n=b.g("scrollbar").attr({zIndex:k.zIndex,translateY:-99999}).add();this.track=b.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:k.trackBorderRadius||0,height:v,width:v}).add(n);a||this.track.attr({fill:k.trackBackgroundColor,stroke:k.trackBorderColor,"stroke-width":k.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=b.g().add(n);this.scrollbar=b.rect().addClass("highcharts-scrollbar-thumb").attr({height:v,
width:v,r:k.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=b.path(p(["M",-3,v/4,"L",-3,2*v/3,"M",0,v/4,"L",0,2*v/3,"M",3,v/4,"L",3,2*v/3],k.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);a||(this.scrollbar.attr({fill:k.barBackgroundColor,stroke:k.barBorderColor,"stroke-width":k.barBorderWidth}),this.scrollbarRifles.attr({stroke:k.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%
2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)},position:function(b,k,v,a){var n=this.options.vertical,m=0,d=this.rendered?"animate":"attr";this.x=b;this.y=k+this.trackBorderWidth;this.width=v;this.xOffset=this.height=a;this.yOffset=m;n?(this.width=this.yOffset=v=m=this.size,this.xOffset=k=0,this.barWidth=a-2*v,this.x=b+=this.options.margin):(this.height=this.xOffset=a=k=this.size,this.barWidth=v-2*a,this.y+=this.options.margin);this.group[d]({translateX:b,
translateY:this.y});this.track[d]({width:v,height:a});this.scrollbarButtons[1][d]({translateX:n?0:v-k,translateY:n?a-m:0})},drawScrollbarButton:function(b){var k=this.renderer,d=this.scrollbarButtons,a=this.options,n=this.size,m;m=k.g().add(this.group);d.push(m);m=k.rect().addClass("highcharts-scrollbar-button").add(m);this.chart.styledMode||m.attr({stroke:a.buttonBorderColor,"stroke-width":a.buttonBorderWidth,fill:a.buttonBackgroundColor});m.attr(m.crisp({x:-.5,y:-.5,width:n+1,height:n+1,r:a.buttonBorderRadius},
m.strokeWidth()));m=k.path(p(["M",n/2+(b?-1:1),n/2-3,"L",n/2+(b?-1:1),n/2+3,"L",n/2+(b?2:-2),n/2],a.vertical)).addClass("highcharts-scrollbar-arrow").add(d[b]);this.chart.styledMode||m.attr({fill:a.buttonArrowColor})},setRange:function(b,k){var d=this.options,a=d.vertical,n=d.minWidth,m=this.barWidth,c,h,e=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";A(m)&&(b=Math.max(b,0),c=Math.ceil(m*b),this.calculatedWidth=h=u(m*Math.min(k,1)-c),h<n&&
(c=(m-n+h)*b,h=n),n=Math.floor(c+this.xOffset+this.yOffset),m=h/2-.5,this.from=b,this.to=k,a?(this.scrollbarGroup[e]({translateY:n}),this.scrollbar[e]({height:h}),this.scrollbarRifles[e]({translateY:m}),this.scrollbarTop=n,this.scrollbarLeft=0):(this.scrollbarGroup[e]({translateX:n}),this.scrollbar[e]({width:h}),this.scrollbarRifles[e]({translateX:m}),this.scrollbarLeft=n,this.scrollbarTop=0),12>=h?this.scrollbarRifles.hide():this.scrollbarRifles.show(!0),!1===d.showFull&&(0>=b&&1<=k?this.group.hide():
this.group.show()),this.rendered=!0)},initEvents:function(){var b=this;b.mouseMoveHandler=function(k){var d=b.chart.pointer.normalize(k),a=b.options.vertical?"chartY":"chartX",n=b.initPositions;!b.grabbedCenter||k.touches&&0===k.touches[0][a]||(d=b.cursorToScrollbarPosition(d)[a],a=b[a],a=d-a,b.hasDragged=!0,b.updatePosition(n[0]+a,n[1]+a),b.hasDragged&&D(b,"changed",{from:b.from,to:b.to,trigger:"scrollbar",DOMType:k.type,DOMEvent:k}))};b.mouseUpHandler=function(k){b.hasDragged&&D(b,"changed",{from:b.from,
to:b.to,trigger:"scrollbar",DOMType:k.type,DOMEvent:k});b.grabbedCenter=b.hasDragged=b.chartX=b.chartY=null};b.mouseDownHandler=function(k){k=b.chart.pointer.normalize(k);k=b.cursorToScrollbarPosition(k);b.chartX=k.chartX;b.chartY=k.chartY;b.initPositions=[b.from,b.to];b.grabbedCenter=!0};b.buttonToMinClick=function(k){var d=u(b.to-b.from)*b.options.step;b.updatePosition(u(b.from-d),u(b.to-d));D(b,"changed",{from:b.from,to:b.to,trigger:"scrollbar",DOMEvent:k})};b.buttonToMaxClick=function(k){var d=
(b.to-b.from)*b.options.step;b.updatePosition(b.from+d,b.to+d);D(b,"changed",{from:b.from,to:b.to,trigger:"scrollbar",DOMEvent:k})};b.trackClick=function(k){var d=b.chart.pointer.normalize(k),a=b.to-b.from,n=b.y+b.scrollbarTop,m=b.x+b.scrollbarLeft;b.options.vertical&&d.chartY>n||!b.options.vertical&&d.chartX>m?b.updatePosition(b.from+a,b.to+a):b.updatePosition(b.from-a,b.to-a);D(b,"changed",{from:b.from,to:b.to,trigger:"scrollbar",DOMEvent:k})}},cursorToScrollbarPosition:function(b){var k=this.options,
k=k.minWidth>this.calculatedWidth?k.minWidth:0;return{chartX:(b.chartX-this.x-this.xOffset)/(this.barWidth-k),chartY:(b.chartY-this.y-this.yOffset)/(this.barWidth-k)}},updatePosition:function(b,k){1<k&&(b=u(1-u(k-b)),k=1);0>b&&(k=u(k-b),b=0);this.from=b;this.to=k},update:function(b){this.destroy();this.init(this.chart.renderer,l(!0,this.options,b),this.chart)},addEvents:function(){var b=this.options.inverted?[1,0]:[0,1],k=this.scrollbarButtons,d=this.scrollbarGroup.element,a=this.mouseDownHandler,
n=this.mouseMoveHandler,m=this.mouseUpHandler,b=[[k[b[0]].element,"click",this.buttonToMinClick],[k[b[1]].element,"click",this.buttonToMaxClick],[this.track.element,"click",this.trackClick],[d,"mousedown",a],[d.ownerDocument,"mousemove",n],[d.ownerDocument,"mouseup",m]];C&&b.push([d,"touchstart",a],[d.ownerDocument,"touchmove",n],[d.ownerDocument,"touchend",m]);b.forEach(function(b){r.apply(null,b)});this._events=b},removeEvents:function(){this._events.forEach(function(b){t.apply(null,b)});this._events.length=
0},destroy:function(){var b=this.chart.scroller;this.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(b){this[b]&&this[b].destroy&&(this[b]=this[b].destroy())},this);b&&this===b.scrollbar&&(b.scrollbar=null,x(b.scrollbarButtons))}};c.Scrollbar||(r(q,"afterInit",function(){var b=this;b.options&&b.options.scrollbar&&b.options.scrollbar.enabled&&(b.options.scrollbar.vertical=!b.horiz,b.options.startOnTick=b.options.endOnTick=!1,b.scrollbar=new E(b.chart.renderer,
b.options.scrollbar,b.chart),r(b.scrollbar,"changed",function(k){var d=Math.min(g(b.options.min,b.min),b.min,b.dataMin),a=Math.max(g(b.options.max,b.max),b.max,b.dataMax)-d,n;b.horiz&&!b.reversed||!b.horiz&&b.reversed?(n=d+a*this.to,d+=a*this.from):(n=d+a*(1-this.from),d+=a*(1-this.to));g(this.options.liveRedraw,c.svg&&!c.isTouchDevice&&!this.chart.isBoosting)||"mouseup"===k.DOMType||!A(k.DOMType)?b.setExtremes(d,n,!0,"mousemove"!==k.DOMType,k):this.setRange(this.from,this.to)}))}),r(q,"afterRender",
function(){var b=Math.min(g(this.options.min,this.min),this.min,g(this.dataMin,this.min)),k=Math.max(g(this.options.max,this.max),this.max,g(this.dataMax,this.max)),d=this.scrollbar,a=this.titleOffset||0;if(d){this.horiz?(d.position(this.left,this.top+this.height+2+this.chart.scrollbarsOffsets[1]+(this.opposite?0:a+this.axisTitleMargin+this.offset),this.width,this.height),a=1):(d.position(this.left+this.width+2+this.chart.scrollbarsOffsets[0]+(this.opposite?a+this.axisTitleMargin+this.offset:0),this.top,
this.width,this.height),a=0);if(!this.opposite&&!this.horiz||this.opposite&&this.horiz)this.chart.scrollbarsOffsets[a]+=this.scrollbar.size+this.scrollbar.options.margin;isNaN(b)||isNaN(k)||!A(this.min)||!A(this.max)?d.setRange(0,0):(a=(this.min-b)/(k-b),b=(this.max-b)/(k-b),this.horiz&&!this.reversed||!this.horiz&&this.reversed?d.setRange(a,b):d.setRange(1-b,1-a))}}),r(q,"afterGetOffset",function(){var b=this.horiz?2:1,d=this.scrollbar;d&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[b]+=
d.size+d.options.margin)}),c.Scrollbar=E)});B(q,"parts/Navigator.js",[q["parts/Globals.js"]],function(c){function E(h){this.init(h)}var r=c.addEvent,q=c.Axis,u=c.Chart,z=c.color,A=c.defaultOptions,x=c.defined,D=c.destroyObjectProperties,C=c.erase,l=c.extend,g=c.hasTouch,t=c.isArray,p=c.isNumber,d=c.isTouchDevice,b=c.merge,k=c.pick,v=c.removeEvent,a=c.Scrollbar,n=c.Series,m,w=function(h){var e=[].filter.call(arguments,p);if(e.length)return Math[h].apply(0,e)};m=void 0===c.seriesTypes.areaspline?"line":
"areaspline";l(A,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:z("#6685c2").setOpacity(.3).get(),outlineColor:"#cccccc",outlineWidth:1,series:{type:m,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,smoothed:!0,units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,
15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},pointRange:0,threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#999999"},x:3,y:-4},
crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});c.Renderer.prototype.symbols["navigator-handle"]=function(h,e,f,b,a){h=a.width/2;e=Math.round(h/3)+.5;a=a.height;return["M",-h-1,.5,"L",h,.5,"L",h,a+.5,"L",-h-1,a+.5,"L",-h-1,.5,"M",-e,4,"L",-e,a-3,"M",e-1,4,"L",e-1,a-3]};q.prototype.toFixedRange=function(h,e,f,b){var a=this.chart&&this.chart.fixedRange;
h=k(f,this.translate(h,!0,!this.horiz));e=k(b,this.translate(e,!0,!this.horiz));f=a&&(e-h)/a;.7<f&&1.3>f&&(b?h=e-a:e=h+a);p(h)&&p(e)||(h=e=void 0);return{min:h,max:e}};E.prototype={drawHandle:function(h,e,f,b){var a=this.navigatorOptions.handles.height;this.handles[e][b](f?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(h,10)+.5-a)}:{translateX:Math.round(this.left+parseInt(h,10)),translateY:Math.round(this.top+this.height/2-a/2-1)})},drawOutline:function(h,
e,f,b){var a=this.navigatorOptions.maskInside,y=this.outline.strokeWidth(),d=y/2,y=y%2/2,k=this.outlineHeight,m=this.scrollbarHeight,n=this.size,c=this.left-m,g=this.top;f?(c-=d,f=g+e+y,e=g+h+y,h=["M",c+k,g-m-y,"L",c+k,f,"L",c,f,"L",c,e,"L",c+k,e,"L",c+k,g+n+m].concat(a?["M",c+k,f-d,"L",c+k,e+d]:[])):(h+=c+m-y,e+=c+m-y,g+=d,h=["M",c,g,"L",h,g,"L",h,g+k,"L",e,g+k,"L",e,g,"L",c+n+2*m,g].concat(a?["M",h-d,g,"L",e+d,g]:[]));this.outline[b]({d:h})},drawMasks:function(h,e,f,b){var a=this.left,y=this.top,
d=this.height,k,m,n,c;f?(n=[a,a,a],c=[y,y+h,y+e],m=[d,d,d],k=[h,e-h,this.size-e]):(n=[a,a+h,a+e],c=[y,y,y],m=[h,e-h,this.size-e],k=[d,d,d]);this.shades.forEach(function(f,e){f[b]({x:n[e],y:c[e],width:m[e],height:k[e]})})},renderElements:function(){var h=this,e=h.navigatorOptions,f=e.maskInside,a=h.chart,b=a.renderer,d,k={cursor:a.inverted?"ns-resize":"ew-resize"};h.navigatorGroup=d=b.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!f,f,!f].forEach(function(f,y){h.shades[y]=b.rect().addClass("highcharts-navigator-mask"+
(1===y?"-inside":"-outside")).add(d);a.styledMode||h.shades[y].attr({fill:f?e.maskFill:"rgba(0,0,0,0)"}).css(1===y&&k)});h.outline=b.path().addClass("highcharts-navigator-outline").add(d);a.styledMode||h.outline.attr({"stroke-width":e.outlineWidth,stroke:e.outlineColor});e.handles.enabled&&[0,1].forEach(function(f){e.handles.inverted=a.inverted;h.handles[f]=b.symbol(e.handles.symbols[f],-e.handles.width/2-1,0,e.handles.width,e.handles.height,e.handles);h.handles[f].attr({zIndex:7-f}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+
["left","right"][f]).add(d);if(!a.styledMode){var y=e.handles;h.handles[f].attr({fill:y.backgroundColor,stroke:y.borderColor,"stroke-width":y.lineWidth}).css(k)}})},update:function(h){(this.series||[]).forEach(function(e){e.baseSeries&&delete e.baseSeries.navigatorSeries});this.destroy();b(!0,this.chart.options.navigator,this.options,h);this.init(this.chart)},render:function(h,e,f,a){var b=this.chart,y,d,m=this.scrollbarHeight,n,g=this.xAxis;y=g.fake?b.xAxis[0]:g;var l=this.navigatorEnabled,w,v=this.rendered;
d=b.inverted;var t,r=b.xAxis[0].minRange,u=b.xAxis[0].options.maxRange;if(!this.hasDragged||x(f)){if(!p(h)||!p(e))if(v)f=0,a=k(g.width,y.width);else return;this.left=k(g.left,b.plotLeft+m+(d?b.plotWidth:0));this.size=w=n=k(g.len,(d?b.plotHeight:b.plotWidth)-2*m);b=d?m:n+2*m;f=k(f,g.toPixels(h,!0));a=k(a,g.toPixels(e,!0));p(f)&&Infinity!==Math.abs(f)||(f=0,a=b);h=g.toValue(f,!0);e=g.toValue(a,!0);t=Math.abs(c.correctFloat(e-h));t<r?this.grabbedLeft?f=g.toPixels(e-r,!0):this.grabbedRight&&(a=g.toPixels(h+
r,!0)):x(u)&&t>u&&(this.grabbedLeft?f=g.toPixels(e-u,!0):this.grabbedRight&&(a=g.toPixels(h+u,!0)));this.zoomedMax=Math.min(Math.max(f,a,0),w);this.zoomedMin=Math.min(Math.max(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(f,a),0),w);this.range=this.zoomedMax-this.zoomedMin;w=Math.round(this.zoomedMax);f=Math.round(this.zoomedMin);l&&(this.navigatorGroup.attr({visibility:"visible"}),v=v&&!this.hasDragged?"animate":"attr",this.drawMasks(f,w,d,v),this.drawOutline(f,w,d,v),this.navigatorOptions.handles.enabled&&
(this.drawHandle(f,0,d,v),this.drawHandle(w,1,d,v)));this.scrollbar&&(d?(d=this.top-m,y=this.left-m+(l||!y.opposite?0:(y.titleOffset||0)+y.axisTitleMargin),m=n+2*m):(d=this.top+(l?this.height:-m),y=this.left-m),this.scrollbar.position(y,d,b,m),this.scrollbar.setRange(this.zoomedMin/(n||1),this.zoomedMax/(n||1)));this.rendered=!0}},addMouseEvents:function(){var h=this,e=h.chart,f=e.container,a=[],b,d;h.mouseMoveHandler=b=function(f){h.onMouseMove(f)};h.mouseUpHandler=d=function(f){h.onMouseUp(f)};
a=h.getPartsEvents("mousedown");a.push(r(f,"mousemove",b),r(f.ownerDocument,"mouseup",d));g&&(a.push(r(f,"touchmove",b),r(f.ownerDocument,"touchend",d)),a.concat(h.getPartsEvents("touchstart")));h.eventsToUnbind=a;h.series&&h.series[0]&&a.push(r(h.series[0].xAxis,"foundExtremes",function(){e.navigator.modifyNavigatorAxisExtremes()}))},getPartsEvents:function(h){var e=this,f=[];["shades","handles"].forEach(function(a){e[a].forEach(function(b,y){f.push(r(b.element,h,function(f){e[a+"Mousedown"](f,y)}))})});
return f},shadesMousedown:function(h,e){h=this.chart.pointer.normalize(h);var f=this.chart,a=this.xAxis,b=this.zoomedMin,d=this.left,k=this.size,m=this.range,n=h.chartX,c,g;f.inverted&&(n=h.chartY,d=this.top);1===e?(this.grabbedCenter=n,this.fixedWidth=m,this.dragOffset=n-b):(h=n-d-m/2,0===e?h=Math.max(0,h):2===e&&h+m>=k&&(h=k-m,this.reversedExtremes?(h-=m,g=this.getUnionExtremes().dataMin):c=this.getUnionExtremes().dataMax),h!==b&&(this.fixedWidth=m,e=a.toFixedRange(h,h+m,g,c),x(e.min)&&f.xAxis[0].setExtremes(Math.min(e.min,
e.max),Math.max(e.min,e.max),!0,null,{trigger:"navigator"})))},handlesMousedown:function(h,e){this.chart.pointer.normalize(h);h=this.chart;var f=h.xAxis[0],a=this.reversedExtremes;0===e?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=a?f.min:f.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=a?f.max:f.min);h.fixedRange=null},onMouseMove:function(h){var e=this,f=e.chart,a=e.left,b=e.navigatorSize,m=e.range,n=e.dragOffset,g=f.inverted;h.touches&&
0===h.touches[0].pageX||(h=f.pointer.normalize(h),f=h.chartX,g&&(a=e.top,f=h.chartY),e.grabbedLeft?(e.hasDragged=!0,e.render(0,0,f-a,e.otherHandlePos)):e.grabbedRight?(e.hasDragged=!0,e.render(0,0,e.otherHandlePos,f-a)):e.grabbedCenter&&(e.hasDragged=!0,f<n?f=n:f>b+n-m&&(f=b+n-m),e.render(0,0,f-n,f-n+m)),e.hasDragged&&e.scrollbar&&k(e.scrollbar.options.liveRedraw,c.svg&&!d&&!this.chart.isBoosting)&&(h.DOMType=h.type,setTimeout(function(){e.onMouseUp(h)},0)))},onMouseUp:function(a){var e=this.chart,
f=this.xAxis,h=this.scrollbar,b,d,m=a.DOMEvent||a;(!this.hasDragged||h&&h.hasDragged)&&"scrollbar"!==a.trigger||(h=this.getUnionExtremes(),this.zoomedMin===this.otherHandlePos?b=this.fixedExtreme:this.zoomedMax===this.otherHandlePos&&(d=this.fixedExtreme),this.zoomedMax===this.size&&(d=this.reversedExtremes?h.dataMin:h.dataMax),0===this.zoomedMin&&(b=this.reversedExtremes?h.dataMax:h.dataMin),f=f.toFixedRange(this.zoomedMin,this.zoomedMax,b,d),x(f.min)&&e.xAxis[0].setExtremes(Math.min(f.min,f.max),
Math.max(f.min,f.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:m}));"mousemove"!==a.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null)},removeEvents:function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(a){a()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()},removeBaseSeriesEvents:function(){var a=this.baseSeries||[];this.navigatorEnabled&&
a[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&a.forEach(function(e){v(e,"updatedData",this.updatedDataHandler)},this),a[0].xAxis&&v(a[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},init:function(h){var e=h.options,f=e.navigator,d=f.enabled,m=e.scrollbar,n=m.enabled,e=d?f.height:0,c=n?m.height:0;this.handles=[];this.shades=[];this.chart=h;this.setBaseSeries();this.height=e;this.scrollbarHeight=c;this.scrollbarEnabled=n;this.navigatorEnabled=d;this.navigatorOptions=f;this.scrollbarOptions=
m;this.outlineHeight=e+c;this.opposite=k(f.opposite,!d&&h.inverted);var g=this,d=g.baseSeries,m=h.xAxis.length,n=h.yAxis.length,l=d&&d[0]&&d[0].xAxis||h.xAxis[0]||{options:{}};h.isDirtyBox=!0;g.navigatorEnabled?(g.xAxis=new q(h,b({breaks:l.options.breaks,ordinal:l.options.ordinal},f.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:m,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},h.inverted?{offsets:[c,
0,-c,0],width:e}:{offsets:[0,-c,0,c],height:e})),g.yAxis=new q(h,b(f.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:n,isInternal:!0,zoomEnabled:!1},h.inverted?{width:e}:{height:e})),d||f.series.data?g.updateNavigatorSeries(!1):0===h.series.length&&(g.unbindRedraw=r(h,"beforeRedraw",function(){0<h.series.length&&!g.series&&(g.setBaseSeries(),g.unbindRedraw())})),g.reversedExtremes=h.inverted&&!g.xAxis.reversed||!h.inverted&&g.xAxis.reversed,g.renderElements(),g.addMouseEvents()):g.xAxis=
{translate:function(f,e){var a=h.xAxis[0],b=a.getExtremes(),d=a.len-2*c,m=w("min",a.options.min,b.dataMin),a=w("max",a.options.max,b.dataMax)-m;return e?f*a/d+m:d*(f-m)/a},toPixels:function(f){return this.translate(f)},toValue:function(f){return this.translate(f,!0)},toFixedRange:q.prototype.toFixedRange,fake:!0};h.options.scrollbar.enabled&&(h.scrollbar=g.scrollbar=new a(h.renderer,b(h.options.scrollbar,{margin:g.navigatorEnabled?0:10,vertical:h.inverted}),h),r(g.scrollbar,"changed",function(f){var a=
g.size,e=a*this.to,a=a*this.from;g.hasDragged=g.scrollbar.hasDragged;g.render(0,0,a,e);(h.options.scrollbar.liveRedraw||"mousemove"!==f.DOMType&&"touchmove"!==f.DOMType)&&setTimeout(function(){g.onMouseUp(f)})}));g.addBaseSeriesEvents();g.addChartEvents()},getUnionExtremes:function(a){var e=this.chart.xAxis[0],f=this.xAxis,b=f.options,h=e.options,d;a&&null===e.dataMin||(d={dataMin:k(b&&b.min,w("min",h.min,e.dataMin,f.dataMin,f.min)),dataMax:k(b&&b.max,w("max",h.max,e.dataMax,f.dataMax,f.max))});return d},
setBaseSeries:function(a,e){var f=this.chart,b=this.baseSeries=[];a=a||f.options&&f.options.navigator.baseSeries||(f.series.length?c.find(f.series,function(f){return!f.options.isInternal}).index:0);(f.series||[]).forEach(function(f,e){f.options.isInternal||!f.options.showInNavigator&&(e!==a&&f.options.id!==a||!1===f.options.showInNavigator)||b.push(f)});this.xAxis&&!this.xAxis.fake&&this.updateNavigatorSeries(!0,e)},updateNavigatorSeries:function(a,e){var f=this,h=f.chart,d=f.baseSeries,m,n,k=f.navigatorOptions.series,
g,w={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:!1,isInternal:!0,states:{inactive:{opacity:1}}},p=f.series=(f.series||[]).filter(function(a){var e=a.baseSeries;return 0>d.indexOf(e)?(e&&(v(e,"updatedData",f.updatedDataHandler),delete e.navigatorSeries),a.chart&&a.destroy(),!1):!0});d&&d.length&&d.forEach(function(a){var y=a.navigatorSeries,c=l({color:a.color,visible:a.visible},t(k)?A.navigator.series:
k);y&&!1===f.navigatorOptions.adaptToUpdatedData||(w.name="Navigator "+d.length,m=a.options||{},g=m.navigatorOptions||{},n=b(m,w,c,g),c=g.data||c.data,f.hasNavigatorData=f.hasNavigatorData||!!c,n.data=c||m.data&&m.data.slice(0),y&&y.options?y.update(n,e):(a.navigatorSeries=h.initSeries(n),a.navigatorSeries.baseSeries=a,p.push(a.navigatorSeries)))});if(k.data&&(!d||!d.length)||t(k))f.hasNavigatorData=!1,k=c.splat(k),k.forEach(function(a,e){w.name="Navigator "+(p.length+1);n=b(A.navigator.series,{color:h.series[e]&&
!h.series[e].options.isInternal&&h.series[e].color||h.options.colors[e]||h.options.colors[0]},w,a);n.data=a.data;n.data&&(f.hasNavigatorData=!0,p.push(h.initSeries(n)))});a&&this.addBaseSeriesEvents()},addBaseSeriesEvents:function(){var a=this,e=a.baseSeries||[];e[0]&&e[0].xAxis&&r(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes);e.forEach(function(f){r(f,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)});r(f,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,
!1)});!1!==this.navigatorOptions.adaptToUpdatedData&&f.xAxis&&r(f,"updatedData",this.updatedDataHandler);r(f,"remove",function(){this.navigatorSeries&&(C(a.series,this.navigatorSeries),x(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)})},this)},getBaseSeriesMin:function(a){return this.baseSeries.reduce(function(a,f){return Math.min(a,f.xData?f.xData[0]:a)},a)},modifyNavigatorAxisExtremes:function(){var a=this.xAxis,e;a.getExtremes&&(!(e=this.getUnionExtremes(!0))||
e.dataMin===a.min&&e.dataMax===a.max||(a.min=e.dataMin,a.max=e.dataMax))},modifyBaseAxisExtremes:function(){var a=this.chart.navigator,e=this.getExtremes(),f=e.dataMin,b=e.dataMax,e=e.max-e.min,d=a.stickToMin,m=a.stickToMax,n=k(this.options.overscroll,0),g,c,l=a.series&&a.series[0],w=!!this.setExtremes;this.eventArgs&&"rangeSelectorButton"===this.eventArgs.trigger||(d&&(c=f,g=c+e),m&&(g=b+n,d||(c=Math.max(g-e,a.getBaseSeriesMin(l&&l.xData?l.xData[0]:-Number.MAX_VALUE)))),w&&(d||m)&&p(c)&&(this.min=
this.userMin=c,this.max=this.userMax=g));a.stickToMin=a.stickToMax=null},updatedDataHandler:function(){var a=this.chart.navigator,e=this.navigatorSeries,f=a.getBaseSeriesMin(this.xData[0]);a.stickToMax=a.reversedExtremes?0===Math.round(a.zoomedMin):Math.round(a.zoomedMax)>=Math.round(a.size);a.stickToMin=p(this.xAxis.min)&&this.xAxis.min<=f&&(!this.chart.fixedRange||!a.stickToMax);e&&!a.hasNavigatorData&&(e.options.pointStart=this.xData[0],e.setData(this.options.data,!1,null,!1))},addChartEvents:function(){this.eventsToUnbind||
(this.eventsToUnbind=[]);this.eventsToUnbind.push(r(this.chart,"redraw",function(){var a=this.navigator,e=a&&(a.baseSeries&&a.baseSeries[0]&&a.baseSeries[0].xAxis||a.scrollbar&&this.xAxis[0]);e&&a.render(e.min,e.max)}),r(this.chart,"getMargins",function(){var a=this.navigator,e=a.opposite?"plotTop":"marginBottom";this.inverted&&(e=a.opposite?"marginRight":"plotLeft");this[e]=(this[e]||0)+(a.navigatorEnabled||!this.inverted?a.outlineHeight:0)+a.navigatorOptions.margin}))},destroy:function(){this.removeEvents();
this.xAxis&&(C(this.chart.xAxis,this.xAxis),C(this.chart.axes,this.xAxis));this.yAxis&&(C(this.chart.yAxis,this.yAxis),C(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(a){a.destroy&&a.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(a){this[a]&&this[a].destroy&&this[a].destroy();this[a]=null},this);[this.handles].forEach(function(a){D(a)},this)}};c.Navigator||(c.Navigator=E,
r(q,"zoom",function(a){var e=this.chart.options,f=e.chart.zoomType,b=e.chart.pinchType,h=e.navigator,e=e.rangeSelector;this.isXAxis&&(h&&h.enabled||e&&e.enabled)&&("y"===f?a.zoomed=!1:(!d&&"xy"===f||d&&"xy"===b)&&this.options.range&&(f=this.previousZoom,x(a.newMin)?this.previousZoom=[this.min,this.max]:f&&(a.newMin=f[0],a.newMax=f[1],delete this.previousZoom)));void 0!==a.zoomed&&a.preventDefault()}),r(u,"beforeShowResetZoom",function(){var a=this.options,e=a.navigator,f=a.rangeSelector;if((e&&e.enabled||
f&&f.enabled)&&(!d&&"x"===a.chart.zoomType||d&&"x"===a.chart.pinchType))return!1}),r(u,"beforeRender",function(){var a=this.options;if(a.navigator.enabled||a.scrollbar.enabled)this.scroller=this.navigator=new E(this)}),r(u,"afterSetChartSize",function(){var a=this.legend,e=this.navigator,f,b,d,m;e&&(b=a&&a.options,d=e.xAxis,m=e.yAxis,f=e.scrollbarHeight,this.inverted?(e.left=e.opposite?this.chartWidth-f-e.height:this.spacing[3]+f,e.top=this.plotTop+f):(e.left=this.plotLeft+f,e.top=e.navigatorOptions.top||
this.chartHeight-e.height-f-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(b&&"bottom"===b.verticalAlign&&b.enabled&&!b.floating?a.legendHeight+k(b.margin,10):0)),d&&m&&(this.inverted?d.options.left=m.options.left=e.left:d.options.top=m.options.top=e.top,d.setAxisSize(),m.setAxisSize()))}),r(u,"update",function(a){var e=a.options.navigator||{},f=a.options.scrollbar||{};this.navigator||this.scroller||!e.enabled&&!f.enabled||(b(!0,this.options.navigator,
e),b(!0,this.options.scrollbar,f),delete a.options.navigator,delete a.options.scrollbar)}),r(u,"afterUpdate",function(a){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new E(this),k(a.redraw,!0)&&this.redraw(a.animation))}),r(u,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),r(n,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,
!1)}),u.prototype.callbacks.push(function(a){var e=a.navigator;e&&a.xAxis[0]&&(a=a.xAxis[0].getExtremes(),e.render(a.min,a.max))}))});B(q,"parts/OrdinalAxis.js",[q["parts/Globals.js"]],function(c){var E=c.addEvent,r=c.Axis,q=c.Chart,u=c.css,z=c.defined,A=c.extend,x=c.noop,D=c.pick,C=c.timeUnits;E(c.Series,"updatedData",function(){var c=this.xAxis;c&&c.options.ordinal&&delete c.ordinalIndex});r.prototype.getTimeTicks=function(c,g,t,p,d,b,k){var l=0,a,n,m={},w,h,e,f=[],y=-Number.MAX_VALUE,G=this.options.tickPixelInterval,
F=this.chart.time,H=[];if(!this.options.ordinal&&!this.options.breaks||!d||3>d.length||void 0===g)return F.getTimeTicks.apply(F,arguments);h=d.length;for(a=0;a<h;a++){e=a&&d[a-1]>t;d[a]<g&&(l=a);if(a===h-1||d[a+1]-d[a]>5*b||e){if(d[a]>y){for(n=F.getTimeTicks(c,d[l],d[a],p);n.length&&n[0]<=y;)n.shift();n.length&&(y=n[n.length-1]);H.push(f.length);f=f.concat(n)}l=a+1}if(e)break}n=n.info;if(k&&n.unitRange<=C.hour){a=f.length-1;for(l=1;l<a;l++)F.dateFormat("%d",f[l])!==F.dateFormat("%d",f[l-1])&&(m[f[l]]=
"day",w=!0);w&&(m[f[0]]="day");n.higherRanks=m}n.segmentStarts=H;f.info=n;if(k&&z(G)){l=H=f.length;w=[];for(var r,F=[];l--;)a=this.translate(f[l]),r&&(F[l]=r-a),w[l]=r=a;F.sort();F=F[Math.floor(F.length/2)];F<.6*G&&(F=null);l=f[H-1]>t?H-1:H;for(r=void 0;l--;)a=w[l],H=Math.abs(r-a),r&&H<.8*G&&(null===F||H<.8*F)?(m[f[l]]&&!m[f[l+1]]?(H=l+1,r=a):H=l,f.splice(H,1)):r=a}return f};A(r.prototype,{beforeSetTickPositions:function(){var c,g=[],t,p=!1,d,b=this.getExtremes(),k=b.min,v=b.max,a,n=this.isXAxis&&
!!this.options.breaks,b=this.options.ordinal,m=Number.MAX_VALUE,w=this.chart.options.chart.ignoreHiddenSeries,h;if(b||n){this.series.forEach(function(a,f){t=[];if(!(w&&!1===a.visible||!1===a.takeOrdinalPosition&&!n)&&(g=g.concat(a.processedXData),c=g.length,g.sort(function(a,f){return a-f}),m=Math.min(m,D(a.closestPointRange,m)),c)){for(f=0;f<c-1;)g[f]!==g[f+1]&&t.push(g[f+1]),f++;t[0]!==g[0]&&t.unshift(g[0]);g=t}a.isSeriesBoosting&&(h=!0)});h&&(g.length=0);c=g.length;if(2<c){d=g[1]-g[0];for(a=c-
1;a--&&!p;)g[a+1]-g[a]!==d&&(p=!0);!this.options.keepOrdinalPadding&&(g[0]-k>d||v-g[g.length-1]>d)&&(p=!0)}else this.options.overscroll&&(2===c?m=g[1]-g[0]:1===c?(m=this.options.overscroll,g=[g[0],g[0]+m]):m=this.overscrollPointsRange);p?(this.options.overscroll&&(this.overscrollPointsRange=m,g=g.concat(this.getOverscrollPositions())),this.ordinalPositions=g,d=this.ordinal2lin(Math.max(k,g[0]),!0),a=Math.max(this.ordinal2lin(Math.min(v,g[g.length-1]),!0),1),this.ordinalSlope=v=(v-k)/(a-d),this.ordinalOffset=
k-d*v):(this.overscrollPointsRange=D(this.closestPointRange,this.overscrollPointsRange),this.ordinalPositions=this.ordinalSlope=this.ordinalOffset=void 0)}this.isOrdinal=b&&p;this.groupIntervalFactor=null},val2lin:function(c,g){var l=this.ordinalPositions;if(l){var p=l.length,d,b;for(d=p;d--;)if(l[d]===c){b=d;break}for(d=p-1;d--;)if(c>l[d]||0===d){c=(c-l[d])/(l[d+1]-l[d]);b=d+c;break}g=g?b:this.ordinalSlope*(b||0)+this.ordinalOffset}else g=c;return g},lin2val:function(c,g){var l=this.ordinalPositions;
if(l){var p=this.ordinalSlope,d=this.ordinalOffset,b=l.length-1,k;if(g)0>c?c=l[0]:c>b?c=l[b]:(b=Math.floor(c),k=c-b);else for(;b--;)if(g=p*b+d,c>=g){p=p*(b+1)+d;k=(c-g)/(p-g);break}return void 0!==k&&void 0!==l[b]?l[b]+(k?k*(l[b+1]-l[b]):0):c}return c},getExtendedPositions:function(){var c=this,g=c.chart,t=c.series[0].currentDataGrouping,p=c.ordinalIndex,d=t?t.count+t.unitName:"raw",b=c.options.overscroll,k=c.getExtremes(),v,a;p||(p=c.ordinalIndex={});p[d]||(v={series:[],chart:g,getExtremes:function(){return{min:k.dataMin,
max:k.dataMax+b}},options:{ordinal:!0},val2lin:r.prototype.val2lin,ordinal2lin:r.prototype.ordinal2lin},c.series.forEach(function(b){a={xAxis:v,xData:b.xData.slice(),chart:g,destroyGroupedData:x};a.xData=a.xData.concat(c.getOverscrollPositions());a.options={dataGrouping:t?{enabled:!0,forced:!0,approximation:"open",units:[[t.unitName,[t.count]]]}:{enabled:!1}};b.processData.apply(a);v.series.push(a)}),c.beforeSetTickPositions.apply(v),p[d]=v.ordinalPositions);return p[d]},getOverscrollPositions:function(){var l=
this.options.overscroll,g=this.overscrollPointsRange,t=[],p=this.dataMax;if(c.defined(g))for(t.push(p);p<=this.dataMax+l;)p+=g,t.push(p);return t},getGroupIntervalFactor:function(c,g,t){var l;t=t.processedXData;var d=t.length,b=[];l=this.groupIntervalFactor;if(!l){for(l=0;l<d-1;l++)b[l]=t[l+1]-t[l];b.sort(function(b,d){return b-d});b=b[Math.floor(d/2)];c=Math.max(c,t[0]);g=Math.min(g,t[d-1]);this.groupIntervalFactor=l=d*b/(g-c)}return l},postProcessTickInterval:function(c){var g=this.ordinalSlope;
return g?this.options.breaks?this.closestPointRange||c:c/(g/this.closestPointRange):c}});r.prototype.ordinal2lin=r.prototype.val2lin;E(q,"pan",function(c){var g=this.xAxis[0],l=g.options.overscroll,p=c.originalEvent.chartX,d=!1;if(g.options.ordinal&&g.series.length){var b=this.mouseDownX,k=g.getExtremes(),v=k.dataMax,a=k.min,n=k.max,m=this.hoverPoints,w=g.closestPointRange||g.overscrollPointsRange,b=(b-p)/(g.translationSlope*(g.ordinalSlope||w)),h={ordinalPositions:g.getExtendedPositions()},w=g.lin2val,
e=g.val2lin,f;h.ordinalPositions?1<Math.abs(b)&&(m&&m.forEach(function(a){a.setState()}),0>b?(m=h,f=g.ordinalPositions?g:h):(m=g.ordinalPositions?g:h,f=h),h=f.ordinalPositions,v>h[h.length-1]&&h.push(v),this.fixedRange=n-a,b=g.toFixedRange(null,null,w.apply(m,[e.apply(m,[a,!0])+b,!0]),w.apply(f,[e.apply(f,[n,!0])+b,!0])),b.min>=Math.min(k.dataMin,a)&&b.max<=Math.max(v,n)+l&&g.setExtremes(b.min,b.max,!0,!1,{trigger:"pan"}),this.mouseDownX=p,u(this.container,{cursor:"move"})):d=!0}else d=!0;d?l&&(g.max=
g.dataMax+l):c.preventDefault()});E(r,"foundExtremes",function(){this.isXAxis&&z(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&z(this.userMin)&&(this.min+=this.options.overscroll))})});B(q,"modules/broken-axis.src.js",[q["parts/Globals.js"]],function(c){var E=c.addEvent,r=c.pick,q=c.extend,u=c.isArray,z=c.find,A=c.fireEvent,
x=c.Axis,D=c.Series,C=function(c,g){return z(g,function(g){return g.from<c&&c<g.to})};q(x.prototype,{isInBreak:function(c,g){var l=c.repeat||Infinity,p=c.from,d=c.to-c.from;g=g>=p?(g-p)%l:l-(p-g)%l;return c.inclusive?g<=d:g<d&&0!==g},isInAnyBreak:function(c,g){var l=this.options.breaks,p=l&&l.length,d,b,k;if(p){for(;p--;)this.isInBreak(l[p],c)&&(d=!0,b||(b=r(l[p].showPoints,!this.isXAxis)));k=d&&g?d&&!b:d}return k}});E(x,"afterInit",function(){"function"===typeof this.setBreaks&&this.setBreaks(this.options.breaks,
!1)});E(x,"afterSetTickPositions",function(){if(this.isBroken){var c=this.tickPositions,g=this.tickPositions.info,t=[],p;for(p=0;p<c.length;p++)this.isInAnyBreak(c[p])||t.push(c[p]);this.tickPositions=t;this.tickPositions.info=g}});E(x,"afterSetOptions",function(){this.isBroken&&(this.options.ordinal=!1)});x.prototype.setBreaks=function(c,g){function l(b){var c=b,a,n;for(n=0;n<d.breakArray.length;n++)if(a=d.breakArray[n],a.to<=b)c-=a.len;else if(a.from>=b)break;else if(d.isInBreak(a,b)){c-=b-a.from;
break}return c}function p(b){var c,a;for(a=0;a<d.breakArray.length&&!(c=d.breakArray[a],c.from>=b);a++)c.to<b?b+=c.len:d.isInBreak(c,b)&&(b+=c.len);return b}var d=this,b=u(c)&&!!c.length;d.isDirty=d.isBroken!==b;d.isBroken=b;d.options.breaks=d.userOptions.breaks=c;d.forceRedraw=!0;b||d.val2lin!==l||(delete d.val2lin,delete d.lin2val);b&&(d.userOptions.ordinal=!1,d.val2lin=l,d.lin2val=p,d.setExtremes=function(b,c,a,d,m){if(this.isBroken){for(var n,h=this.options.breaks;n=C(b,h);)b=n.to;for(;n=C(c,
h);)c=n.from;c<b&&(c=b)}x.prototype.setExtremes.call(this,b,c,a,d,m)},d.setAxisTranslation=function(b){x.prototype.setAxisTranslation.call(this,b);this.unitLength=null;if(this.isBroken){b=d.options.breaks;var c=[],a=[],n=0,m,g,h=d.userMin||d.min,e=d.userMax||d.max,f=r(d.pointRangePadding,0),y,k;b.forEach(function(a){g=a.repeat||Infinity;d.isInBreak(a,h)&&(h+=a.to%g-h%g);d.isInBreak(a,e)&&(e-=e%g-a.from%g)});b.forEach(function(a){y=a.from;for(g=a.repeat||Infinity;y-g>h;)y-=g;for(;y<h;)y+=g;for(k=y;k<
e;k+=g)c.push({value:k,move:"in"}),c.push({value:k+(a.to-a.from),move:"out",size:a.breakSize})});c.sort(function(a,f){return a.value===f.value?("in"===a.move?0:1)-("in"===f.move?0:1):a.value-f.value});m=0;y=h;c.forEach(function(f){m+="in"===f.move?1:-1;1===m&&"in"===f.move&&(y=f.value);0===m&&(a.push({from:y,to:f.value,len:f.value-y-(f.size||0)}),n+=f.value-y-(f.size||0))});d.breakArray=a;d.unitLength=e-h-n+f;A(d,"afterBreaks");d.staticScale?d.transA=d.staticScale:d.unitLength&&(d.transA*=(e-d.min+
f)/d.unitLength);f&&(d.minPixelPadding=d.transA*d.minPointOffset);d.min=h;d.max=e}});r(g,!0)&&this.chart.redraw()};E(D,"afterGeneratePoints",function(){var c=this.xAxis,g=this.yAxis,t=this.points,p,d=t.length,b=this.options.connectNulls,k;if(c&&g&&(c.options.breaks||g.options.breaks))for(;d--;)p=t[d],k=null===p.y&&!1===b,k||!c.isInAnyBreak(p.x,!0)&&!g.isInAnyBreak(p.y,!0)||(t.splice(d,1),this.data[d]&&this.data[d].destroyElements())});E(D,"afterRender",function(){this.drawBreaks(this.xAxis,["x"]);
this.drawBreaks(this.yAxis,r(this.pointArrayMap,["y"]))});c.Series.prototype.drawBreaks=function(c,g){var l=this,p=l.points,d,b,k,v;c&&g.forEach(function(a){d=c.breakArray||[];b=c.isXAxis?c.min:r(l.options.threshold,c.min);p.forEach(function(n){v=r(n["stack"+a.toUpperCase()],n[a]);d.forEach(function(a){k=!1;if(b<a.from&&v>a.to||b>a.from&&v<a.from)k="pointBreak";else if(b<a.from&&v>a.from&&v<a.to||b>a.from&&v>a.to&&v<a.from)k="pointInBreak";k&&A(c,k,{point:n,brk:a})})})})};c.Series.prototype.gappedPath=
function(){var l=this.currentDataGrouping,g=l&&l.gapSize,l=this.options.gapSize,t=this.points.slice(),p=t.length-1,d=this.yAxis;if(l&&0<p)for("value"!==this.options.gapUnit&&(l*=this.closestPointRange),g&&g>l&&(l=g);p--;)t[p+1].x-t[p].x>l&&(g=(t[p].x+t[p+1].x)/2,t.splice(p+1,0,{isNull:!0,x:g}),this.options.stacking&&(g=d.stacks[this.stackKey][g]=new c.StackItem(d,d.options.stackLabels,!1,g,this.stack),g.total=0));return this.getGraphPath(t)}});B(q,"masters/modules/broken-axis.src.js",[],function(){});
B(q,"parts/DataGrouping.js",[q["parts/Globals.js"]],function(c){var q=c.addEvent,r=c.arrayMax,B=c.arrayMin,u=c.Axis,z=c.defaultPlotOptions,A=c.defined,x=c.extend,D=c.format,C=c.isNumber,l=c.merge,g=c.pick,t=c.Point,p=c.Series,d=c.Tooltip,b=c.approximations={sum:function(a){var f=a.length,b;if(!f&&a.hasNulls)b=null;else if(f)for(b=0;f--;)b+=a[f];return b},average:function(a){var f=a.length;a=b.sum(a);C(a)&&f&&(a/=f);return a},averages:function(){var a=[];[].forEach.call(arguments,function(f){a.push(b.average(f))});
return void 0===a[0]?void 0:a},open:function(a){return a.length?a[0]:a.hasNulls?null:void 0},high:function(a){return a.length?r(a):a.hasNulls?null:void 0},low:function(a){return a.length?B(a):a.hasNulls?null:void 0},close:function(a){return a.length?a[a.length-1]:a.hasNulls?null:void 0},ohlc:function(a,e,c,d){a=b.open(a);e=b.high(e);c=b.low(c);d=b.close(d);if(C(a)||C(e)||C(c)||C(d))return[a,e,c,d]},range:function(a,e){a=b.low(a);e=b.high(e);if(C(a)||C(e))return[a,e];if(null===a&&null===e)return null}},
k=function(a,e,c,d){var f=this,h=f.data,m=f.options&&f.options.data,n=[],g=[],k=[],y=a.length,p,w,F=!!e,G=[],t=f.pointArrayMap,v=t&&t.length,r=["x"].concat(t||["y"]),u=0,D=0,z,x;d="function"===typeof d?d:b[d]?b[d]:b[f.getDGApproximation&&f.getDGApproximation()||"average"];v?t.forEach(function(){G.push([])}):G.push([]);z=v||1;for(x=0;x<=y&&!(a[x]>=c[0]);x++);for(x;x<=y;x++){for(;void 0!==c[u+1]&&a[x]>=c[u+1]||x===y;){p=c[u];f.dataGroupInfo={start:f.cropStart+D,length:G[0].length};w=d.apply(f,G);f.pointClass&&
!A(f.dataGroupInfo.options)&&(f.dataGroupInfo.options=l(f.pointClass.prototype.optionsToObject.call({series:f},f.options.data[f.cropStart+D])),r.forEach(function(a){delete f.dataGroupInfo.options[a]}));void 0!==w&&(n.push(p),g.push(w),k.push(f.dataGroupInfo));D=x;for(p=0;p<z;p++)G[p].length=0,G[p].hasNulls=!1;u+=1;if(x===y)break}if(x===y)break;if(t){p=f.cropStart+x;w=h&&h[p]||f.pointClass.prototype.applyOptions.apply({series:f},[m[p]]);var q;for(p=0;p<v;p++)q=w[t[p]],C(q)?G[p].push(q):null===q&&(G[p].hasNulls=
!0)}else p=F?e[x]:null,C(p)?G[0].push(p):null===p&&(G[0].hasNulls=!0)}return{groupedXData:n,groupedYData:g,groupMap:k}},v={approximations:b,groupData:k},a=p.prototype,n=a.processData,m=a.generatePoints,w={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y",
"%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},h={line:{},spline:{},area:{},areaspline:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5}},e=c.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",
[1,3,6]],["year",null]];a.getDGApproximation=function(){return c.seriesTypes.arearange&&this instanceof c.seriesTypes.arearange?"range":c.seriesTypes.ohlc&&this instanceof c.seriesTypes.ohlc?"ohlc":c.seriesTypes.column&&this instanceof c.seriesTypes.column?"sum":"average"};a.groupData=k;a.processData=function(){var f=this.chart,b=this.options.dataGrouping,c=!1!==this.allowDG&&b&&g(b.enabled,f.options.isStock),d=this.visible||!f.options.chart.ignoreHiddenSeries,h,m=this.currentDataGrouping,k,p=!1;
this.forceCrop=c;this.groupPixelWidth=null;this.hasProcessed=!0;c&&!this.requireSorting&&(this.requireSorting=p=!0);c=!1===n.apply(this,arguments)||!c;p&&(this.requireSorting=!1);if(!c){this.destroyGroupedData();var w,c=b.groupAll?this.xData:this.processedXData,l=b.groupAll?this.yData:this.processedYData,t=f.plotSizeX,f=this.xAxis,v=f.options.ordinal,r=this.groupPixelWidth=f.getGroupPixelWidth&&f.getGroupPixelWidth();if(r){this.isDirty=h=!0;this.points=null;p=f.getExtremes();k=p.min;var p=p.max,v=
v&&f.getGroupIntervalFactor(k,p,this)||1,r=r*(p-k)/t*v,t=f.getTimeTicks(f.normalizeTimeTickInterval(r,b.units||e),Math.min(k,c[0]),Math.max(p,c[c.length-1]),f.options.startOfWeek,c,this.closestPointRange),l=a.groupData.apply(this,[c,l,t,b.approximation]),c=l.groupedXData,v=l.groupedYData,u=0;if(b.smoothed&&c.length){w=c.length-1;for(c[w]=Math.min(c[w],p);w--&&0<w;)c[w]+=r/2;c[0]=Math.max(c[0],k)}for(w=1;w<t.length;w++)t.info.segmentStarts&&-1!==t.info.segmentStarts.indexOf(w)||(u=Math.max(t[w]-t[w-
1],u));k=t.info;k.gapSize=u;this.closestPointRange=t.info.totalRange;this.groupMap=l.groupMap;if(A(c[0])&&c[0]<f.dataMin&&d){if(!A(f.options.min)&&f.min<=f.dataMin||f.min===f.dataMin)f.min=c[0];f.dataMin=c[0]}b.groupAll&&(b=this.cropData(c,v,f.min,f.max,1),c=b.xData,v=b.yData);this.processedXData=c;this.processedYData=v}else this.groupMap=null;this.hasGroupedData=h;this.currentDataGrouping=k;this.preventGraphAnimation=(m&&m.totalRange)!==(k&&k.totalRange)}};a.destroyGroupedData=function(){var a=this.groupedData;
(a||[]).forEach(function(b,f){b&&(a[f]=b.destroy?b.destroy():null)});this.groupedData=null};a.generatePoints=function(){m.apply(this);this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null};q(t,"update",function(){if(this.dataGroup)return c.error(24,!1,this.series.chart),!1});q(d,"headerFormatter",function(a){var b=this.chart.time,f=a.labelConfig,e=f.series,c=e.tooltipOptions,d=e.options.dataGrouping,h=c.xDateFormat,m,n=e.xAxis,g,k=c[(a.isFooter?"footer":"header")+"Format"];
n&&"datetime"===n.options.type&&d&&C(f.key)&&(g=e.currentDataGrouping,d=d.dateTimeLabelFormats||w.dateTimeLabelFormats,g?(c=d[g.unitName],1===g.count?h=c[0]:(h=c[1],m=c[2])):!h&&d&&(h=this.getXDateFormat(f,c,n)),h=b.dateFormat(h,f.key),m&&(h+=b.dateFormat(m,f.key+g.totalRange-1)),e.chart.styledMode&&(k=this.styledModeFormat(k)),a.text=D(k,{point:x(f.point,{key:h}),series:e},b),a.preventDefault())});q(p,"destroy",a.destroyGroupedData);q(p,"afterSetOptions",function(a){a=a.options;var b=this.type,f=
this.chart.options.plotOptions,e=z[b].dataGrouping,c=this.useCommonDataGrouping&&w;if(h[b]||c)e||(e=l(w,h[b])),a.dataGrouping=l(c,e,f.series&&f.series.dataGrouping,f[b].dataGrouping,this.userOptions.dataGrouping)});q(u,"afterSetScale",function(){this.series.forEach(function(a){a.hasProcessed=!1})});u.prototype.getGroupPixelWidth=function(){var a=this.series,b=a.length,e,c=0,d=!1,h;for(e=b;e--;)(h=a[e].options.dataGrouping)&&(c=Math.max(c,g(h.groupPixelWidth,w.groupPixelWidth)));for(e=b;e--;)(h=a[e].options.dataGrouping)&&
a[e].hasProcessed&&(b=(a[e].processedXData||a[e].data).length,a[e].groupPixelWidth||b>this.chart.plotSizeX/c||b&&h.forced)&&(d=!0);return d?c:0};u.prototype.setDataGrouping=function(a,b){var e;b=g(b,!0);a||(a={forced:!1,units:null});if(this instanceof u)for(e=this.series.length;e--;)this.series[e].update({dataGrouping:a},!1);else this.chart.options.series.forEach(function(b){b.dataGrouping=a},!1);this.ordinalSlope=null;b&&this.chart.redraw()};return c.dataGrouping=v});B(q,"parts/OHLCSeries.js",[q["parts/Globals.js"]],
function(c){var q=c.Point,r=c.seriesType,B=c.seriesTypes;r("ohlc","column",{lineWidth:1,tooltip:{pointFormat:'\x3cspan style\x3d"color:{point.color}"\x3e\u25cf\x3c/span\x3e \x3cb\x3e {series.name}\x3c/b\x3e\x3cbr/\x3eOpen: {point.open}\x3cbr/\x3eHigh: {point.high}\x3cbr/\x3eLow: {point.low}\x3cbr/\x3eClose: {point.close}\x3cbr/\x3e'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0},{directTouch:!1,pointArrayMap:["open","high","low","close"],toYData:function(c){return[c.open,c.high,c.low,
c.close]},pointValKey:"close",pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},init:function(){B.column.prototype.init.apply(this,arguments);this.options.stacking=!1},pointAttribs:function(c,r){r=B.column.prototype.pointAttribs.call(this,c,r);var u=this.options;delete r.fill;!c.options.color&&u.upColor&&c.open<c.close&&(r.stroke=u.upColor);return r},translate:function(){var c=this,r=c.yAxis,A=!!c.modifyValue,x=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];B.column.prototype.translate.apply(c);
c.points.forEach(function(u){[u.open,u.high,u.low,u.close,u.low].forEach(function(q,l){null!==q&&(A&&(q=c.modifyValue(q)),u[x[l]]=r.toPixels(q,!0))});u.tooltipPos[1]=u.plotHigh+r.pos-c.chart.plotTop})},drawPoints:function(){var c=this,r=c.chart;c.points.forEach(function(u){var x,q,z,l,g=u.graphic,t,p=!g;void 0!==u.plotY&&(g||(u.graphic=g=r.renderer.path().add(c.group)),r.styledMode||g.attr(c.pointAttribs(u,u.selected&&"select")),q=g.strokeWidth()%2/2,t=Math.round(u.plotX)-q,z=Math.round(u.shapeArgs.width/
2),l=["M",t,Math.round(u.yBottom),"L",t,Math.round(u.plotHigh)],null!==u.open&&(x=Math.round(u.plotOpen)+q,l.push("M",t,x,"L",t-z,x)),null!==u.close&&(x=Math.round(u.plotClose)+q,l.push("M",t,x,"L",t+z,x)),g[p?"attr":"animate"]({d:l}).addClass(u.getClassName(),!0))})},animate:null},{getClassName:function(){return q.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")}})});B(q,"parts/CandlestickSeries.js",[q["parts/Globals.js"]],function(c){var q=
c.defaultPlotOptions,r=c.merge,B=c.seriesType,u=c.seriesTypes;B("candlestick","ohlc",r(q.column,{states:{hover:{lineWidth:2}},tooltip:q.ohlc.tooltip,threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}),{pointAttribs:function(c,r){var q=u.column.prototype.pointAttribs.call(this,c,r),D=this.options,z=c.open<c.close,l=D.lineColor||this.color;q["stroke-width"]=D.lineWidth;q.fill=c.options.color||(z?D.upColor||this.color:this.color);q.stroke=c.lineColor||(z?D.upLineColor||
l:l);r&&(c=D.states[r],q.fill=c.color||q.fill,q.stroke=c.lineColor||q.stroke,q["stroke-width"]=c.lineWidth||q["stroke-width"]);return q},drawPoints:function(){var c=this,r=c.chart,u=c.yAxis.reversed;c.points.forEach(function(q){var x=q.graphic,l,g,t,p,d,b,k,v=!x;void 0!==q.plotY&&(x||(q.graphic=x=r.renderer.path().add(c.group)),c.chart.styledMode||x.attr(c.pointAttribs(q,q.selected&&"select")).shadow(c.options.shadow),d=x.strokeWidth()%2/2,b=Math.round(q.plotX)-d,l=q.plotOpen,g=q.plotClose,t=Math.min(l,
g),l=Math.max(l,g),k=Math.round(q.shapeArgs.width/2),g=u?l!==q.yBottom:Math.round(t)!==Math.round(q.plotHigh),p=u?Math.round(t)!==Math.round(q.plotHigh):l!==q.yBottom,t=Math.round(t)+d,l=Math.round(l)+d,d=[],d.push("M",b-k,l,"L",b-k,t,"L",b+k,t,"L",b+k,l,"Z","M",b,t,"L",b,g?Math.round(u?q.yBottom:q.plotHigh):t,"M",b,l,"L",b,p?Math.round(u?q.plotHigh:q.yBottom):l),x[v?"attr":"animate"]({d:d}).addClass(q.getClassName(),!0))})}})});B(q,"mixins/on-series.js",[q["parts/Globals.js"]],function(c){var q=
c.defined,r=c.seriesTypes,B=c.stableSort;return{getPlotBox:function(){return c.Series.prototype.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){r.column.prototype.translate.apply(this);var c=this,z=c.options,A=c.chart,x=c.points,E=x.length-1,C,l=z.onSeries,l=l&&A.get(l),z=z.onKey||"y",g=l&&l.options.step,t=l&&l.points,p=t&&t.length,d=A.inverted,b=c.xAxis,k=c.yAxis,v=0,a,n,m,w;if(l&&l.visible&&p)for(v=(l.pointXOffset||0)+(l.barW||0)/2,A=l.currentDataGrouping,
n=t[p-1].x+(A?A.totalRange:0),B(x,function(a,b){return a.x-b.x}),z="plot"+z[0].toUpperCase()+z.substr(1);p--&&x[E]&&!(a=t[p],A=x[E],A.y=a.y,a.x<=A.x&&void 0!==a[z]&&(A.x<=n&&(A.plotY=a[z],a.x<A.x&&!g&&(m=t[p+1])&&void 0!==m[z]&&(w=(A.x-a.x)/(m.x-a.x),A.plotY+=w*(m[z]-a[z]),A.y+=w*(m.y-a.y))),E--,p++,0>E)););x.forEach(function(a,e){var f;a.plotX+=v;if(void 0===a.plotY||d)0<=a.plotX&&a.plotX<=b.len?d?(a.plotY=b.translate(a.x,0,1,0,1),a.plotX=q(a.y)?k.translate(a.y,0,0,0,1):0):a.plotY=(b.opposite?0:
c.yAxis.len)+b.offset:a.shapeArgs={};(C=x[e-1])&&C.plotX===a.plotX&&(void 0===C.stackIndex&&(C.stackIndex=0),f=C.stackIndex+1);a.stackIndex=f});this.onSeries=l}}});B(q,"parts/FlagsSeries.js",[q["parts/Globals.js"],q["mixins/on-series.js"]],function(c,q){function r(c){t[c+"pin"]=function(d,b,g,p,a){var n=a&&a.anchorX;a=a&&a.anchorY;var m;"circle"===c&&p>g&&(d-=Math.round((p-g)/2),g=p);m=t[c](d,b,g,p);n&&a&&(m.push("M","circle"===c?d+g/2:m[1]+m[4]/2,b>a?b:b+p,"L",n,a),m=m.concat(t.circle(n-1,a-1,2,
2)));return m}}var E=c.addEvent,u=c.merge,z=c.noop,A=c.defined,x=c.Renderer,D=c.Series,C=c.seriesType,l=c.TrackerMixin,g=c.VMLRenderer,t=c.SVGRenderer.prototype.symbols;C("flags","column",{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}\x3cbr/\x3e"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd6eb"}},style:{fontSize:"11px",fontWeight:"bold"}},{sorted:!1,noSharedTooltip:!0,allowDG:!1,
takeOrdinalPosition:!1,trackerGroups:["markerGroup"],forceCrop:!0,init:D.prototype.init,pointAttribs:function(c,d){var b=this.options,g=c&&c.color||this.color,p=b.lineColor,a=c&&c.lineWidth;c=c&&c.fillColor||b.fillColor;d&&(c=b.states[d].fillColor,p=b.states[d].lineColor,a=b.states[d].lineWidth);return{fill:c||g,stroke:p||g,"stroke-width":a||b.lineWidth||0}},translate:q.translate,getPlotBox:q.getPlotBox,drawPoints:function(){var g=this.points,d=this.chart,b=d.renderer,k,l,a=d.inverted,n=this.options,
m=n.y,w,h,e,f,y,t,q=this.yAxis,r={},x=[];for(h=g.length;h--;)e=g[h],t=(a?e.plotY:e.plotX)>this.xAxis.len,k=e.plotX,f=e.stackIndex,w=e.options.shape||n.shape,l=e.plotY,void 0!==l&&(l=e.plotY+m-(void 0!==f&&f*n.stackDistance)),e.anchorX=f?void 0:e.plotX,y=f?void 0:e.plotY,f=e.graphic,void 0!==l&&0<=k&&!t?(f||(f=e.graphic=b.label("",null,null,w,null,null,n.useHTML),d.styledMode||f.attr(this.pointAttribs(e)).css(u(n.style,e.style)),f.attr({align:"flag"===w?"left":"center",width:n.width,height:n.height,
"text-align":n.textAlign}).addClass("highcharts-point").add(this.markerGroup),e.graphic.div&&(e.graphic.div.point=e),d.styledMode||f.shadow(n.shadow),f.isNew=!0),0<k&&(k-=f.strokeWidth()%2),w={y:l,anchorY:y},n.allowOverlapX&&(w.x=k,w.anchorX=e.anchorX),f.attr({text:e.options.title||n.title||"A"})[f.isNew?"attr":"animate"](w),n.allowOverlapX||(r[e.plotX]?r[e.plotX].size=Math.max(r[e.plotX].size,f.width):r[e.plotX]={align:0,size:f.width,target:k,anchorX:k}),e.tooltipPos=[k,l+q.pos-d.plotTop]):f&&(e.graphic=
f.destroy());n.allowOverlapX||(c.objectEach(r,function(a){a.plotX=a.anchorX;x.push(a)}),c.distribute(x,a?q.len:this.xAxis.len,100),g.forEach(function(a){var b=a.graphic&&r[a.plotX];b&&(a.graphic[a.graphic.isNew?"attr":"animate"]({x:b.pos,anchorX:a.anchorX}),A(b.pos)?a.graphic.isNew=!1:(a.graphic.attr({x:-9999,anchorX:-9999}),a.graphic.isNew=!0))}));n.useHTML&&c.wrap(this.markerGroup,"on",function(a){return c.SVGElement.prototype.on.apply(a.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,
1))})},drawTracker:function(){var c=this.points;l.drawTrackerPoint.apply(this);c.forEach(function(d){var b=d.graphic;b&&E(b.element,"mouseover",function(){0<d.stackIndex&&!d.raised&&(d._y=b.y,b.attr({y:d._y-8}),d.raised=!0);c.forEach(function(b){b!==d&&b.raised&&b.graphic&&(b.graphic.attr({y:b._y}),b.raised=!1)})})})},animate:function(c){c?this.setClip():this.animate=null},setClip:function(){D.prototype.setClip.apply(this,arguments);!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup.clip(this.chart[this.sharedClipKey])},
buildKDTree:z,invertGroups:z},{isValid:function(){return c.isNumber(this.y)||void 0===this.y}});t.flag=function(c,d,b,g,l){var a=l&&l.anchorX||c;l=l&&l.anchorY||d;return t.circle(a-1,l-1,2,2).concat(["M",a,l,"L",c,d+g,c,d,c+b,d,c+b,d+g,c,d+g,"Z"])};r("circle");r("square");x===g&&["flag","circlepin","squarepin"].forEach(function(c){g.prototype.symbols[c]=t[c]})});B(q,"parts/RangeSelector.js",[q["parts/Globals.js"]],function(c){function q(a){this.init(a)}var r=c.addEvent,B=c.Axis,u=c.Chart,z=c.css,
A=c.createElement,x=c.defaultOptions,D=c.defined,C=c.destroyObjectProperties,l=c.discardElement,g=c.extend,t=c.fireEvent,p=c.isNumber,d=c.merge,b=c.pick,k=c.pInt,v=c.splat;g(x,{rangeSelector:{verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputPosition:{align:"right",x:0,y:0},buttonPosition:{align:"left",x:0,y:0},labelStyle:{color:"#666666"}}});x.lang=d(x.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"From",rangeSelectorTo:"To"});q.prototype=
{clickButton:function(a,c){var d=this.chart,g=this.buttonOptions[a],h=d.xAxis[0],e=d.scroller&&d.scroller.getUnionExtremes()||h||{},f=e.dataMin,n=e.dataMax,k,l=h&&Math.round(Math.min(h.max,b(n,h.max))),q=g.type,t,e=g._range,u,x,S,z=g.dataGrouping;if(null!==f&&null!==n){d.fixedRange=e;z&&(this.forcedDataGrouping=!0,B.prototype.setDataGrouping.call(h||{chart:this.chart},z,!1),this.frozenStates=g.preserveDataGrouping);if("month"===q||"year"===q)h?(q={range:g,max:l,chart:d,dataMin:f,dataMax:n},k=h.minFromRange.call(q),
p(q.newMax)&&(l=q.newMax)):e=g;else if(e)k=Math.max(l-e,f),l=Math.min(k+e,n);else if("ytd"===q)if(h)void 0===n&&(f=Number.MAX_VALUE,n=Number.MIN_VALUE,d.series.forEach(function(a){a=a.xData;f=Math.min(a[0],f);n=Math.max(a[a.length-1],n)}),c=!1),l=this.getYTDExtremes(n,f,d.time.useUTC),k=u=l.min,l=l.max;else{this.deferredYTDClick=a;return}else"all"===q&&h&&(k=f,l=n);k+=g._offsetMin;l+=g._offsetMax;this.setSelected(a);h?h.setExtremes(k,l,b(c,1),null,{trigger:"rangeSelectorButton",rangeSelectorButton:g}):
(t=v(d.options.xAxis)[0],S=t.range,t.range=e,x=t.min,t.min=u,r(d,"load",function(){t.range=S;t.min=x}))}},setSelected:function(a){this.selected=this.options.selected=a},defaultButtons:[{type:"month",count:1,text:"1m"},{type:"month",count:3,text:"3m"},{type:"month",count:6,text:"6m"},{type:"ytd",text:"YTD"},{type:"year",count:1,text:"1y"},{type:"all",text:"All"}],init:function(a){var b=this,c=a.options.rangeSelector,d=c.buttons||[].concat(b.defaultButtons),h=c.selected,e=function(){var a=b.minInput,
c=b.maxInput;a&&a.blur&&t(a,"blur");c&&c.blur&&t(c,"blur")};b.chart=a;b.options=c;b.buttons=[];b.buttonOptions=d;this.unMouseDown=r(a.container,"mousedown",e);this.unResize=r(a,"resize",e);d.forEach(b.computeButtonRange);void 0!==h&&d[h]&&this.clickButton(h,!1);r(a,"load",function(){a.xAxis&&a.xAxis[0]&&r(a.xAxis[0],"setExtremes",function(c){this.max-this.min!==a.fixedRange&&"rangeSelectorButton"!==c.trigger&&"updatedData"!==c.trigger&&b.forcedDataGrouping&&!b.frozenStates&&this.setDataGrouping(!1,
!1)})})},updateButtonStates:function(){var a=this,b=this.chart,c=b.xAxis[0],d=Math.round(c.max-c.min),h=!c.hasVisibleSeries,e=b.scroller&&b.scroller.getUnionExtremes()||c,f=e.dataMin,g=e.dataMax,b=a.getYTDExtremes(g,f,b.time.useUTC),k=b.min,l=b.max,q=a.selected,t=p(q),r=a.options.allButtonsEnabled,u=a.buttons;a.buttonOptions.forEach(function(b,e){var m=b._range,n=b.type,p=b.count||1,w=u[e],y=0,F=b._offsetMax-b._offsetMin;b=e===q;var v=m>g-f,x=m<c.minRange,G=!1,H=!1,m=m===d;("month"===n||"year"===
n)&&d+36E5>=864E5*{month:28,year:365}[n]*p-F&&d-36E5<=864E5*{month:31,year:366}[n]*p+F?m=!0:"ytd"===n?(m=l-k+F===d,G=!b):"all"===n&&(m=c.max-c.min>=g-f,H=!b&&t&&m);n=!r&&(v||x||H||h);p=b&&m||m&&!t&&!G||b&&a.frozenStates;n?y=3:p&&(t=!0,y=2);w.state!==y&&(w.setState(y),0===y&&q===e&&a.setSelected(null))})},computeButtonRange:function(a){var c=a.type,d=a.count||1,g={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(g[c])a._range=g[c]*d;else if("month"===c||"year"===c)a._range=864E5*
{month:30,year:365}[c]*d;a._offsetMin=b(a.offsetMin,0);a._offsetMax=b(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin},setInputValue:function(a,b){var c=this.chart.options.rangeSelector,d=this.chart.time,g=this[a+"Input"];D(b)&&(g.previousValue=g.HCTime,g.HCTime=b);g.value=d.dateFormat(c.inputEditDateFormat||"%Y-%m-%d",g.HCTime);this[a+"DateBox"].attr({text:d.dateFormat(c.inputDateFormat||"%b %e, %Y",g.HCTime)})},showInput:function(a){var b=this.inputGroup,c=this[a+"DateBox"];z(this[a+"Input"],
{left:b.translateX+c.x+"px",top:b.translateY+"px",width:c.width-2+"px",height:c.height-2+"px",border:"2px solid silver"})},hideInput:function(a){z(this[a+"Input"],{border:0,width:"1px",height:"1px"});this.setInputValue(a)},drawInput:function(a){function b(){var a=t.value,b=(f.inputDateParser||Date.parse)(a),c=l.xAxis[0],e=l.scroller&&l.scroller.xAxis?l.scroller.xAxis:c,d=e.dataMin,e=e.dataMax;b!==t.previousValue&&(t.previousValue=b,p(b)||(b=a.split("-"),b=Date.UTC(k(b[0]),k(b[1])-1,k(b[2]))),p(b)&&
(l.time.useUTC||(b+=6E4*(new Date).getTimezoneOffset()),q?b>m.maxInput.HCTime?b=void 0:b<d&&(b=d):b<m.minInput.HCTime?b=void 0:b>e&&(b=e),void 0!==b&&c.setExtremes(q?b:c.min,q?c.max:b,void 0,void 0,{trigger:"rangeSelectorInput"})))}var m=this,l=m.chart,h=l.renderer.style||{},e=l.renderer,f=l.options.rangeSelector,y=m.div,q="min"===a,t,r,u=this.inputGroup;this[a+"Label"]=r=e.label(x.lang[q?"rangeSelectorFrom":"rangeSelectorTo"],this.inputGroup.offset).addClass("highcharts-range-label").attr({padding:2}).add(u);
u.offset+=r.width+5;this[a+"DateBox"]=e=e.label("",u.offset).addClass("highcharts-range-input").attr({padding:2,width:f.inputBoxWidth||90,height:f.inputBoxHeight||17,"text-align":"center"}).on("click",function(){m.showInput(a);m[a+"Input"].focus()});l.styledMode||e.attr({stroke:f.inputBoxBorderColor||"#cccccc","stroke-width":1});e.add(u);u.offset+=e.width+(q?10:0);this[a+"Input"]=t=A("input",{name:a,className:"highcharts-range-selector",type:"text"},{top:l.plotTop+"px"},y);l.styledMode||(r.css(d(h,
f.labelStyle)),e.css(d({color:"#333333"},h,f.inputStyle)),z(t,g({position:"absolute",border:0,width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:h.fontSize,fontFamily:h.fontFamily,top:"-9999em"},f.inputStyle)));t.onfocus=function(){m.showInput(a)};t.onblur=function(){t===c.doc.activeElement&&(b(),m.hideInput(a),t.blur())};t.onchange=b;t.onkeypress=function(a){13===a.keyCode&&b()}},getPosition:function(){var a=this.chart,b=a.options.rangeSelector,a="top"===b.verticalAlign?a.plotTop-a.axisOffset[0]:
0;return{buttonTop:a+b.buttonPosition.y,inputTop:a+b.inputPosition.y-10}},getYTDExtremes:function(a,b,c){var d=this.chart.time,g=new d.Date(a),e=d.get("FullYear",g);c=c?d.Date.UTC(e,0,1):+new d.Date(e,0,1);b=Math.max(b||0,c);g=g.getTime();return{max:Math.min(a||g,g),min:b}},render:function(a,c){var d=this,g=d.chart,h=g.renderer,e=g.container,f=g.options,k=f.exporting&&!1!==f.exporting.enabled&&f.navigation&&f.navigation.buttonOptions,n=x.lang,l=d.div,p=f.rangeSelector,t=b(f.chart.style&&f.chart.style.zIndex,
0)+1,f=p.floating,q=d.buttons,l=d.inputGroup,r=p.buttonTheme,u=p.buttonPosition,v=p.inputPosition,z=p.inputEnabled,E=r&&r.states,C=g.plotLeft,D,B=d.buttonGroup,L;L=d.rendered;var M=d.options.verticalAlign,O=g.legend,P=O&&O.options,Q=u.y,N=v.y,R=L||!1,T=R?"animate":"attr",K=0,I=0,J;if(!1!==p.enabled){L||(d.group=L=h.g("range-selector-group").attr({zIndex:7}).add(),d.buttonGroup=B=h.g("range-selector-buttons").add(L),d.zoomText=h.text(n.rangeSelectorZoom,0,15).add(B),g.styledMode||(d.zoomText.css(p.labelStyle),
r["stroke-width"]=b(r["stroke-width"],0)),d.buttonOptions.forEach(function(a,b){q[b]=h.button(a.text,0,0,function(c){var e=a.events&&a.events.click,f;e&&(f=e.call(a,c));!1!==f&&d.clickButton(b);d.isActive=!0},r,E&&E.hover,E&&E.select,E&&E.disabled).attr({"text-align":"center"}).add(B)}),!1!==z&&(d.div=l=A("div",null,{position:"relative",height:0,zIndex:t}),e.parentNode.insertBefore(l,e),d.inputGroup=l=h.g("input-group").add(L),l.offset=0,d.drawInput("min"),d.drawInput("max")));d.zoomText[T]({x:b(C+
u.x,C)});D=b(C+u.x,C)+d.zoomText.getBBox().width+5;d.buttonOptions.forEach(function(a,c){q[c][T]({x:D});D+=q[c].width+b(p.buttonSpacing,5)});C=g.plotLeft-g.spacing[3];d.updateButtonStates();k&&this.titleCollision(g)&&"top"===M&&"right"===u.align&&u.y+B.getBBox().height-12<(k.y||0)+k.height&&(K=-40);"left"===u.align?J=u.x-g.spacing[3]:"right"===u.align&&(J=u.x+K-g.spacing[1]);B.align({y:u.y,width:B.getBBox().width,align:u.align,x:J},!0,g.spacingBox);d.group.placed=R;d.buttonGroup.placed=R;!1!==z&&
(K=k&&this.titleCollision(g)&&"top"===M&&"right"===v.align&&v.y-l.getBBox().height-12<(k.y||0)+k.height+g.spacing[0]?-40:0,"left"===v.align?J=C:"right"===v.align&&(J=-Math.max(g.axisOffset[1],-K)),l.align({y:v.y,width:l.getBBox().width,align:v.align,x:v.x+J-2},!0,g.spacingBox),e=l.alignAttr.translateX+l.alignOptions.x-K+l.getBBox().x+2,k=l.alignOptions.width,n=B.alignAttr.translateX+B.getBBox().x,J=B.getBBox().width+20,(v.align===u.align||n+J>e&&e+k>n&&Q<N+l.getBBox().height)&&l.attr({translateX:l.alignAttr.translateX+
(g.axisOffset[1]>=-K?0:-K),translateY:l.alignAttr.translateY+B.getBBox().height+10}),d.setInputValue("min",a),d.setInputValue("max",c),d.inputGroup.placed=R);d.group.align({verticalAlign:M},!0,g.spacingBox);a=d.group.getBBox().height+20;c=d.group.alignAttr.translateY;"bottom"===M&&(O=P&&"bottom"===P.verticalAlign&&P.enabled&&!P.floating?O.legendHeight+b(P.margin,10):0,a=a+O-20,I=c-a-(f?0:p.y)-10);if("top"===M)f&&(I=0),g.titleOffset&&(I=g.titleOffset+g.options.title.margin),I+=g.margin[0]-g.spacing[0]||
0;else if("middle"===M)if(N===Q)I=0>N?c+void 0:c;else if(N||Q)I=0>N||0>Q?I-Math.min(N,Q):c-a+NaN;d.group.translate(p.x,p.y+Math.floor(I));!1!==z&&(d.minInput.style.marginTop=d.group.translateY+"px",d.maxInput.style.marginTop=d.group.translateY+"px");d.rendered=!0}},getHeight:function(){var a=this.options,b=this.group,c=a.y,d=a.buttonPosition.y,g=a.inputPosition.y;if(a.height)return a.height;a=b?b.getBBox(!0).height+13+c:0;b=Math.min(g,d);if(0>g&&0>d||0<g&&0<d)a+=Math.abs(b);return a},titleCollision:function(a){return!(a.options.title.text||
a.options.subtitle.text)},update:function(a){var b=this.chart;d(!0,b.options.rangeSelector,a);this.destroy();this.init(b);b.rangeSelector.render()},destroy:function(){var a=this,b=a.minInput,d=a.maxInput;a.unMouseDown();a.unResize();C(a.buttons);b&&(b.onfocus=b.onblur=b.onchange=null);d&&(d.onfocus=d.onblur=d.onchange=null);c.objectEach(a,function(b,c){b&&"chart"!==c&&(b.destroy?b.destroy():b.nodeType&&l(this[c]));b!==q.prototype[c]&&(a[c]=null)},this)}};B.prototype.minFromRange=function(){var a=
this.range,c={month:"Month",year:"FullYear"}[a.type],d,g=this.max,h,e,f=this.chart.time,k=function(a,b){var e=new f.Date(a),d=f.get(c,e);f.set(c,e,d+b);d===f.get(c,e)&&e.setDate(0);return e.getTime()-a};p(a)?(d=g-a,e=a):(d=g+k(g,-a.count),this.chart&&(this.chart.fixedRange=g-d));h=b(this.dataMin,Number.MIN_VALUE);p(d)||(d=h);d<=h&&(d=h,void 0===e&&(e=k(d,a.count)),this.newMax=Math.min(d+e,this.dataMax));p(g)||(d=void 0);return d};c.RangeSelector||(r(u,"afterGetContainer",function(){this.options.rangeSelector.enabled&&
(this.rangeSelector=new q(this))}),r(u,"beforeRender",function(){var a=this.axes,b=this.rangeSelector;b&&(p(b.deferredYTDClick)&&(b.clickButton(b.deferredYTDClick),delete b.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),this.getAxisMargins(),b.render(),a=b.options.verticalAlign,b.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))}),r(u,"update",function(a){var b=a.options.rangeSelector;a=this.rangeSelector;var c=this.extraBottomMargin,
d=this.extraTopMargin;b&&b.enabled&&!D(a)&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=new q(this));this.extraTopMargin=this.extraBottomMargin=!1;a&&(a.render(),b=b&&b.verticalAlign||a.options&&a.options.verticalAlign,a.options.floating||("bottom"===b?this.extraBottomMargin=!0:"middle"!==b&&(this.extraTopMargin=!0)),this.extraBottomMargin!==c||this.extraTopMargin!==d)&&(this.isDirtyBox=!0)}),r(u,"render",function(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,
"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))}),r(u,"getMargins",function(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))}),u.prototype.callbacks.push(function(a){function b(){c=a.xAxis[0].getExtremes();p(c.min)&&d.render(c.min,c.max)}var c,d=a.rangeSelector,g,e;d&&(e=r(a.xAxis[0],"afterSetExtremes",function(a){d.render(a.min,a.max)}),g=r(a,"redraw",b),b());r(a,"destroy",function(){d&&
(g(),e())})}),c.RangeSelector=q)});B(q,"parts/StockChart.js",[q["parts/Globals.js"]],function(c){var q=c.addEvent,r=c.arrayMax,B=c.arrayMin,u=c.Axis,z=c.Chart,A=c.defined,x=c.extend,D=c.format,C=c.isNumber,l=c.isString,g=c.merge,t=c.pick,p=c.Point,d=c.Renderer,b=c.Series,k=c.splat,v=c.SVGRenderer,a=c.VMLRenderer,n=b.prototype,m=n.init,w=n.processData,h=p.prototype.tooltipFormatter;c.StockChart=c.stockChart=function(a,b,d){var e=l(a)||a.nodeName,f=arguments[e?1:0],h=f,n=f.series,m=c.getOptions(),p,
q=t(f.navigator&&f.navigator.enabled,m.navigator.enabled,!0),y=q?{startOnTick:!1,endOnTick:!1}:null,r={marker:{enabled:!1,radius:2}},u={shadow:!1,borderWidth:0};f.xAxis=k(f.xAxis||{}).map(function(a,b){return g({minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0},m.xAxis,m.xAxis&&m.xAxis[b],a,{type:"datetime",categories:null},y)});f.yAxis=k(f.yAxis||{}).map(function(a,b){p=t(a.opposite,!0);return g({labels:{y:-2},opposite:p,showLastLabel:!(!a.categories&&
"category"!==a.type),title:{text:null}},m.yAxis,m.yAxis&&m.yAxis[b],a)});f.series=null;f=g({chart:{panning:!0,pinchType:"x"},navigator:{enabled:q},scrollbar:{enabled:t(m.scrollbar.enabled,!0)},rangeSelector:{enabled:t(m.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:t(m.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1},plotOptions:{line:r,spline:r,area:r,areaspline:r,arearange:r,areasplinerange:r,column:u,columnrange:u,candlestick:u,ohlc:u}},f,{isStock:!0});f.series=h.series=n;return e?
new z(a,f,d):new z(f,b)};q(u,"autoLabelAlign",function(a){var b=this.chart,c=this.options,b=b._labelPanes=b._labelPanes||{},e=this.options.labels;this.chart.options.isStock&&"yAxis"===this.coll&&(c=c.top+","+c.height,!b[c]&&e.enabled&&(15===e.x&&(e.x=0),void 0===e.align&&(e.align="right"),b[c]=this,a.align="right",a.preventDefault()))});q(u,"destroy",function(){var a=this.chart,b=this.options&&this.options.top+","+this.options.height;b&&a._labelPanes&&a._labelPanes[b]===this&&delete a._labelPanes[b]});
q(u,"getPlotLinePath",function(a){function b(a){var b="xAxis"===a?"yAxis":"xAxis";a=d.options[b];return C(a)?[g[b][a]]:l(a)?[g.get(a)]:e.map(function(a){return a[b]})}var d=this,e=this.isLinked&&!this.series?this.linkedParent.series:this.series,g=d.chart,h=g.renderer,k=d.left,n=d.top,m,p,q,r,u=[],v=[],x,w,z=a.translatedValue,B=a.value,D=a.force,E;if("xAxis"===d.coll||"yAxis"===d.coll)a.preventDefault(),v=b(d.coll),x=d.isXAxis?g.yAxis:g.xAxis,x.forEach(function(a){if(A(a.options.id)?-1===a.options.id.indexOf("navigator"):
1){var b=a.isXAxis?"yAxis":"xAxis",b=A(a.options[b])?g[b][a.options[b]]:g[b][0];d===b&&v.push(a)}}),w=v.length?[]:[d.isXAxis?g.yAxis[0]:g.xAxis[0]],v.forEach(function(a){-1!==w.indexOf(a)||c.find(w,function(b){return b.pos===a.pos&&b.len===a.len})||w.push(a)}),E=t(z,d.translate(B,null,null,a.old)),C(E)&&(d.horiz?w.forEach(function(a){var b;p=a.pos;r=p+a.len;m=q=Math.round(E+d.transB);"pass"!==D&&(m<k||m>k+d.width)&&(D?m=q=Math.min(Math.max(k,m),k+d.width):b=!0);b||u.push("M",m,p,"L",q,r)}):w.forEach(function(a){var b;
m=a.pos;q=m+a.len;p=r=Math.round(n+d.height-E);"pass"!==D&&(p<n||p>n+d.height)&&(D?p=r=Math.min(Math.max(n,p),d.top+d.height):b=!0);b||u.push("M",m,p,"L",q,r)})),a.path=0<u.length?h.crispPolyLine(u,a.lineWidth||1):null});v.prototype.crispPolyLine=function(a,b){var c;for(c=0;c<a.length;c+=6)a[c+1]===a[c+4]&&(a[c+1]=a[c+4]=Math.round(a[c+1])-b%2/2),a[c+2]===a[c+5]&&(a[c+2]=a[c+5]=Math.round(a[c+2])+b%2/2);return a};d===a&&(a.prototype.crispPolyLine=v.prototype.crispPolyLine);q(u,"afterHideCrosshair",
function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});q(u,"afterDrawCrosshair",function(a){var b,c;if(A(this.crosshair.label)&&this.crosshair.label.enabled&&this.cross){var d=this.chart,e=this.options.crosshair.label,g=this.horiz;b=this.opposite;c=this.left;var h=this.top,k=this.crossLabel,l=e.format,m="",n="inside"===this.options.tickPosition,p=!1!==this.crosshair.snap,q=0,r=a.e||this.cross&&this.cross.e,u=a.point;a=this.lin2log;var v,w;this.isLog?(v=a(this.min),w=a(this.max)):(v=
this.min,w=this.max);a=g?"center":b?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";k||(k=this.crossLabel=d.renderer.label(null,null,null,e.shape||"callout").addClass("highcharts-crosshair-label"+(this.series[0]&&" highcharts-color-"+this.series[0].colorIndex)).attr({align:e.align||a,padding:t(e.padding,8),r:t(e.borderRadius,3),zIndex:2}).add(this.labelGroup),d.styledMode||k.attr({fill:e.backgroundColor||this.series[0]&&this.series[0].color||"#666666",stroke:e.borderColor||
"","stroke-width":e.borderWidth||0}).css(x({color:"#ffffff",fontWeight:"normal",fontSize:"11px",textAlign:"center"},e.style)));g?(a=p?u.plotX+c:r.chartX,h+=b?0:this.height):(a=b?this.width+c:0,h=p?u.plotY+h:r.chartY);l||e.formatter||(this.isDatetimeAxis&&(m="%b %d, %Y"),l="{value"+(m?":"+m:"")+"}");m=p?u[this.isXAxis?"x":"y"]:this.toValue(g?r.chartX:r.chartY);k.attr({text:l?D(l,{value:m},d.time):e.formatter.call(this,m),x:a,y:h,visibility:m<v||m>w?"hidden":"visible"});e=k.getBBox();if(g){if(n&&!b||
!n&&b)h=k.y-e.height}else h=k.y-e.height/2;g?(b=c-e.x,c=c+this.width-e.x):(b="left"===this.labelAlign?c:0,c="right"===this.labelAlign?c+this.width:d.chartWidth);k.translateX<b&&(q=b-k.translateX);k.translateX+e.width>=c&&(q=-(k.translateX+e.width-c));k.attr({x:a+q,y:h,anchorX:g?a:this.opposite?0:d.chartWidth,anchorY:g?this.opposite?d.chartHeight:0:h+e.height/2})}});n.init=function(){m.apply(this,arguments);this.setCompare(this.options.compare)};n.setCompare=function(a){this.modifyValue="value"===
a||"percent"===a?function(b,c){var d=this.compareValue;if(void 0!==b&&void 0!==d)return b="value"===a?b-d:b/d*100-(100===this.options.compareBase?0:100),c&&(c.change=b),b}:null;this.userOptions.compare=a;this.chart.hasRendered&&(this.isDirty=!0)};n.processData=function(){var a,b=-1,c,d,g=!0===this.options.compareStart?0:1,h,k;w.apply(this,arguments);if(this.xAxis&&this.processedYData)for(c=this.processedXData,d=this.processedYData,h=d.length,this.pointArrayMap&&(b=this.pointArrayMap.indexOf(this.options.pointValKey||
this.pointValKey||"y")),a=0;a<h-g;a++)if(k=d[a]&&-1<b?d[a][b]:d[a],C(k)&&c[a+g]>=this.xAxis.min&&0!==k){this.compareValue=k;break}};q(b,"afterGetExtremes",function(){if(this.modifyValue){var a=[this.modifyValue(this.dataMin),this.modifyValue(this.dataMax)];this.dataMin=B(a);this.dataMax=r(a)}});u.prototype.setCompare=function(a,b){this.isXAxis||(this.series.forEach(function(b){b.setCompare(a)}),t(b,!0)&&this.chart.redraw())};p.prototype.tooltipFormatter=function(a){a=a.replace("{point.change}",(0<
this.change?"+":"")+c.numberFormat(this.change,t(this.series.tooltipOptions.changeDecimals,2)));return h.apply(this,[a])};q(b,"render",function(){var a;this.chart.is3d&&this.chart.is3d()||this.chart.polar||!this.xAxis||this.xAxis.isRadial||(a=this.yAxis.len-(this.xAxis.axisLine?Math.floor(this.xAxis.axisLine.strokeWidth()/2):0),!this.clipBox&&this.animate?(this.clipBox=g(this.chart.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=a):this.chart[this.sharedClipKey]&&(this.chart[this.sharedClipKey].animate({width:this.xAxis.len,
height:a}),this.chart[this.sharedClipKey+"m"]&&this.chart[this.sharedClipKey+"m"].animate({width:this.xAxis.len})))});q(z,"update",function(a){a=a.options;"scrollbar"in a&&this.navigator&&(g(!0,this.options.scrollbar,a.scrollbar),this.navigator.update({},!1),delete a.scrollbar)})});B(q,"masters/modules/stock.src.js",[],function(){})});
//# sourceMappingURL=stock.js.map
