<?php
/**
 * Functions to provide support for the One Click Demo Import plugin (wordpress.org/plugins/one-click-demo-import)
 *
 * @package daohang
 */


/**
 * Set import files
 */
function daohang_set_import_files() {
    return array(
        array(
            'import_file_name'           => __('Demo Content', 'daohang'),
            'local_import_file'          => trailingslashit( get_template_directory() ) . 'demo-content/demo-content.xml',           
            'local_import_widget_file'   => trailingslashit( get_template_directory() ) . 'demo-content/demo-widgets.wie',
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'daohang_set_import_files' );

/**
 * Define actions that happen after import
 */
function daohang_set_after_import_mods() {

	//Assign the menu
    $top_menu    = get_term_by( 'name', '顶部菜单', 'nav_menu' );
    $main_menu_1 = get_term_by( 'name', '主菜单', 'nav_menu' );
    $friend_menu = get_term_by( 'name', '友情链接', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $top_menu->term_id,
            'main-1'  => $main_menu_1->term_id,
            'friend'  => $friend_menu->term_id,
            'footer'  => $top_menu->term_id,
            'mobile'  => $main_menu_1->term_id,
        )
    );

    //Asign the static front page and the blog page
    //$front_page = get_page_by_title( '首页' );
    //$blog_page  = get_page_by_title( '新闻动态' );

    //update_option( 'show_on_front', 'page' );
    //update_option( 'page_on_front', $front_page -> ID );
    //update_option( 'page_for_posts', $blog_page -> ID );

    //Assign the Front Page template
    //update_post_meta( $front_page -> ID, '_wp_page_template', 'page-templates/page-canvas.php' );

}
add_action( 'pt-ocdi/after_import', 'daohang_set_after_import_mods' );

/**
* Remove branding
*/
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );