<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package daohang
 */

?>
	</div><!-- #content .site-content -->
	
	<div class="clear"></div>

	<footer id="colophon" class="site-footer clear">

		<?php if ( is_active_sidebar( 'footer-area' ) ) { ?>	

		<div class="footer-columns">
			<div class="container clear">
				<?php dynamic_sidebar( 'footer-area' ); ?>
			</div><!-- .container -->
		</div><!-- .footer-area -->

		<?php } ?>

		<?php
			if ( has_nav_menu( 'friend' ) && is_front_page() && (!is_paged()) ) {
				echo '<div class="friend-section container clear">';
				echo '<strong>' . get_theme_mod('home-friend-title', '友情链接') . ' <i class="fa fa-angle-right"></i></strong>';
				wp_nav_menu( array( 'theme_location' => 'friend', 'menu_id' => 'friend-menu', 'menu_class' => 'friend-nav' ) );
				echo '</div>';
			}				
		?>

		<div id="site-bottom" class="<?php if ( !is_active_sidebar( 'footer-area' ) && (!is_home()) ) { echo "no-footer-widgets"; } ?> container clear">

			<div class="site-info">

				<?php if(get_theme_mod('footer-credit')) { 
					
					echo get_theme_mod('footer-credit');
					
					} else { 
						$theme_uri = 'https://www.domain.com/';
						$author_uri = 'https://www.domain.com/';
				?>

				&copy; <?php echo date("o"); ?> <a href="<?php echo home_url(); ?>"><?php echo get_bloginfo('name'); ?></a> - <?php echo __('某某导航网', 'daohang'); ?><a href="<?php echo $author_uri; ?>" target="_blank">WordPress主题</a> &bullet; <a href="http://www.beian.miit.gov.cn/">京ICP备11111111号-1</a>

				<?php } ?>

			</div><!-- .site-info -->

			<?php 
				if ( has_nav_menu( 'footer' ) ) {
					wp_nav_menu( array( 'theme_location' => 'footer', 'menu_id' => 'footer-menu', 'menu_class' => 'footer-nav' ) );
				}
			?>	

		</div><!-- #site-bottom -->

	</footer><!-- #colophon -->

</div><!-- #page -->

<div class="bottom-right">

	<?php if ( get_theme_mod('back-top-on', true) ) : ?>
	<div id="back-top">
		<a href="#top" title="<?php echo __('返回顶部', 'daohang'); ?>">
			<span class="icon"><i class="fa fa-chevron-up"></i></span>
			<span class="text">返回顶部</span>
		</a>
	</div>
	<?php endif; ?>
</div><!-- .bottom-right -->

<?php if ( is_single() ) : ?>

<script src="<?php echo get_template_directory_uri() . '/assets/js/sticky-sidebar.min.js'?>"></script>

<script>

(function($){ //create closure so we can safely use $ as alias for jQuery

    $(document).ready(function(){

        "use strict";
		$(window).load(function() {
			var stickySidebar = new StickySidebar('#secondary', {
				topSpacing: 20,
				bottomSpacing: 20,
				containerSelector: '.site_container',
				innerWrapperSelector: '.sidebar__inner'
			});
		});	

    });


})(jQuery);
</script>

<?php endif; ?>

<?php wp_footer(); ?>

</body>
</html>
