<?php
/**
 * newsnow_pro functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package daohang
 */

// Define path and URL to the ACF plugin.
define( 'MY_ACF_PATH', get_stylesheet_directory() . '/includes/acf/' );
define( 'MY_ACF_URL', get_stylesheet_directory_uri() . '/includes/acf/' );

// Include the ACF plugin.
include_once( MY_ACF_PATH . 'acf.php' );

// Customize the url setting to fix incorrect asset URLs.
add_filter('acf/settings/url', 'my_acf_settings_url');
function my_acf_settings_url( $url ) {
    return MY_ACF_URL;
}

// (Optional) Hide the ACF admin menu item.
add_filter('acf/settings/show_admin', 'my_acf_settings_show_admin');
function my_acf_settings_show_admin( $show_admin ) {
    return false;
}

if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
    'key' => 'group_5e57f512555ef',
    'title' => '分类链接设置',
    'fields' => array(
        array(
            'key' => 'field_5e57f50c2cf9f',
            'label' => '链接图标',
            'name' => 'cat_link_image',
            'type' => 'true_false',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'admin_column_enabled' => 0,
            'admin_column_post_types' => '',
            'admin_column_taxonomies' => '',
            'message' => '显示链接图标',
            'default_value' => 1,
            'ui' => 0,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5e57f5d6e3a48',
            'label' => '链接标题',
            'name' => 'cat_link_bold',
            'type' => 'true_false',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'admin_column_enabled' => 0,
            'admin_column_post_types' => '',
            'admin_column_taxonomies' => '',
            'message' => '将链接标题设置为粗体',
            'default_value' => 1,
            'ui' => 0,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5e57f60de3a49',
            'label' => '链接说明',
            'name' => 'cat_link_desc',
            'type' => 'true_false',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'admin_column_enabled' => 0,
            'admin_column_post_types' => '',
            'admin_column_taxonomies' => '',
            'message' => '显示链接说明',
            'default_value' => 1,
            'ui' => 0,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5e57f6e76ac12',
            'label' => '链接目标',
            'name' => 'cat_new_tab',
            'type' => 'true_false',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'admin_column_enabled' => 0,
            'admin_column_post_types' => '',
            'admin_column_taxonomies' => '',
            'message' => '在新标签页打开链接',
            'default_value' => 1,
            'ui' => 0,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5e57f63be3a4a',
            'label' => '每行链接数',
            'name' => 'cat_row_num',
            'type' => 'number',
            'instructions' => '每行要显示的链接数 (1到15)',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'admin_column_enabled' => 0,
            'admin_column_post_types' => '',
            'admin_column_taxonomies' => '',
            'default_value' => 5,
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'min' => 1,
            'max' => 15,
            'step' => '',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'taxonomy',
                'operator' => '==',
                'value' => 'link_cat',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array(
    'key' => 'group_5e4f6e824b51a',
    'title' => '链接设置',
    'fields' => array(
        array(
            'key' => 'field_5e4f6ed342a6d',
            'label' => '链接地址',
            'name' => 'link_url',
            'type' => 'url',
            'instructions' => '',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'admin_column_enabled' => 1,
            'admin_column_post_types' => array(
                0 => 'links',
            ),
            'admin_column_taxonomies' => '',
            'default_value' => '',
            'placeholder' => 'http://',
        ),
        array(
            'key' => 'field_5e4f6fb65593c',
            'label' => '链接说明',
            'name' => 'link_desc',
            'type' => 'textarea',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'admin_column_enabled' => 0,
            'admin_column_post_types' => array(
                0 => 'links',
            ),
            'admin_column_taxonomies' => '',
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => 2,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_5e4f6ff7dfa5a',
            'label' => '选择链接图标',
            'name' => 'link_image',
            'type' => 'image',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'admin_column_enabled' => 0,
            'admin_column_post_types' => '',
            'admin_column_taxonomies' => '',
            'return_format' => 'url',
            'preview_size' => 'thumbnail',
            'library' => 'all',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => '',
            'mime_types' => '',
        ),
        array(
            'key' => 'field_5e5f94f2d2a23',
            'label' => '或输入图标地址',
            'name' => 'link_image2',
            'type' => 'url',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'admin_column_enabled' => 0,
            'admin_column_post_types' => '',
            'admin_column_taxonomies' => '',
            'default_value' => '',
            'placeholder' => 'http://',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'links',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

endif;


/* Post Images */
if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
    'key' => 'group_5dd4ba24e02c6',
    'title' => '文章列表图片设置',
    'fields' => array(
        array(
            'key' => 'field_5dd4ba3b00fb1',
            'label' => '图片1',
            'name' => 'image_1',
            'type' => 'url',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'http://',
        ),
        array(
            'key' => 'field_5dd4bb1267472',
            'label' => '图片2',
            'name' => 'image_2',
            'type' => 'url',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'http://',
        ),
        array(
            'key' => 'field_5dd4bb2867473',
            'label' => '图片3',
            'name' => 'image_3',
            'type' => 'url',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'http://',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'post',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
));

endif;


if ( ! function_exists( 'daohang_setup' ) ) :

function daohang_setup() {

    load_theme_textdomain( 'daohang', get_template_directory() . '/languages' );

    // Add default posts and comments RSS feed links to head.
    add_theme_support( 'automatic-feed-links' );

    /*
     * Let WordPress manage the document title.
     * By adding theme support, we declare that this theme does not use a
     * hard-coded <title> tag in the document head, and expect WordPress to
     * provide it for us.
     */
    add_theme_support( 'title-tag' );

    /*
     * Enable support for Post Thumbnails on posts and pages.
     *
     * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
     */
    add_theme_support( 'post-thumbnails' );

    // This theme uses wp_nav_menu() in one location.
    register_nav_menus( array(
        'primary' => esc_html__( '顶部菜单', 'daohang' ),
        'main-1'  => esc_html__( '主菜单', 'daohang' ),
        'footer'  => esc_html__( '底部菜单', 'daohang' ),  
        'mobile'  => esc_html__( '移动端菜单 (仅在移动端显示)', 'daohang' ),   
        'friend'  => esc_html__( '友情链接', 'daohang' ),                                     
    ) );

    /*
     * Switch default core markup for search form, comment form, and comments
     * to output valid HTML5.
     */
    add_theme_support( 'html5', array(
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
    ) );

    // Add theme support for Custom Logo.
    add_theme_support( 'custom-logo', array(
        'width'       => 400,
        'height'      => 100,
        'flex-width'  => true,
        'flex-height' => true
    ) );

    // Set up the WordPress core custom background feature.
    add_theme_support( 'custom-background', apply_filters( 'daohang_custom_background_args', array(
        'default-color' => 'ffffff',
        'default-image' => '',
    ) ) );

    add_editor_style( array( 'assets/css/editor-style.css', '' ) ); 
}
endif;
add_action( 'after_setup_theme', 'daohang_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function daohang_content_width() {
    $GLOBALS['content_width'] = apply_filters( 'daohang_content_width', 760 );
}
add_action( 'after_setup_theme', 'daohang_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function daohang_sidebar_init() {

    register_sidebar( array(
        'name'          => esc_html__( '首页模块', 'daohang' ),
        'id'            => 'homepage',
        'description'   => esc_html__( '仅限添加"首页链接模块"和"广告"小工具', 'daohang' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );      

    register_sidebar( array(
        'name'          => esc_html__( '右侧边栏', 'daohang' ),
        'id'            => 'sidebar-1',
        'description'   => esc_html__( '在此添加小工具', 'daohang' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    register_sidebar( array(
        'name'          => esc_html__( '网站底部', 'daohang' ),
        'id'            => 'footer-area',
        'description'   => esc_html__( '在此处添加小工具', 'daohang' ),
        'before_widget' => '<div id="%1$s" class="footer-area %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );                    

}
add_action( 'widgets_init', 'daohang_sidebar_init' );

/**
 * Implement the Custom Header feature.
 */
//require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */

require get_template_directory() . '/admin/customizer-library.php';

require get_template_directory() . '/admin/customizer-options.php';

require get_template_directory() . '/admin/styles.php';

require get_template_directory() . '/admin/mods.php';

require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Load plugins.
 */
require get_template_directory() . '/inc/plugins.php';

/* Demo Content*/
require_once dirname( __FILE__ ) . '/demo-content/setup.php';

/**
 * Registers custom widgets.
 */
function daohang_widgets_init() {

    require trailingslashit( get_template_directory() ) . 'inc/widgets/widget-links.php';
    register_widget( 'daohang_Links_Widget' );    

   // require trailingslashit( get_template_directory() ) . 'inc/widgets/widget-category-posts.php';
    //register_widget( 'daohang_Category_Posts_Widget' );    

    require trailingslashit( get_template_directory() ) . 'inc/widgets/widget-ad.php';
    register_widget( 'daohang_Ad_Widget' ); 
                                
}
add_action( 'widgets_init', 'daohang_widgets_init' );

/* Fix PHP warning */
function _get($str){
    $val = !empty($_GET[$str]) ? $_GET[$str] : null;
    return $val;
}

/**
 * No Category Base
 */
if (get_theme_mod('no-category-base-on', false) == true) {
    require trailingslashit( get_template_directory() ) . 'inc/no-category-base.php';
}

/**
 * acf_admin_columns
 */
require trailingslashit( get_template_directory() ) . 'includes/admin-columns-for-acf-fields/acf_admin_columns.php';

/**
 * Enqueues scripts and styles.
 */
function daohang_scripts() {

    // load jquery if it isn't

    //wp_deregister_script()('jquery');

    wp_enqueue_script('jquery');

    //wp_enqueue_script('jquery', get_template_directory_uri() . '/assets/js/jquery.js', array(), '', true );

	//  Enqueues Javascripts
	wp_enqueue_script( 'superfish', get_template_directory_uri() . '/assets/js/superfish.js', array(), '', true );
	wp_enqueue_script( 'modernizr', get_template_directory_uri() . '/assets/js/modernizr.min.js',array(), '', true ); 
	wp_enqueue_script( 'html5', get_template_directory_uri() . '/assets/js/html5.js', array(), '', true );
    //wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/assets/js/owl.carousel.min.js', array(), '', true );                 
	//wp_enqueue_script( 'bxslider', get_template_directory_uri() . '/assets/js/jquery.bxslider.min.js', array(), '', true );

    if ( is_single() && ( get_theme_mod('single-share-on', true) == true ) ) {
        wp_enqueue_script( 'qrcode', get_template_directory_uri() . '/assets/js/qrcode.js', array(), '', true ); 
        wp_enqueue_script( 'social-share', get_template_directory_uri() . '/assets/js/social-share.js', array(), '', true ); 
    }          
	          	
	wp_enqueue_script( 'custom', get_template_directory_uri() . '/assets/js/jquery.custom.js', array(), '20191126', true );

    // Enqueues CSS styles
    wp_enqueue_style( 'daohang-style', get_stylesheet_uri(), array(), '20200201' );     
    wp_enqueue_style( 'genericons-style',   get_template_directory_uri() . '/genericons/genericons.css' );

    if ( get_theme_mod( 'site-layout', 'choice-1' ) == 'choice-1' ) {
    	wp_enqueue_style( 'responsive-style',   get_template_directory_uri() . '/responsive.css', array(), '20200101' ); 
	}
	
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }    
}
add_action( 'wp_enqueue_scripts', 'daohang_scripts' );

/* Admin CSS Style */
function daohang_admin_style() {
	wp_enqueue_style('admin-style', get_template_directory_uri().'/assets/css/admin.css');
}
add_action('admin_enqueue_scripts', 'daohang_admin_style');

/**
 * Post Thumbnails.
 */
if ( function_exists( 'add_theme_support' ) ) { 
    add_theme_support( 'post-thumbnails' );
    //set_post_thumbnail_size( 150, 150, true ); // default Post Thumbnail dimensions (cropped)
    add_image_size( 'post_thumb', 400, 230, true );
    add_image_size( 'single_thumb', 790, 474, true ); 
}
