<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package daohang
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="HandheldFriendly" content="true">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php if (get_theme_mod('favicon', '') != null) { ?>
<link rel="icon" type="image/png" href="<?php echo esc_url( get_theme_mod('favicon', '') ); ?>" />
<?php } ?>
<?php wp_head(); ?>

<?php
	// Theme Color
	$primary_color = get_theme_mod('primary-color', '#0099e5');
	$secondary_color = get_theme_mod('secondary-color', '#ff5a00');	
	$mobile_color = get_theme_mod('mobile-color', '#0099e5');
	$header_color = get_theme_mod('header-color', '#3d4557');
	$footer_color = get_theme_mod('footer-color', '#3d4557');
?>
<style type="text/css" media="all">
	a,
	a:visited,
	.content-block .section-heading h3 a,
	.content-block .section-heading h3,
	.sidebar .widget a,
	.site-footer .widget a,
	.logged-in-as a,
	.edit-link a,
	.form-submit-text a,
	.single #primary .entry-footer .entry-like a,
	.single #primary .entry-footer .entry-sponsor span {
		color: <?php echo $primary_color; ?>;		
	}
	.content-block .section-heading h3:hover,
	.sf-menu ul li li a:hover,
	.sf-menu li.sfHover li a:hover,
	#primary-menu li li a:hover,
	.breadcrumbs .breadcrumbs-nav a:hover,
	.comment-reply-title small a:hover,
	.pagination .page-numbers:hover,	
	a:hover,
	.site-title a:hover,
	.entry-title a:hover,
	.entry-related .hentry .entry-title a:hover,
	.sidebar .widget a:hover,
	.sidebar .widget ul li a:hover,	 
	.single .navigation a:hover,
	.breadcrumbs ul.sub-categories li a:hover,
	.entry-content a:hover,
	.author-box .author-meta .author-name a:hover,
	.entry-content li a:hover,
	.page-content li a:hover,
	.pagination .page-numbers.current,
	.content-loop .entry-meta .entry-category a,
	.entry-tags .tag-links a:hover,
	.main-menu li a:hover  {
		color: <?php echo $secondary_color; ?>;
	}
	.section-links .link-item a:hover .link-title,
	.widget_tag_cloud .tagcloud a:hover {
		color: <?php echo $secondary_color; ?> !important;
	}

	button,
	.btn,
	input[type="submit"],
	input[type="reset"],
	input[type="button"],
	button:hover,
	.btn:hover,
	input[type="reset"]:hover,
	input[type="submit"]:hover,
	input[type="button"]:hover,
	.content-loop .entry-header .entry-category-icon a,
	.entry-related .section-title:before,
	.comments-title:before,
	#reply-title:before,
	.breadcrumbs h1:before,	
	.friend h3:before,
	.sidebar .widget .widget-title:before,
	.bottom-right span.icon-link .text,
	.bottom-right a .text,
	.home .sidebar .widget .widget-title:before,
	.sidebar .widget .widget-title:before,
	.single #primary .entry-footer .entry-like a:hover,
	.single #primary .entry-footer .entry-sponsor span:hover {
		background-color: <?php echo $primary_color; ?>;
	}
	.form-submit .submit,
	.form-submit .submit:hover,
	#post-nav a:hover,
	#post-nav .no-next:hover,
	.content-loop .entry-meta .entry-category a:hover {
		background-color: <?php echo $secondary_color; ?>;
	}	
	@media only screen and (max-width: 479px) {
		.header-search .search-submit,
		.header-search .search-submit:hover {
			background-color: <?php echo $secondary_color; ?>;	
		}
	}		
	.single #primary .entry-footer .entry-like a,
	.single #primary .entry-footer .entry-like a:hover,
	.single #primary .entry-footer .entry-sponsor span {
		border-color: <?php echo $primary_color; ?>;
	}	
	.mobile-nav {
		background-color: <?php echo $mobile_color; ?>;
	}
	.pagination .page-numbers:hover,
	.entry-tags .tag-links a:hover,
	.widget_tag_cloud .tagcloud a:hover,
	.content-loop .entry-meta .entry-category a {
		border-color: <?php echo $secondary_color; ?>;
	}
	#primary-bar {
		background-color: <?php echo $header_color; ?>;
	}
	.site-footer {
		background-color: <?php echo $footer_color; ?>;		
	}
	<?php 
		/* Fix post title margins on single post */
		if( ( get_theme_mod('single-author-avatar-on', true) == false ) &&  
			( get_theme_mod('single-author-name-on', true) == false ) && 
			( get_theme_mod('single-date-on', true) == false ) && 
			( get_theme_mod('single-share-on', true) == false ) && 
			( get_theme_mod('single-comment-on', true) == false ) &&
			( get_theme_mod('single-view-on', true) == false ) ) : 			
	?>
		.single #primary .entry-header h1.entry-title {
			margin-bottom: 0;
		}
		.single .entry-header .entry-meta {
			display: none;
			height: 0;
		}
	<?php 
		endif; 
	?>
	
	<?php
		/* Fix post title margins on content list */
		if( ( get_theme_mod('loop-author-avatar-on', true) == false ) &&  
			( get_theme_mod('loop-author-name-on', true) == false ) &&
			( get_theme_mod('loop-category-on', true) == false ) && 
			( get_theme_mod('loop-date-on', true) == false ) && 
			( get_theme_mod('loop-comment-on', true) == false ) &&
			( get_theme_mod('loop-view-on', true) == false ) ) : 			

	?>
		.content-loop .entry-title,
		.content-search .entry-title {
			margin-bottom: 0;
		}
	<?php 
		endif; 
	?>

	<?php if( get_theme_mod('single-indent-on', true) == true ) : ?>
		@media only screen and (min-width: 480px) {
			.entry-content p {
				text-indent: 2em;
			}
		}
	<?php endif; ?>

</style>

</head>

<body <?php body_class(); ?>>

<div id="page" class="site">

	<header id="masthead" class="site-header clear">

		<div id="primary-bar">

			<div class="container">

			<nav id="primary-nav" class="main-navigation">

				<?php 
					if ( has_nav_menu( 'primary' ) ) {
						wp_nav_menu( array( 'theme_location' => 'primary', 'menu_id' => 'primary-menu', 'menu_class' => 'sf-menu' ) );
					} else {
				?>

					<ul id="primary-menu" class="sf-menu">
						<li><a href="<?php echo home_url(); ?>/wp-admin/nav-menus.php"><?php echo __('请设置顶部菜单', 'daohang'); ?></a></li>
					</ul><!-- .sf-menu -->

				<?php } ?>

			</nav><!-- #primary-nav -->	

			<ul class="top-right">	
				
				<?php if( get_theme_mod('header-day-on', true) == true ) : ?>
					<li class="current-date">
						<?php echo date("Y年m月d日"); ?>
					</li>
				<?php endif; ?>

				<?php if( get_theme_mod('header-date-on', true) == true ) : ?>
					<li class="current-day">
						<?php echo "星期" . mb_substr( "日一二三四五六",date("w"),1,"utf-8" ); ?>					
					</li>
				<?php endif; ?>

				<?php 
					if( is_user_logged_in() ) {
				?>

					<li class="header-user">
						你好, <a href="<?php echo home_url(); ?>/wp-admin/"><?php echo wp_get_current_user()->user_login; ?></a>
					</li>

					<li class="header-logout">
						<a href="<?php echo wp_logout_url(); ?>" title="退出">退出</a>
					</li>

				<?php
					} else {
				?>

					<?php if( get_theme_mod('header-login-on', true) == true ) : ?>
						<li class="header-login">
							<a href="<?php echo wp_login_url(); ?>" title="登录">登录</a>
						</li>
					<?php endif; ?>

					<?php if( get_theme_mod('header-reg-on', true) == true ) : ?>
						<li class="header-register">
							<a href="<?php echo wp_registration_url(); ?>" title="注册">注册</a>
						</li>
					<?php endif; ?>	

				<?php
					}
				?>											
			</ul><!-- .top-right -->

			</div><!-- .container -->

		</div><!-- #primary-bar -->	

		<div class="site-start clear">

			<div class="container">

			<div class="site-branding">

	            <?php if (has_custom_logo()) { ?>

	                <div id="logo">
	                    <span class="helper"></span>
	                    <?php the_custom_logo(); ?>
	                </div><!-- #logo -->

	            <?php } else { ?>

	                <div class="site-title">
	                    <h1><a href="<?php echo esc_url( home_url() ); ?>"><?php bloginfo('name'); ?></a></h1>
	                </div><!-- .site-title -->

	            <?php } ?>

				<?php if( get_theme_mod('site-desc-on',true) == true ) : ?>
				<div class="site-desc">
					<?php 
						if( get_theme_mod('header-slogan2','新一代网站模版') != null ) {
							$header_slogan_layout = 'has-line2';
						} else {
							$header_slogan_layout = 'no-line2';
						}
					?>
					<div class="line1 <?php echo $header_slogan_layout; ?>"><?php echo get_theme_mod('header-slogan1','网址导航主题'); ?></div>
					<div class="line2"><?php echo get_theme_mod('header-slogan2','新一代网站模版'); ?></div>
				</div><!-- .site-desc -->
				<?php endif; ?>	            
				
			</div><!-- .site-branding -->

			<?php if ( get_theme_mod('header-search-on', true) ) : ?>

				<div class="header-search">
					<form action="https://www.baidu.com/baidu" target="_blank">
					<input name=tn type=hidden value=baidu>
					<input class="search-input" type=text name=word size=30 placeholder="百度一下，你就知道">
					<input class="search-submit" type="submit" value="百度一下">
					</form>
				</div><!-- .header-search -->

			<?php endif; ?>

			<div class="header-icons">
				<?php if ( get_theme_mod('header-mobile-on', true) ) : ?>
				<div class="header-mobile header-icon tooltip">
					    <span>手机版</span>
					    <div class="bottom-space">
						    <div class="bottom">
						        <img src="<?php echo get_theme_mod('site-url-qrcode', get_template_directory_uri() . '/assets/img/site-url-qrcode.png'); ?>" alt="手机扫一扫打开网站"/>
						        <h3>扫一扫打开手机网站</h3>
						        <i></i>
						    </div>
						</div>
				</div>
				<?php endif; ?>
				
				<?php if ( get_theme_mod('header-weixin-on', true) ) : ?>				
				<div class="header-weixin header-icon tooltip">
					    <span>公众号</span>
					    <div class="bottom-space">
						    <div class="bottom">
						        <img src="<?php echo get_theme_mod('weixin-qrcode', get_template_directory_uri() . '/assets/img/weixin-qrcode.png'); ?>" alt="微信扫一扫关注我们"/>
						        <h3>微信扫一扫关注我们</h3>
						        <i></i>
						    </div>
						</div>
				</div>
				<?php endif; ?>

				<?php if ( get_theme_mod('header-weibo-on', true) ) : ?>
				<div class="header-weibo header-icon">
					<a href="<?php echo get_theme_mod('weibo-url', 'https://weibo.com/zhutibaba'); ?>" target="_blank">微博</a>
				</div>		
				<?php endif; ?>										
			</div><!-- .header-icons -->
			
			</div><!-- .container -->

		</div><!-- .site-start -->


			<?php 
				if ( has_nav_menu( 'main-1' ) ) {
			?>
				<nav class="main-nav container">
					<?php
						wp_nav_menu( array( 'theme_location' => 'main-1', 'menu_id' => 'main-1', 'menu_class' => 'main-menu' ) );
					?>
				</nav>
			<?php		
				} 																				
			?>			

		<?php if ( get_theme_mod('header-search-on', true) ) : ?>
			
			<span class="search-icon">
				<i class="fa fa-search"></i>
				<i class="fa fa-close"></i>			
			</span>

		<?php endif; ?>						

	</header><!-- #masthead -->

	<?php
		// Mobile Phone Menu
		$phone_cols = "";

		if ( get_theme_mod('phone-columns', 'choice-4') == 'choice-0') {
			$phone_cols = 'flexible-menu';
		}			
		if ( get_theme_mod('phone-columns', 'choice-4') == 'choice-1') {
			$phone_cols = 'phone_menu_col_1';
		}
		if ( get_theme_mod('phone-columns', 'choice-4') == 'choice-2') {
			$phone_cols = 'phone_menu_col_2';
		}
		if ( get_theme_mod('phone-columns', 'choice-4') == 'choice-3') {
			$phone_cols = 'phone_menu_col_3';
		}
		if ( get_theme_mod('phone-columns', 'choice-4') == 'choice-4') {
			$phone_cols = 'phone_menu_col_4';
		}
		if ( get_theme_mod('phone-columns', 'choice-4') == 'choice-5') {
			$phone_cols = 'phone_menu_col_5';
		}
		if ( get_theme_mod('phone-columns', 'choice-4') == 'choice-6') {
			$phone_cols = 'phone_menu_col_6';
		}
		if ( get_theme_mod('phone-columns', 'choice-4') == 'choice-7') {
			$phone_cols = 'phone_menu_col_7';
		}
		if ( get_theme_mod('phone-columns', 'choice-4') == 'choice-8') {
			$phone_cols = 'phone_menu_col_8';
		}

		// Tablet Menu
		$tablet_cols = "";

		if ( get_theme_mod('tablet-columns', 'choice-6') == 'choice-0') {
			$tablet_cols = 'flexible-menu';
		}			
		if ( get_theme_mod('tablet-columns', 'choice-6') == 'choice-1') {
			$tablet_cols = 'tablet_menu_col_1';
		}
		if ( get_theme_mod('tablet-columns', 'choice-6') == 'choice-2') {
			$tablet_cols = 'tablet_menu_col_2';
		}
		if ( get_theme_mod('tablet-columns', 'choice-6') == 'choice-3') {
			$tablet_cols = 'tablet_menu_col_3';
		}
		if ( get_theme_mod('tablet-columns', 'choice-6') == 'choice-4') {
			$tablet_cols = 'tablet_menu_col_4';
		}
		if ( get_theme_mod('tablet-columns', 'choice-6') == 'choice-5') {
			$tablet_cols = 'tablet_menu_col_5';
		}
		if ( get_theme_mod('tablet-columns', 'choice-6') == 'choice-6') {
			$tablet_cols = 'tablet_menu_col_6';
		}
		if ( get_theme_mod('tablet-columns', 'choice-6') == 'choice-7') {
			$tablet_cols = 'tablet_menu_col_7';
		}
		if ( get_theme_mod('tablet-columns', 'choice-6') == 'choice-8') {
			$tablet_cols = 'tablet_menu_col_8';
		}	

	?>

	<nav id="mobile-nav" class="mobile-nav  <?php echo $tablet_cols; ?> <?php echo $phone_cols; ?> clear">
		<?php 
			if ( has_nav_menu( 'mobile' ) ) {
				wp_nav_menu( array( 'theme_location' => 'mobile', 'menu_id' => 'mobile-menu', 'menu_class' => 'mobile-menu' ) );
			} else {
		?>
			<ul class="mobile-menu">
				<li><a href="<?php echo home_url();?>/wp-admin/nav-menus.php">请设置移动端导航菜单</a></li>
			</ul>		
		<?php
			}
		?>
	</nav>
	<div class="clear"></div>
		
	<div id="content" class="site-content site_container container clear">
