<?php

class daohang_Links_Widget extends WP_Widget {

	public function __construct() {
		$widget_ops = array('classname' => 'daohang_Links_Widget', 'description' => __( '以分类的形式展示链接。', 'daohang') );
        parent::__construct(false, $name = __('&raquo; 首页链接模块', 'daohang'), $widget_ops);
		$this->alt_option_name = 'daohang_Links_Widget';
	
    }
	
	function form($instance) {
		$title     		= isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$number    		= isset( $instance['number'] ) ? intval( $instance['number'] ) : 10;
		$row_num    		= isset( $instance['row_num'] ) ? intval( $instance['row_num'] ) : 5;		
		$cat   	        = isset( $instance['cat'] ) ? esc_attr( $instance['cat'] ) : '';
		$link_image			= isset( $instance['link_image'] ) ? (bool) $instance['link_image'] : true;	
		$link_desc			= isset( $instance['link_desc'] ) ? (bool) $instance['link_desc'] : true;		
		$link_bold			= isset( $instance['link_bold'] ) ? (bool) $instance['link_bold'] : true;			
		$new_tab			= isset( $instance['new_tab'] ) ? (bool) $instance['new_tab'] : true;					
	?>

	<p><?php _e('要显示此小工具，必须先从后台添加一些链接。', 'daohang'); ?></p>
	<p>
	<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('标题', 'daohang'); ?></label>
	<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'cat' ); ?>"><?php _e( '选择一个分类目录', 'daohang' ); ?></label>
		<select class="widefat" id="<?php echo $this->get_field_id( 'cat' ); ?>" name="<?php echo $this->get_field_name( 'cat' ); ?>" style="width:100%;">
			<?php $categories = get_terms( 'link_cat' ); ?>
			<option value="0"><?php _e( '所有分类目录 &hellip;', 'daohang' ); ?></option>
			<?php foreach( $categories as $category ) { ?>
				<option value="<?php echo esc_attr( $category->term_id ); ?>" <?php selected( $instance['cat'], $category->term_id ); ?>><?php echo esc_html( $category->name ); ?></option>
			<?php } ?>
		</select>
	</p>

	<p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( '要显示的链接数量', 'daohang' ); ?></label>
	<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo $number; ?>" size="3" /></p>

	<p><label for="<?php echo $this->get_field_id( 'row_num' ); ?>"><?php _e( '每行显示的链接数 (1到15)', 'daohang' ); ?></label>
	<input id="<?php echo $this->get_field_id( 'row_num' ); ?>" name="<?php echo $this->get_field_name( 'row_num' ); ?>" type="text" value="<?php echo $row_num; ?>" size="3" /></p>


	<p><input class="checkbox" type="checkbox" <?php checked( $new_tab ); ?> id="<?php echo $this->get_field_id( 'new_tab' ); ?>" name="<?php echo $this->get_field_name( 'new_tab' ); ?>" />
	<label for="<?php echo $this->get_field_id( 'new_tab' ); ?>"><?php _e( '在新标签页中打开链接', 'daohang' ); ?></label></p>

	<p><input class="checkbox" type="checkbox" <?php checked( $link_image ); ?> id="<?php echo $this->get_field_id( 'link_image' ); ?>" name="<?php echo $this->get_field_name( 'link_image' ); ?>" />
	<label for="<?php echo $this->get_field_id( 'link_image' ); ?>"><?php _e( '显示链接图标', 'daohang' ); ?></label></p>

	<p><input class="checkbox" type="checkbox" <?php checked( $link_desc ); ?> id="<?php echo $this->get_field_id( 'link_desc' ); ?>" name="<?php echo $this->get_field_name( 'link_desc' ); ?>" />
	<label for="<?php echo $this->get_field_id( 'link_desc' ); ?>"><?php _e( '显示链接说明', 'daohang' ); ?></label></p>	

	<p><input class="checkbox" type="checkbox" <?php checked( $link_bold ); ?> id="<?php echo $this->get_field_id( 'link_bold' ); ?>" name="<?php echo $this->get_field_name( 'link_bold' ); ?>" />
	<label for="<?php echo $this->get_field_id( 'link_bold' ); ?>"><?php _e( '将链接标题设为粗体', 'daohang' ); ?></label></p>	

	<?php
	}

	function update($new_instance, $old_instance) {
		$instance = $new_instance;
		$instance['title'] 			= strip_tags($new_instance['title']);
		$instance['number'] 		= strip_tags($new_instance['number']);
		$instance['row_num'] 		= strip_tags($new_instance['row_num']);		
		$instance['cat']   = (int) $new_instance['cat'];
		$instance['link_image'] 		= isset( $new_instance['link_image'] ) ? (bool) $new_instance['link_image'] : false;
		$instance['link_desc'] 		= isset( $new_instance['link_desc'] ) ? (bool) $new_instance['link_desc'] : false;		
		$instance['link_bold'] 		= isset( $new_instance['link_bold'] ) ? (bool) $new_instance['link_bold'] : false;
		$instance['new_tab'] 		= isset( $new_instance['new_tab'] ) ? (bool) $new_instance['new_tab'] : false;  
		if ( $instance['row_num'] >= 15 ) {
			$instance['row_num'] = 15;
		}
		if ( $instance['row_num'] <= 1 ) {
			$instance['row_num'] = 1;
		}	

		return $instance;
	}

	// display widget
	function widget($args, $instance) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		extract($args);

		$title 			= ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';
		$title 			= apply_filters( 'widget_title', $title, $instance, $this->id_base );
		$number 		= ( ! empty( $instance['number'] ) ) ? intval( $instance['number'] ) : 10;
		if ( ! $number ) {
			$number = 10;
		}	
		$row_num 		= ( ! empty( $instance['row_num'] ) ) ? intval( $instance['row_num'] ) : 5;
		if ( ! $row_num ) {
			$row_num = 5;
		}
											
		//$cat 		= isset( $instance['cat'] ) ? esc_attr($instance['cat']) : '';
		$link_image			= isset( $instance['link_image'] ) ? $instance['link_image'] : false;	
		$link_desc			= isset( $instance['link_desc'] ) ? $instance['link_desc'] : false;		
		$link_bold		= isset( $instance['link_bold'] ) ? $instance['link_bold'] : false;				
		$new_tab			= isset( $instance['new_tab'] ) ? $instance['new_tab'] : false;

		if ( $new_tab ) {
			$target = "_blank";
		} else {
			$target = "_self";
		}

		// Pull the selected category.
		$cat_id = isset( $instance['cat'] ) ? absint( $instance['cat'] ) : 0;

		// Get the category.
		$category = get_term( $cat_id );

		// Get the category archive link.
		$cat_link = get_category_link( $cat_id );

		// Limit to category based on user selected tag.
		if ( ! $cat_id == 0 ) {
			$args['cat'] = $cat_id;
		}
		
		if ( ! $cat_id == 0 ) {
			$args = array( 
				'post_type'      => 'links',
				//'posts_per_page' => ( ! empty( $instance['limit'] ) ) ? absint( $instance['limit'] ) : 5,
				'posts_per_page' => $number,
				//'cat' => $cat_id
				'tax_query' => array(
			        array (
			            'taxonomy' => 'link_cat',
			            'field' => 'id',
			            'terms' => $cat_id,
			        )
			    ),
			);  
		} else {
			$args = array( 
				'post_type'      => 'links',
				//'posts_per_page' => ( ! empty( $instance['limit'] ) ) ? absint( $instance['limit'] ) : 5,
				'posts_per_page' => $number
			);  	
		}		
		/*
		$links = new WP_Query( array(
			//'no_found_rows'       => true,
			//'post_status'         => 'publish',
			'post_type' 		  => 'links',
			'posts_per_page'	  => $number,
			'cat'		  => $cat_id
		) );
		*/
		$links = new WP_Query( $args );

		
		echo $args['before_widget'];

		if ($links->have_posts()) :
?>
			<div class="section-links">

			<?php
				if ( ( $title ) && ( $cat_id != 0 ) ) {
					echo '<h3 class="widget-title"><a target="_blank" href="' . esc_url( $cat_link ) . '">' . $instance['title'] . '</a></h3>';
				} elseif ( ( $title ) && ( $cat_id == 0 ) ) {
					echo '<h3 class="widget-title">' . $title . '</h3>';
				} elseif ( ( !$title ) && ( $cat_id == 0 ) ) {
					echo '';
				} else {
					echo '<h3 class="widget-title"><a target="_blank" href="' . esc_url( $cat_link ) . '">' . esc_attr( $category->name ) . '</a></h3>';
				}
			?>

				<?php //if ( $title ) echo $before_title . $title . $after_title; ?>

				<div class="section-links-wrap <?php echo 'row-num-' . $instance['row_num']; ?> <?php if ($instance['link_bold']) { echo 'link-bold'; } ?>">
				<?php while ( $links->have_posts() ) : $links->the_post(); ?>
					<?php $link_url = get_field('link_url'); ?>
					<?php 
						if ( get_field('link_image2') ) {
							$link_image = get_field('link_image2'); 
						} else {
							$link_image = get_field('link_image'); 
						}
					?>
					<?php $link_desc = get_field('link_desc'); ?>
						<div class="link-item <?php if ($link_image && $instance['link_image']) { echo 'link-image'; } ?> <?php if ($link_desc && $instance['link_desc']) { echo 'has-desc'; } else { echo "no-desc"; } ?>">
							<?php if ($link_url) : ?>
								<a target="<?php echo $target; ?>" href="<?php echo esc_url($link_url); ?>" rel="nofollow">
									<?php if ($link_image && $instance['link_image']) : ?>
										<img src="<?php echo $link_image; ?>" alt="<?php echo get_the_title(); ?>">
									<?php endif; ?>
									<div class="link-title"><?php the_title(); ?></div>
									<?php if ($link_desc && $instance['link_desc']) : ?>
									<div class="link-desc">
										<?php echo $link_desc; ?>
									</div>
									<?php endif; ?>
								</a>
							<?php endif; ?>
						</div><!-- .link-item -->
				<?php endwhile; ?>
				</div><!-- .section-link-wrap -->
			</div><!-- .section-link -->

	<?php
		echo $args['after_widget'];
		wp_reset_postdata();
		wp_reset_query();
		endif;
	}
	
}