<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package daohang
 */

get_header(); 

if ( function_exists( 'daohang_set_post_views' ) ) :
	daohang_set_post_views(get_the_ID());
endif;
?>

	<div id="primary" class="content-area">

		<?php if( get_theme_mod('single-top-ad','') ) { ?>
			<div class="single-top-ad">
				<?php echo get_theme_mod('single-top-ad'); ?>
			</div>
		<?php } ?>

		<?php if( get_theme_mod('single-breadcrumbs-on', true) == true ) : ?>
	
			<div class="single-breadcrumbs">
				<a href="<?php echo home_url(); ?>">首页</a> <i class="fa fa-angle-right"></i> <?php daohang_first_category(); ?> <i class="fa fa-angle-right"></i> <?php the_title(); ?>
			</div>
		
		<?php endif; ?>

		<main id="main" class="site-main" >

		<?php
		while ( have_posts() ) : the_post();

			get_template_part( 'template-parts/content', 'single' );

			// the_post_navigation();

			get_template_part( 'template-parts/content', 'related' );

			// If comments are open or we have at least one comment, load up the comment template.
			if ( get_theme_mod('close-comments-on', false) == false ) {
				if ( comments_open() || get_comments_number() ) :
				comments_template();
				endif;
			}

		endwhile; // End of the loop.
		?>
		</main><!-- #main -->
	</div><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>
