<?php

/**
 * The template for displaying archive links.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package daohang
 */

get_header();

$link_term = get_queried_object();

$cat_link_bold = get_field('cat_link_bold', $link_term);
$cat_link_image = get_field('cat_link_image', $link_term);
$cat_link_desc = get_field('cat_link_desc', $link_term);
$cat_new_tab = get_field('cat_new_tab', $link_term);
$cat_row_num = get_field('cat_row_num', $link_term);

if ($cat_link_bold) {
    $cat_link_bold = true;
}

if ($cat_link_image) {
    $cat_link_image = true;
}

if ($cat_link_desc) {
    $cat_link_desc = true;
}

if (!$cat_row_num) {
    $cat_row_num = 5;
}

if ( $cat_new_tab ) {
    $target = "_blank";
} else {
    $target = "_self";
}          
?>

<?php $term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) ); ?>

<?php 
  query_posts(array( 
      'post_type' => 'links', 
      'link_cat' => $term->slug,
      'posts_per_page' => -1
    )
  ); 
?>

    <div id="primary" class="content-area full-width clear">
        
    <main id="main" class="site-main clear">

    <div class="section-links">
      <div class="widget-title">
        <?php
          echo "<h1>";
            single_cat_title('');
          echo "</h1>";
        ?>          
      </div>
      <div class="section-links-wrap <?php echo 'row-num-' . $cat_row_num; ?> <?php if ($cat_link_bold) { echo 'link-bold'; } ?>">

    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

          <?php
  
          ?>

          <?php $link_url = get_field('link_url'); ?>
          <?php $link_image = get_field('link_image'); ?>
          <?php $link_desc = get_field('link_desc'); ?>

            <div class="link-item <?php if ($link_image && $cat_link_image) { echo 'link-image'; } ?> <?php if ($link_desc && $cat_link_desc) { echo 'has-desc'; } else { echo "no-desc"; } ?>">
              <?php if ($link_url) : ?>
                <a target="<?php echo $target; ?>" href="<?php echo esc_url($link_url); ?>" rel="nofollow">
                  <?php if ($link_image && $cat_link_image) : ?>
                    <img src="<?php echo $link_image; ?>" alt="<?php echo get_the_title(); ?>">
                  <?php endif; ?>
                  <div class="link-title"><?php the_title(); ?></div>
                  <?php if ($link_desc && $cat_link_desc) : ?>
                  <div class="link-desc">
                    <?php echo $link_desc; ?>
                  </div>
                  <?php endif; ?>
                </a>
              <?php endif; ?>
            </div><!-- .link-item -->

    <?php endwhile; endif; ?>
    </div><!-- .section-links-wrap -->
    </div><!-- .section-links -->

    </main><!-- #main -->
  </div><!-- #primary -->

<?php get_footer(); ?>