<?php
		
	if ( get_theme_mod('related-posts-on', true) ) : 
	 
	// Get the taxonomy terms of the current page for the specified taxonomy.
	$terms = wp_get_post_terms( get_the_ID(), 'category', array( 'fields' => 'ids' ) );

	// Bail if the term empty.
	if ( empty( $terms ) ) {
		return;
	}

	// Posts query arguments.
	$query = array(
		'post__not_in' => array( get_the_ID() ),
		'tax_query'    => array(
			array(
				'taxonomy' => 'category',
				'field'    => 'id',
				'terms'    => $terms,
				'operator' => 'IN'
			)
		),
		'posts_per_page' => get_theme_mod('related-num','5'),
		'post_type'      => 'post',
	);

	// Allow dev to filter the query.
	$args = apply_filters( 'daohang_related_posts_args', $query );

	// The post query
	$related = new WP_Query( $args );

	if ( $related->have_posts() ) : $i = 1; ?>

		<div class="entry-related clear">
			<h3 class="section-title"><?php esc_html_e('为您推荐', 'daohang'); ?></h3>
			<div id="recent-content" class="content-loop clear">
				<?php while ( $related->have_posts() ) : $related->the_post(); ?>

					<?php 
						get_template_part('template-parts/content', 'loop');
					?>

				<?php $i++; endwhile; ?>
			</div><!-- .content-loop -->
		</div><!-- .entry-related -->

	<?php endif;

	// Restore original Post Data.
	wp_reset_postdata();

	endif;
?>