<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDefaultImage extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('default_image', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->string('type', 50)->nullable()->comment('类型');
            $table->string('image', 100)->nullable()->comment('图片');
            $table->tinyInteger('visible')->nullable()->comment('显示');
            $table->integer('sort')->nullable()->comment('排序');
            $table->string('title', 50)->nullable()->comment('标题');

            $table->index('type');

        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
