<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateModulePrizePool extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('module_prize_pool', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->tinyInteger('enable')->nullable()->comment('开启');
            $table->integer('memberUserId')->nullable()->comment('用户ID');

            $table->string('name', 100)->nullable()->comment('奖品名称');
            $table->string('cover', 100)->nullable()->comment('奖品图片');

            /** @see \App\Modules\PrizePool\PrizeType */
            $table->tinyInteger('type')->nullable()->comment('奖品类型');

            /** @see \App\Modules\PrizePool\RedbagType */
            $table->tinyInteger('redbagType')->nullable()->comment('红包');
            $table->decimal('redbagMax', 20, 2)->nullable()->comment('红包');
            $table->decimal('redbagMin', 20, 2)->nullable()->comment('红包');
            $table->decimal('redbagFixed', 20, 2)->nullable()->comment('红包');

            /** @see \App\Modules\PrizePool\CreditType */
            $table->tinyInteger('creditType')->nullable()->comment('积分');
            $table->integer('creditMax')->nullable()->comment('积分');
            $table->integer('creditMin')->nullable()->comment('积分');
            $table->integer('creditFixed')->nullable()->comment('积分');

            $table->index('memberUserId');

        });

        Schema::create('module_prize_pool_code', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('prizeId')->nullable()->comment('奖品ID');

            $table->string('no', 100)->nullable()->comment('卡号');
            $table->string('secret', 100)->nullable()->comment('卡密');
            $table->string('expire', 100)->nullable()->comment('过期');

            $table->index('prizeId');

        });

        Schema::create('module_prize_pool_drawn', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('memberUserId')->nullable()->comment('商户ID');
            $table->integer('userId')->nullable()->comment('用户ID');
            $table->integer('prizeId')->nullable()->comment('奖品ID');

            /** @see \App\Modules\PrizePool\ActivityType */
            $table->string('activityType', 50)->nullable()->comment('活动');
            $table->integer('activityId')->nullable()->comment('活动ID');

            $table->string('checkCode', 50)->nullable()->comment('核销码');

            $table->string('name', 100)->nullable()->comment('奖品名称');
            $table->string('cover', 100)->nullable()->comment('奖品图片');

            /** @see \App\Modules\PrizePool\PrizeType */
            $table->tinyInteger('type')->nullable()->comment('奖品类型');

            /** @see \App\Modules\PrizePool\RedbagType */
            $table->tinyInteger('redbagType')->nullable()->comment('红包');
            $table->decimal('redbagValue', 20, 2)->nullable()->comment('红包');

            /** @see \App\Modules\PrizePool\CreditType */
            $table->tinyInteger('creditType')->nullable()->comment('积分');
            $table->integer('creditValue')->nullable()->comment('积分');

            $table->string('codeNo', 100)->nullable()->comment('兑换码');
            $table->string('codeSecret', 100)->nullable()->comment('兑换密码');
            $table->string('codeExpire', 100)->nullable()->comment('过期');

            /** @see \App\Modules\PrizePool\DrawnPhysicalStatus */
            $table->tinyInteger('physicalStatus')->nullable()->comment('实物状态');

            $table->string('userName', 100)->nullable()->comment('姓名');
            $table->string('userAddress', 100)->nullable()->comment('地址');
            $table->string('userPhone', 100)->nullable()->comment('手机');

            $table->unique(['memberUserId', 'checkCode']);
            $table->index('userId');

        });

        Schema::create('module_prize_pool_activity_prize', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            /** @see \App\Modules\PrizePool\ActivityType */
            $table->string('activityType', 50)->nullable()->comment('兑换码');
            $table->integer('activityId')->nullable()->comment('兑换码');

            $table->integer('prizeId')->nullable()->comment('奖品ID');
            $table->decimal('rate', 20, 2)->nullable()->comment('概率');
            /** @see \App\Modules\PrizePool\AmountType */
            $table->tinyInteger('amountType')->nullable()->comment('数量类型');
            $table->integer('amount')->nullable()->comment('数量');

            $table->index(['activityType', 'activityId']);
            $table->index(['prizeId']);

        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
