@extends('theme.default.pc.member.frame')

@section('pageTitleMain','奖品中心')

@section('headScript')
    <link rel="stylesheet" href="@assets('assets/vue/iview/iview.css')">
    @parent
    <script src="@assets('assets/vue/vue.js')"></script>
    <script src="@assets('assets/vue/iview/iview.js')"></script>
@endsection

@section('memberBreadcrumb')
    <ul class="uk-breadcrumb">
        <li><a href="/member">管理首页</a></li>
        <li><a href="/module/manage/prize_pool">奖品中心</a></li>
        <li><a href="/module/manage/prize_pool_prize">奖品管理</a></li>
        <li class="uk-active"><span>奖品编辑</span></li>
    </ul>
@endsection

@section('bodyScript')
    @parent
    <script>
        $(function () {
            var app = null;
            var data = {
                name:@jsonString($prize['name']),
                enable:@jsonBoolean($prize['enable']),
                cover:@jsonString($prize['cover']),
                type:@jsonNumber($prize['type']),
                redbagType:@jsonNumber($prize['redbagType']),
                redbagFixed:@jsonString($prize['redbagFixed']),
                redbagMin:@jsonString($prize['redbagMin']),
                redbagMax:@jsonString($prize['redbagMax']),
                creditType:@jsonNumber($prize['creditType']),
                creditFixed:@jsonString($prize['creditFixed']),
                creditMin:@jsonString($prize['creditMin']),
                creditMax:@jsonString($prize['creditMax']),
            };
            var init = function () {
                $('[data-image-widget]').on('image-widget.change',function (event,value) {
                    if(app){
                        app.cover = value;
                    }
                });
                $('[data-image-widget]').imageWidget().val(data.cover);
            };
            var methods = {
                save:function () {
                    window.api.dialog.loadingOn();
                    var data = $.extend({},this.$data);
                    $.post('?',data,function (res) {
                        window.api.dialog.loadingOff();
                        window.api.base.defaultFormCallback(res);
                    });
                }
            };
            Vue.use(window.iview, {
                size: 'small',
            });
            app = new Vue({
                el: '#app',
                data:data,
                methods:methods,
                mounted:function () {
                    setTimeout(function () {
                        init();
                    },100);
                }
            });
        });
    </script>
@endsection

@section('memberContent')
    <div id="app" v-cloak>
        <div class="pb pb-module-panel">
            <div class="head">
                <h2>奖品中心</h2>
            </div>
            <div class="body">

                <i-form :label-width="100">
                    <Form-item label="奖品名称">
                        <i-input v-model="name"></i-input>
                    </Form-item>
                    <Row>
                        <i-col span="12">
                            <Form-item label="图标">
                                <div data-image-widget>
                                    <input type="hidden" name="cover" data-image value="" />
                                    <span class="image" style="background-image:url({{\TechSoft\Laravel\Assets\AssetsUtil::fix('assets/lib/img/none.png')}});"></span>
                                    <span class="add"><i class="uk-icon-plus"></i></span>
                                    <span class="delete"><i class="uk-icon-remove"></i></span>
                                </div>
                            </Form-item>
                        </i-col>
                        <i-col span="12">
                            <Form-item label="启用">
                                <i-switch v-model="enable"></i-switch>
                            </Form-item>
                        </i-col>
                    </Row>
                    <Form-item label="奖品类型">
                        <Radio-group v-model="type">
                            @foreach(\App\Modules\PrizePool\PrizeType::getList() as $k=>$v)
                                <Radio :label="{{$k}}">{{$v}}</Radio>
                            @endforeach
                        </Radio-group>
                    </Form-item>
                    <Row v-show="type=={{\App\Modules\PrizePool\PrizeType::REDBAG}}">
                        <i-col span="12">
                            <Form-item label="红包类型">
                                <Radio-group v-model="redbagType">
                                    @foreach(\App\Modules\PrizePool\RedbagType::getList() as $k=>$v)
                                        <Radio :label="{{$k}}">{{$v}}</Radio>
                                    @endforeach
                                </Radio-group>
                            </Form-item>
                        </i-col>
                    </Row>
                    <Row v-show="type=={{\App\Modules\PrizePool\PrizeType::REDBAG}} && redbagType=={{\App\Modules\PrizePool\RedbagType::FIXED}}">
                        <i-col span="12">
                            <Form-item label="红包金额">
                                <i-input v-model="redbagFixed"></i-input>
                            </Form-item>
                        </i-col>
                    </Row>
                    <Row v-show="type=={{\App\Modules\PrizePool\PrizeType::REDBAG}} && redbagType=={{\App\Modules\PrizePool\RedbagType::RANDOM}}">
                        <i-col span="12">
                            <Form-item label="红包金额">
                                <Row>
                                    <i-col span="11">
                                        <i-input v-model="redbagMin"></i-input>
                                    </i-col>
                                    <i-col span="2" style="text-align: center">
                                        -
                                    </i-col>
                                    <i-col span="11">
                                        <i-input v-model="redbagMax"></i-input>
                                    </i-col>
                                </Row>

                            </Form-item>
                        </i-col>
                    </Row>
                    <Row v-show="type=={{\App\Modules\PrizePool\PrizeType::CREDIT}}">
                        <i-col span="12">
                            <Form-item label="积分类型">
                                <Radio-group v-model="creditType">
                                    @foreach(\App\Modules\PrizePool\CreditType::getList() as $k=>$v)
                                        <Radio :label="{{$k}}">{{$v}}</Radio>
                                    @endforeach
                                </Radio-group>
                            </Form-item>
                        </i-col>
                    </Row>
                    <Row v-show="type=={{\App\Modules\PrizePool\PrizeType::CREDIT}} && creditType=={{\App\Modules\PrizePool\CreditType::FIXED}}">
                        <i-col span="12">
                            <Form-item label="积分值">
                                <i-input v-model="creditFixed"></i-input>
                            </Form-item>
                        </i-col>
                    </Row>
                    <Row v-show="type=={{\App\Modules\PrizePool\PrizeType::CREDIT}} && creditType=={{\App\Modules\PrizePool\CreditType::RANDOM}}">
                        <i-col span="12">
                            <Form-item label="积分值">
                                <Row>
                                    <i-col span="11">
                                        <i-input v-model="creditMin"></i-input>
                                    </i-col>
                                    <i-col span="2" style="text-align: center">
                                        -
                                    </i-col>
                                    <i-col span="11">
                                        <i-input v-model="creditMax"></i-input>
                                    </i-col>
                                </Row>

                            </Form-item>
                        </i-col>
                    </Row>
                    <Row v-show="type=={{\App\Modules\PrizePool\PrizeType::CODE}}">
                        <i-col span="12">
                            <Form-item label="兑换码说明">
                                兑换码在创建奖品后批量导入
                            </Form-item>
                        </i-col>
                    </Row>
                </i-form>
            </div>
        </div>

        <div style="height:70px;"></div>
        <div class="pb pb-module-panel pb-module-panel-bottom-fixed">
            <div class="body">
                <button id="save" class="uk-button uk-button-primary uk-width-1-1" @click="save()">保存</button>
            </div>
        </div>
    </div>
@endsection