<?php
/**
 * 源码名：caozha-comment（功能强大的原生PHP评论系统）
 * Copyright © 2020 草札 （草札官网：http://caozha.com）
 * 基于木兰宽松许可证 2.0（Mulan PSL v2）免费开源，您可以自由复制、修改、分发或用于商业用途，但需保留作者版权等声明。详见开源协议：http://license.coscl.org.cn/MulanPSL2
 * caozha-comment (Software Name) is licensed under Mulan PSL v2. Please refer to: http://license.coscl.org.cn/MulanPSL2
 * Github：https://github.com/cao-zha/caozha-comment   or   Gitee：https://gitee.com/caozha/caozha-comment
 */

session_start();

function getAuthImage($text) {
    $im_x = 160;
    $im_y = 40;
    $im = imagecreatetruecolor($im_x,$im_y);
    $text_c = ImageColorAllocate($im, mt_rand(0,100),mt_rand(0,100),mt_rand(0,100));
//    $tmpC0=mt_rand(100,255);
//    $tmpC1=mt_rand(100,255);
//    $tmpC2=mt_rand(100,255);
    $tmpC0=228;
    $tmpC1=218;
    $tmpC2=225;
    $buttum_c = ImageColorAllocate($im,$tmpC0,$tmpC1,$tmpC2);
    imagefill($im, 16, 13, $buttum_c);

    $font = realpath('./font/t1.ttf');

    for ($i=0;$i<strlen($text);$i++)
    {
        $tmp =substr($text,$i,1);
        $array = array(-1,1);
        $p = array_rand($array);
        $an = $array[$p]*mt_rand(1,10);//角度
        $size = 30;
        imagettftext($im, $size, $an, 10+$i*$size, 35, $text_c, $font, $tmp);
    }


    $distortion_im = imagecreatetruecolor ($im_x, $im_y);

    imagefill($distortion_im, 16, 13, $buttum_c);
    for ( $i=0; $i<$im_x; $i++) {
        for ( $j=0; $j<$im_y; $j++) {
            $rgb = imagecolorat($im, $i , $j);
            if( (int)($i+20+sin($j/$im_y*2*M_PI)*10) <= imagesx($distortion_im)&& (int)($i+20+sin($j/$im_y*2*M_PI)*10) >=0 ) {
                imagesetpixel ($distortion_im, (int)($i+10+sin($j/$im_y*2*M_PI-M_PI*0.1)*4) , $j , $rgb);
            }
        }
    }
    //加入干扰象素;
    $count = 1800;//干扰像素的数量
    for($i=0; $i<$count; $i++){
        $randcolor = ImageColorallocate($distortion_im,mt_rand(0,255),mt_rand(0,255),mt_rand(0,255));
        imagesetpixel($distortion_im, mt_rand()%$im_x , mt_rand()%$im_y , $randcolor);
    }

    $rand = mt_rand(5,30);
    $rand1 = mt_rand(15,25);
    $rand2 = mt_rand(5,10);
    for ($yy=$rand; $yy<=+$rand+2; $yy++){
        for ($px=-80;$px<=80;$px=$px+0.1)
        {
            $x=$px/$rand1;
            if ($x!=0)
            {
                $y=sin($x);
            }
            $py=$y*$rand2;

            imagesetpixel($distortion_im, $px+80, $py+$yy, $text_c);
        }
    }

    //设置文件头;
    Header("Content-type: image/JPEG");

    //以PNG格式将图像输出到浏览器或文件;
    ImagePNG($distortion_im);

    //销毁一图像,释放与image关联的内存;
    ImageDestroy($distortion_im);
    ImageDestroy($im);
}

function make_rand($length="32"){//验证码文字生成函数
    $str="0123456789";
    $result="";
    for($i=0;$i<$length;$i++){
        $num[$i]=rand(0,8);
        $result.=$str[$num[$i]];
    }
    return $result;
}



// 获得任意位数的随机码
function get_randnum($len=4,$ext_num_type=4) {

    $an1 = 'abcdefghijkmnpqrstwxy';

    $an2 = 'ABCDEFGHJKLMNPQRSWXY';

    $an3 = '234567';
    $randnum="";

    if ($ext_num_type == '') {
        $str = $an1.$an2.$an3;
    }elseif ($ext_num_type == 1){
        $str = $an1;
    }elseif ($ext_num_type == 2){
        $str = $an2;
    }elseif ($ext_num_type == 3){
        $str = $an3;
    }elseif ($ext_num_type == 4){
        $str = $an2.$an3;
    }elseif ($ext_num_type == 5){
        $str = $an1.$an3;
    }elseif ($ext_num_type == 6){
        $str = $an1.$an2;
    }

    for ($i = 0; $i < $len; $i++) {

        $start = rand(1,strlen($str) - 1);

        $randnum .= substr($str,$start,1);

    }
    return($randnum);
}


//输出调用
$checkcode = get_randnum(4);//make_rand(4);
$checkcode_md5=md5("caozha_".strtolower($checkcode)."po-E$*5p98&$#o2");
header('P3P: CP=CAO PSA OUR');
$_SESSION["user_captcha"]=$checkcode_md5;
getAuthImage($checkcode);