<?php
 namespace Module\ConfigSite\Admin\Controller; use Illuminate\Routing\Controller; use Illuminate\Support\Facades\Mail; use Illuminate\Support\Facades\View; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Core\Input\Response; use ModStart\Core\RateLimit\RateLimitUtil; use ModStart\Core\Util\RedisUtil; use ModStart\Form\Form; use Module\Vendor\Sms\SmsSender; use Module\Vendor\SoftApi\SoftApiUtil; class ConfigController extends Controller { public function site(AdminConfigBuilder $builder) { $builder->pageTitle('基础设置'); $builder->image('siteLogo', '网站Logo'); $builder->text('siteName', '网站名称'); $builder->text('siteSlogan', '网站副标题'); $builder->text('siteDomain', '网站域名'); $builder->text('siteKeywords', '网站关键词'); $builder->textarea('siteDescription', '网站描述'); $builder->text('siteBeian', '备案编号'); $builder->image('siteFavIco', '网站ICO'); $builder->color('sitePrimaryColor', '网站主色调'); return $builder->perform(); } public function visit(AdminConfigBuilder $builder) { $builder->pageTitle('访问设置'); $builder->textarea('systemCounter', 'head访问统计代码'); $builder->textarea('systemCounterBody', 'body访问统计代码'); $builder->text('systemCdnUrl', '网站加速CDN')->help('如 http://cdn.example.com/，以 / 结尾')->rules('regex:/\\/$/i'); $builder->formClass('wide-2'); return $builder->perform(); } public function email(AdminConfigBuilder $builder) { $builder->pageTitle('邮箱配置'); $builder->switch('systemEmailEnable', '开启邮件发送'); $builder->text('systemEmailSmtpServer', 'SMTP服务器地址'); $builder->switch('systemEmailSmtpSsl', 'SMTP是否为SSL'); $builder->text('systemEmailSmtpUser', 'SMTP用户'); $builder->text('systemEmailSmtpPassword', 'SMTP密码'); $builder->formClass('wide'); return $builder->perform(); } public function emailTest(AdminConfigBuilder $builder) { $builder->pageTitle('邮件发送测试'); $builder->text('email', '测试接收邮箱')->rules('required'); $builder->formClass('wide'); return $builder->perform(null, function (Form $form) { $data = $form->dataForming(); $email = $data['email']; $config = modstart_config(); config([ 'mail' => [ 'driver' => 'smtp', 'host' => $config->getWithEnv('systemEmailSmtpServer'), 'port' => $config->getWithEnv('systemEmailSmtpSsl', false) ? 465 : 25, 'encryption' => $config->getWithEnv('systemEmailSmtpSsl', false) ? 'ssl' : 'tls', 'from' => array('address' => $config->getWithEnv('systemEmailSmtpUser'), 'name' => $config->get('siteName') . ' @ ' . $config->get('siteDomain')), 'username' => $config->getWithEnv('systemEmailSmtpUser'), 'password' => $config->getWithEnv('systemEmailSmtpPassword'), ] ]); $emailUserName = $email; $subject = '测试邮件'; try { Mail::send('module::ConfigSite.View.test', [], function ($message) use ($email, $emailUserName, $subject) { $message->to($email, $emailUserName)->subject($subject); }); } catch (\Exception $e) { return Response::generateError('邮件发送失败:(' . $e->getMessage() . ')'); } return Response::generateSuccess('测试邮件成功发送到' . $email); }); } public function visitLimit(AdminConfigBuilder $builder) { $builder->pageTitle('访问限制'); $builder->switch('systemVisitWhiteListEnable', '启用白名单控制'); $builder->textarea('systemVisitWhiteList', '访问白名单'); $builder->switch('systemVisitBlackListEnable', '启用黑名单控制'); $builder->textarea('systemVisitBlackList', '访问黑名单')->help('<p>一行一个，如</p>
<p>192.168.1.1</p>
<p>192.168.1.0/24</p>
<p><a href="javascript:;" data-dialog-request="visit_ips">查看访问IP</a></p>'); $builder->formClass('wide-2'); return $builder->perform(); } public function visitIps(AdminDialogPage $page) { if (!!RedisUtil::isEnable()) { return Response::send(-1, '访问IP需要依赖Redis'); } return $page->pageTitle('访问IP') ->body(View::make('module::ConfigSite.View.visitIps', [ 'ips' => RateLimitUtil::listVisitIps(), ])->render()); } public function sms(AdminConfigBuilder $builder) { $builder->pageTitle('短信设置'); $builder->switch('systemSmsEnable', '开启短信发送') ->help('<div>访问 <a href="' . SoftApiUtil::url() . '" target="_blank">' . SoftApiUtil::url() . '</a> 申请</div>'); $builder->radio('systemSmsSender', '发送类型') ->defaultValue(SmsSender::SOFT_API) ->options(SmsSender::getList([SmsSender::SOFT_API])) ->when(SmsSender::SOFT_API, function (Form $form) { $form->display('none', '通用短信接口')->help('访问 <a href="https://api.' . __BASE_SITE__ . '" target="_blank">https://api.' . __BASE_SITE__ . '</a> 申请短信服务'); $form->text('systemSmsSender_softApi_appId', 'AppId'); $form->text('systemSmsSender_softApi_appSecret', 'AppSecret'); $form->text('systemSmsSender_softApi_verify_templateId', '验证码模板ID')->help('验证码模板变量为 code'); }) ->when(SmsSender::ALIYUN, function (Form $form) { $form->text('systemSmsSender_aliyun_accessKeyId', 'AccessKeyId'); $form->text('systemSmsSender_aliyun_accessKeySecret', 'accessKeySecret'); $form->text('systemSmsSender_aliyun_signName', '短信签名'); $form->text('systemSmsSender_aliyun_verify_templateId', '验证码模板ID')->help('验证码模板变量为 code'); }); $builder->formClass('wide'); return $builder->perform(); } public function upload(AdminConfigBuilder $builder) { $builder->pageTitle('上传设置'); $builder->radio('uploadDriver', '上传类型') ->defaultValue('local') ->options([ 'local' => '本地存储', 'ossAliyun' => '阿里云存储', ]) ->when('ossAliyun', function (Form $form) { $form->text('uploadDriverDomain', '阿里云OSS域名')->help('如 http://cdn.example.com'); $form->text('uploadDriverAliyunAccessKeyId', '阿里云OSS AccessKeyId'); $form->text('uploadDriverAliyunAccessKeySecret', '阿里云OSS AccessKeySecret'); $form->text('uploadDriverAliyunEndpoint', '阿里云OSS Endpoint'); $form->text('uploadDriverAliyunBucket', '阿里云OSS Bucket'); }); $builder->formClass('wide-2'); return $builder->perform(); } }