<?php
 namespace Module\Event\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminPage; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextAjaxRequest; use Module\Event\Type\EventOrderItemStatus; use Module\Event\Type\EventOrderStatus; use Module\Member\Util\MemberCmsUtil; class OrderItemController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $builder) { $builder ->init('event_order_item') ->field(function ($builder) { $builder->id('id', 'ID')->editable(true); $builder->display('created_at', '创建时间')->editable(true); $builder->display('memberUserId', '用户')->hookRendering(function (AbstractField $field, $item, $index) { return MemberCmsUtil::showFromId($item->memberUserId); }); $builder->display('checkCode', '票号')->editable(true); $builder->type('status', '状态')->type(EventOrderItemStatus::class); $builder->display('_info', '订单信息')->hookRendering(function (AbstractField $field, $item, $index) { $event = ModelUtil::get('event', $item->eventId); return AutoRenderedFieldValue::makeView('module::Event.View.admin.orderItem.info', [ 'event' => $event, 'item' => $item, ]); })->width(300); $builder->display('_field', '报名信息')->hookRendering(function (AbstractField $field, $item, $index) { $event = ModelUtil::get('event', $item->eventId); return AutoRenderedFieldValue::makeView('module::Event.View.admin.orderItem.field', [ 'event' => $event, 'item' => $item, ]); })->width(300); }) ->gridFilder(function (GridFilter $filter) { $filter->eq('id', L('ID')); $filter->eq('status', '状态')->select(EventOrderStatus::class); $filter->fixScope()->where('orderStatus', EventOrderStatus::COMPLETED); }) ->disableCUD()->canShow(false)->canEdit(true) ->hookItemOperateRendering(function (ItemOperate $itemOperate) { $item = $itemOperate->item(); switch ($item->status) { case EventOrderItemStatus::WAIT_SIGN_IN: $itemOperate->prepend(TextAjaxRequest::primary('签到', action('\\' . __CLASS__ . '@signIn', ['_id' => $item->id]))); $itemOperate->prepend(TextAjaxRequest::danger('缺席', action('\\' . __CLASS__ . '@absent', ['_id' => $item->id]), '确认缺席？')); break; } }) ->title('活动订单'); } public function signIn() { AdminPermission::demoCheck(); ModelUtil::update('event_order_item', ['id' => CRUDUtil::id(), 'status' => EventOrderItemStatus::WAIT_SIGN_IN], ['status' => EventOrderItemStatus::COMPLETED] ); return Response::redirect(CRUDUtil::jsGridRefresh()); } public function absent() { AdminPermission::demoCheck(); ModelUtil::update('event_order_item', ['id' => CRUDUtil::id(), 'status' => EventOrderItemStatus::WAIT_SIGN_IN], ['status' => EventOrderItemStatus::ABSENT] ); return Response::redirect(CRUDUtil::jsGridRefresh()); } private function listForStatus($status) { $grid = $this->grid(); $grid->build(); $grid->filter(function (GridFilter $filter) use ($status) { $filter->clearFilter(); $filter->fixScope()->where('orderStatus', EventOrderStatus::COMPLETED); $filter->eq('id', L('ID')); $filter->fixScope()->where('status', $status); }); CRUDUtil::registerGridResource($grid, '\\' . __CLASS__); if (Request::isPost()) { return $grid->request(); } return app(AdminPage::class)->pageTitle(TypeUtil::name(EventOrderItemStatus::class, $status))->body($grid); } public function listWaitSignIn() { return $this->listForStatus(EventOrderItemStatus::WAIT_SIGN_IN); } public function listCompleted() { return $this->listForStatus(EventOrderItemStatus::COMPLETED); } public function listAbsent() { return $this->listForStatus(EventOrderItemStatus::ABSENT); } } 