<?php
 namespace Module\Event\Api\Controller; use Illuminate\Routing\Controller; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\IdUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Field\CustomField; use Module\Event\Constant\PayConstant; use Module\Event\Type\EventOrderItemStatus; use Module\Event\Type\EventOrderStatus; use Module\Event\Type\EventShowStatus; use Module\Event\Type\EventStatus; use Module\Member\Auth\MemberUser; use Module\PayCenter\Traits\PayCenterPerformTrait; class EventController extends Controller { use PayCenterPerformTrait; public function categories() { $categories = ModelUtil::all('event_category', ['pid' => 0], ['*'], ['sort', 'asc']); return Response::generateSuccessData($categories); } public function paginate() { $input = InputPackage::buildFromInput(); $page = $input->getPage(); $pageSize = 12; $option = []; $option['order'] = ['id', 'desc']; $option['where'] = []; $option['where']['showStatus'] = EventShowStatus::SHOW; if ($categoryId = $input->getInteger('categoryId')) { $option['where'] ['categoryId'] = $categoryId; } $keyword = $input->getTrimString('keywords'); if ($keyword) { $option['whereOperate'] = ['title', 'like', '%' . $keyword . '%']; } $paginateData = ModelUtil::paginate('event', $page, $pageSize, $option); $currentCategory = null; if ($categoryId) { $currentCategory = ModelUtil::get('event_category', ['id' => $categoryId]); } return Response::generateSuccessData([ 'page' => $page, 'pageSize' => $pageSize, 'records' => $paginateData['records'], 'total' => $paginateData['total'], 'currentCategory' => $currentCategory ]); } public function get() { $id = InputPackage::buildFromInput()->getInteger('id'); $event = ModelUtil::get('event', ['id' => $id]); if (empty($event)) { return Response::generate(-1, 'no record', null, '/'); } $event['_category'] = ModelUtil::get('event_category', ['id' => $event['categoryId']]); ModelUtil::decodeRecordJson($event, 'photos'); ModelUtil::decodeRecordJson($event, 'param'); CustomField::unbuildTableFieldRow($event); return Response::generateSuccessData($event); } public function submit() { $input = InputPackage::buildFromInput(); $id = $input->getInteger('id'); BizException::throwsIf('没有登录', !MemberUser::id()); $event = ModelUtil::get('event', ['id' => $id]); BizException::throwsIf('记录不存在', !$event); for ($i = 1; $i < 5; $i++) { ModelUtil::decodeRecordJson($event, 'fieldCustom' . $i); } if ($event['status'] != EventStatus::APPLYING) { return Response::generate(-1, '当前状态不能报名'); } if ($event['applyTimeLimit'] && (time() < strtotime($event['applyStartTime']) || time() > strtotime($event['applyEndTime']))) { return Response::generate(-1, '已经不能报名'); } $eventOrderItem = []; for ($i = 1; $i <= 5; $i++) { if (empty($event['fieldCustom' . $i])) { continue; } $eventOrderItem['fieldCustom' . $i] = $input->getTrimString('fieldCustom' . $i); if (empty($eventOrderItem['fieldCustom' . $i])) { return Response::generate(-1, $event['fieldCustom' . $i]['title'] . '不能为空'); } } try { ModelUtil::transactionBegin(); $event = ModelUtil::getWithLock('event', ['id' => $id]); if ($event['applyNumberLimit']) { $payedTotal = ModelUtil::count('event_order_item', ['eventId' => $event['id'], 'orderStatus' => EventOrderStatus::WAIT_PAY]); $unpayedTotal = ModelUtil::count('event_order_item', ['eventId' => $event['id'], 'orderStatus' => EventOrderStatus::COMPLETED]); if ($payedTotal + $unpayedTotal >= $event['applyNumberMax']) { ModelUtil::transactionCommit(); return Response::generate(-1, '报名人数已满'); } } $order = []; $order['sn'] = IdUtil::generateSN(); $order['memberUserId'] = MemberUser::id(); $order['status'] = EventOrderStatus::WAIT_PAY; $order['totalFee'] = $event['price']; $order['payFee'] = $event['price']; $order = ModelUtil::insert('event_order', $order); $eventOrderItem['memberUserId'] = MemberUser::id(); $eventOrderItem['orderId'] = $order['id']; $eventOrderItem['eventId'] = $event['id']; $eventOrderItem['checkCode'] = RandomUtil::number(10); $eventOrderItem['orderStatus'] = $order['status']; $eventOrderItem['status'] = EventOrderItemStatus::WAIT_SIGN_IN; ModelUtil::insert('event_order_item', $eventOrderItem); ModelUtil::transactionCommit(); return $this->performSubmitOrder( PayConstant::EVENT_ORDER, $order['id'], $order['payFee'], '活动报名' ); } catch (\Exception $e) { ModelUtil::transactionRollback(); throw $e; } } } 