@extends($_viewFrame)

@if($currentCategory)
    @section('pageTitleMain',htmlspecialchars($currentCategory['title']))
@else
    @section('pageTitleMain','活动')
@endif

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-nav margin-top">
            <a class="item @if(!$currentCategory) active @endif" href="{{modstart_web_url('event')}}">全部</a>
            @foreach($categories as $category)
                <a class="item @if($currentCategory&&$currentCategory['id']==$category['id']) active @endif"
                   href="?categoryId={{$category['id']}}">{{$category['title']}}</a>
            @endforeach
        </div>

        @if($currentCategory && $currentCategory['summary'])
            <div class="tw-bg-white tw-rounded tw-p-2 margin-top ub-text-muted">
                {{$currentCategory['summary']}}
            </div>
        @endif

        <div class="ub-list-items margin-top">
            @if(empty($records))
                <div class="ub-empty">
                    <div class="icon">
                        <div class="iconfont icon-emptybox"></div>
                    </div>
                    <div class="text">暂无记录</div>
                </div>
            @else
                <div class="row">
                    @foreach($records as $record)
                        <div class="col-md-3 col-12">
                            <div class="item-video-cover">
                                <a class="ub-cover-5-3" href="{{modstart_web_url('event/'.$record['id'])}}" style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($record['cover'])}})"></a>
                                <a class="title" href="{{modstart_web_url('event/'.$record['id'])}}">{{$record['title']}}</a>
                                <div class="category">
                                    <div class="stat">
                                        <span class="ub-text-muted">
                                            <i class="iconfont icon-time"></i>
                                            {{\Carbon\Carbon::parse($record['time'])->toDateString()}}
                                        </span>
                                    </div>
                                    @if($record['status']==\Module\Event\Type\EventStatus::APPLYING)
                                        <span class="ub-text-success">正在报名</span>
                                    @else
                                        <div class="ub-text-muted">{{\ModStart\Core\Type\TypeUtil::name(\Module\Event\Type\EventStatus::class,$record['status'])}}</div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>

        <div class="ub-page">{!! $pageHtml !!}</div>

    </div>

@endsection





