@extends($_viewFrame)

@section('pageTitleMain',htmlspecialchars($event['title']))

{!! \ModStart\ModStart::js('asset/common/lazyLoad.js') !!}
@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('')}}">首页</a>
            <a href="{{modstart_web_url('event')}}">活动</a>
            <a class="active" href="{{modstart_web_url('event/'.$event['id'])}}">{{$event['title']}}</a>
        </div>

        <div class="tw-bg-white">
            <div class="row">
                <div class="col-md-6">
                    {!! \ModStart\ModStart::css('asset/vendor/swiper/swiper.css') !!}
                    {!! \ModStart\ModStart::js('asset/vendor/swiper/swiper_jquery.js') !!}
                    {!! \ModStart\ModStart::css('vendor/Banner/style/banner.css') !!}
                    <div class="ub-banner ratio-5-3" id="eventImage">
                        <div class="swiper-container">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide" style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($event['cover'])}});"></div>
                                @foreach($event['photos'] as $photo)
                                    <div class="swiper-slide" style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($photo)}});"></div>
                                @endforeach
                            </div>
                            <div class="swiper-pagination swiper-pagination-white"></div>
                            <div class="swiper-button-next swiper-button-white"></div>
                            <div class="swiper-button-prev swiper-button-white"></div>
                        </div>
                    </div>
                    <script>
                        $(function () {
                            var swiper = new Swiper('#eventImage .swiper-container', {
                                pagination: '.swiper-pagination',
                                paginationClickable: '.swiper-pagination',
                                nextButton: '.swiper-button-next',
                                prevButton: '.swiper-button-prev',
                                loop: true,
                                autoplay: 3000,
                                autoplayDisableOnInteraction: false
                            });
                            $('#eventImage').hover(function(){
                                swiper.stopAutoplay();
                            },function(){
                                swiper.startAutoplay();
                            });
                        });
                    </script>
                </div>
                <div class="col-md-6">
                    <div class="tw-p-6">
                        <h1>{{$event['title']}}</h1>
                        <div class="ub-pair">
                            <div class="name">
                                时间：
                            </div>
                            <div class="value">
                                {{\Carbon\Carbon::parse($event['time'])->format('Y-m-d H:i')}}
                            </div>
                        </div>
                        @if($event['applyTimeLimit'])
                            <div class="ub-pair">
                                <div class="name">
                                    报名开始：
                                </div>
                                <div class="value">
                                    {{\Carbon\Carbon::parse($event['applyStartTime'])->format('Y-m-d H:i')}}
                                </div>
                            </div>
                            <div class="ub-pair">
                                <div class="name">
                                    报名截止：
                                </div>
                                <div class="value">
                                    {{\Carbon\Carbon::parse($event['applyEndTime'])->format('Y-m-d H:i')}}
                                </div>
                            </div>
                        @endif
                        @if($event['applyNumberLimit'])
                            <div class="ub-pair">
                                <div class="name">
                                    报名限制：
                                </div>
                                <div class="value">
                                    {{$event['applyNumberMax']}}人
                                </div>
                            </div>
                        @endif
                        @foreach($event['param'] as $item)
                            <div class="ub-pair">
                                <div class="name">
                                    {{$item['name']}}：
                                </div>
                                <div class="value">
                                    {{$item['value']}}
                                </div>
                            </div>
                        @endforeach
                        <div class="ub-pair">
                            <div class="name">
                                费用：
                            </div>
                            <div class="value">
                                @if($event['price']>0)
                                    <div class="tw-font-bold ub-text-primary">￥{{$event['price']}}元</div>
                                @else
                                    <div class="tw-font-bold ub-text-primary">免费</div>
                                @endif
                            </div>
                        </div>
                        <div class="tw-pt-4">
                            @if($event['applyTimeLimit'] && time()<strtotime($event['applyStartTime']))
                                <div class="btn btn-lg ub-text-muted">报名未开始</div>
                            @elseif($event['applyTimeLimit'] && time()>strtotime($event['applyEndTime']))
                                <div class="btn btn-lg ub-text-muted">报名已截止</div>
                            @elseif($event['status']==\Module\Event\Type\EventStatus::NOT_START)
                                <div class="btn btn-lg ub-text-muted">报名未开始</div>
                            @elseif($event['status']==\Module\Event\Type\EventStatus::APPLYING)
                                @if(\Module\Member\Auth\MemberUser::id())
                                    <a class="btn btn-primary btn-lg" href="{{modstart_web_url('event/'.$event['id'].'/submit')}}">立即报名</a>
                                @else
                                    <a class="btn btn-primary btn-lg" href="{{modstart_web_url('login')}}?redirect={{urlencode('/event/'.$event['id'])}}">登录并报名</a>
                                @endif
                            @elseif($event['status']==\Module\Event\Type\EventStatus::APPLY_EXPIRED)
                                <div class="btn btn-lg ub-text-muted">已过期</div>
                            @elseif($event['status']==\Module\Event\Type\EventStatus::FINISHED)
                                <div class="btn btn-lg ub-text-muted">已结束</div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row margin-top">
            <div class="col-md-9">
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">详细描述</div>
                    </div>
                    <div class="body ub-html">
                        {!! \ModStart\Core\Util\HtmlUtil::replaceImageSrcToLazyLoad($event['content'],'data-src',true) !!}
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">{{$event['title']}}</div>
                    </div>
                    <div class="body ub-html">
                        {!! \ModStart\Core\Util\HtmlUtil::text2html($event['summary']) !!}
                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection





