<div class="tw-bg-white tw-mb-2 tw-rounded-sm tw-border tw-border-solid tw-border-gray-200">
    <div class="tw-p-2 tw-flex tw-border-gray-200 tw-border-solid tw-border-0 tw-border-b">
        <div class="tw-flex-grow">
            订单号：{{$item->sn}}
            <br>
            <span class="ub-text-muted"><i class="iconfont icon-time"></i> {{$item['created_at']}}</span>
        </div>
        <div class="status">
            @if($item['status']==\Module\Event\Type\EventOrderStatus::WAIT_PAY)
                <span class="ub-text-danger">等待付款</span>
            @elseif($item['status']==\Module\Event\Type\EventOrderStatus::EXPIRED)
                <span class="ub-text-muted">已过期</span>
            @elseif($item['status']==\Module\Event\Type\EventOrderStatus::COMPLETED)
                <span class="ub-text-success">已完成</span>
            @endif
        </div>
    </div>
    <div class="tw-p-2">
        @foreach($orderItems as $orderItem)
        <div class="tw-p-2 tw-flex">
            <div class="tw-w-16 tw-flex-shrink-0">
                <div class="ub-cover-1-1" style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($orderItem['_event']['cover'])}})"></div>
            </div>
            <div class="tw-flex-grow tw-pl-2">
                <div class="">{{$orderItem['_event']['title']}}</div>
                <div class="tw-text-gray-400 margin-top">
                    @foreach(\ModStart\Field\CustomField::buildRecordNameValue($orderItem['_event'],$orderItem) as $fieldItem)
                        <div>
                            {{$fieldItem['name']}}：{{$fieldItem['value']}}
                        </div>
                    @endforeach
                    <div class="tw-font-bold ub-text-primary margin-top">
                        票号：{{$orderItem['checkCode']}}
                        <a href="javascript:;" data-qrcode-content="{{$orderItem['checkCode']}}"><i class="iconfont icon-qr_code"></i></a>
                    </div>
                </div>
                @if(!empty($orderItem['_event']['applySuccessText']))
                    <div class="tw-bg-gray-100 tw-rounded tw-p-2 margin-top ub-html">
                        {!! $orderItem['_event']['applySuccessText'] !!}
                    </div>
                @endif
            </div>
            <div class="tw-w-16 tw-flex-shrink-0 tw-text-right">
                @if($orderItem['orderStatus']==\Module\Event\Type\EventOrderStatus::COMPLETED)
                    @if($orderItem['status']==\Module\Event\Type\EventOrderItemStatus::WAIT_SIGN_IN)
                        <div class="ub-text-warning">待签到</div>
                    @endif
                    @if($orderItem['status']==\Module\Event\Type\EventOrderItemStatus::ABSENT)
                        <div class="ub-text-danger">缺席</div>
                    @endif
                    @if($orderItem['status']==\Module\Event\Type\EventOrderItemStatus::COMPLETED)
                        <div class="ub-text-warning">已完成</div>
                    @endif
                @else
                    -
                @endif
            </div>
        </div>
        @endforeach
    </div>
    <div class="tw-p-2 tw-text-right tw-border-gray-200 tw-border-solid tw-border-0 tw-border-t">
        <div class="tw-float-left">
            支付价格：<span class="tw-font-bold ub-text-primary">￥{{$item->payFee}}</span> 元
        </div>
        @if($item['status']==\Module\Event\Type\EventOrderStatus::WAIT_PAY)
            <a href="{{modstart_web_url('event_order_member/pay/'.$item->id)}}" class="btn btn-primary">立即付款</a>
        @endif
        &nbsp;
    </div>
</div>

