<?php
 namespace Module\PayCenter\Api\Controller; use Illuminate\Routing\Controller; use Illuminate\Support\Facades\Session; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use Module\PayCenter\Type\PayType; use Module\PayCenter\Util\PayOrderUtil; use Module\PayCenter\Util\PayUtil; use Module\Vendor\Oauth\OauthType; class PayController extends Controller { public function info() { $input = InputPackage::buildFromInput(); $orderSecretId = $input->getTrimString('order'); $order = PayOrderUtil::getOrder($orderSecretId); BizException::throwsIfEmpty('订单不存在', $order); return Response::generateSuccessData([ 'orderSecretId' => $orderSecretId, 'order' => [ 'id' => $order['id'], 'status' => $order['status'], 'body' => $order['body'], 'redirect' => $order['redirect'], 'feeTotal' => $order['feeTotal'], ] ]); } public function submit($order = null, $orderSecretId = null) { $input = InputPackage::buildFromInput(); if (empty($order)) { $orderSecretId = $input->getTrimString('order'); $order = PayOrderUtil::getOrder($orderSecretId); BizException::throwsIfEmpty('订单不存在', $order); } $payType = $input->getType('type', PayType::class, null); if (empty($payType)) { return Response::generateError('支付方式错误'); } if (!PayUtil::isPayEnable($payType)) { return Response::generateError('支付方式未开启'); } $device = $input->getTrimString('device'); $option = []; $option['device'] = $device; switch ($payType) { case PayType::ALIPAY: $option['alipay_wap'] = AgentUtil::isMobile(); return PayOrderUtil::createPay($order['id'], $payType, $option); case PayType::WECHAT: $ret = PayOrderUtil::createPay($order['id'], $payType, $option); if (isset($ret['data'])) { $ret['data']['payWatchUrl'] = '/pay/watch?order=' . $orderSecretId; } return Response::jsonFromGenerate($ret); case PayType::WECHAT_MOBILE: $openId = Session::get('oauthViewOpenId_' . OauthType::WECHAT_MOBILE); if (empty($openId)) { Session::put('autoClickPayType', PayType::WECHAT_MOBILE); return Response::json(-1, null, [ 'needOauthLogin' => true, ], '/oauth_login_' . OauthType::WECHAT_MOBILE . '?view=true&silence=true&redirect=' . urlencode(Request::currentPageUrl())); } $option['openId'] = $openId; return PayOrderUtil::createPay($order['id'], $payType, $option); case PayType::WECHAT_MINI_PROGRAM: $openId = Session::get('oauthViewOpenId_' . OauthType::WECHAT_MINI_PROGRAM); if (empty($openId)) { return Response::json(-1, null, [ 'needOauthLogin' => true, ]); } $option['openId'] = $openId; return PayOrderUtil::createPay($order['id'], $payType, $option); } return Response::generateError('支付方式错误'); } }