<?php
 namespace Module\PayCenter\Util; use Carbon\Carbon; use EasyWeChat\Factory; use EasyWeChat\Foundation\Application; use Illuminate\Support\Facades\Event; use Illuminate\Support\Facades\Log; use Illuminate\Support\Facades\Session; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Response; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\IdUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\StrUtil; use ModStart\Core\Util\TimeUtil; use Module\PayCenter\Type\PayOrderStatus; use Module\PayCenter\Type\PayType; use Module\Vendor\SoftApi\SoftApi; use Payment\Client\Charge; use Payment\Common\PayException; use Payment\Config; use Module\PayCenter\Events\OrderPayedEvent; class PayOrderUtil { private static function getOrGeneratePaySessionKey() { $key = Session::get('paySessionKey', null); if (empty($key)) { $key = RandomUtil::string(32); Session::put('paySessionKey', $key); } return $key; } public static function prepareOrder($biz, $bizId, $feeTotal, $body, $redirect, $param = []) { $order = []; $id = IdUtil::generateSN(); $order['id'] = $id; $order['biz'] = $biz; $order['bizId'] = $bizId; $order['payType'] = null; $order['status'] = PayOrderStatus::NEW_ORDER; $order['payOrderId'] = null; $order['feeTotal'] = $feeTotal; $order['timePayCreated'] = null; $order['timePay'] = null; $order['feeRefund'] = null; $order['timeRefundCreated'] = null; $order['timeRefundSuccess'] = null; $order['timeClosed'] = null; $order['param'] = json_encode($param); $order['body'] = $body; $order['redirect'] = $redirect; $order = ModelUtil::insert('pay_order', $order); $order['id'] = $id; $order['param'] = $param; return $order; } public static function getOrderSecretId($orderId) { return EncodeUtil::expiredDataForever($orderId, self::getOrGeneratePaySessionKey()); } public static function getOrder($order) { $id = EncodeUtil::expiredDataDecode($order, self::getOrGeneratePaySessionKey()); if (!$id) { return null; } $record = ModelUtil::get('pay_order', $id); ModelUtil::decodeRecordJson($record, ['param']); $record['id'] = '' . $record['id']; return $record; } public static function createPay($orderId, $payType, $option = []) { $payOrder = self::get($orderId); BizException::throwsIfEmpty('订单不存在', $payOrder); if ($payOrder['status'] == PayOrderStatus::PAYED) { return Response::generateError('订单已支付'); } else if ($payOrder['status'] == PayOrderStatus::CLOSED) { return Response::generateError('订单已关闭，请刷新该页面'); } switch ($payType) { case PayType::ALIPAY: return self::createAlipay($payOrder, $payType, $option); case PayType::WECHAT: return self::createWechat($payOrder, $payType, $option); case PayType::WECHAT_MOBILE: return self::createWechatMobile($payOrder, $payType, $option); case PayType::WECHAT_MINI_PROGRAM: return self::createWechatMiniProgram($payOrder, $payType, $option); } return Response::generate(-1, 'error payType'); } public static function update($id, $data) { return ModelUtil::update('pay_order', ['id' => $id], $data); } public static function get($id) { $m = ModelUtil::get('pay_order', $id); ModelUtil::decodeRecordJson($m, 'param'); return $m; } public static function getByBizAndBizId($biz, $bizId) { $m = ModelUtil::get('pay_order', [ 'biz' => $biz, 'bizId' => $bizId, ]); ModelUtil::decodeRecordJson($m, 'param'); return $m; } public static function getWechatPayment() { $config = modstart_config(); $config = [ 'app_id' => $config->getWithEnv('payWechatAppId'), 'mch_id' => $config->getWithEnv('payWechatMerchantId'), 'key' => $config->getWithEnv('payWechatKey'), 'cert_path' => '', 'key_path' => '', 'log' => [ 'default' => 'debug', 'channels' => [ 'debug' => [ 'driver' => 'single', 'path' => storage_path('logs/easywechat_payment_' . TimeUtil::date() . '.log'), 'level' => 'debug', ], ] ], ]; return Factory::payment($config); } private static function createWechat($payOrder, $payType, $option) { if (!modstart_config('payWechatOn', false)) { return Response::generate(-1, '微信支付未开启'); } $payment = self::getWechatPayment(); $attributes = [ 'trade_type' => 'NATIVE', 'body' => $payOrder['body'], 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $payOrder['id'], 'total_fee' => intval($payOrder['feeTotal'] * 100), 'notify_url' => action('\Module\PayCenter\Web\Controller\NotifyController@index', ['payType' => PayType::WECHAT]), ]; if (isset($option['limitPay'])) { switch ($option['limitPay']) { case 'no_credit': $attributes['limit_pay'] = $option['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } $ret = $payment->order->unify($attributes); if (!isset($ret['return_code']) || $ret['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:(' . (isset($ret['return_msg']) ? $ret['return_msg'] : 'NULL') . ')'); } if (!isset($ret['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } if ($ret['result_code'] != 'SUCCESS') { $errMsg = $ret['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $errMsg . ')'); } self::update($payOrder['id'], [ 'status' => PayOrderStatus::CREATED, 'payType' => $payType, 'timePayCreated' => Carbon::now(), 'payOrderId' => $ret['prepay_id'], ]); $data = [ 'payCodeUrl' => $ret['code_url'], 'successRedirect' => $payOrder['redirect'], ]; return Response::generate(0, null, $data); } private static function createWechatMobile($payOrder, $payType, $option) { if (!modstart_config('payWechatOn', false)) { return Response::generate(-1, 'wechat mobile pay not enable'); } if (empty($option['openId'])) { return Response::generate(-1, 'wechat mobile openId empty'); } $payment = self::getWechatPayment(); $attributes = [ 'openid' => $option['openId'], 'trade_type' => 'JSAPI', 'body' => $payOrder['body'], 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $payOrder['id'], 'total_fee' => intval($payOrder['feeTotal'] * 100), 'notify_url' => action('\Module\PayCenter\Web\Controller\NotifyController@index', ['payType' => PayType::WECHAT_MOBILE]), ]; if (isset($option['limitPay'])) { switch ($option['limitPay']) { case 'no_credit': $attributes['limit_pay'] = $option['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } $ret = $payment->order->unify($attributes); if (!isset($ret['return_code']) || $ret['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:(' . (isset($ret['return_msg']) ? $ret['return_msg'] : 'NULL') . ')'); } if (!isset($ret['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } if ($ret['result_code'] != 'SUCCESS') { $errMsg = $ret['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $errMsg . ')'); } self::update($payOrder['id'], [ 'status' => PayOrderStatus::CREATED, 'payType' => $payType, 'timePayCreated' => Carbon::now(), 'payOrderId' => $ret['prepay_id'], ]); $payJsSdkConfig = $payment->jssdk->bridgeConfig($ret['prepay_id'], false); $data = [ 'payJsSdkConfig' => $payJsSdkConfig, 'successRedirect' => $payOrder['redirect'], ]; return Response::generate(0, null, $data); } public static function getWechatMiniProgramPayment() { $config = modstart_config(); $config = [ 'app_id' => $config->getWithEnv('oauthWechatMiniProgramAppId'), 'mch_id' => $config->getWithEnv('payWechatMerchantId'), 'key' => $config->getWithEnv('payWechatKey'), 'cert_path' => '', 'key_path' => '', 'log' => [ 'default' => 'debug', 'channels' => [ 'debug' => [ 'driver' => 'single', 'path' => storage_path('logs/easywechat_payment_' . TimeUtil::date() . '.log'), 'level' => 'debug', ], ] ], ]; return Factory::payment($config); } private static function createWechatMiniProgram($payOrder, $payType, $option) { if (!modstart_config('payWechatOn', false)) { return Response::generate(-1, 'wechat mini program pay not enable'); } if (empty($option['openId'])) { return Response::generate(-1, 'wechat mini program openId empty'); } $payment = self::getWechatMiniProgramPayment(); $attributes = [ 'openid' => $option['openId'], 'trade_type' => 'JSAPI', 'body' => $payOrder['body'], 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $payOrder['id'], 'total_fee' => intval($payOrder['feeTotal'] * 100), 'notify_url' => action('\Module\PayCenter\Web\Controller\NotifyController@index', ['payType' => PayType::WECHAT_MINI_PROGRAM]), ]; if (isset($option['limitPay'])) { switch ($option['limitPay']) { case 'no_credit': $attributes['limit_pay'] = $option['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } $ret = $payment->order->unify($attributes); if (!isset($ret['return_code']) || $ret['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:(' . (isset($ret['return_msg']) ? $ret['return_msg'] : 'NULL') . ')'); } if (!isset($ret['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } if ($ret['result_code'] != 'SUCCESS') { $errMsg = $ret['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $errMsg . ')'); } self::update($payOrder['id'], [ 'status' => PayOrderStatus::CREATED, 'payType' => $payType, 'timePayCreated' => Carbon::now(), 'payOrderId' => $ret['prepay_id'], ]); $payJsSdkConfig = $payment->jssdk->bridgeConfig($ret['prepay_id'], false); $data = [ 'payJsSdkConfig' => $payJsSdkConfig, 'successRedirect' => $payOrder['redirect'], ]; return Response::generate(0, null, $data); } public static function initAlipay() { config([ 'latrell-alipay.partner_id' => config('pay.alipay.partnerId'), 'latrell-alipay.seller_id' => config('pay.alipay.sellerId'), 'latrell-alipay-web.key' => config('pay.alipay.key'), 'latrell-alipay-web.return_url' => action('\Module\PayCenter\Web\Controller\ReturnController@index', ['payType' => PayType::ALIPAY]), 'latrell-alipay-web.notify_url' => action('\Module\PayCenter\Web\Controller\NotifyController@index', ['payType' => PayType::ALIPAY]), ]); } private static function createAlipay($payOrder, $payType, $option) { self::initAlipay(); if (!config('latrell-alipay.partner_id') || !config('latrell-alipay.seller_id') || !config('latrell-alipay-web.key')) { return Response::generate(-1, '支付宝配置错误'); } if (!empty($option['alipay_wap'])) { $alipay = app('alipay.wap'); } else { $alipay = app('alipay.web'); } $alipay->setOutTradeNo(config('pay.payOrderOutTradeNoPrefix') . '_' . $payOrder['id']); $alipay->setTotalFee($payOrder['feeTotal']); $alipay->setSubject($payOrder['body']); $alipay->setBody($payOrder['body']); self::update($payOrder['id'], [ 'status' => PayOrderStatus::CREATED, 'payType' => $payType, 'timePayCreated' => Carbon::now(), ]); $data = []; $data['payLink'] = $alipay->getPayLink(); $data['successRedirect'] = $payOrder['redirect']; return Response::generate(0, 'ok', $data); } public static function handleOrderPay($type, $outTradeNo, $orderUpdate = []) { $shouldFireEvent = false; $order = null; Log::info('PayOrderNotify - ' . $type . ' - ' . $outTradeNo); $pieces = explode('_', $outTradeNo); if (count($pieces) != 2) { return Response::generate(-1, 'outTradeNo error'); } $outTradeNoPrefix = $pieces[0]; $orderId = $pieces[1]; if ($outTradeNoPrefix != config('pay.payOrderOutTradeNoPrefix')) { return Response::generate(-1, 'outTradeNo prefix not match'); } try { ModelUtil::transactionBegin(); $order = ModelUtil::getWithLock('pay_order', ['id' => $orderId]); if (empty($order)) { ModelUtil::transactionCommit(); return Response::generate(-1, 'order not found'); } if ($order['status'] == PayOrderStatus::CREATED) { Log::info('PayOrderNotify - update order to payed - ' . $outTradeNo); ModelUtil::update('pay_order', ['id' => $order['id']], array_merge([ 'status' => PayOrderStatus::PAYED, 'timePay' => Carbon::now(), ], $orderUpdate)); $shouldFireEvent = true; } else { if (!empty($orderUpdate)) { ModelUtil::update('pay_order', ['id' => $order['id']], $orderUpdate); } } ModelUtil::transactionCommit(); } catch (\Exception $e) { ModelUtil::transactionRollback(); } if ($shouldFireEvent) { $event = new OrderPayedEvent(); $event->biz = $order['biz']; $event->bizId = $order['bizId']; $event->order = $order; Event::fire($event); Log::info('PayOrderNotify - FireEvent - OrderPayedEvent - ' . json_encode($event)); } ModelUtil::decodeRecordJson($order, 'param'); return Response::generate(0, null, [ 'order' => $order, ]); } } 