<?php
 namespace Module\PayCenter\Web\Controller; use Illuminate\Routing\Controller; use Illuminate\Support\Facades\Input; use Illuminate\Support\Facades\Log; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use Module\PayCenter\Type\PayType; use Module\PayCenter\Util\PayOrderUtil; use Payment\Client\Notify; use Payment\Config; use Payment\Notify\PayNotifyInterface; class NotifyController extends Controller { public function index($payType = '') { $input = InputPackage::buildFromInput(); switch ($payType) { case PayType::ALIPAY: PayOrderUtil::initAlipay(); if (!app('alipay.web')->verify()) { Log::info('PayCenter.NotifyController - alipay return - query data verification fail - ' . json_encode([ 'data' => Request::instance()->getContent() ])); return 'fail'; } switch (Input::get('trade_status')) { case 'TRADE_SUCCESS': case 'TRADE_FINISHED': $outTradeNo = $input->getTrimString('out_trade_no'); $tradeNo = $input->getTrimString('trade_no'); Log::info('PayCenter.NotifyController - alipay return -> data verification success - ' . json_encode([ 'out_trade_no' => $outTradeNo, 'trade_no' => $tradeNo ])); $ret = PayOrderUtil::handleOrderPay(PayType::ALIPAY, $outTradeNo, [ 'payOrderId' => $tradeNo, ]); if ($ret['code']) { return 'fail'; } return 'success'; } return 'fail'; case PayType::WECHAT: return PayOrderUtil::getWechatPayment()->handlePaidNotify(function ($message, $fail) { $ret = PayOrderUtil::handleOrderPay(PayType::WECHAT, $message['out_trade_no']); if ($ret['code']) { $fail($ret['msg']); } return true; }); case PayType::WECHAT_MOBILE: return PayOrderUtil::getWechatPayment()->handlePaidNotify(function ($message, $fail) { $ret = PayOrderUtil::handleOrderPay(PayType::WECHAT_MOBILE, $message['out_trade_no']); if ($ret['code']) { $fail($ret['msg']); } return true; }); case PayType::WECHAT_MINI_PROGRAM: return PayOrderUtil::getWechatMiniProgramPayment()->handlePaidNotify(function ($message, $fail) { $ret = PayOrderUtil::handleOrderPay(PayType::WECHAT_MINI_PROGRAM, $message['out_trade_no']); if ($ret['code']) { $fail($ret['msg']); } return true; }); } } } 