@extends('modstart::layout.frame')

@section('pageFavIco',\ModStart\Core\Assets\AssetsUtil::fix(modstart_config('siteFavIco')))
@section('pageTitle')@yield('pageTitleMain','') - {{modstart_config('siteName')}}@endsection
@section('pageKeywords',modstart_config('siteKeywords'))
@section('pageDescription',modstart_config('pageDescription'))

@section('headAppend')
    @parent
    <link rel="stylesheet" href="{{\ModStart\Core\Assets\AssetsUtil::fix('theme/'.modstart_config('siteTemplate','default').'/pc/css/style.css')}}"/>
    {!! modstart_config('systemCounter') !!}
    <style type="text/css">
        @if(modstart_config('sitePrimaryColor',null))
            :root{
            --theme-color-primary: {{modstart_config('sitePrimaryColor')}};
            --theme-color-primary-light: {{modstart_config('sitePrimaryColor')}};
            --theme-color-primary-dark: {{modstart_config('sitePrimaryColor')}};
        }
        @endif
    </style>
@endsection

@section('bodyAppend')
    @parent
    {!! modstart_config('systemCounterBody') !!}
@endsection

@section('body')

    <header class="ub-header-b primary">
        <div class="ub-container">
            <div class="menu">
                @if(\Module\Member\Auth\MemberUser::id())
                    @if(modstart_config('moduleMemberVipEnable',false))
                        <a class="ub-color-vip" href="{{modstart_web_url('member_vip')}}">
                            <i class="iconfont icon-VIP"></i>
                            {{\Module\Member\Auth\MemberVip::get('title')}}
                        </a>
                    @endif
                    <a href="{{modstart_web_url('member_message')}}">
                        <i class="iconfont icon-bell"></i>
                        <?php $count = \Module\Member\Util\MemberMessageUtil::getUnreadMessageCount(\Module\Member\Auth\MemberUser::id()); ?>
                        @if($count)
                            <span class="badge" data-member-unread-message-count>{{$count}}</span>
                        @endif
                    </a>
                    <a href="{{modstart_web_url('member')}}"><i class="iconfont icon-user"></i> {{\Module\Member\Auth\MemberUser::get('username')}}</a>
                    <a href="javascript:;" data-confirm="确认退出？" data-href="{{modstart_web_url('logout')}}">退出</a>
                @else
                    <a href="{{modstart_web_url('login')}}">登录</a>
                    @if(!modstart_config('registerDisable',false))
                        <a href="{{modstart_web_url('register')}}">注册</a>
                    @endif
                @endif
            </div>
            <div class="logo">
                <a href="{{modstart_web_url('')}}">
                    <img src="{{\ModStart\Core\Assets\AssetsUtil::fix(modstart_config('siteLogo'))}}"/>
                </a>
            </div>
            <div class="nav-mask" onclick="$(this).closest('.ub-header-b').removeClass('show')"></div>
            <div class="nav">
                @foreach(\Module\Nav\Util\NavUtil::listByPositionWithCache('header') as $nav)
                    <a class="{{modstart_baseurl_active($nav['link'])}}" href="{{$nav['link']}}">{{$nav['name']}}</a>
                @endforeach
            </div>
            <a class="nav-toggle" href="javascript:;" onclick="$(this).closest('.ub-header-b').toggleClass('show')">
                <i class="show iconfont icon-list"></i>
                <i class="close iconfont icon-close"></i>
            </a>
        </div>
    </header>

    @section('bodyContent')
    @show

    <footer class="ub-footer">
        <div class="ub-container">
            <div class="line"></div>
            <div class="nav">
                @foreach(\Module\Article\Util\ArticleUtil::listByPositionWithCache('footer') as $footerArticle)
                    <a href="{{modstart_web_url('article/'.$footerArticle['id'])}}">{{$footerArticle['title']}}</a>
                @endforeach
            </div>
            <div class="copyright">
                <a href="http://beian.miit.gov.cn" target="_blank">{{modstart_config('siteBeian','[网站备案信息]')}}</a>
                &copy;{{modstart_config('siteDomain')}}
            </div>
        </div>
    </footer>

    @if(\ModStart\Core\Util\AgentUtil::isMobile())
        <div class="ub-nav-mobile-foot-spacer"></div>
        <div class="ub-nav-mobile-foot">
            <a class="item" href="{{modstart_web_url('')}}">
                <div class="icon"><i class="img iconfont icon-home"></i></div>
                <div class="title">首页</div>
            </a>
            <a class="item" href="{{modstart_web_url('event')}}">
                <div class="icon"><i class="img iconfont icon-category"></i></div>
                <div class="title">活动</div>
            </a>
            <a class="item" href="{{modstart_web_url('member')}}">
                <div class="icon"><i class="img iconfont icon-user"></i></div>
                <div class="title">我的</div>
            </a>
        </div>
    @endif

@endsection
