<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------

namespace app\model;

/**
 * 设置模型
 */
class Channel extends \think\Model {

	protected $type = array(
		'id' => 'integer',
	);

	protected $auto = array('update_time', 'status' => 1);
	protected $insert = array('create_time');

	protected function getStatusTextAttr($value, $data){
		$status = [0 => '禁用', 1 => '启用'];
		return isset($status[$data['status']]) ? $status[$data['status']] : '禁用';
	}

	public static function getChannelList($pid, $tree){
		$map = [];
		$map[] = ['status', '=', 1];
		if ($pid !== '') {
			$map[] = ['pid', '=', $pid];
		}
		
		$list = self::where($map)->order('sort asc, id desc')->column("*");
		if ($tree) {
			$list = (new \sent\tree\Tree())->listToTree($list);
		}
		return $list;
	}
}