<?php

namespace sent\jwt;

use sent\jwt\contract\Storage;

/**
 * 黑名单
 */
class Blacklist {
	protected $test = '';
	protected $storage;

	public function __construct(Storage $storage) {
		$this->storage = $storage;
	}

	/**
	 * 添加黑名单
	 * @param [type] $payload [description]
	 */
	public function add($payload) {
		$this->set($this->getKey($payload));

		return $this;
	}

	/**
	 * 判断是否在黑名单
	 * @param  [type]  $payload [description]
	 * @return boolean          [description]
	 */
	public function has($payload) {
		return $this->get($this->getKey($payload)) ? true : false;
	}

	protected function getKey($payload) {
		return $payload['jti']->getValue();
	}

	public function set($key, $time = 0) {
		$this->storage->set($key, $time);

		return $this;
	}

	public function get($key) {
		return $this->storage->get($key);
	}

	public function remove($key) {
		return $this->storage->delete($key);
	}
}
