<?php

namespace sent\jwt;

use sent\jwt\claim\Audience;
use sent\jwt\claim\Expiration;
use sent\jwt\claim\Factory;
use sent\jwt\claim\IssuedAt;
use sent\jwt\claim\Issuer;
use sent\jwt\claim\JwtId;
use sent\jwt\claim\NotBefore;
use sent\jwt\claim\Subject;

class Payload {
	protected $factory;

	protected $classMap
	= [
		'aud' => Audience::class,
		'exp' => Expiration::class,
		'iat' => IssuedAt::class,
		'iss' => Issuer::class,
		'jti' => JwtId::class,
		'nbf' => NotBefore::class,
		'sub' => Subject::class,
	];

	protected $claims;

	public function __construct(Factory $factory) {
		$this->factory = $factory;
	}

	public function customer(array $claim = []) {
		foreach ($claim as $key => $value) {
			$this->factory->customer($key,
				is_object($value) ? $value->getValue() : $value);
		}

		return $this;
	}

	public function get() {
		$claim = $this->factory->builder()->getClaims();

		return $claim;
	}

	public function check($refresh = false) {
		$this->factory->validate($refresh);

		return $this;
	}
}
