<?php

namespace sent\jwt\middleware;

class JWTAuth extends BaseMiddleware {
	public function handle($request, \Closure $next) {
		try {
			$auth          = $this->auth->auth();
			$request->user = $auth['data'];
		} catch (TokenExpiredException $e) {
			$this->data['msg']  = $e->getMessage();
			$this->data['code'] = 2001;
			return json($this->data);
		} catch (JWTException $e) {
			$this->data['code'] = 2000;
			$this->data['msg']  = $e->getMessage();
			return json($this->data);
		}
	}
}
