<?php

namespace sent\jwt\middleware;

use sent\jwt\exception\TokenExpiredException;

class JWTAuthAndRefresh extends BaseMiddleware {
	public function handle($request, \Closure $next) {
		try {
			$this->auth->auth();
		} catch (TokenExpiredException $e) {
			$response = $next($request);

			return $this->setAuthentication($response);
		}

		return $next($request);
	}
}
